/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.model.internal.intermediates;

import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.declaration.Variant;
import com.autonomousapps.model.declaration.internal.Bucket;
import com.autonomousapps.model.internal.intermediates.DependencyTraceReport;
import com.autonomousapps.model.internal.intermediates.Reason;
import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0081\b\u0018\u00002\u00020\u0001:\u0003 !\"B=\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003JK\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport;", "", "buildType", "", "flavor", "variant", "Lcom/autonomousapps/model/declaration/Variant;", "dependencies", "", "Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Trace;", "annotationProcessors", "(Ljava/lang/String;Ljava/lang/String;Lcom/autonomousapps/model/declaration/Variant;Ljava/util/Set;Ljava/util/Set;)V", "getAnnotationProcessors", "()Ljava/util/Set;", "getBuildType", "()Ljava/lang/String;", "getDependencies", "getFlavor", "getVariant", "()Lcom/autonomousapps/model/declaration/Variant;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Builder", "Kind", "Trace", "dependency-analysis-gradle-plugin"})
public final class DependencyTraceReport {
    @Nullable
    private final String buildType;
    @Nullable
    private final String flavor;
    @NotNull
    private final Variant variant;
    @NotNull
    private final Set<Trace> dependencies;
    @NotNull
    private final Set<Trace> annotationProcessors;

    public DependencyTraceReport(@Nullable String buildType, @Nullable String flavor, @NotNull Variant variant, @NotNull Set<Trace> dependencies2, @NotNull Set<Trace> annotationProcessors) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(annotationProcessors, (String)"annotationProcessors");
        this.buildType = buildType;
        this.flavor = flavor;
        this.variant = variant;
        this.dependencies = dependencies2;
        this.annotationProcessors = annotationProcessors;
    }

    @Nullable
    public final String getBuildType() {
        return this.buildType;
    }

    @Nullable
    public final String getFlavor() {
        return this.flavor;
    }

    @NotNull
    public final Variant getVariant() {
        return this.variant;
    }

    @NotNull
    public final Set<Trace> getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final Set<Trace> getAnnotationProcessors() {
        return this.annotationProcessors;
    }

    @Nullable
    public final String component1() {
        return this.buildType;
    }

    @Nullable
    public final String component2() {
        return this.flavor;
    }

    @NotNull
    public final Variant component3() {
        return this.variant;
    }

    @NotNull
    public final Set<Trace> component4() {
        return this.dependencies;
    }

    @NotNull
    public final Set<Trace> component5() {
        return this.annotationProcessors;
    }

    @NotNull
    public final DependencyTraceReport copy(@Nullable String buildType, @Nullable String flavor, @NotNull Variant variant, @NotNull Set<Trace> dependencies2, @NotNull Set<Trace> annotationProcessors) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(annotationProcessors, (String)"annotationProcessors");
        return new DependencyTraceReport(buildType, flavor, variant, dependencies2, annotationProcessors);
    }

    public static /* synthetic */ DependencyTraceReport copy$default(DependencyTraceReport dependencyTraceReport, String string, String string2, Variant variant, Set set2, Set set3, int n, Object object) {
        if ((n & 1) != 0) {
            string = dependencyTraceReport.buildType;
        }
        if ((n & 2) != 0) {
            string2 = dependencyTraceReport.flavor;
        }
        if ((n & 4) != 0) {
            variant = dependencyTraceReport.variant;
        }
        if ((n & 8) != 0) {
            set2 = dependencyTraceReport.dependencies;
        }
        if ((n & 0x10) != 0) {
            set3 = dependencyTraceReport.annotationProcessors;
        }
        return dependencyTraceReport.copy(string, string2, variant, set2, set3);
    }

    @NotNull
    public String toString() {
        return "DependencyTraceReport(buildType=" + this.buildType + ", flavor=" + this.flavor + ", variant=" + this.variant + ", dependencies=" + this.dependencies + ", annotationProcessors=" + this.annotationProcessors + ")";
    }

    public int hashCode() {
        int result = this.buildType == null ? 0 : this.buildType.hashCode();
        result = result * 31 + (this.flavor == null ? 0 : this.flavor.hashCode());
        result = result * 31 + this.variant.hashCode();
        result = result * 31 + ((Object)this.dependencies).hashCode();
        result = result * 31 + ((Object)this.annotationProcessors).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DependencyTraceReport)) {
            return false;
        }
        DependencyTraceReport dependencyTraceReport = (DependencyTraceReport)other;
        if (!Intrinsics.areEqual((Object)this.buildType, (Object)dependencyTraceReport.buildType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.flavor, (Object)dependencyTraceReport.flavor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variant, (Object)dependencyTraceReport.variant)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dependencies, dependencyTraceReport.dependencies)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotationProcessors, dependencyTraceReport.annotationProcessors);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J2\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\t2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J*\u0010\u001b\u001a\u00020\u001c2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J!\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J!\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0086\u0002J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\"H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Builder;", "", "buildType", "", "flavor", "variant", "Lcom/autonomousapps/model/declaration/Variant;", "(Ljava/lang/String;Ljava/lang/String;Lcom/autonomousapps/model/declaration/Variant;)V", "annotationProcessors", "", "Lcom/autonomousapps/model/Coordinates;", "Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Trace;", "dependencies", "reasons", "", "Lcom/autonomousapps/model/internal/intermediates/Reason;", "build", "Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport;", "handle", "", "map", "coordinates", "bucket", "Lcom/autonomousapps/model/declaration/internal/Bucket;", "reason", "handleAnnotationProcessor", "handleDependency", "isBinaryIncompatible", "", "set", "kind", "Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Kind;", "withReasons", "", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nDependencyTraceReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTraceReport.kt\ncom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n*L\n1#1,145:1\n808#2,11:146\n1628#2,3:158\n108#3:157\n*S KotlinDebug\n*F\n+ 1 DependencyTraceReport.kt\ncom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Builder\n*L\n128#1:146,11\n139#1:158,3\n139#1:157\n*E\n"})
    public static final class Builder {
        @Nullable
        private final String buildType;
        @Nullable
        private final String flavor;
        @NotNull
        private final Variant variant;
        @NotNull
        private final Map<Coordinates, Trace> dependencies;
        @NotNull
        private final Map<Coordinates, Trace> annotationProcessors;
        @NotNull
        private final Map<Coordinates, Set<Reason>> reasons;

        public Builder(@Nullable String buildType, @Nullable String flavor, @NotNull Variant variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            this.buildType = buildType;
            this.flavor = flavor;
            this.variant = variant;
            this.dependencies = new LinkedHashMap();
            this.annotationProcessors = new LinkedHashMap();
            this.reasons = new LinkedHashMap();
        }

        public final void set(@NotNull Coordinates coordinates, @NotNull Kind kind, @NotNull Bucket bucket2) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)((Object)bucket2), (String)"bucket");
            if (kind == Kind.ANNOTATION_PROCESSOR) {
                this.handleAnnotationProcessor(coordinates, bucket2);
            } else {
                this.handleDependency(coordinates, bucket2);
            }
        }

        public final void set(@NotNull Coordinates coordinates, @NotNull Kind kind, @NotNull Reason reason) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            if (kind == Kind.ANNOTATION_PROCESSOR) {
                this.handleAnnotationProcessor(coordinates, reason);
            } else {
                this.handleDependency(coordinates, reason);
            }
        }

        private final void handleDependency(Coordinates coordinates, Bucket bucket2) {
            this.handle(this.dependencies, coordinates, bucket2);
        }

        private final void handleAnnotationProcessor(Coordinates coordinates, Bucket bucket2) {
            this.handle(this.annotationProcessors, coordinates, bucket2);
        }

        private final void handle(Map<Coordinates, Trace> map, Coordinates coordinates, Bucket bucket2) {
            Bucket currBucket;
            Trace currTrace;
            if (this.isBinaryIncompatible(this.reasons, coordinates)) {
                return;
            }
            Trace trace = currTrace = map.get(coordinates);
            Bucket bucket3 = currBucket = trace != null ? trace.getBucket() : null;
            if ((bucket3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bucket3.ordinal()]) == -1) {
                map.put(coordinates, new Trace(coordinates, bucket2, null, 4, null));
            } else if (currBucket == bucket2) {
                map.merge(coordinates, new Trace(coordinates, bucket2, null, 4, null), new BiFunction(coordinates, currBucket){
                    final /* synthetic */ Coordinates $coordinates;
                    final /* synthetic */ Bucket $currBucket;
                    {
                        this.$coordinates = $coordinates;
                        this.$currBucket = $currBucket;
                    }

                    public final Trace apply(Trace acc, Trace inc) {
                        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
                        Intrinsics.checkNotNullParameter((Object)inc, (String)"inc");
                        return new Trace(this.$coordinates, this.$currBucket, SetsKt.plus(acc.getReasons(), (Iterable)inc.getReasons()));
                    }
                });
            } else {
                throw new IllegalStateException(StringsKt.trimMargin$default((String)("It is an error to try to associate a dependency with more than one bucket.\n                | Dependency: " + coordinates + "\n                | Buckets: " + currBucket + " (original), " + bucket2 + " (new)\n              "), null, (int)1, null).toString());
            }
        }

        private final void handleDependency(Coordinates coordinates, Reason reason) {
            this.handle(this.reasons, coordinates, reason);
        }

        private final void handleAnnotationProcessor(Coordinates coordinates, Reason reason) {
            this.handle(this.reasons, coordinates, reason);
        }

        private final void handle(Map<Coordinates, Set<Reason>> map, Coordinates coordinates, Reason reason) {
            if (reason instanceof Reason.BinaryIncompatible) {
                Map<Coordinates, Set<Reason>> map2 = map;
                Object object = new Reason[]{reason};
                object = SetsKt.mutableSetOf((Object[])object);
                map2.put(coordinates, (Set<Reason>)object);
                this.dependencies.put(coordinates, new Trace(coordinates, Bucket.NONE, null, 4, null));
            } else if (!this.isBinaryIncompatible(map, coordinates)) {
                Object[] objectArray = new Reason[]{reason};
                map.merge(coordinates, SetsKt.mutableSetOf((Object[])objectArray), handle.2.INSTANCE);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isBinaryIncompatible(Map<Coordinates, Set<Reason>> map, Coordinates coordinates) {
            boolean bl;
            Set<Reason> set2 = map.get(coordinates);
            if (set2 != null) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = set2;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Reason.BinaryIncompatible)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                bl = !((Collection)((List)destination$iv$iv)).isEmpty();
            } else {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final DependencyTraceReport build() {
            return new DependencyTraceReport(this.buildType, this.flavor, this.variant, this.withReasons(this.dependencies), this.withReasons(this.annotationProcessors));
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Trace> withReasons(Map<Coordinates, Trace> $this$withReasons) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapToSet$iv = $this$withReasons.values();
            boolean $i$f$mapToSet = false;
            Iterable iterable = $this$mapToSet$iv;
            Collection destination$iv$iv = new LinkedHashSet(CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Set<Reason> reasons;
                void it;
                Trace trace = (Trace)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (this.reasons.get(it.getCoordinates()) == null) {
                    throw new IllegalStateException(("No reasons found for " + it.getCoordinates()).toString());
                }
                collection.add(new Trace(it.getCoordinates(), it.getBucket(), reasons));
            }
            return (Set)destination$iv$iv;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                $EnumSwitchMapping$0 = new int[Bucket.values().length];
            }
        }
    }

    @JsonClass(generateAdapter=false)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Kind;", "", "(Ljava/lang/String;I)V", "DEPENDENCY", "ANNOTATION_PROCESSOR", "dependency-analysis-gradle-plugin"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind DEPENDENCY = new Kind();
        public static final /* enum */ Kind ANNOTATION_PROCESSOR = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.DEPENDENCY, Kind.ANNOTATION_PROCESSOR};
        }
    }

    @JsonClass(generateAdapter=false)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Trace;", "", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "bucket", "Lcom/autonomousapps/model/declaration/internal/Bucket;", "reasons", "", "Lcom/autonomousapps/model/internal/intermediates/Reason;", "(Lcom/autonomousapps/model/Coordinates;Lcom/autonomousapps/model/declaration/internal/Bucket;Ljava/util/Set;)V", "getBucket", "()Lcom/autonomousapps/model/declaration/internal/Bucket;", "getCoordinates", "()Lcom/autonomousapps/model/Coordinates;", "getReasons", "()Ljava/util/Set;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dependency-analysis-gradle-plugin"})
    public static final class Trace {
        @NotNull
        private final Coordinates coordinates;
        @NotNull
        private final Bucket bucket;
        @NotNull
        private final Set<Reason> reasons;

        public Trace(@NotNull Coordinates coordinates, @NotNull Bucket bucket2, @NotNull Set<? extends Reason> reasons) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            Intrinsics.checkNotNullParameter((Object)((Object)bucket2), (String)"bucket");
            Intrinsics.checkNotNullParameter(reasons, (String)"reasons");
            this.coordinates = coordinates;
            this.bucket = bucket2;
            this.reasons = reasons;
        }

        public /* synthetic */ Trace(Coordinates coordinates, Bucket bucket2, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                set2 = SetsKt.emptySet();
            }
            this(coordinates, bucket2, set2);
        }

        @NotNull
        public final Coordinates getCoordinates() {
            return this.coordinates;
        }

        @NotNull
        public final Bucket getBucket() {
            return this.bucket;
        }

        @NotNull
        public final Set<Reason> getReasons() {
            return this.reasons;
        }

        @NotNull
        public final Coordinates component1() {
            return this.coordinates;
        }

        @NotNull
        public final Bucket component2() {
            return this.bucket;
        }

        @NotNull
        public final Set<Reason> component3() {
            return this.reasons;
        }

        @NotNull
        public final Trace copy(@NotNull Coordinates coordinates, @NotNull Bucket bucket2, @NotNull Set<? extends Reason> reasons) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            Intrinsics.checkNotNullParameter((Object)((Object)bucket2), (String)"bucket");
            Intrinsics.checkNotNullParameter(reasons, (String)"reasons");
            return new Trace(coordinates, bucket2, reasons);
        }

        public static /* synthetic */ Trace copy$default(Trace trace, Coordinates coordinates, Bucket bucket2, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                coordinates = trace.coordinates;
            }
            if ((n & 2) != 0) {
                bucket2 = trace.bucket;
            }
            if ((n & 4) != 0) {
                set2 = trace.reasons;
            }
            return trace.copy(coordinates, bucket2, set2);
        }

        @NotNull
        public String toString() {
            return "Trace(coordinates=" + this.coordinates + ", bucket=" + this.bucket + ", reasons=" + this.reasons + ")";
        }

        public int hashCode() {
            int result = this.coordinates.hashCode();
            result = result * 31 + this.bucket.hashCode();
            result = result * 31 + ((Object)this.reasons).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trace)) {
                return false;
            }
            Trace trace = (Trace)other;
            if (!Intrinsics.areEqual((Object)this.coordinates, (Object)trace.coordinates)) {
                return false;
            }
            if (this.bucket != trace.bucket) {
                return false;
            }
            return Intrinsics.areEqual(this.reasons, trace.reasons);
        }
    }
}

