/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.Behavior;
import com.autonomousapps.extension.Ignore;
import com.autonomousapps.internal.DependencyScope;
import com.autonomousapps.internal.advice.SeverityHandler;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.DuplicateClass;
import com.autonomousapps.model.ModuleAdvice;
import com.autonomousapps.model.PluginAdvice;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.model.Warning;
import com.autonomousapps.tasks.FilterAdviceTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010)\u001a\u00020*H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\tR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\tR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\tR\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\tR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "anyBehavior", "Lorg/gradle/api/provider/ListProperty;", "Lcom/autonomousapps/extension/Behavior;", "getAnyBehavior", "()Lorg/gradle/api/provider/ListProperty;", "compileOnlyBehavior", "getCompileOnlyBehavior", "dataBindingEnabled", "Lorg/gradle/api/provider/Property;", "", "getDataBindingEnabled", "()Lorg/gradle/api/provider/Property;", "duplicateClassWarningsBehavior", "getDuplicateClassWarningsBehavior", "incorrectConfigurationBehavior", "getIncorrectConfigurationBehavior", "moduleStructureBehavior", "getModuleStructureBehavior", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "projectAdvice", "getProjectAdvice", "redundantPluginsBehavior", "getRedundantPluginsBehavior", "runtimeOnlyBehavior", "getRuntimeOnlyBehavior", "unusedDependenciesBehavior", "getUnusedDependenciesBehavior", "unusedProcsBehavior", "getUnusedProcsBehavior", "usedTransitiveDependenciesBehavior", "getUsedTransitiveDependenciesBehavior", "viewBindingEnabled", "getViewBindingEnabled", "action", "", "Companion", "FilterAdviceAction", "FilterAdviceParameters", "dependency-analysis-gradle-plugin"})
public abstract class FilterAdviceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private static final List<String> databindingDependencies;
    @NotNull
    private static final List<String> viewBindingDependencies;

    @Inject
    public FilterAdviceTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setDescription("Filter merged advice based on user preferences");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @Input
    @NotNull
    public abstract Property<Boolean> getDataBindingEnabled();

    @Input
    @NotNull
    public abstract Property<Boolean> getViewBindingEnabled();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getAnyBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getUnusedDependenciesBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getUsedTransitiveDependenciesBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getIncorrectConfigurationBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getUnusedProcsBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getCompileOnlyBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getRuntimeOnlyBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getDuplicateClassWarningsBehavior();

    @Input
    @NotNull
    public abstract Property<Behavior> getRedundantPluginsBehavior();

    @Input
    @NotNull
    public abstract Property<Behavior> getModuleStructureBehavior();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(FilterAdviceAction.class, new Action(this){
            final /* synthetic */ FilterAdviceTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(FilterAdviceParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                $this$submit.getProjectAdvice().set((Provider)this.this$0.getProjectAdvice());
                $this$submit.getDataBindingEnabled().set((Provider)this.this$0.getDataBindingEnabled());
                $this$submit.getViewBindingEnabled().set((Provider)this.this$0.getViewBindingEnabled());
                $this$submit.getAnyBehavior().set((Provider)this.this$0.getAnyBehavior());
                $this$submit.getUnusedDependenciesBehavior().set((Provider)this.this$0.getUnusedDependenciesBehavior());
                $this$submit.getUsedTransitiveDependenciesBehavior().set((Provider)this.this$0.getUsedTransitiveDependenciesBehavior());
                $this$submit.getIncorrectConfigurationBehavior().set((Provider)this.this$0.getIncorrectConfigurationBehavior());
                $this$submit.getUnusedProcsBehavior().set((Provider)this.this$0.getUnusedProcsBehavior());
                $this$submit.getCompileOnlyBehavior().set((Provider)this.this$0.getCompileOnlyBehavior());
                $this$submit.getRuntimeOnlyBehavior().set((Provider)this.this$0.getRuntimeOnlyBehavior());
                $this$submit.getDuplicateClassWarningsBehavior().set((Provider)this.this$0.getDuplicateClassWarningsBehavior());
                $this$submit.getRedundantPluginsBehavior().set((Provider)this.this$0.getRedundantPluginsBehavior());
                $this$submit.getModuleStructureBehavior().set((Provider)this.this$0.getModuleStructureBehavior());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
        });
    }

    public static final /* synthetic */ List access$getDatabindingDependencies$cp() {
        return databindingDependencies;
    }

    public static final /* synthetic */ List access$getViewBindingDependencies$cp() {
        return viewBindingDependencies;
    }

    static {
        Object[] objectArray = new String[]{"androidx.databinding:databinding-adapters", "androidx.databinding:databinding-runtime", "androidx.databinding:databinding-common", "androidx.databinding:databinding-compiler", "androidx.databinding:databinding-ktx"};
        databindingDependencies = CollectionsKt.listOf((Object[])objectArray);
        viewBindingDependencies = CollectionsKt.listOf((Object)"androidx.databinding:viewbinding");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask$Companion;", "", "()V", "databindingDependencies", "", "", "viewBindingDependencies", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002JF\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u001eH\u0002J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0019*\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005H\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceParameters;", "()V", "anyBehavior", "Lkotlin/Pair;", "Lcom/autonomousapps/extension/Behavior;", "", "compileOnlyBehavior", "dataBindingEnabled", "", "duplicateClassWarningsBehavior", "incorrectConfigurationBehavior", "moduleStructureBehavior", "redundantPluginsBehavior", "runtimeOnlyBehavior", "unusedDependenciesBehavior", "unusedProcsBehavior", "usedTransitiveDependenciesBehavior", "viewBindingEnabled", "execute", "", "partition", "behaviors", "filterDataBinding", "Lkotlin/sequences/Sequence;", "Lcom/autonomousapps/model/Advice;", "filterOf", "behaviorSpec", "predicate", "Lkotlin/Function1;", "Lcom/autonomousapps/model/DuplicateClass;", "filterViewBinding", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nFilterAdviceTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterAdviceTask.kt\ncom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,300:1\n3193#2,10:301\n117#3,13:311\n40#4,2:324\n33#4,4:326\n176#4,3:330\n40#4,2:333\n33#4,4:335\n179#4,2:339\n*S KotlinDebug\n*F\n+ 1 FilterAdviceTask.kt\ncom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceAction\n*L\n130#1:301,10\n141#1:311,13\n141#1:324,2\n141#1:326,4\n200#1:330,3\n200#1:333,2\n200#1:335,4\n200#1:339,2\n*E\n"})
    public static abstract class FilterAdviceAction
    implements WorkAction<FilterAdviceParameters> {
        private final boolean dataBindingEnabled;
        private final boolean viewBindingEnabled;
        @NotNull
        private final Pair<Behavior, List<Behavior>> anyBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> unusedDependenciesBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> usedTransitiveDependenciesBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> incorrectConfigurationBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> unusedProcsBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> compileOnlyBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> runtimeOnlyBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> duplicateClassWarningsBehavior;
        @NotNull
        private final Behavior redundantPluginsBehavior;
        @NotNull
        private final Behavior moduleStructureBehavior;

        public FilterAdviceAction() {
            Object object = ((FilterAdviceParameters)this.getParameters()).getDataBindingEnabled().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.dataBindingEnabled.get()");
            this.dataBindingEnabled = (Boolean)object;
            Object object2 = ((FilterAdviceParameters)this.getParameters()).getViewBindingEnabled().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.viewBindingEnabled.get()");
            this.viewBindingEnabled = (Boolean)object2;
            Object object3 = ((FilterAdviceParameters)this.getParameters()).getAnyBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.anyBehavior.get()");
            this.anyBehavior = this.partition((List)object3);
            Object object4 = ((FilterAdviceParameters)this.getParameters()).getUnusedDependenciesBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.unusedDependenciesBehavior.get()");
            this.unusedDependenciesBehavior = this.partition((List)object4);
            Object object5 = ((FilterAdviceParameters)this.getParameters()).getUsedTransitiveDependenciesBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.usedTransitiv\u2026ependenciesBehavior.get()");
            this.usedTransitiveDependenciesBehavior = this.partition((List)object5);
            Object object6 = ((FilterAdviceParameters)this.getParameters()).getIncorrectConfigurationBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters.incorrectConfigurationBehavior.get()");
            this.incorrectConfigurationBehavior = this.partition((List)object6);
            Object object7 = ((FilterAdviceParameters)this.getParameters()).getUnusedProcsBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"parameters.unusedProcsBehavior.get()");
            this.unusedProcsBehavior = this.partition((List)object7);
            Object object8 = ((FilterAdviceParameters)this.getParameters()).getCompileOnlyBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"parameters.compileOnlyBehavior.get()");
            this.compileOnlyBehavior = this.partition((List)object8);
            Object object9 = ((FilterAdviceParameters)this.getParameters()).getRuntimeOnlyBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"parameters.runtimeOnlyBehavior.get()");
            this.runtimeOnlyBehavior = this.partition((List)object9);
            Object object10 = ((FilterAdviceParameters)this.getParameters()).getDuplicateClassWarningsBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"parameters.duplicateClassWarningsBehavior.get()");
            this.duplicateClassWarningsBehavior = this.partition((List)object10);
            Object object11 = ((FilterAdviceParameters)this.getParameters()).getRedundantPluginsBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"parameters.redundantPluginsBehavior.get()");
            this.redundantPluginsBehavior = (Behavior)object11;
            Object object12 = ((FilterAdviceParameters)this.getParameters()).getModuleStructureBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"parameters.moduleStructureBehavior.get()");
            this.moduleStructureBehavior = (Behavior)object12;
        }

        private final Pair<Behavior, List<Behavior>> partition(List<? extends Behavior> behaviors) {
            Iterable $this$partition$iv = behaviors;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Behavior it = (Behavior)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getSourceSetName(), (Object)"__all")) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair p = new Pair(first$iv, second$iv);
            Behavior global = (Behavior)CollectionsKt.first((List)((List)p.getFirst()));
            List rest = (List)p.getSecond();
            return TuplesKt.to((Object)global, (Object)rest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Object $this$withNulls$iv$iv$iv$iv$iv;
            Pair<Behavior, List<Behavior>> reader$iv$iv$iv2;
            File output = UtilsKt.getAndDelete(((FilterAdviceParameters)this.getParameters()).getOutput());
            RegularFileProperty $this$fromJson$iv = ((FilterAdviceParameters)this.getParameters()).getProjectAdvice();
            boolean $i$f$fromJson = false;
            Object object = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson222 = false;
            Pair<Behavior, List<Behavior>> pair = (Pair<Behavior, List<Behavior>>)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Pair<Behavior, List<Behavior>> pair2 = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)pair;
                boolean bl = false;
                boolean withNulls$iv$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object2 = $this$withNulls$iv$iv$iv$iv$iv.fromJson((BufferedSource)reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object2);
                reader$iv$iv$iv2 = object2;
            }
            catch (Throwable reader$iv$iv$iv2) {
                pair2 = reader$iv$iv$iv2;
                throw reader$iv$iv$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)pair, (Throwable)pair2);
            }
            ProjectAdvice projectAdvice2 = (ProjectAdvice)reader$iv$iv$iv2;
            Set dependencyAdvice2 = SequencesKt.toSortedSet(this.filterViewBinding(this.filterDataBinding(this.filterOf(this.filterOf(this.filterOf(this.filterOf(this.filterOf(this.filterOf(this.filterOf((Sequence<Advice>)CollectionsKt.asSequence((Iterable)projectAdvice2.getDependencyAdvice()), this.anyBehavior, (Function1<? super Advice, Boolean>)((Function1)execute.dependencyAdvice.1.INSTANCE)), this.unusedDependenciesBehavior, (Function1<? super Advice, Boolean>)((Function1)execute.dependencyAdvice.2.INSTANCE)), this.usedTransitiveDependenciesBehavior, (Function1<? super Advice, Boolean>)((Function1)execute.dependencyAdvice.3.INSTANCE)), this.incorrectConfigurationBehavior, (Function1<? super Advice, Boolean>)((Function1)execute.dependencyAdvice.4.INSTANCE)), this.compileOnlyBehavior, (Function1<? super Advice, Boolean>)((Function1)execute.dependencyAdvice.5.INSTANCE)), this.runtimeOnlyBehavior, (Function1<? super Advice, Boolean>)((Function1)execute.dependencyAdvice.6.INSTANCE)), this.unusedProcsBehavior, (Function1<? super Advice, Boolean>)((Function1)execute.dependencyAdvice.7.INSTANCE)))));
            Set pluginAdvice2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)projectAdvice2.getPluginAdvice()), (Function1)((Function1)new Function1<PluginAdvice, Boolean>(this){
                final /* synthetic */ FilterAdviceAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(PluginAdvice it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FilterAdviceAction.access$getAnyBehavior$p(this.this$0).getFirst() instanceof Ignore || ((Behavior)FilterAdviceAction.access$getAnyBehavior$p(this.this$0).getFirst()).getFilter().contains(it.getRedundantPlugin());
                }
            })), (Function1)((Function1)new Function1<PluginAdvice, Boolean>(this){
                final /* synthetic */ FilterAdviceAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(PluginAdvice it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FilterAdviceAction.access$getRedundantPluginsBehavior$p(this.this$0) instanceof Ignore || FilterAdviceAction.access$getRedundantPluginsBehavior$p(this.this$0).getFilter().contains(it.getRedundantPlugin());
                }
            })));
            Set moduleAdvice2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)projectAdvice2.getModuleAdvice()), (Function1)((Function1)new Function1<ModuleAdvice, Boolean>(this){
                final /* synthetic */ FilterAdviceAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(ModuleAdvice it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FilterAdviceAction.access$getAnyBehavior$p(this.this$0).getFirst() instanceof Ignore || it.shouldIgnore$dependency_analysis_gradle_plugin((Behavior)FilterAdviceAction.access$getAnyBehavior$p(this.this$0).getFirst());
                }
            })), (Function1)((Function1)new Function1<ModuleAdvice, Boolean>(this){
                final /* synthetic */ FilterAdviceAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(ModuleAdvice it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FilterAdviceAction.access$getModuleStructureBehavior$p(this.this$0) instanceof Ignore || it.shouldIgnore$dependency_analysis_gradle_plugin(FilterAdviceAction.access$getModuleStructureBehavior$p(this.this$0));
                }
            })));
            SortedSet duplicateClassWarnings = SequencesKt.toSortedSet(this.filterOf((Sequence<DuplicateClass>)CollectionsKt.asSequence((Iterable)projectAdvice2.getWarning().getDuplicateClasses()), this.duplicateClassWarningsBehavior));
            Pair<Behavior, List<Behavior>> $i$f$fromJson222 = this.anyBehavior;
            pair = this.unusedDependenciesBehavior;
            pair2 = this.usedTransitiveDependenciesBehavior;
            reader$iv$iv$iv2 = this.incorrectConfigurationBehavior;
            Pair<Behavior, List<Behavior>> bl = this.unusedProcsBehavior;
            Pair<Behavior, List<Behavior>> withNulls$iv$iv$iv$iv = this.compileOnlyBehavior;
            Pair<Behavior, List<Behavior>> $i$f$getJsonAdapter = this.duplicateClassWarningsBehavior;
            $this$withNulls$iv$iv$iv$iv$iv = this.redundantPluginsBehavior;
            Object object3 = this.moduleStructureBehavior;
            SeverityHandler severityHandler = new SeverityHandler($i$f$fromJson222, pair, pair2, reader$iv$iv$iv2, withNulls$iv$iv$iv$iv, bl, $i$f$getJsonAdapter, (Behavior)$this$withNulls$iv$iv$iv$iv$iv, (Behavior)object3);
            boolean shouldFailDeps = severityHandler.shouldFailDeps(dependencyAdvice2);
            boolean shouldFailPlugins = severityHandler.shouldFailPlugins(pluginAdvice2);
            boolean shouldFailModuleStructure = severityHandler.shouldFailModuleStructure(moduleAdvice2);
            boolean shouldFailDuplicateClasses = severityHandler.shouldFailDuplicateClasses(duplicateClassWarnings);
            ProjectAdvice filteredAdvice = ProjectAdvice.copy$default(projectAdvice2, null, dependencyAdvice2, pluginAdvice2, moduleAdvice2, new Warning(duplicateClassWarnings), shouldFailDeps || shouldFailPlugins || shouldFailModuleStructure || shouldFailDuplicateClasses, 1, null);
            File $this$bufferWriteJson_u24default$iv = output;
            String indent$iv = "";
            boolean $i$f$bufferWriteJson = false;
            object3 = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
            Throwable throwable = null;
            try {
                JsonWriter writer$iv = (JsonWriter)object3;
                boolean bl2 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter2 = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)filteredAdvice);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
        }

        private final Sequence<Advice> filterOf(Sequence<Advice> $this$filterOf, Pair<? extends Behavior, ? extends List<? extends Behavior>> behaviorSpec, Function1<? super Advice, Boolean> predicate) {
            Behavior globalBehavior = (Behavior)behaviorSpec.getFirst();
            List sourceSetsBehavior = (List)behaviorSpec.getSecond();
            Function1 byGlobal2 = (Function1)new Function1<Advice, Boolean>(globalBehavior){
                final /* synthetic */ Behavior $globalBehavior;
                {
                    this.$globalBehavior = $globalBehavior;
                    super(1);
                }

                public final Boolean invoke(Advice a) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    return this.$globalBehavior instanceof Ignore || this.$globalBehavior.getFilter().contains(a.getCoordinates().getIdentifier()) || this.$globalBehavior.getFilter().contains(a.getCoordinates().gav());
                }
            };
            Function1 bySourceSets2 = (Function1)new Function1<Advice, Boolean>((List<? extends Behavior>)sourceSetsBehavior){
                final /* synthetic */ List<Behavior> $sourceSetsBehavior;
                {
                    this.$sourceSetsBehavior = $sourceSetsBehavior;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Boolean invoke(Advice a) {
                    Object v2;
                    void $this$reduceOrNull$iv;
                    void $this$mapTo$iv$iv;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Iterable $this$filter$iv = this.$sourceSetsBehavior;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Iterable<Object> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String to;
                        String string;
                        String from;
                        String string2;
                        Behavior b = (Behavior)element$iv$iv;
                        boolean bl = false;
                        if (a.getFromConfiguration() != null) {
                            String it;
                            boolean bl2 = false;
                            string2 = DependencyScope.Companion.sourceSetName(it);
                        } else {
                            string2 = from = null;
                        }
                        if (a.getToConfiguration() != null) {
                            String it;
                            boolean bl3 = false;
                            string = DependencyScope.Companion.sourceSetName(it);
                        } else {
                            string = to = null;
                        }
                        if (!(Intrinsics.areEqual((Object)b.getSourceSetName(), (Object)from) || Intrinsics.areEqual((Object)b.getSourceSetName(), (Object)to))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List behaviors = (List)destination$iv$iv;
                    Iterable $this$map$iv = behaviors;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Behavior bl = (Behavior)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl4 = false;
                        collection.add(it instanceof Ignore || it.getFilter().contains(a.getCoordinates().getIdentifier()) || it.getFilter().contains(a.getCoordinates().gav()));
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$reduceOrNull = false;
                    Iterator<T> iterator$iv = $this$reduceOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v2 = null;
                    } else {
                        Object accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void b;
                            $i$f$mapTo = (Boolean)iterator$iv.next();
                            boolean acc = (Boolean)accumulator$iv;
                            boolean bl = false;
                            accumulator$iv = acc || b != false;
                        }
                        v2 = accumulator$iv;
                    }
                    Boolean bl = v2;
                    return bl != null ? bl : false;
                }
            };
            return SequencesKt.filterNot($this$filterOf, (Function1)((Function1)new Function1<Advice, Boolean>(predicate, (Function1<? super Advice, Boolean>)byGlobal2, (Function1<? super Advice, Boolean>)bySourceSets2){
                final /* synthetic */ Function1<Advice, Boolean> $predicate;
                final /* synthetic */ Function1<Advice, Boolean> $byGlobal;
                final /* synthetic */ Function1<Advice, Boolean> $bySourceSets;
                {
                    this.$predicate = $predicate;
                    this.$byGlobal = $byGlobal;
                    this.$bySourceSets = $bySourceSets;
                    super(1);
                }

                public final Boolean invoke(Advice advice) {
                    Intrinsics.checkNotNullParameter((Object)advice, (String)"advice");
                    return (Boolean)this.$predicate.invoke((Object)advice) != false && ((Boolean)this.$byGlobal.invoke((Object)advice) != false || (Boolean)this.$bySourceSets.invoke((Object)advice) != false);
                }
            }));
        }

        private final Sequence<Advice> filterDataBinding(Sequence<Advice> $this$filterDataBinding) {
            return this.dataBindingEnabled ? SequencesKt.filterNot($this$filterDataBinding, (Function1)filterDataBinding.1.INSTANCE) : $this$filterDataBinding;
        }

        private final Sequence<Advice> filterViewBinding(Sequence<Advice> $this$filterViewBinding) {
            return this.viewBindingEnabled ? SequencesKt.filterNot($this$filterViewBinding, (Function1)filterViewBinding.1.INSTANCE) : $this$filterViewBinding;
        }

        private final Sequence<DuplicateClass> filterOf(Sequence<DuplicateClass> $this$filterOf, Pair<? extends Behavior, ? extends List<? extends Behavior>> behaviorSpec) {
            Behavior globalBehavior = (Behavior)behaviorSpec.getFirst();
            List sourceSetsBehavior = (List)behaviorSpec.getSecond();
            Function1 byGlobal2 = (Function1)new Function1<DuplicateClass, Boolean>(globalBehavior){
                final /* synthetic */ Behavior $globalBehavior;
                {
                    this.$globalBehavior = $globalBehavior;
                    super(1);
                }

                public final Boolean invoke(DuplicateClass d) {
                    Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                    return this.$globalBehavior instanceof Ignore || d.containsMatchIn$dependency_analysis_gradle_plugin(this.$globalBehavior);
                }
            };
            Function1 bySourceSets2 = (Function1)new Function1<DuplicateClass, Boolean>((List<? extends Behavior>)sourceSetsBehavior){
                final /* synthetic */ List<Behavior> $sourceSetsBehavior;
                {
                    this.$sourceSetsBehavior = $sourceSetsBehavior;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Boolean invoke(DuplicateClass d) {
                    Object v0;
                    void $this$reduceOrNull$iv;
                    void $this$mapTo$iv$iv;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                    Iterable $this$filter$iv = this.$sourceSetsBehavior;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Iterable<T> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Behavior b = (Behavior)element$iv$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)b.getSourceSetName(), (Object)DependencyScope.Companion.sourceSetName(d.getClasspathName()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List behaviors = (List)destination$iv$iv;
                    Iterable $this$map$iv = behaviors;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Behavior bl = (Behavior)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(it instanceof Ignore || d.containsMatchIn$dependency_analysis_gradle_plugin((Behavior)it));
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$reduceOrNull = false;
                    Iterator<T> iterator$iv = $this$reduceOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v0 = null;
                    } else {
                        Object accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void b;
                            $i$f$mapTo = (Boolean)iterator$iv.next();
                            boolean acc = (Boolean)accumulator$iv;
                            boolean bl = false;
                            accumulator$iv = acc || b != false;
                        }
                        v0 = accumulator$iv;
                    }
                    Boolean bl = v0;
                    return bl != null ? bl : false;
                }
            };
            return SequencesKt.filterNot($this$filterOf, (Function1)((Function1)new Function1<DuplicateClass, Boolean>((Function1<? super DuplicateClass, Boolean>)byGlobal2, (Function1<? super DuplicateClass, Boolean>)bySourceSets2){
                final /* synthetic */ Function1<DuplicateClass, Boolean> $byGlobal;
                final /* synthetic */ Function1<DuplicateClass, Boolean> $bySourceSets;
                {
                    this.$byGlobal = $byGlobal;
                    this.$bySourceSets = $bySourceSets;
                    super(1);
                }

                public final Boolean invoke(DuplicateClass duplicateClass) {
                    Intrinsics.checkNotNullParameter((Object)duplicateClass, (String)"duplicateClass");
                    return (Boolean)this.$byGlobal.invoke((Object)duplicateClass) != false || (Boolean)this.$bySourceSets.invoke((Object)duplicateClass) != false;
                }
            }));
        }

        public static final /* synthetic */ Pair access$getAnyBehavior$p(FilterAdviceAction $this) {
            return $this.anyBehavior;
        }

        public static final /* synthetic */ Behavior access$getRedundantPluginsBehavior$p(FilterAdviceAction $this) {
            return $this.redundantPluginsBehavior;
        }

        public static final /* synthetic */ Behavior access$getModuleStructureBehavior$p(FilterAdviceAction $this) {
            return $this.moduleStructureBehavior;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0006R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0006R\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0006R\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0006R\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006&\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceParameters;", "Lorg/gradle/workers/WorkParameters;", "anyBehavior", "Lorg/gradle/api/provider/ListProperty;", "Lcom/autonomousapps/extension/Behavior;", "getAnyBehavior", "()Lorg/gradle/api/provider/ListProperty;", "compileOnlyBehavior", "getCompileOnlyBehavior", "dataBindingEnabled", "Lorg/gradle/api/provider/Property;", "", "getDataBindingEnabled", "()Lorg/gradle/api/provider/Property;", "duplicateClassWarningsBehavior", "getDuplicateClassWarningsBehavior", "incorrectConfigurationBehavior", "getIncorrectConfigurationBehavior", "moduleStructureBehavior", "getModuleStructureBehavior", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "projectAdvice", "getProjectAdvice", "redundantPluginsBehavior", "getRedundantPluginsBehavior", "runtimeOnlyBehavior", "getRuntimeOnlyBehavior", "unusedDependenciesBehavior", "getUnusedDependenciesBehavior", "unusedProcsBehavior", "getUnusedProcsBehavior", "usedTransitiveDependenciesBehavior", "getUsedTransitiveDependenciesBehavior", "viewBindingEnabled", "getViewBindingEnabled", "dependency-analysis-gradle-plugin"})
    public static interface FilterAdviceParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getProjectAdvice();

        @NotNull
        public Property<Boolean> getDataBindingEnabled();

        @NotNull
        public Property<Boolean> getViewBindingEnabled();

        @NotNull
        public ListProperty<Behavior> getAnyBehavior();

        @NotNull
        public ListProperty<Behavior> getUnusedDependenciesBehavior();

        @NotNull
        public ListProperty<Behavior> getUsedTransitiveDependenciesBehavior();

        @NotNull
        public ListProperty<Behavior> getIncorrectConfigurationBehavior();

        @NotNull
        public ListProperty<Behavior> getUnusedProcsBehavior();

        @NotNull
        public ListProperty<Behavior> getCompileOnlyBehavior();

        @NotNull
        public ListProperty<Behavior> getRuntimeOnlyBehavior();

        @NotNull
        public ListProperty<Behavior> getDuplicateClassWarningsBehavior();

        @NotNull
        public Property<Behavior> getRedundantPluginsBehavior();

        @NotNull
        public Property<Behavior> getModuleStructureBehavior();

        @NotNull
        public RegularFileProperty getOutput();
    }
}

