/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.intermediates.NativeLibDependency;
import com.autonomousapps.tasks.FindNativeLibsTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0007J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/tasks/FindNativeLibsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "androidJni", "Lorg/gradle/api/artifacts/ArtifactCollection;", "dylibs", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "findAndroidNativeDependencies", "", "Lcom/autonomousapps/model/internal/intermediates/NativeLibDependency;", "findMacNativeDependencies", "getAndroidJniFiles", "Lorg/gradle/api/file/FileCollection;", "getMacNativeLibs", "setAndroidJni", "setMacNativeLibs", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFindNativeLibsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindNativeLibsTask.kt\ncom/autonomousapps/tasks/FindNativeLibsTask\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 3 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n149#2,3:110\n49#2,3:113\n33#2,4:116\n152#2,2:120\n136#3:122\n136#3:128\n1619#4:123\n1863#4:124\n1864#4:126\n1620#4:127\n1619#4:129\n1863#4:130\n1864#4:132\n1620#4:133\n1#5:125\n1#5:131\n*S KotlinDebug\n*F\n+ 1 FindNativeLibsTask.kt\ncom/autonomousapps/tasks/FindNativeLibsTask\n*L\n62#1:110,3\n62#1:113,3\n62#1:116,4\n62#1:120,2\n68#1:122\n87#1:128\n68#1:123\n68#1:124\n68#1:126\n68#1:127\n87#1:129\n87#1:130\n87#1:132\n87#1:133\n68#1:125\n87#1:131\n*E\n"})
public abstract class FindNativeLibsTask
extends DefaultTask {
    private ArtifactCollection androidJni;
    private ArtifactCollection dylibs;

    public FindNativeLibsTask() {
        this.setDescription("Produces a report of all dependencies that supply native libs");
    }

    public final void setAndroidJni(@NotNull ArtifactCollection androidJni) {
        Intrinsics.checkNotNullParameter((Object)androidJni, (String)"androidJni");
        this.androidJni = androidJni;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @Nullable
    public final FileCollection getAndroidJniFiles() {
        if (this.androidJni == null) {
            return null;
        }
        ArtifactCollection artifactCollection = this.androidJni;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidJni");
            artifactCollection = null;
        }
        return artifactCollection.getArtifactFiles();
    }

    public final void setMacNativeLibs(@NotNull ArtifactCollection dylibs2) {
        Intrinsics.checkNotNullParameter((Object)dylibs2, (String)"dylibs");
        this.dylibs = dylibs2;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @Nullable
    public final FileCollection getMacNativeLibs() {
        if (this.dylibs == null) {
            return null;
        }
        ArtifactCollection artifactCollection = this.dylibs;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dylibs");
            artifactCollection = null;
        }
        return artifactCollection.getArtifactFiles();
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void action() {
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        Set<NativeLibDependency> nativeLibDependencies = this.findAndroidNativeDependencies();
        Set<NativeLibDependency> macNativeLibs = this.findMacNativeDependencies();
        Set result = SetsKt.plus(nativeLibDependencies, (Iterable)macNativeLibs);
        File $this$bufferWriteJsonSet_u24default$iv = outputFile;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            Type[] typeArray = new Type[]{NativeLibDependency.class};
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)result);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<NativeLibDependency> findAndroidNativeDependencies() {
        void $this$mapNotNullTo$iv$iv;
        if (this.androidJni == null) {
            return SetsKt.emptySet();
        }
        ArtifactCollection artifactCollection = this.androidJni;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidJni");
            artifactCollection = null;
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NativeLibDependency it$iv$iv;
            NativeLibDependency nativeLibDependency;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult jniDep = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            File file = jniDep.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jniDep.file");
            SortedSet soFiles2 = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkBottomUp((File)file)), (Function1)findAndroidNativeDependencies.1.soFiles.1.INSTANCE), (Function1)findAndroidNativeDependencies.1.soFiles.2.INSTANCE));
            try {
                Intrinsics.checkNotNullExpressionValue((Object)jniDep, (String)"jniDep");
                nativeLibDependency = NativeLibDependency.Companion.newInstance(GradleStringsKt.toCoordinates(jniDep), soFiles2);
            }
            catch (GradleException gradleException) {
                nativeLibDependency = null;
            }
            if (nativeLibDependency == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<NativeLibDependency> findMacNativeDependencies() {
        void $this$mapNotNullTo$iv$iv;
        if (this.dylibs == null) {
            return SetsKt.emptySet();
        }
        ArtifactCollection artifactCollection = this.dylibs;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dylibs");
            artifactCollection = null;
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NativeLibDependency nativeLibDependency;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult maybeMacArtifact = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            File file = maybeMacArtifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"maybeMacArtifact.file");
            SortedSet dylibs2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkBottomUp((File)file)), (Function1)findMacNativeDependencies.1.dylibs.1.INSTANCE), (Function1)findMacNativeDependencies.1.dylibs.2.INSTANCE), (Function1)findMacNativeDependencies.1.dylibs.3.INSTANCE));
            if (!((Collection)dylibs2).isEmpty()) {
                NativeLibDependency nativeLibDependency2;
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)maybeMacArtifact, (String)"maybeMacArtifact");
                    nativeLibDependency2 = NativeLibDependency.Companion.newInstance(GradleStringsKt.toCoordinates(maybeMacArtifact), dylibs2);
                }
                catch (GradleException gradleException) {
                    nativeLibDependency2 = null;
                }
                nativeLibDependency = nativeLibDependency2;
            } else {
                nativeLibDependency = null;
            }
            if (nativeLibDependency == null) continue;
            NativeLibDependency it$iv$iv = nativeLibDependency;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Set)destination$iv$iv;
    }
}

