/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.parse.ExplodedRes;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.XmlKt;
import com.autonomousapps.internal.utils.document.DocumentKt;
import com.autonomousapps.model.internal.AndroidResSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/internal/parse/AndroidResParser;", "", "projectDir", "Ljava/io/File;", "resources", "", "(Ljava/io/File;Ljava/lang/Iterable;)V", "androidResSource", "", "Lcom/autonomousapps/internal/parse/ExplodedRes;", "getAndroidResSource", "()Ljava/util/Set;", "container", "Lcom/autonomousapps/internal/parse/AndroidResParser$Container;", "extractAttrsFromResourceXml", "", "doc", "Lorg/w3c/dom/Document;", "extractContentReferencesFromResourceXml", "extractStyleParentsFromResourceXml", "Lcom/autonomousapps/model/internal/AndroidResSource$StyleParentRef;", "Container", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nexplodeAndroidResSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidResParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 5 document.kt\ncom/autonomousapps/internal/utils/document/DocumentKt\n*L\n1#1,196:1\n1603#2,9:197\n1855#2:206\n1856#2:208\n1612#2:209\n1620#2,3:211\n1620#2,3:220\n1855#2,2:223\n1855#2,2:225\n1#3:207\n1#3:217\n107#4:210\n107#4:219\n55#5,3:214\n59#5:218\n*S KotlinDebug\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidResParser\n*L\n59#1:197,9\n59#1:206\n59#1:208\n59#1:209\n67#1:211,3\n83#1:220,3\n88#1:223,2\n94#1:225,2\n59#1:207\n81#1:217\n67#1:210\n83#1:219\n81#1:214,3\n81#1:218\n*E\n"})
public final class AndroidResParser {
    @NotNull
    private final Container container;
    @NotNull
    private final Set<ExplodedRes> androidResSource;

    /*
     * WARNING - void declaration
     */
    public AndroidResParser(@NotNull File projectDir, @NotNull Iterable<? extends File> resources) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.container = new Container();
        Iterable<? extends File> iterable = resources;
        AndroidResParser androidResParser = this;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair it$iv$iv;
            Pair pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            try {
                pair2 = TuplesKt.to((Object)it, (Object)XmlKt.buildDocument(it));
            }
            catch (SAXParseException sAXParseException) {
                pair2 = null;
            }
            if (pair2 == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$mapNotNullTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = (File)pair.component1();
            Document doc = (Document)pair.component2();
            this.extractAttrsFromResourceXml(doc);
            this.extractContentReferencesFromResourceXml(doc);
            collection.add(new ExplodedRes(FilesKt.toRelativeString((File)file, (File)projectDir), this.extractStyleParentsFromResourceXml(doc), this.container.nonLocalAttrRefs()));
        }
        androidResParser.androidResSource = (Set)destination$iv$iv;
    }

    @NotNull
    public final Set<ExplodedRes> getAndroidResSource() {
        return this.androidResSource;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AndroidResSource.StyleParentRef> extractStyleParentsFromResourceXml(Document doc) {
        void $this$mapTo$iv$iv;
        String it$iv;
        NodeList nodeList = doc.getElementsByTagName("style");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"doc.getElementsByTagName(\"style\")");
        NodeList $this$mapNotNull$iv = nodeList;
        boolean $i$f$mapNotNull = false;
        Iterable<String> destination$iv = new ArrayList($this$mapNotNull$iv.getLength());
        int n = $this$mapNotNull$iv.getLength();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Node it;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapNotNull$iv.item(i$iv), (String)"item(i)");
            boolean bl = false;
            Node node = it.getAttributes().getNamedItem("parent");
            if ((node != null ? node.getNodeValue() : null) == null) continue;
            it$iv = it$iv;
            boolean bl2 = false;
            ((ArrayList)destination$iv).add(it$iv);
        }
        Iterable $this$mapToSet$iv = (List)destination$iv;
        boolean $i$f$mapToSet = false;
        destination$iv = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            it$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AndroidResSource.StyleParentRef.Companion.of((String)it));
        }
        return (Set)destination$iv$iv;
    }

    private final void extractAttrsFromResourceXml(Document doc) {
        Iterable $this$forEach$iv = DocumentKt.attrs(doc);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            AndroidResSource.AttrRef.Companion.from$dependency_analysis_gradle_plugin((Pair<String, String>)it, this.container);
        }
    }

    private final void extractContentReferencesFromResourceXml(Document doc) {
        Iterable $this$forEach$iv = DocumentKt.contentReferences(doc).entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            AndroidResSource.AttrRef.Companion.from$dependency_analysis_gradle_plugin((Pair<String, String>)TuplesKt.to(it.getKey(), it.getValue()), this.container);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/internal/parse/AndroidResParser$Container;", "", "()V", "attrRefs", "", "Lcom/autonomousapps/model/internal/AndroidResSource$AttrRef;", "getAttrRefs", "()Ljava/util/Set;", "newIds", "getNewIds", "nonLocalAttrRefs", "", "dependency-analysis-gradle-plugin"})
    public static final class Container {
        @NotNull
        private final Set<AndroidResSource.AttrRef> attrRefs = new LinkedHashSet();
        @NotNull
        private final Set<AndroidResSource.AttrRef> newIds = new LinkedHashSet();

        @NotNull
        public final Set<AndroidResSource.AttrRef> getAttrRefs() {
            return this.attrRefs;
        }

        @NotNull
        public final Set<AndroidResSource.AttrRef> getNewIds() {
            return this.newIds;
        }

        @NotNull
        public final Set<AndroidResSource.AttrRef> nonLocalAttrRefs() {
            return SetsKt.minus(this.attrRefs, (Iterable)this.newIds);
        }
    }
}

