/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.Bundles;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.CoordinatesString;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.MultimapsKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.IncludedBuildCoordinates;
import com.autonomousapps.model.PluginAdvice;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.model.Warning;
import com.autonomousapps.model.declaration.Variant;
import com.autonomousapps.model.declaration.internal.Declaration;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.autonomousapps.model.internal.intermediates.AndroidScoreVariant;
import com.autonomousapps.model.internal.intermediates.BundleTrace;
import com.autonomousapps.model.internal.intermediates.DependencyTraceReport;
import com.autonomousapps.model.internal.intermediates.Usage;
import com.autonomousapps.model.internal.intermediates.UsageBuilder;
import com.autonomousapps.tasks.ComputeAdviceTask;
import com.autonomousapps.tasks.DependencyAdviceBuilder;
import com.autonomousapps.tasks.PluginAdviceBuilder;
import com.google.common.collect.SetMultimap;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u000256B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00103\u001a\u000204H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\tR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\tR\u0014\u0010\u001e\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\tR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020'0\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0012R\u0014\u0010+\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0012R\u0014\u0010/\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00100#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/autonomousapps/tasks/ComputeAdviceTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "androidScoreReports", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getAndroidScoreReports", "()Lorg/gradle/api/provider/ListProperty;", "annotationProcessorUsages", "Lorg/gradle/api/file/RegularFileProperty;", "getAnnotationProcessorUsages", "()Lorg/gradle/api/file/RegularFileProperty;", "buildPath", "Lorg/gradle/api/provider/Property;", "", "getBuildPath", "()Lorg/gradle/api/provider/Property;", "bundledTraces", "getBundledTraces", "bundles", "Lcom/autonomousapps/extension/DependenciesHandler$SerializableBundles;", "getBundles", "declarations", "getDeclarations", "dependencyGraphViews", "getDependencyGraphViews", "dependencyUsageReports", "getDependencyUsageReports", "dependencyUsages", "getDependencyUsages", "duplicateClassesReports", "getDuplicateClassesReports", "explicitSourceSets", "Lorg/gradle/api/provider/SetProperty;", "getExplicitSourceSets", "()Lorg/gradle/api/provider/SetProperty;", "ignoreKtx", "", "getIgnoreKtx", "kapt", "getKapt", "output", "getOutput", "projectPath", "getProjectPath", "redundantJvmPluginReport", "getRedundantJvmPluginReport", "supportedSourceSets", "getSupportedSourceSets", "action", "", "ComputeAdviceAction", "ComputeAdviceParameters", "dependency-analysis-gradle-plugin"})
public abstract class ComputeAdviceTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;

    @Inject
    public ComputeAdviceTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setDescription("Merges dependency usage reports from variant-specific computations");
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getDependencyUsageReports();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getDependencyGraphViews();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getAndroidScoreReports();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getDeclarations();

    @Nested
    @NotNull
    public abstract Property<DependenciesHandler.SerializableBundles> getBundles();

    @Input
    @NotNull
    public abstract SetProperty<String> getSupportedSourceSets();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreKtx();

    @Input
    @NotNull
    public abstract SetProperty<String> getExplicitSourceSets();

    @Input
    @NotNull
    public abstract Property<Boolean> getKapt();

    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getRedundantJvmPluginReport();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getDuplicateClassesReports();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getDependencyUsages();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAnnotationProcessorUsages();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBundledTraces();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(ComputeAdviceAction.class, new Action(this){
            final /* synthetic */ ComputeAdviceTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull ComputeAdviceParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                $this$submit.getProjectPath().set((Provider)this.this$0.getProjectPath());
                $this$submit.getBuildPath().set((Provider)this.this$0.getBuildPath());
                $this$submit.getDependencyUsageReports().set((Provider)this.this$0.getDependencyUsageReports());
                $this$submit.getDependencyGraphViews().set((Provider)this.this$0.getDependencyGraphViews());
                $this$submit.getAndroidScoreReports().set((Provider)this.this$0.getAndroidScoreReports());
                $this$submit.getDeclarations().set((Provider)this.this$0.getDeclarations());
                $this$submit.getBundles().set((Provider)this.this$0.getBundles());
                $this$submit.getSupportedSourceSets().set((Provider)this.this$0.getSupportedSourceSets());
                $this$submit.getIgnoreKtx().set((Provider)this.this$0.getIgnoreKtx());
                $this$submit.getExplicitSourceSets().set((Provider)this.this$0.getExplicitSourceSets());
                $this$submit.getKapt().set((Provider)this.this$0.getKapt());
                $this$submit.getRedundantPluginReport().set((Provider)this.this$0.getRedundantJvmPluginReport());
                $this$submit.getDuplicateClassesReports().set((Provider)this.this$0.getDuplicateClassesReports());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
                $this$submit.getDependencyUsages().set((Provider)this.this$0.getDependencyUsages());
                $this$submit.getAnnotationProcessorUsages().set((Provider)this.this$0.getAnnotationProcessorUsages());
                $this$submit.getBundledTraces().set((Provider)this.this$0.getBundledTraces());
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J(\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/tasks/ComputeAdviceTask$ComputeAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ComputeAdviceTask$ComputeAdviceParameters;", "()V", "buildWarning", "Lcom/autonomousapps/model/Warning;", "computeDirectDependenciesMap", "Lcom/google/common/collect/SetMultimap;", "", "Lcom/autonomousapps/model/declaration/Variant;", "dependencyGraph", "", "Lcom/autonomousapps/model/internal/DependencyGraphView;", "execute", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nComputeAdviceTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeAdviceTask.kt\ncom/autonomousapps/tasks/ComputeAdviceTask$ComputeAdviceAction\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n*L\n1#1,423:1\n46#2,8:424\n122#2,8:442\n122#2,8:466\n122#2,8:485\n40#2:504\n52#2,2:505\n49#3,3:432\n33#3,4:435\n40#3,2:450\n33#3,4:452\n40#3,2:474\n33#3,4:476\n40#3,2:493\n33#3,4:495\n49#3,3:507\n33#3,4:510\n190#3,3:514\n40#3,2:517\n33#3,4:519\n193#3,2:523\n114#3,7:525\n55#3,2:532\n33#3,4:534\n121#3,2:538\n114#3,7:540\n55#3,2:547\n33#3,4:549\n121#3,2:553\n177#3,3:555\n49#3,3:558\n33#3,4:561\n180#3,2:565\n1549#4:439\n1620#4,2:440\n1622#4:456\n1194#4,2:457\n1222#4,4:459\n1549#4:463\n1620#4,2:464\n1622#4:480\n1620#4,2:483\n1622#4:499\n1549#4:500\n1620#4,3:501\n1549#4:567\n1620#4,2:568\n1855#4,2:570\n1622#4:572\n1#5:481\n107#6:482\n*S KotlinDebug\n*F\n+ 1 ComputeAdviceTask.kt\ncom/autonomousapps/tasks/ComputeAdviceTask$ComputeAdviceAction\n*L\n162#1:424,8\n164#1:442,8\n167#1:466,8\n171#1:485,8\n209#1:504\n209#1:505,2\n162#1:432,3\n162#1:435,4\n164#1:450,2\n164#1:452,4\n167#1:474,2\n167#1:476,4\n171#1:493,2\n171#1:495,4\n209#1:507,3\n209#1:510,4\n221#1:514,3\n221#1:517,2\n221#1:519,4\n221#1:523,2\n223#1:525,7\n223#1:532,2\n223#1:534,4\n223#1:538,2\n224#1:540,7\n224#1:547,2\n224#1:549,4\n224#1:553,2\n225#1:555,3\n225#1:558,3\n225#1:561,4\n225#1:565,2\n164#1:439\n164#1:440,2\n164#1:456\n165#1:457,2\n165#1:459,4\n167#1:463\n167#1:464,2\n167#1:480\n171#1:483,2\n171#1:499\n175#1:500\n175#1:501,3\n248#1:567\n248#1:568,2\n250#1:570,2\n248#1:572\n171#1:482\n*E\n"})
    public static abstract class ComputeAdviceAction
    implements WorkAction<ComputeAdviceParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            void $this$bufferWriteJsonSet_u24default$iv;
            Type[] $this$withNulls$iv$iv$iv;
            ParameterizedType type$iv$iv;
            boolean $i$f$getJsonMapAdapter;
            boolean bl;
            JsonWriter writer$iv3;
            File $this$bufferWriteJsonMap_u24default$iv;
            Object object;
            boolean $i$f$withNulls;
            Object object2;
            boolean bl2;
            DependencyAdviceBuilder dependencyAdviceBuilder;
            Map<Coordinates, Set<Usage>> annotationProcessorUsages;
            Map<Coordinates, Set<Usage>> dependencyUsages;
            Collection collection;
            Set<AndroidScore> androidScore;
            String buildPath2;
            String projectPath;
            File bundleTraces;
            File annotationProcessorUsagesOut;
            File dependencyUsagesOut;
            File output;
            block62: {
                block61: {
                    Set set2;
                    void $this$fromNullableJsonSet$iv;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    File $this$fromJson$iv$iv;
                    void $this$mapTo$iv$iv2;
                    RegularFile $this$fromJson$iv;
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv2;
                    void $this$associateByTo$iv$iv;
                    void $this$associateBy$iv;
                    Object reader$iv$iv3;
                    Object object3;
                    Object object4;
                    void $this$mapTo$iv$iv4;
                    Iterable $this$map$iv3;
                    Set set3;
                    output = UtilsKt.getAndDelete(((ComputeAdviceParameters)this.getParameters()).getOutput());
                    dependencyUsagesOut = UtilsKt.getAndDelete(((ComputeAdviceParameters)this.getParameters()).getDependencyUsages());
                    annotationProcessorUsagesOut = UtilsKt.getAndDelete(((ComputeAdviceParameters)this.getParameters()).getAnnotationProcessorUsages());
                    bundleTraces = UtilsKt.getAndDelete(((ComputeAdviceParameters)this.getParameters()).getBundledTraces());
                    Object object5 = ((ComputeAdviceParameters)this.getParameters()).getProjectPath().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.projectPath.get()");
                    projectPath = (String)object5;
                    Object object6 = ((ComputeAdviceParameters)this.getParameters()).getBuildPath().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters.buildPath.get()");
                    buildPath2 = (String)object6;
                    RegularFileProperty $this$fromJsonSet$iv = ((ComputeAdviceParameters)this.getParameters()).getDeclarations();
                    boolean $i$f$fromJsonSet22 = false;
                    Object object7 = $this$fromJsonSet$iv.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get()");
                    RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object7;
                    boolean $i$f$fromJsonSet32 = false;
                    File file = $this$fromJsonSet$iv$iv.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
                    Closeable closeable = (Closeable)UtilsKt.access$bufferRead(file);
                    Throwable throwable = null;
                    try {
                        BufferedSource reader$iv$iv2 = (BufferedSource)closeable;
                        boolean bl3 = false;
                        boolean withNulls$iv$iv$iv = false;
                        boolean $i$f$getJsonSetAdapter = false;
                        Type[] typeArray = new Type[]{Declaration.class};
                        ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                        JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                        JsonAdapter $this$withNulls$iv$iv$iv$iv = jsonAdapter;
                        boolean $i$f$withNulls2 = false;
                        Object object8 = $this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv2);
                        Intrinsics.checkNotNull((Object)object8);
                        set3 = (Set)object8;
                    }
                    catch (Throwable reader$iv$iv2) {
                        throwable = reader$iv$iv2;
                        throw reader$iv$iv2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    Set declarations2 = set3;
                    Object object9 = ((ComputeAdviceParameters)this.getParameters()).getDependencyGraphViews().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"parameters.dependencyGraphViews.get()");
                    Iterable $i$f$fromJsonSet22 = (Iterable)object9;
                    boolean $i$f$map = false;
                    void $i$f$fromJsonSet32 = $this$map$iv3;
                    Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                        Object object10;
                        File $this$fromJson$iv$iv2;
                        void it;
                        RegularFile withNulls$iv$iv$iv = (RegularFile)item$iv$iv;
                        object4 = destination$iv$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        void $this$fromJson$iv2 = it;
                        boolean $i$f$fromJson = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv2.getAsFile(), (String)"asFile");
                        boolean $i$f$fromJson2 = false;
                        Closeable closeable2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv2);
                        object3 = null;
                        try {
                            JsonAdapter $this$withNulls$iv$iv$iv$iv;
                            reader$iv$iv3 = (BufferedSource)closeable2;
                            boolean bl5 = false;
                            boolean withNulls$iv$iv$iv2 = false;
                            boolean $i$f$getJsonAdapter = false;
                            Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(DependencyGraphView.class), (String)"MOSHI.adapter(T::class.java)");
                            boolean $i$f$withNulls3 = false;
                            Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv3));
                        }
                        catch (Throwable reader$iv$iv3) {
                            object3 = reader$iv$iv3;
                            throw reader$iv$iv3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object3);
                        }
                        object4.add((DependencyGraphView)object10);
                    }
                    $this$map$iv3 = (List)destination$iv$iv;
                    boolean $i$f$associateBy22 = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    destination$iv$iv = $this$associateBy$iv;
                    Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it;
                        DependencyGraphView bl4 = (DependencyGraphView)element$iv$iv;
                        object4 = destination$iv$iv2;
                        boolean bl6 = false;
                        object4.put(it.getName(), element$iv$iv);
                    }
                    Map dependencyGraph = destination$iv$iv2;
                    Object object11 = ((ComputeAdviceParameters)this.getParameters()).getAndroidScoreReports().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"parameters.androidScoreReports.get()");
                    Iterable $i$f$associateBy22 = (Iterable)object11;
                    boolean $i$f$map2 = false;
                    $this$associateByTo$iv$iv = $this$map$iv2;
                    destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        Object object12;
                        File $this$fromJson$iv$iv3;
                        RegularFile it = (RegularFile)item$iv$iv;
                        object4 = destination$iv$iv2;
                        boolean bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        $this$fromJson$iv = it;
                        boolean $i$f$fromJson = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv.getAsFile(), (String)"asFile");
                        boolean $i$f$fromJson3 = false;
                        object3 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv3);
                        reader$iv$iv3 = null;
                        try {
                            JsonAdapter $this$withNulls$iv$iv$iv$iv;
                            BufferedSource reader$iv$iv4 = (BufferedSource)object3;
                            boolean bl8 = false;
                            boolean withNulls$iv$iv$iv = false;
                            boolean $i$f$getJsonAdapter = false;
                            Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(AndroidScoreVariant.class), (String)"MOSHI.adapter(T::class.java)");
                            boolean $i$f$withNulls4 = false;
                            Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv4));
                        }
                        catch (Throwable reader$iv$iv4) {
                            reader$iv$iv3 = reader$iv$iv4;
                            throw reader$iv$iv4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object3, (Throwable)reader$iv$iv3);
                        }
                        object4.add((AndroidScoreVariant)object12);
                    }
                    List $this$execute_u24lambda_u243 = (List)destination$iv$iv2;
                    boolean bl9 = false;
                    androidScore = CollectionsKt.toSetOrEmpty(AndroidScore.Companion.ofVariants($this$execute_u24lambda_u243));
                    Object object13 = ((ComputeAdviceParameters)this.getParameters()).getBundles().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"parameters.bundles.get()");
                    DependenciesHandler.SerializableBundles bundleRules = (DependenciesHandler.SerializableBundles)object13;
                    Object object14 = ((ComputeAdviceParameters)this.getParameters()).getDependencyUsageReports().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object14, (String)"parameters.dependencyUsageReports.get()");
                    Iterable $this$mapToSet$iv = (Iterable)object14;
                    boolean $i$f$mapToSet22 = false;
                    Iterable $i$f$mapTo22 = $this$mapToSet$iv;
                    Collection destination$iv$iv3 = new LinkedHashSet(CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        Object object15;
                        void it;
                        $this$fromJson$iv = (RegularFile)item$iv$iv;
                        object4 = destination$iv$iv3;
                        boolean bl10 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        void $this$fromJson$iv3 = it;
                        boolean $i$f$fromJson = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv3.getAsFile(), (String)"asFile");
                        boolean $i$f$fromJson4 = false;
                        Closeable reader$iv$iv4 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv);
                        Throwable bl8 = null;
                        try {
                            JsonAdapter $this$withNulls$iv$iv$iv$iv;
                            BufferedSource reader$iv$iv5 = (BufferedSource)reader$iv$iv4;
                            boolean bl11 = false;
                            boolean withNulls$iv$iv$iv = false;
                            boolean $i$f$getJsonAdapter = false;
                            Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(DependencyTraceReport.class), (String)"MOSHI.adapter(T::class.java)");
                            boolean $i$f$withNulls5 = false;
                            Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv5));
                        }
                        catch (Throwable reader$iv$iv5) {
                            bl8 = reader$iv$iv5;
                            throw reader$iv$iv5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)reader$iv$iv4, (Throwable)bl8);
                        }
                        object4.add((DependencyTraceReport)object15);
                    }
                    Set traces = (Set)destination$iv$iv3;
                    Iterable $i$f$mapToSet22 = dependencyGraph.values();
                    Set set4 = traces;
                    boolean $i$f$map3 = false;
                    destination$iv$iv3 = $this$map$iv;
                    Collection destination$iv$iv4 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo4 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DependencyGraphView bl10 = (DependencyGraphView)item$iv$iv;
                        collection = destination$iv$iv4;
                        boolean bl12 = false;
                        collection.add(it.getVariant());
                    }
                    Collection collection2 = (List)destination$iv$iv4;
                    Set set5 = set4;
                    UsageBuilder usageBuilder = new UsageBuilder(set5, collection2);
                    dependencyUsages = usageBuilder.getDependencyUsages();
                    annotationProcessorUsages = usageBuilder.getAnnotationProcessingUsages();
                    Object object16 = ((ComputeAdviceParameters)this.getParameters()).getSupportedSourceSets().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object16, (String)"parameters.supportedSourceSets.get()");
                    Set supportedSourceSets = (Set)object16;
                    Object object17 = ((ComputeAdviceParameters)this.getParameters()).getExplicitSourceSets().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object17, (String)"parameters.explicitSourceSets.get()");
                    Set explicitSourceSets = (Set)object17;
                    Object object18 = ((ComputeAdviceParameters)this.getParameters()).getKapt().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object18, (String)"parameters.kapt.get()");
                    boolean isKaptApplied2 = (Boolean)object18;
                    SetMultimap<String, Variant> directDependencies = this.computeDirectDependenciesMap(dependencyGraph);
                    Object object19 = ((ComputeAdviceParameters)this.getParameters()).getIgnoreKtx().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object19, (String)"parameters.ignoreKtx.get()");
                    boolean ignoreKtx = (Boolean)object19;
                    Bundles bundles = Bundles.Companion.of(projectPath, dependencyGraph, bundleRules, dependencyUsages, ignoreKtx);
                    dependencyAdviceBuilder = new DependencyAdviceBuilder(projectPath, buildPath2, bundles, dependencyUsages, annotationProcessorUsages, declarations2, directDependencies, supportedSourceSets, explicitSourceSets, isKaptApplied2);
                    $this$fromJson$iv$iv = ((ComputeAdviceParameters)this.getParameters()).getRedundantPluginReport();
                    bl2 = isKaptApplied2;
                    boolean $i$f$fromNullableJsonSet = false;
                    RegularFile reader$iv$iv4 = (RegularFile)$this$fromNullableJsonSet$iv.getOrNull();
                    object2 = reader$iv$iv4;
                    if (object2 == null) break block61;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"orNull");
                    RegularFile $this$fromJsonSet$iv$iv2 = reader$iv$iv4;
                    boolean $i$f$fromJsonSet = false;
                    File file2 = $this$fromJsonSet$iv$iv2.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
                    Closeable bl11 = (Closeable)UtilsKt.access$bufferRead(file2);
                    Throwable withNulls$iv$iv$iv = null;
                    try {
                        BufferedSource reader$iv$iv6 = (BufferedSource)bl11;
                        boolean bl13 = false;
                        boolean withNulls$iv$iv$iv3 = false;
                        boolean $i$f$getJsonSetAdapter = false;
                        Type[] typeArray = new Type[]{PluginAdvice.class};
                        ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                        JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                        JsonAdapter $this$withNulls$iv$iv$iv$iv = jsonAdapter;
                        $i$f$withNulls = false;
                        Object object20 = $this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv6);
                        Intrinsics.checkNotNull((Object)object20);
                        Set set6 = (Set)object20;
                        set2 = set6;
                    }
                    catch (Throwable reader$iv$iv6) {
                        withNulls$iv$iv$iv = reader$iv$iv6;
                        throw reader$iv$iv6;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)bl11, (Throwable)withNulls$iv$iv$iv);
                    }
                    object2 = set2;
                    if (set2 != null) break block62;
                }
                object2 = SetsKt.emptySet();
            }
            collection = object2;
            Map<Coordinates, Set<Usage>> map = annotationProcessorUsages;
            Collection collection3 = collection;
            boolean bl14 = bl2;
            PluginAdviceBuilder pluginAdviceBuilder = new PluginAdviceBuilder(bl14, (Set<PluginAdvice>)collection3, map);
            ProjectAdvice projectAdvice2 = new ProjectAdvice(projectPath, dependencyAdviceBuilder.getAdvice(), pluginAdviceBuilder.getPluginAdvice(), androidScore, this.buildWarning(), false, 32, null);
            File $this$bufferWriteJson_u24default$iv = output;
            String indent$iv = "";
            boolean $i$f$bufferWriteJson = false;
            Closeable $i$f$fromJsonSet = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
            Throwable bl11 = null;
            try {
                JsonWriter writer$iv2 = (JsonWriter)$i$f$fromJsonSet;
                boolean bl15 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                JsonAdapter $this$withNulls$iv$iv$iv2 = jsonAdapter;
                boolean $i$f$withNulls6 = false;
                $this$withNulls$iv$iv$iv2.indent(indent$iv).toJson(writer$iv2, (Object)projectAdvice2);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                bl11 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$f$fromJsonSet, (Throwable)bl11);
            }
            $this$bufferWriteJson_u24default$iv = dependencyUsagesOut;
            Object set$iv = CoordinatesString.Companion.toStringCoordinates(dependencyUsages, buildPath2);
            boolean withNulls$iv = false;
            String indent$iv2 = "";
            boolean $i$f$bufferWriteJsonMap = false;
            object = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonMap_u24default$iv, (boolean)false, (int)1, null)));
            Throwable bl15 = null;
            try {
                writer$iv3 = (JsonWriter)object;
                bl = false;
                $i$f$getJsonMapAdapter = false;
                Type[] $i$f$withNulls6 = new Type[]{String.class, Set.class};
                type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$i$f$withNulls6);
                Type[] typeArray = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"MOSHI.adapter<Map<K, V>>(type)");
                $this$withNulls$iv$iv$iv = typeArray;
                $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv2).toJson(writer$iv3, set$iv);
                writer$iv3 = Unit.INSTANCE;
            }
            catch (Throwable writer$iv3) {
                bl15 = writer$iv3;
                throw writer$iv3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)bl15);
            }
            $this$bufferWriteJsonMap_u24default$iv = annotationProcessorUsagesOut;
            set$iv = CoordinatesString.Companion.toStringCoordinates(annotationProcessorUsages, buildPath2);
            withNulls$iv = false;
            indent$iv2 = "";
            $i$f$bufferWriteJsonMap = false;
            object = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonMap_u24default$iv, (boolean)false, (int)1, null)));
            bl15 = null;
            try {
                writer$iv3 = (JsonWriter)object;
                bl = false;
                $i$f$getJsonMapAdapter = false;
                $this$withNulls$iv$iv$iv = new Type[]{String.class, Set.class};
                type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$this$withNulls$iv$iv$iv);
                Type[] typeArray = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"MOSHI.adapter<Map<K, V>>(type)");
                $this$withNulls$iv$iv$iv = typeArray;
                $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv2).toJson(writer$iv3, set$iv);
                writer$iv3 = Unit.INSTANCE;
            }
            catch (Throwable writer$iv4) {
                bl15 = writer$iv4;
                throw writer$iv4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)bl15);
            }
            $this$bufferWriteJsonMap_u24default$iv = bundleTraces;
            set$iv = dependencyAdviceBuilder.getBundledTraces();
            String indent$iv3 = "";
            boolean $i$f$bufferWriteJsonSet = false;
            Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null)));
            object = null;
            try {
                JsonWriter writer$iv5 = (JsonWriter)closeable;
                boolean bl16 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                $this$withNulls$iv$iv$iv = new Type[]{BundleTrace.class};
                type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])$this$withNulls$iv$iv$iv);
                Type[] typeArray = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"MOSHI.adapter<Set<T>>(type)");
                $this$withNulls$iv$iv$iv = typeArray;
                $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv3).toJson(writer$iv5, set$iv);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }

        private final Warning buildWarning() {
            Object object = ((ComputeAdviceParameters)this.getParameters()).getDuplicateClassesReports().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.duplicateClassesReports.get()");
            SortedSet duplicateClassesReports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)buildWarning.duplicateClassesReports.1.INSTANCE)));
            return new Warning(duplicateClassesReports2);
        }

        /*
         * WARNING - void declaration
         */
        private final SetMultimap<String, Variant> computeDirectDependenciesMap(Map<String, DependencyGraphView> dependencyGraph) {
            void $this$mapTo$iv$iv;
            SetMultimap setMultimap;
            SetMultimap $this$computeDirectDependenciesMap_u24lambda_u248 = setMultimap = MultimapsKt.newSetMultimap();
            boolean bl = false;
            Iterable $this$map$iv = dependencyGraph.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void graphView;
                DependencyGraphView dependencyGraphView = (DependencyGraphView)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Coordinates root = (Coordinates)Graphs.INSTANCE.root(graphView.getGraph$dependency_analysis_gradle_plugin());
                Iterable $this$forEach$iv = Graphs.INSTANCE.children(graphView.getGraph$dependency_analysis_gradle_plugin(), (Object)root);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Coordinates directDependency = (Coordinates)element$iv;
                    boolean bl3 = false;
                    String identifier2 = directDependency instanceof IncludedBuildCoordinates ? ((IncludedBuildCoordinates)directDependency).getResolvedProject().getIdentifier() : directDependency.getIdentifier();
                    $this$computeDirectDependenciesMap_u24lambda_u248.put((Object)identifier2, (Object)graphView.getVariant());
                }
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            return setMultimap;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0012\u0010\u0015\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R\u0012\u0010\u001b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006R\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000fR\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020$0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0012\u0010(\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\nR\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000fR\u0012\u0010,\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\nR\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\"\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00060\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ComputeAdviceTask$ComputeAdviceParameters;", "Lorg/gradle/workers/WorkParameters;", "androidScoreReports", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getAndroidScoreReports", "()Lorg/gradle/api/provider/ListProperty;", "annotationProcessorUsages", "Lorg/gradle/api/file/RegularFileProperty;", "getAnnotationProcessorUsages", "()Lorg/gradle/api/file/RegularFileProperty;", "buildPath", "Lorg/gradle/api/provider/Property;", "", "getBuildPath", "()Lorg/gradle/api/provider/Property;", "bundledTraces", "getBundledTraces", "bundles", "Lcom/autonomousapps/extension/DependenciesHandler$SerializableBundles;", "getBundles", "declarations", "getDeclarations", "dependencyGraphViews", "getDependencyGraphViews", "dependencyUsageReports", "getDependencyUsageReports", "dependencyUsages", "getDependencyUsages", "duplicateClassesReports", "getDuplicateClassesReports", "explicitSourceSets", "Lorg/gradle/api/provider/SetProperty;", "getExplicitSourceSets", "()Lorg/gradle/api/provider/SetProperty;", "ignoreKtx", "", "getIgnoreKtx", "kapt", "getKapt", "output", "getOutput", "projectPath", "getProjectPath", "redundantPluginReport", "getRedundantPluginReport", "supportedSourceSets", "getSupportedSourceSets", "dependency-analysis-gradle-plugin"})
    public static interface ComputeAdviceParameters
    extends WorkParameters {
        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public Property<String> getBuildPath();

        @NotNull
        public ListProperty<RegularFile> getDependencyUsageReports();

        @NotNull
        public ListProperty<RegularFile> getDependencyGraphViews();

        @NotNull
        public ListProperty<RegularFile> getAndroidScoreReports();

        @NotNull
        public RegularFileProperty getDeclarations();

        @NotNull
        public Property<DependenciesHandler.SerializableBundles> getBundles();

        @NotNull
        public SetProperty<String> getSupportedSourceSets();

        @NotNull
        public Property<Boolean> getIgnoreKtx();

        @NotNull
        public SetProperty<String> getExplicitSourceSets();

        @NotNull
        public Property<Boolean> getKapt();

        @NotNull
        public RegularFileProperty getRedundantPluginReport();

        @NotNull
        public ListProperty<RegularFile> getDuplicateClassesReports();

        @NotNull
        public RegularFileProperty getOutput();

        @NotNull
        public RegularFileProperty getDependencyUsages();

        @NotNull
        public RegularFileProperty getAnnotationProcessorUsages();

        @NotNull
        public RegularFileProperty getBundledTraces();
    }
}

