/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencySizeTree;
import com.autonomousapps.graph.DominanceTree;
import com.autonomousapps.graph.DominanceTreeDataWriter;
import com.autonomousapps.graph.DominanceTreeWriter;
import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.utils.FileUtils;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.IncludedBuildCoordinates;
import com.autonomousapps.model.ProjectCoordinates;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.autonomousapps.model.internal.PhysicalArtifact;
import com.autonomousapps.tasks.ComputeDominatorTreeTask;
import com.google.common.graph.Graph;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "graphView", "Lorg/gradle/api/file/RegularFileProperty;", "getGraphView", "()Lorg/gradle/api/file/RegularFileProperty;", "outputDot", "getOutputDot", "outputJson", "getOutputJson", "outputTxt", "getOutputTxt", "physicalArtifacts", "getPhysicalArtifacts", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "action", "", "BySize", "Companion", "dependency-analysis-gradle-plugin"})
public abstract class ComputeDominatorTreeTask
extends DefaultTask {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public ComputeDominatorTreeTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Computes a dominator view of the dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPhysicalArtifacts();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getGraphView();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputTxt();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJson();

    @TaskAction
    public final void action() {
        Companion.compute(this.getProjectPath(), this.getOutputTxt(), this.getOutputDot(), this.getOutputJson(), this.getPhysicalArtifacts(), this.getGraphView());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000bj\b\u0012\u0004\u0012\u00020\u0002`\u0013H\u0016J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize;", "Lcom/autonomousapps/graph/DominanceTreeWriter$NodeWriter;", "Lcom/autonomousapps/model/Coordinates;", "files", "", "Ljava/io/File;", "tree", "Lcom/autonomousapps/graph/DominanceTree;", "root", "(Ljava/util/Map;Lcom/autonomousapps/graph/DominanceTree;Lcom/autonomousapps/model/Coordinates;)V", "comparator", "Ljava/util/Comparator;", "reachableNodes", "", "", "scale", "Lcom/autonomousapps/internal/utils/FileUtils$Scale;", "sizes", "", "Lkotlin/Comparator;", "getSize", "node", "(Lcom/autonomousapps/model/Coordinates;)Ljava/lang/Long;", "getTreeSize", "toString", "", "treeSizeOf", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nComputeDominatorTreeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1603#2,9:181\n1855#2:190\n1856#2:192\n1612#2:193\n1603#2,9:195\n1855#2:204\n1856#2:206\n1612#2:207\n1603#2,9:209\n1855#2:218\n1856#2:220\n1612#2:221\n1#3:191\n1#3:194\n1#3:205\n1#3:208\n1#3:219\n1#3:222\n*S KotlinDebug\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize\n*L\n90#1:181,9\n90#1:190\n90#1:192\n90#1:193\n85#1:195,9\n85#1:204\n85#1:206\n85#1:207\n108#1:209,9\n108#1:218\n108#1:220\n108#1:221\n90#1:191\n85#1:205\n108#1:219\n*E\n"})
    private static final class BySize
    implements DominanceTreeWriter.NodeWriter<Coordinates> {
        @NotNull
        private final Map<Coordinates, File> files;
        @NotNull
        private final DominanceTree<Coordinates> tree;
        @NotNull
        private final Map<Coordinates, Long> sizes;
        @NotNull
        private final Map<Coordinates, Set<Coordinates>> reachableNodes;
        @NotNull
        private final FileUtils.Scale scale;
        @NotNull
        private final Comparator<Coordinates> comparator;

        /*
         * WARNING - void declaration
         */
        public BySize(@NotNull Map<Coordinates, ? extends File> files, @NotNull DominanceTree<Coordinates> tree, @NotNull Coordinates root) {
            void it;
            long l;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.files = files;
            this.tree = tree;
            this.sizes = new LinkedHashMap();
            this.reachableNodes = new LinkedHashMap();
            Iterable iterable = this.reachableNodes(root);
            BySize bySize = this;
            boolean $i$f$mapNotNull22 = false;
            void var6_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it2 = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
            long $i$f$mapNotNull22 = 0L;
            for (Object e : iterable) {
                void it3;
                $this$forEach$iv$iv$iv = (File)e;
                l = $i$f$mapNotNull22;
                boolean bl = false;
                long l2 = it3.length();
                $i$f$mapNotNull22 = l + l2;
            }
            $i$f$mapNotNull22 = l = $i$f$mapNotNull22;
            boolean bl = false;
            bySize.scale = FileUtils.INSTANCE.getScale((long)it);
            this.comparator = new Comparator(this){
                final /* synthetic */ BySize this$0;
                {
                    this.this$0 = $receiver;
                }

                public final int compare(Coordinates left, Coordinates right) {
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    long l = this.this$0.getTreeSize(right);
                    Intrinsics.checkNotNullExpressionValue((Object)left, (String)"left");
                    return Intrinsics.compare((long)l, (long)this.this$0.getTreeSize(left));
                }
            };
        }

        @NotNull
        public Long getTreeSize(@NotNull Coordinates node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Long l = this.sizes.computeIfAbsent(node, new Function(this){
                final /* synthetic */ BySize this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public final Long apply(@NotNull Coordinates it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return BySize.access$treeSizeOf(this.this$0, it);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"override fun getTreeSize\u2026(node) { treeSizeOf(it) }");
            return l;
        }

        @Nullable
        public Long getSize(@NotNull Coordinates node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            File file = this.files.get(node);
            return file != null ? Long.valueOf(file.length()) : null;
        }

        private final Set<Coordinates> reachableNodes(Coordinates node) {
            Set<Coordinates> set2 = this.reachableNodes.computeIfAbsent(node, new Function(this, node){
                final /* synthetic */ BySize this$0;
                final /* synthetic */ Coordinates $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                }

                @NotNull
                public final Set<Coordinates> apply(@NotNull Coordinates it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Graphs.INSTANCE.reachableNodes(BySize.access$getTree$p(this.this$0).getDominanceGraph(), (Object)this.$node, false);
                }
            });
            Intrinsics.checkNotNullExpressionValue(set2, (String)"private fun reachableNod\u2026xcludeSelf = false)\n    }");
            return set2;
        }

        /*
         * WARNING - void declaration
         */
        private final long treeSizeOf(Coordinates node) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.reachableNodes(node);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            long l = 0L;
            for (Object t : iterable2) {
                void it;
                $this$forEach$iv$iv$iv = (File)t;
                long l2 = l;
                boolean bl = false;
                long l3 = it.length();
                l = l2 + l3;
            }
            return l;
        }

        @NotNull
        public Comparator<Coordinates> comparator() {
            return this.comparator;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String toString(@NotNull Coordinates node) {
            File totalSize2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            StringBuilder builder = new StringBuilder();
            boolean printedTotalSize = false;
            Set<Coordinates> subs = this.reachableNodes(node);
            if (!((Collection)SetsKt.minus(subs, (Object)node)).isEmpty()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = subs;
                boolean $i$f$mapNotNull = false;
                void var10_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    File it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Coordinates it = (Coordinates)element$iv$iv;
                    boolean bl2 = false;
                    if (this.files.get(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv;
                long l = 0L;
                for (Object $i$f$mapNotNullTo2 : iterable) {
                    void it;
                    $this$forEach$iv$iv$iv = (File)$i$f$mapNotNullTo2;
                    long l2 = l;
                    boolean bl = false;
                    long l3 = it.length();
                    l = l2 + l3;
                }
                long totalSize2 = l;
                printedTotalSize = true;
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(totalSize2, this.scale)).append(' ');
            }
            if ((totalSize2 = this.files.get(node)) != null) {
                long it = totalSize2.length();
                boolean bl = false;
                if (printedTotalSize) {
                    builder.append('(');
                }
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(it, this.scale));
                if (printedTotalSize) {
                    builder.append(')');
                }
                builder.append(' ');
            }
            Coordinates preferredCoordinatesNotation = node instanceof IncludedBuildCoordinates ? (Coordinates)((IncludedBuildCoordinates)node).getResolvedProject() : node;
            builder.append(preferredCoordinatesNotation.gav());
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        public static final /* synthetic */ long access$treeSizeOf(BySize $this, Coordinates node) {
            return $this.treeSizeOf(node);
        }

        public static final /* synthetic */ DominanceTree access$getTree$p(BySize $this) {
            return $this.tree;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion;", "", "()V", "compute", "", "projectPath", "Lorg/gradle/api/provider/Property;", "", "outputTxt", "Lorg/gradle/api/file/RegularFileProperty;", "outputDot", "outputJson", "physicalArtifacts", "graphView", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nComputeDominatorTreeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n46#2,8:181\n117#2,13:202\n49#3,3:189\n33#3,4:192\n40#3,2:215\n33#3,4:217\n196#3,10:221\n1179#4,2:196\n1253#4,4:198\n*S KotlinDebug\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion\n*L\n148#1:181,8\n152#1:202,13\n148#1:189,3\n148#1:192,4\n152#1:215,2\n152#1:217,4\n174#1:221,10\n148#1:196,2\n148#1:198,4\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void compute(@NotNull Property<String> projectPath, @NotNull RegularFileProperty outputTxt, @NotNull RegularFileProperty outputDot, @NotNull RegularFileProperty outputJson, @NotNull RegularFileProperty physicalArtifacts, @NotNull RegularFileProperty graphView) {
            void $this$bufferWriteParameterizedJson_u24default$iv;
            Object object;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Set set2;
            Intrinsics.checkNotNullParameter(projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)outputTxt, (String)"outputTxt");
            Intrinsics.checkNotNullParameter((Object)outputDot, (String)"outputDot");
            Intrinsics.checkNotNullParameter((Object)outputJson, (String)"outputJson");
            Intrinsics.checkNotNullParameter((Object)physicalArtifacts, (String)"physicalArtifacts");
            Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
            File outputTxt2 = UtilsKt.getAndDelete(outputTxt);
            File outputDot2 = UtilsKt.getAndDelete(outputDot);
            File outputJson2 = UtilsKt.getAndDelete(outputJson);
            Object $this$fromJsonSet$iv = physicalArtifacts;
            boolean $i$f$fromJsonSet = false;
            Object object2 = $this$fromJsonSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get()");
            RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJsonSet22 = false;
            File file = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead(file);
            Throwable throwable = null;
            try {
                BufferedSource reader$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{PhysicalArtifact.class};
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                JsonAdapter $this$withNulls$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                set2 = (Set)object3;
            }
            catch (Throwable reader$iv$iv) {
                throwable = reader$iv$iv;
                throw reader$iv$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fromJsonSet$iv = set2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void $i$f$fromJsonSet22 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map withNulls$iv$iv$iv = destination$iv$iv;
                PhysicalArtifact $i$f$getJsonSetAdapter = (PhysicalArtifact)element$iv$iv;
                boolean bl = false;
                Coordinates coord = $i$f$getJsonSetAdapter.component1();
                File file2 = $i$f$getJsonSetAdapter.component2();
                $i$f$getJsonSetAdapter = TuplesKt.to((Object)coord, (Object)file2);
                withNulls$iv$iv$iv.put($i$f$getJsonSetAdapter.getFirst(), $i$f$getJsonSetAdapter.getSecond());
            }
            Map artifactMap = destination$iv$iv;
            RegularFileProperty $this$fromJson$iv = graphView;
            boolean $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object4;
            boolean $i$f$fromJson2 = false;
            File file3 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file3;
            boolean $i$f$fromJson222 = false;
            Closeable element$iv$iv = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable withNulls$iv$iv$iv = null;
            try {
                BufferedSource reader$iv$iv$iv = (BufferedSource)element$iv$iv;
                boolean bl = false;
                boolean withNulls$iv$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(DependencyGraphView.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                JsonAdapter $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object5);
                object = object5;
            }
            catch (Throwable reader$iv$iv$iv) {
                withNulls$iv$iv$iv = reader$iv$iv$iv;
                throw reader$iv$iv$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)element$iv$iv, (Throwable)withNulls$iv$iv$iv);
            }
            DependencyGraphView graphView2 = (DependencyGraphView)object;
            Object object6 = projectPath.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"projectPath.get()");
            ProjectCoordinates project = new ProjectCoordinates((String)object6, new GradleVariantIdentification(SetsKt.setOf((Object)"ROOT"), MapsKt.emptyMap()), ":");
            DominanceTree tree = new DominanceTree(graphView2.getGraph$dependency_analysis_gradle_plugin(), (Object)project);
            BySize nodeWriter = new BySize(artifactMap, (DominanceTree<Coordinates>)tree, project);
            DominanceTreeWriter writer = new DominanceTreeWriter((Object)project, tree, (DominanceTreeWriter.NodeWriter)nodeWriter);
            DominanceTreeDataWriter dataWriter = new DominanceTreeDataWriter((Object)project, tree, (DominanceTreeWriter.NodeWriter)nodeWriter);
            FilesKt.writeText$default((File)outputTxt2, (String)writer.getString(), null, (int)2, null);
            FilesKt.writeText$default((File)outputDot2, (String)GraphWriter.INSTANCE.toDot((Graph<Coordinates>)tree.getDominanceGraph()), null, (int)2, null);
            File $i$f$fromJson222 = outputJson2;
            element$iv$iv = dataWriter.getSizeTree().map((Function1)compute.1.INSTANCE);
            String indent$iv = "";
            boolean $i$f$bufferWriteParameterizedJson = false;
            Closeable closeable2 = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteParameterizedJson_u24default$iv, (boolean)false, (int)1, null)));
            Throwable throwable2 = null;
            try {
                void parameterizedData$iv;
                JsonWriter writer$iv = (JsonWriter)closeable2;
                boolean bl = false;
                Type[] typeArray = new Type[]{String.class};
                MoshiUtils.getMOSHI().adapter((Type)Types.newParameterizedType((Type)((Type)((Object)DependencySizeTree.class)), (Type[])typeArray)).indent(indent$iv).toJson(writer$iv, (Object)parameterizedData$iv);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

