/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.BytecodeReader;
import com.autonomousapps.internal.ClassReferenceParser;
import com.autonomousapps.internal.ExplodedClass;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.internal.intermediates.consumer.ExplodingBytecode;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/autonomousapps/internal/ClassFilesParser;", "Lcom/autonomousapps/internal/ClassReferenceParser;", "classes", "", "Ljava/io/File;", "buildDir", "(Ljava/util/Set;Ljava/io/File;)V", "logger", "Lorg/gradle/api/logging/Logger;", "parseBytecode", "Lcom/autonomousapps/model/internal/intermediates/consumer/ExplodingBytecode;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBytecodeParsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeParsers.kt\ncom/autonomousapps/internal/ClassFilesParser\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n*L\n1#1,143:1\n21#2:144\n*S KotlinDebug\n*F\n+ 1 BytecodeParsers.kt\ncom/autonomousapps/internal/ClassFilesParser\n*L\n36#1:144\n*E\n"})
public final class ClassFilesParser
extends ClassReferenceParser {
    @NotNull
    private final Set<File> classes;
    @NotNull
    private final Logger logger;

    public ClassFilesParser(@NotNull Set<? extends File> classes, @NotNull File buildDir) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)buildDir, (String)"buildDir");
        super(buildDir, null);
        this.classes = classes;
        boolean $i$f$getLogger = false;
        Logger logger = Logging.getLogger(ClassFilesParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java)");
        this.logger = logger;
    }

    @Override
    @NotNull
    protected Set<ExplodingBytecode> parseBytecode() {
        return SequencesKt.toSet((Sequence)SequencesKt.map(CollectionsKt.asSequenceOfClassFiles((Collection<? extends File>)this.classes), (Function1)((Function1)new Function1<File, ExplodingBytecode>(this){
            final /* synthetic */ ClassFilesParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final ExplodingBytecode invoke(File classFile) {
                ExplodedClass explodedClass;
                Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
                String classFilePath = classFile.getPath();
                Closeable closeable = new FileInputStream(classFile);
                ClassFilesParser classFilesParser = this.this$0;
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl = false;
                    byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                    Logger logger = ClassFilesParser.access$getLogger$p(classFilesParser);
                    Intrinsics.checkNotNullExpressionValue((Object)classFilePath, (String)"classFilePath");
                    explodedClass = new BytecodeReader(byArray, logger, classFilePath).parse();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                ExplodedClass explodedClass2 = explodedClass;
                return new ExplodingBytecode(this.this$0.relativize(classFile), explodedClass2.getClassName(), explodedClass2.getSource(), explodedClass2.getNonAnnotationClasses(), explodedClass2.getAnnotationClasses(), explodedClass2.getInvisibleAnnotationClasses(), explodedClass2.getBinaryClasses());
            }
        })));
    }

    public static final /* synthetic */ Logger access$getLogger$p(ClassFilesParser $this) {
        return $this.logger;
    }
}

