/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps;

import com.autonomousapps.Flags;
import com.autonomousapps.internal.GradleVersions;
import com.autonomousapps.internal.android.AgpVersion;
import com.autonomousapps.subplugin.ProjectPlugin;
import com.autonomousapps.subplugin.RootPlugin;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\f\u0010\b\u001a\u00020\u0006*\u00020\u0002H\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002J\f\u0010\n\u001a\u00020\u0006*\u00020\u0002H\u0002J\f\u0010\u000b\u001a\u00020\u0006*\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcom/autonomousapps/DependencyAnalysisPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "applyForRoot", "checkGradleVersion", "checkAgpVersion", "applyForProject", "Companion", "dependency-analysis-gradle-plugin"})
public final class DependencyAnalysisPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "com.autonomousapps.dependency-analysis";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$apply_u24lambda_u240 = project;
        boolean bl = false;
        this.applyForRoot($this$apply_u24lambda_u240);
        this.applyForProject($this$apply_u24lambda_u240);
    }

    private final void applyForRoot(Project $this$applyForRoot) {
        if (Intrinsics.areEqual((Object)$this$applyForRoot, (Object)$this$applyForRoot.getRootProject())) {
            this.checkGradleVersion();
            this.checkAgpVersion($this$applyForRoot);
            new RootPlugin($this$applyForRoot).apply();
        }
    }

    private final void checkGradleVersion() {
        if (!GradleVersions.INSTANCE.isAtLeastMinimum()) {
            boolean bl = false;
            String string = "Dependency Analysis Gradle Plugin requires Gradle " + GradleVersions.minGradleVersion.getVersion() + " or higher. Was " + GradleVersions.INSTANCE.getCurrent().getVersion() + ".";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void checkAgpVersion(Project $this$checkAgpVersion) {
        AgpVersion agpVersion;
        try {
            agpVersion = AgpVersion.Companion.current();
        }
        catch (Throwable throwable) {
            $this$checkAgpVersion.getLogger().info("AGP not on classpath; assuming non-Android project");
            return;
        }
        AgpVersion current = agpVersion;
        $this$checkAgpVersion.getLogger().debug("AgpVersion = " + current);
        Flags.Compatibility compatibility = Flags.INSTANCE.compatibility$dependency_analysis_gradle_plugin($this$checkAgpVersion);
        if (compatibility != Flags.Compatibility.NONE && !current.isSupported() && Intrinsics.areEqual((Object)$this$checkAgpVersion, (Object)$this$checkAgpVersion.getRootProject())) {
            String message = "The Dependency Analysis plugin is only known to work with versions of AGP between " + AgpVersion.Companion.getAGP_MIN().getVersion() + " and " + AgpVersion.Companion.getAGP_MAX().getVersion() + ". You are using " + current.getVersion() + ". Proceed at your own risk.";
            switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
                case 1: {
                    $this$checkAgpVersion.getLogger().debug(message);
                    break;
                }
                case 2: {
                    $this$checkAgpVersion.getLogger().warn(message);
                    break;
                }
                case 3: {
                    $this$checkAgpVersion.getLogger().error(message);
                    break;
                }
                case 4: {
                    throw new IllegalStateException("Not possible".toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void applyForProject(Project $this$applyForProject) {
        new ProjectPlugin($this$applyForProject).apply();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/DependencyAnalysisPlugin$Companion;", "", "<init>", "()V", "ID", "", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Flags.Compatibility.values().length];
            try {
                nArray[Flags.Compatibility.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flags.Compatibility.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flags.Compatibility.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flags.Compatibility.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

