/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AnnotationAnalyzer;
import com.autonomousapps.internal.AsmKt;
import com.autonomousapps.internal.ClassRef;
import com.autonomousapps.internal.FieldAnalyzer;
import com.autonomousapps.internal.MethodAnalyzer;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.asm.FieldVisitor;
import com.autonomousapps.internal.asm.MethodVisitor;
import com.autonomousapps.internal.asm.TypePath;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.RegexKt;
import com.autonomousapps.model.internal.AccessFlags;
import com.autonomousapps.model.internal.intermediates.consumer.LdcConstant;
import com.autonomousapps.model.internal.intermediates.consumer.MemberAccess;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0'0&J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0'J\u001a\u0010)\u001a\u00020*2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070/H\u0002J\u001c\u00100\u001a\u00020*2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u00101\u001a\u0004\u0018\u00010\u0007H\u0016JK\u00102\u001a\u00020*2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010\u00072\b\u00108\u001a\u0004\u0018\u00010\u00072\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u000109H\u0016\u00a2\u0006\u0002\u0010:J4\u0010;\u001a\u00020<2\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010\u00072\b\u0010>\u001a\u0004\u0018\u00010?H\u0016JA\u0010@\u001a\u00020A2\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010\u00072\u0010\u0010B\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u000109H\u0016\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u00020E2\u0006\u0010=\u001a\u00020\u00072\u0006\u0010F\u001a\u00020GH\u0016J*\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u0002042\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010=\u001a\u00020\u00072\u0006\u0010F\u001a\u00020GH\u0016J\b\u0010L\u001a\u00020*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/autonomousapps/internal/ClassAnalyzer;", "Lcom/autonomousapps/internal/asm/ClassVisitor;", "logger", "Lorg/gradle/api/logging/Logger;", "<init>", "(Lorg/gradle/api/logging/Logger;)V", "source", "", "getSource", "()Ljava/lang/String;", "setSource", "(Ljava/lang/String;)V", "className", "getClassName", "setClassName", "superClass", "getSuperClass", "setSuperClass", "interfaces", "Ljava/util/TreeSet;", "getInterfaces", "()Ljava/util/TreeSet;", "classes", "", "Lcom/autonomousapps/internal/ClassRef;", "getClasses", "()Ljava/util/Set;", "binaryClasses", "Ljava/util/SortedMap;", "Ljava/util/SortedSet;", "Lcom/autonomousapps/model/internal/intermediates/consumer/MemberAccess;", "constants", "Lcom/autonomousapps/model/internal/intermediates/consumer/LdcConstant;", "methodAnalyzer", "Lcom/autonomousapps/internal/MethodAnalyzer;", "fieldAnalyzer", "Lcom/autonomousapps/internal/FieldAnalyzer;", "getBinaryClasses", "", "", "getInferredConstants", "addClass", "", "kind", "Lcom/autonomousapps/internal/ClassRef$Kind;", "log", "msgProvider", "Lkotlin/Function0;", "visitSource", "debug", "visit", "version", "", "access", "name", "signature", "superName", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitField", "Lcom/autonomousapps/internal/asm/FieldVisitor;", "descriptor", "value", "", "visitMethod", "Lcom/autonomousapps/internal/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lcom/autonomousapps/internal/asm/MethodVisitor;", "visitAnnotation", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "visible", "", "visitTypeAnnotation", "typeRef", "typePath", "Lcom/autonomousapps/internal/asm/TypePath;", "visitEnd", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nasm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/ClassAnalyzer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,733:1\n18#2:734\n13472#3,2:735\n1869#4,2:737\n1321#5,2:739\n*S KotlinDebug\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/ClassAnalyzer\n*L\n276#1:734\n279#1:735,2\n296#1:737,2\n312#1:739,2\n*E\n"})
public final class ClassAnalyzer
extends ClassVisitor {
    @NotNull
    private final Logger logger;
    @Nullable
    private String source;
    public String className;
    @Nullable
    private String superClass;
    @NotNull
    private final TreeSet<String> interfaces;
    @NotNull
    private final Set<ClassRef> classes;
    @NotNull
    private final SortedMap<String, SortedSet<MemberAccess>> binaryClasses;
    @NotNull
    private final TreeSet<LdcConstant> constants;
    @NotNull
    private final MethodAnalyzer methodAnalyzer;
    @NotNull
    private final FieldAnalyzer fieldAnalyzer;

    public ClassAnalyzer(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(589824);
        this.logger = logger;
        this.interfaces = SetsKt.sortedSetOf((Object[])new String[0]);
        this.classes = new LinkedHashSet();
        this.binaryClasses = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        this.constants = SetsKt.sortedSetOf((Object[])new LdcConstant[0]);
        this.methodAnalyzer = new MethodAnalyzer(this.logger, this.classes, (Map<String, SortedSet<MemberAccess>>)this.binaryClasses, (Set<LdcConstant>)this.constants);
        this.fieldAnalyzer = new FieldAnalyzer(this.logger, this.classes);
    }

    @Nullable
    public final String getSource() {
        return this.source;
    }

    public final void setSource(@Nullable String string) {
        this.source = string;
    }

    @NotNull
    public final String getClassName() {
        String string = this.className;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        return null;
    }

    public final void setClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.className = string;
    }

    @Nullable
    public final String getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(@Nullable String string) {
        this.superClass = string;
    }

    @NotNull
    public final TreeSet<String> getInterfaces() {
        return this.interfaces;
    }

    @NotNull
    public final Set<ClassRef> getClasses() {
        return this.classes;
    }

    @NotNull
    public final Map<String, Set<MemberAccess>> getBinaryClasses() {
        return CollectionsKt.efficient((Map)this.binaryClasses);
    }

    @NotNull
    public final Set<LdcConstant> getInferredConstants() {
        return CollectionsKt.efficient((Set)this.constants);
    }

    private final void addClass(String className, ClassRef.Kind kind) {
        AsmKt.addClass$default(this.classes, className, kind, null, 4, null);
    }

    private final void log(Function0<String> msgProvider) {
        if (!AsmKt.access$getLogDebug$p()) {
            this.logger.quiet((String)msgProvider.invoke());
        }
    }

    public void visitSource(@Nullable String source, @Nullable String debug) {
        this.log((Function0<String>)((Function0)() -> ClassAnalyzer.visitSource$lambda$0(source, debug)));
        this.source = source;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.log((Function0<String>)((Function0)() -> ClassAnalyzer.visit$lambda$1(access, name, superName)));
            this.setClassName(name);
            this.superClass = superName;
            Collection collection = this.interfaces;
            Object[] $this$orEmpty$iv = interfaces;
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                objectArray = new String[]{};
            }
            kotlin.collections.CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
            this.addClass("L" + superName + ";", ClassRef.Kind.NOT_ANNOTATION);
            if (interfaces == null) break block2;
            String[] $this$forEach$iv = interfaces;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String i2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                this.addClass("L" + i2 + ";", ClassRef.Kind.NOT_ANNOTATION);
            }
        }
    }

    @NotNull
    public FieldVisitor visitField(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable Object value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.log((Function0<String>)((Function0)() -> ClassAnalyzer.visitField$lambda$3(access, descriptor, name, signature, value)));
            this.addClass(descriptor, ClassRef.Kind.NOT_ANNOTATION);
            Object object = signature;
            if (object == null || (object = RegexKt.genericTypes((String)object)) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.addClass(it, ClassRef.Kind.NOT_ANNOTATION);
            }
        }
        return this.fieldAnalyzer;
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> ClassAnalyzer.visitMethod$lambda$5(access, name, descriptor)));
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)RegexKt.getMETHOD_DESCRIPTOR_REGEX(), (CharSequence)descriptor, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult result = (MatchResult)element$iv;
            boolean bl = false;
            this.addClass(result.getValue(), ClassRef.Kind.NOT_ANNOTATION);
        }
        return this.methodAnalyzer;
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> ClassAnalyzer.visitAnnotation$lambda$7(descriptor, visible)));
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> ClassAnalyzer.visitTypeAnnotation$lambda$8(typeRef, typePath, descriptor, visible)));
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    public void visitEnd() {
        this.log((Function0<String>)((Function0)ClassAnalyzer::visitEnd$lambda$9));
    }

    private static final String visitSource$lambda$0(String $source, String $debug) {
        return "- visitSource: source=" + $source + " debug=" + $debug;
    }

    private static final String visit$lambda$1(int $access, String $name, String $superName) {
        return "ClassAnalyzer#visit: " + new AccessFlags($access).getModifierString() + " " + $name + " extends " + $superName;
    }

    private static final String visitField$lambda$3(int $access, String $descriptor, String $name, String $signature, Object $value) {
        return "ClassAnalyzer#visitField: " + new AccessFlags($access).getModifierString() + " descriptor=" + $descriptor + " name=" + $name + " signature=" + $signature + " value=" + $value;
    }

    private static final String visitMethod$lambda$5(int $access, String $name, String $descriptor) {
        return "ClassAnalyzer#visitMethod: " + new AccessFlags($access).getModifierString() + " " + $name + " " + $descriptor;
    }

    private static final String visitAnnotation$lambda$7(String $descriptor, boolean $visible) {
        return "ClassAnalyzer#visitAnnotation: descriptor=" + $descriptor + " visible=" + $visible;
    }

    private static final String visitTypeAnnotation$lambda$8(int $typeRef, TypePath $typePath, String $descriptor, boolean $visible) {
        return "ClassAnalyzer#visitTypeAnnotation: typeRef=" + $typeRef + " typePath=" + $typePath + " descriptor=" + $descriptor + " visible=" + $visible;
    }

    private static final String visitEnd$lambda$9() {
        return "\n";
    }
}

