/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.BytecodeReader;
import com.autonomousapps.internal.ClassReferenceParser;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.internal.intermediates.consumer.ExplodingBytecode;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/internal/ClassFilesParser;", "Lcom/autonomousapps/internal/ClassReferenceParser;", "classes", "", "Ljava/io/File;", "buildDir", "<init>", "(Ljava/util/Set;Ljava/io/File;)V", "logger", "Lorg/gradle/api/logging/Logger;", "parseBytecode", "Lcom/autonomousapps/model/internal/intermediates/consumer/ExplodingBytecode;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBytecodeParsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeParsers.kt\ncom/autonomousapps/internal/ClassFilesParser\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n*L\n1#1,144:1\n21#2:145\n*S KotlinDebug\n*F\n+ 1 BytecodeParsers.kt\ncom/autonomousapps/internal/ClassFilesParser\n*L\n37#1:145\n*E\n"})
public final class ClassFilesParser
extends ClassReferenceParser {
    @NotNull
    private final Set<File> classes;
    @NotNull
    private final Logger logger;

    public ClassFilesParser(@NotNull Set<? extends File> classes, @NotNull File buildDir) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)buildDir, (String)"buildDir");
        super(buildDir, null);
        this.classes = classes;
        boolean $i$f$getLogger = false;
        Logger logger = Logging.getLogger(ClassFilesParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @Override
    @NotNull
    protected Set<ExplodingBytecode> parseBytecode() {
        return SequencesKt.toSortedSet((Sequence)SequencesKt.map(CollectionsKt.asSequenceOfClassFiles((Collection<? extends File>)this.classes), arg_0 -> ClassFilesParser.parseBytecode$lambda$1(this, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ExplodingBytecode parseBytecode$lambda$1(ClassFilesParser this$0, File classFile) {
        ExplodingBytecode explodingBytecode;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Closeable closeable = new FileInputStream(classFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
            Logger logger = this$0.logger;
            String string = classFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            explodingBytecode = new BytecodeReader(byArray, logger, string, this$0.relativize(classFile)).parse();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return explodingBytecode;
    }
}

