/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/internal/RootOutputPaths;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "file", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "path", "", "dir", "Lorg/gradle/api/file/Directory;", "duplicateDependenciesPath", "getDuplicateDependenciesPath", "()Lorg/gradle/api/provider/Provider;", "buildHealthPath", "getBuildHealthPath", "consoleReportPath", "getConsoleReportPath", "allLibsVersionsTomlPath", "getAllLibsVersionsTomlPath", "shouldFailPath", "getShouldFailPath", "workPlanDir", "getWorkPlanDir", "dependency-analysis-gradle-plugin"})
public final class RootOutputPaths {
    @NotNull
    private final Project project;
    @NotNull
    private final Provider<RegularFile> duplicateDependenciesPath;
    @NotNull
    private final Provider<RegularFile> buildHealthPath;
    @NotNull
    private final Provider<RegularFile> consoleReportPath;
    @NotNull
    private final Provider<RegularFile> allLibsVersionsTomlPath;
    @NotNull
    private final Provider<RegularFile> shouldFailPath;
    @NotNull
    private final Provider<Directory> workPlanDir;

    public RootOutputPaths(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.duplicateDependenciesPath = this.file("reports/dependency-analysis/duplicate-dependencies-report.json");
        this.buildHealthPath = this.file("reports/dependency-analysis/build-health-report.json");
        this.consoleReportPath = this.file("reports/dependency-analysis/build-health-report.txt");
        this.allLibsVersionsTomlPath = this.file("reports/dependency-analysis/allLibs.versions.toml");
        this.shouldFailPath = this.file("reports/dependency-analysis/should-fail.txt");
        this.workPlanDir = this.dir("reports/dependency-analysis/work-plan");
    }

    private final Provider<RegularFile> file(String path) {
        Provider provider = this.project.getLayout().getBuildDirectory().file(path);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        return provider;
    }

    private final Provider<Directory> dir(String path) {
        Provider provider = this.project.getLayout().getBuildDirectory().dir(path);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        return provider;
    }

    @NotNull
    public final Provider<RegularFile> getDuplicateDependenciesPath() {
        return this.duplicateDependenciesPath;
    }

    @NotNull
    public final Provider<RegularFile> getBuildHealthPath() {
        return this.buildHealthPath;
    }

    @NotNull
    public final Provider<RegularFile> getConsoleReportPath() {
        return this.consoleReportPath;
    }

    @NotNull
    public final Provider<RegularFile> getAllLibsVersionsTomlPath() {
        return this.allLibsVersionsTomlPath;
    }

    @NotNull
    public final Provider<RegularFile> getShouldFailPath() {
        return this.shouldFailPath;
    }

    @NotNull
    public final Provider<Directory> getWorkPlanDir() {
        return this.workPlanDir;
    }
}

