/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.OutputPaths;
import com.autonomousapps.internal.analyzer.AbstractDependencyAnalyzer;
import com.autonomousapps.internal.analyzer.AndroidSources;
import com.autonomousapps.internal.analyzer.AndroidVariant;
import com.autonomousapps.internal.android.AndroidGradlePlugin;
import com.autonomousapps.internal.android.AndroidGradlePluginFactory;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.source.SourceKind;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.AndroidClassesTask;
import com.autonomousapps.tasks.AssetSourceExploderTask;
import com.autonomousapps.tasks.ClassListExploderTask;
import com.autonomousapps.tasks.FindAndroidAssetProviders;
import com.autonomousapps.tasks.FindAndroidLinters;
import com.autonomousapps.tasks.FindAndroidResTask;
import com.autonomousapps.tasks.FindDeclaredProcsTask;
import com.autonomousapps.tasks.FindNativeLibsTask;
import com.autonomousapps.tasks.ManifestComponentsExtractionTask;
import com.autonomousapps.tasks.XmlSourceExploderTask;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010<\u001a\u00020\tH\u0002J\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BJ\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0BJ\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0BJ\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0BJ\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K0BJ\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0BJ\f\u0010N\u001a\b\u0012\u0004\u0012\u00020O0BJ\f\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0BJ\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0BJ\b\u0010T\u001a\u00020\tH\u0002J\b\u0010U\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0011\u0010%\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016R\u0011\u0010'\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0016R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001d\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0*\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010,R\u001d\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0*\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010,R\u001d\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0*\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010,R\u001d\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0*\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010,R\u0014\u00107\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0016R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020:0*\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010,R\u0017\u0010;\u001a\b\u0012\u0004\u0012\u00020:0*\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010,R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@\u00a8\u0006V"}, d2={"Lcom/autonomousapps/internal/analyzer/AndroidAnalyzer;", "Lcom/autonomousapps/internal/analyzer/AbstractDependencyAnalyzer;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/autonomousapps/internal/analyzer/AndroidVariant;", "androidSources", "Lcom/autonomousapps/internal/analyzer/AndroidSources;", "agpVersion", "", "<init>", "(Lorg/gradle/api/Project;Lcom/autonomousapps/internal/analyzer/AndroidVariant;Lcom/autonomousapps/internal/analyzer/AndroidSources;Ljava/lang/String;)V", "getVariant", "()Lcom/autonomousapps/internal/analyzer/AndroidVariant;", "getAndroidSources", "()Lcom/autonomousapps/internal/analyzer/AndroidSources;", "agp", "Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "getAgp", "()Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "flavorName", "getFlavorName", "()Ljava/lang/String;", "variantName", "getVariantName", "buildType", "getBuildType", "sourceKind", "Lcom/autonomousapps/model/source/SourceKind;", "getSourceKind", "()Lcom/autonomousapps/model/source/SourceKind;", "taskNameSuffix", "getTaskNameSuffix", "compileConfigurationName", "getCompileConfigurationName", "runtimeConfigurationName", "getRuntimeConfigurationName", "kaptConfigurationName", "getKaptConfigurationName", "annotationProcessorConfigurationName", "getAnnotationProcessorConfigurationName", "testInstrumentationRunner", "Lorg/gradle/api/provider/Provider;", "getTestInstrumentationRunner", "()Lorg/gradle/api/provider/Provider;", "kotlinSourceFiles", "", "Ljava/io/File;", "getKotlinSourceFiles", "javaSourceFiles", "getJavaSourceFiles", "groovySourceFiles", "getGroovySourceFiles", "scalaSourceFiles", "getScalaSourceFiles", "attributeValueJar", "getAttributeValueJar", "isDataBindingEnabled", "", "isViewBindingEnabled", "suffix", "outputPaths", "Lcom/autonomousapps/internal/OutputPaths;", "getOutputPaths", "()Lcom/autonomousapps/internal/OutputPaths;", "registerByteCodeSourceExploderTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/autonomousapps/tasks/ClassListExploderTask;", "registerManifestComponentsExtractionTask", "Lcom/autonomousapps/tasks/ManifestComponentsExtractionTask;", "registerFindAndroidResTask", "Lcom/autonomousapps/tasks/FindAndroidResTask;", "registerExplodeXmlSourceTask", "Lcom/autonomousapps/tasks/XmlSourceExploderTask;", "registerExplodeAssetSourceTask", "Lcom/autonomousapps/tasks/AssetSourceExploderTask;", "registerFindNativeLibsTask", "Lcom/autonomousapps/tasks/FindNativeLibsTask;", "registerFindAndroidLintersTask", "Lcom/autonomousapps/tasks/FindAndroidLinters;", "registerFindAndroidAssetProvidersTask", "Lcom/autonomousapps/tasks/FindAndroidAssetProviders;", "registerFindDeclaredProcsTask", "Lcom/autonomousapps/tasks/FindDeclaredProcsTask;", "kaptConfName", "computeTaskNameSuffix", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAndroidProjectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/AndroidAnalyzer\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,231:1\n246#2:232\n246#2:233\n246#2:234\n246#2:235\n246#2:236\n246#2:237\n246#2:238\n246#2:239\n246#2:240\n*S KotlinDebug\n*F\n+ 1 AndroidProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/AndroidAnalyzer\n*L\n66#1:232\n75#1:233\n85#1:234\n95#1:235\n107#1:236\n114#1:237\n121#1:238\n127#1:239\n133#1:240\n*E\n"})
public abstract class AndroidAnalyzer
extends AbstractDependencyAnalyzer {
    @NotNull
    private final AndroidVariant variant;
    @NotNull
    private final AndroidSources androidSources;
    @NotNull
    private final AndroidGradlePlugin agp;
    @NotNull
    private final String flavorName;
    @NotNull
    private final String variantName;
    @NotNull
    private final String buildType;
    @NotNull
    private final SourceKind sourceKind;
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileConfigurationName;
    @NotNull
    private final String runtimeConfigurationName;
    @NotNull
    private final String kaptConfigurationName;
    @NotNull
    private final String annotationProcessorConfigurationName;
    @NotNull
    private final Provider<String> testInstrumentationRunner;
    @NotNull
    private final Provider<Iterable<File>> kotlinSourceFiles;
    @NotNull
    private final Provider<Iterable<File>> javaSourceFiles;
    @NotNull
    private final Provider<Iterable<File>> groovySourceFiles;
    @NotNull
    private final Provider<Iterable<File>> scalaSourceFiles;
    @NotNull
    private final String attributeValueJar;
    @NotNull
    private final Provider<Boolean> isDataBindingEnabled;
    @NotNull
    private final Provider<Boolean> isViewBindingEnabled;
    @NotNull
    private final OutputPaths outputPaths;

    public AndroidAnalyzer(@NotNull Project project, @NotNull AndroidVariant variant, @NotNull AndroidSources androidSources, @NotNull String agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)androidSources, (String)"androidSources");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        super(project);
        this.variant = variant;
        this.androidSources = androidSources;
        this.agp = new AndroidGradlePluginFactory(project, agpVersion).newAdapter();
        this.flavorName = this.variant.getFlavorName();
        this.variantName = this.variant.getVariantName();
        this.buildType = this.variant.getBuildType();
        this.sourceKind = this.androidSources.getSourceKind();
        this.taskNameSuffix = this.computeTaskNameSuffix();
        this.compileConfigurationName = this.androidSources.getCompileClasspathConfigurationName();
        this.runtimeConfigurationName = this.androidSources.getRuntimeClasspathConfigurationName();
        this.kaptConfigurationName = this.kaptConfName();
        this.annotationProcessorConfigurationName = this.variantName + "AnnotationProcessorClasspath";
        this.testInstrumentationRunner = this.variant.getTestInstrumentationRunner();
        this.kotlinSourceFiles = this.androidSources.getKotlinSources();
        this.javaSourceFiles = this.androidSources.getJavaSources();
        Provider provider = project.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final Iterable<File> call() {
                return (Iterable)this.$project.files(new Object[0]);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        this.groovySourceFiles = provider;
        Provider provider2 = project.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final Iterable<File> call() {
                return (Iterable)this.$project.files(new Object[0]);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"provider(...)");
        this.scalaSourceFiles = provider2;
        this.attributeValueJar = "android-classes";
        this.isDataBindingEnabled = this.agp.isDataBindingEnabled();
        this.isViewBindingEnabled = this.agp.isViewBindingEnabled();
        this.outputPaths = new OutputPaths(project, this.variantName + this.suffix());
    }

    @NotNull
    protected final AndroidVariant getVariant() {
        return this.variant;
    }

    @NotNull
    protected final AndroidSources getAndroidSources() {
        return this.androidSources;
    }

    @NotNull
    protected final AndroidGradlePlugin getAgp() {
        return this.agp;
    }

    @Override
    @NotNull
    public final String getFlavorName() {
        return this.flavorName;
    }

    @Override
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Override
    @NotNull
    public final String getBuildType() {
        return this.buildType;
    }

    @Override
    @NotNull
    public final SourceKind getSourceKind() {
        return this.sourceKind;
    }

    @Override
    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @Override
    @NotNull
    public final String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    @Override
    @NotNull
    public final String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    @Override
    @NotNull
    public final String getKaptConfigurationName() {
        return this.kaptConfigurationName;
    }

    @Override
    @NotNull
    public final String getAnnotationProcessorConfigurationName() {
        return this.annotationProcessorConfigurationName;
    }

    @Override
    @NotNull
    public final Provider<String> getTestInstrumentationRunner() {
        return this.testInstrumentationRunner;
    }

    @Override
    @NotNull
    public final Provider<Iterable<File>> getKotlinSourceFiles() {
        return this.kotlinSourceFiles;
    }

    @Override
    @NotNull
    public final Provider<Iterable<File>> getJavaSourceFiles() {
        return this.javaSourceFiles;
    }

    @Override
    @NotNull
    public final Provider<Iterable<File>> getGroovySourceFiles() {
        return this.groovySourceFiles;
    }

    @Override
    @NotNull
    public final Provider<Iterable<File>> getScalaSourceFiles() {
        return this.scalaSourceFiles;
    }

    @Override
    @NotNull
    public final String getAttributeValueJar() {
        return this.attributeValueJar;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isDataBindingEnabled() {
        return this.isDataBindingEnabled;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isViewBindingEnabled() {
        return this.isViewBindingEnabled;
    }

    private final String suffix() {
        String string;
        switch (this.sourceKind.getKind()) {
            case "MAIN": {
                string = "Main";
                break;
            }
            case "TEST": {
                string = "Test";
                break;
            }
            case "ANDROID_TEST_FIXTURES": {
                string = "TestFixtures";
                break;
            }
            case "ANDROID_TEST": {
                string = "AndroidTest";
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown kind. Was '" + this.sourceKind.getKind() + "'").toString());
            }
        }
        return string;
    }

    @Override
    @NotNull
    public final OutputPaths getOutputPaths() {
        return this.outputPaths;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<ClassListExploderTask> registerByteCodeSourceExploderTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeByteCodeSource" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerByteCodeSourceExploderTask$lambda$0(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, ClassListExploderTask.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object t) {
                this.function.invoke(t);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        TaskContainer provider = taskContainer2 = taskProvider;
        boolean bl = false;
        this.androidSources.wireWithClassFiles((TaskProvider<? extends AndroidClassesTask>)provider);
        return taskContainer2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<ManifestComponentsExtractionTask> registerManifestComponentsExtractionTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "extractPackageNameFromManifest" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerManifestComponentsExtractionTask$lambda$2(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, ManifestComponentsExtractionTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindAndroidResTask> registerFindAndroidResTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidResImports" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerFindAndroidResTask$lambda$3(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidResTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<XmlSourceExploderTask> registerExplodeXmlSourceTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeXmlSource" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerExplodeXmlSourceTask$lambda$4(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, XmlSourceExploderTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<AssetSourceExploderTask> registerExplodeAssetSourceTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeAssetSource" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerExplodeAssetSourceTask$lambda$5(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, AssetSourceExploderTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindNativeLibsTask> registerFindNativeLibsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findNativeLibs" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerFindNativeLibsTask$lambda$6(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindNativeLibsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindAndroidLinters> registerFindAndroidLintersTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidLinters" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerFindAndroidLintersTask$lambda$7(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidLinters.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindAndroidAssetProviders> registerFindAndroidAssetProvidersTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidAssetProviders" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerFindAndroidAssetProvidersTask$lambda$8(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidAssetProviders.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindDeclaredProcsTask> registerFindDeclaredProcsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findDeclaredProcs" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> AndroidAnalyzer.registerFindDeclaredProcsTask$lambda$11(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindDeclaredProcsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    private final String kaptConfName() {
        Object object;
        switch (this.sourceKind.getKind()) {
            case "MAIN": {
                object = "kapt" + UtilsKt.capitalizeSafely(this.variantName);
                break;
            }
            case "TEST": {
                object = "kaptTest";
                break;
            }
            case "ANDROID_TEST_FIXTURES": {
                object = "kaptTestFixtures";
                break;
            }
            case "ANDROID_TEST": {
                object = "kaptAndroidTest";
                break;
            }
            case "CUSTOM_JVM": {
                throw new IllegalStateException("Custom JVM source sets are not supported in Android context".toString());
            }
            default: {
                throw new IllegalStateException(("Unknown kind: '" + this.sourceKind.getKind() + "'").toString());
            }
        }
        return object;
    }

    private final String computeTaskNameSuffix() {
        return Intrinsics.areEqual((Object)this.sourceKind.getKind(), (Object)"MAIN") ? UtilsKt.capitalizeSafely(this.variantName) : UtilsKt.capitalizeSafely(this.variantName) + this.suffix();
    }

    private static final Unit registerByteCodeSourceExploderTask$lambda$0(AndroidAnalyzer this$0, ClassListExploderTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.getClasses().setFrom((Iterable)$this$register.getProject().files(new Object[0]));
        $this$register.getOutput().set(this$0.outputPaths.getExplodingBytecodePath());
        return Unit.INSTANCE;
    }

    private static final Unit registerManifestComponentsExtractionTask$lambda$2(AndroidAnalyzer this$0, ManifestComponentsExtractionTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$register.setArtifacts(ArtifactViewsKt.artifactsFor((Configuration)object, "android-manifest"));
        $this$register.getNamespace().set(this$0.agp.namespace());
        $this$register.getOutput().set(this$0.outputPaths.getManifestPackagesPath());
        return Unit.INSTANCE;
    }

    private static final Unit registerFindAndroidResTask$lambda$3(AndroidAnalyzer this$0, FindAndroidResTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$register.setAndroidSymbols(ArtifactViewsKt.artifactsFor((Configuration)object, "android-symbol-with-package-name"));
        ConfigurationContainer configurationContainer2 = $this$register.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer2, (String)"getConfigurations(...)");
        Object object2 = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer2), (String)this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        $this$register.setAndroidPublicRes(ArtifactViewsKt.artifactsFor((Configuration)object2, "android-public-res"));
        $this$register.getOutput().set(this$0.outputPaths.getAndroidResPath());
        return Unit.INSTANCE;
    }

    private static final Unit registerExplodeXmlSourceTask$lambda$4(AndroidAnalyzer this$0, XmlSourceExploderTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Object[] objectArray = new Object[]{this$0.androidSources.getAndroidRes()};
        $this$register.getAndroidLocalRes().setFrom(objectArray);
        objectArray = new Object[]{this$0.androidSources.getLayoutFiles()};
        $this$register.getLayoutFiles().setFrom(objectArray);
        objectArray = new Object[]{this$0.androidSources.getManifestFiles()};
        $this$register.getManifestFiles().setFrom(objectArray);
        objectArray = new Object[]{this$0.androidSources.getMergedManifest()};
        $this$register.getMergedManifestFiles().setFrom(objectArray);
        $this$register.getNamespace().set(this$0.agp.namespace());
        $this$register.getOutput().set(this$0.outputPaths.getAndroidResToResUsagePath());
        $this$register.getOutputRuntime().set(this$0.outputPaths.getAndroidResToResUsageRuntimePath());
        return Unit.INSTANCE;
    }

    private static final Unit registerExplodeAssetSourceTask$lambda$5(AndroidAnalyzer this$0, AssetSourceExploderTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Object[] objectArray = new Object[]{this$0.androidSources.getAndroidAssets()};
        $this$register.getAndroidLocalAssets().setFrom(objectArray);
        $this$register.getOutput().set(this$0.outputPaths.getAndroidAssetSourcePath());
        return Unit.INSTANCE;
    }

    private static final Unit registerFindNativeLibsTask$lambda$6(AndroidAnalyzer this$0, FindNativeLibsTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$register.setAndroidJni(ArtifactViewsKt.artifactsFor((Configuration)object, "android-jni"));
        $this$register.getOutput().set(this$0.outputPaths.getNativeDependenciesPath());
        return Unit.INSTANCE;
    }

    private static final Unit registerFindAndroidLintersTask$lambda$7(AndroidAnalyzer this$0, FindAndroidLinters $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$register.setLintJars(ArtifactViewsKt.artifactsFor((Configuration)object, "android-lint"));
        $this$register.getOutput().set(this$0.outputPaths.getAndroidLintersPath());
        return Unit.INSTANCE;
    }

    private static final Unit registerFindAndroidAssetProvidersTask$lambda$8(AndroidAnalyzer this$0, FindAndroidAssetProviders $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this$0.runtimeConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$register.setAssets(ArtifactViewsKt.artifactsFor((Configuration)object, "android-assets"));
        $this$register.getOutput().set(this$0.outputPaths.getAndroidAssetsPath());
        return Unit.INSTANCE;
    }

    private static final Unit registerFindDeclaredProcsTask$lambda$11(AndroidAnalyzer this$0, FindDeclaredProcsTask $this$register) {
        Configuration it;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Property<InMemoryCache> property = $this$register.getInMemoryCacheProvider();
        Project project = $this$register.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        property.set(InMemoryCache.Companion.register(project));
        Configuration configuration = this$0.kaptConf();
        if (configuration != null) {
            it = configuration;
            boolean bl = false;
            ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            $this$register.setKaptArtifacts(artifactCollection);
        }
        Configuration configuration2 = this$0.annotationProcessorConf();
        if (configuration2 != null) {
            it = configuration2;
            boolean bl = false;
            ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            $this$register.setAnnotationProcessorArtifacts(artifactCollection);
        }
        $this$register.getOutput().set(this$0.outputPaths.getDeclaredProcPath());
        return Unit.INSTANCE;
    }
}

