/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.autonomousapps.internal.analyzer.JvmSourceSet;
import com.autonomousapps.model.source.SourceKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/autonomousapps/internal/analyzer/JavaSourceSet;", "Lcom/autonomousapps/internal/analyzer/JvmSourceSet;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "sourceKind", "Lcom/autonomousapps/model/source/SourceKind;", "<init>", "(Lorg/gradle/api/tasks/SourceSet;Lcom/autonomousapps/model/source/SourceKind;)V", "getSourceKind", "()Lcom/autonomousapps/model/source/SourceKind;", "name", "", "getName", "()Ljava/lang/String;", "jarTaskName", "getJarTaskName", "sourceCode", "Lorg/gradle/api/file/SourceDirectorySet;", "getSourceCode", "()Lorg/gradle/api/file/SourceDirectorySet;", "compileClasspathConfigurationName", "getCompileClasspathConfigurationName", "runtimeClasspathConfigurationName", "getRuntimeClasspathConfigurationName", "classesDirs", "Lorg/gradle/api/file/FileCollection;", "getClassesDirs", "()Lorg/gradle/api/file/FileCollection;", "dependency-analysis-gradle-plugin"})
public final class JavaSourceSet
implements JvmSourceSet {
    @NotNull
    private final SourceKind sourceKind;
    @NotNull
    private final String name;
    @NotNull
    private final String jarTaskName;
    @NotNull
    private final SourceDirectorySet sourceCode;
    @NotNull
    private final String compileClasspathConfigurationName;
    @NotNull
    private final String runtimeClasspathConfigurationName;
    @NotNull
    private final FileCollection classesDirs;

    public JavaSourceSet(@NotNull SourceSet sourceSet, @NotNull SourceKind sourceKind) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkNotNullParameter((Object)sourceKind, (String)"sourceKind");
        this.sourceKind = sourceKind;
        String string = sourceSet.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
        String string2 = sourceSet.getJarTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJarTaskName(...)");
        this.jarTaskName = string2;
        SourceDirectorySet sourceDirectorySet = sourceSet.getAllJava();
        Intrinsics.checkNotNullExpressionValue((Object)sourceDirectorySet, (String)"getAllJava(...)");
        this.sourceCode = sourceDirectorySet;
        String string3 = sourceSet.getCompileClasspathConfigurationName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCompileClasspathConfigurationName(...)");
        this.compileClasspathConfigurationName = string3;
        String string4 = sourceSet.getRuntimeClasspathConfigurationName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getRuntimeClasspathConfigurationName(...)");
        this.runtimeClasspathConfigurationName = string4;
        FileCollection fileCollection = sourceSet.getOutput().getClassesDirs();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getClassesDirs(...)");
        this.classesDirs = fileCollection;
    }

    @Override
    @NotNull
    public SourceKind getSourceKind() {
        return this.sourceKind;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getJarTaskName() {
        return this.jarTaskName;
    }

    @Override
    @NotNull
    public SourceDirectorySet getSourceCode() {
        return this.sourceCode;
    }

    @Override
    @NotNull
    public String getCompileClasspathConfigurationName() {
        return this.compileClasspathConfigurationName;
    }

    @Override
    @NotNull
    public String getRuntimeClasspathConfigurationName() {
        return this.runtimeClasspathConfigurationName;
    }

    @Override
    @NotNull
    public FileCollection getClassesDirs() {
        return this.classesDirs;
    }
}

