/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.OutputPaths;
import com.autonomousapps.internal.analyzer.AbstractDependencyAnalyzer;
import com.autonomousapps.internal.analyzer.JvmAnalyzer;
import com.autonomousapps.internal.analyzer.JvmSourceSet;
import com.autonomousapps.internal.analyzer.Language;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.source.SourceKind;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.AbiAnalysisTask;
import com.autonomousapps.tasks.ClassListExploderTask;
import com.autonomousapps.tasks.FindDeclaredProcsTask;
import com.autonomousapps.tasks.FindNativeLibsTask;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u001c\u00107\u001a\n\u0012\u0004\u0012\u000208\u0018\u0001052\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0#J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;05J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020=05H\u0016J\u0014\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#H\u0002J\u0014\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#H\u0002J\u0014\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#H\u0002J\u0014\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#H\u0002J\b\u0010B\u001a\u00020CH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0014\u0010\u001c\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0014\u0010\u001e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR\u0014\u0010 \u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u001d\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\"\u0010(\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$\u0018\u00010#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'R\u001d\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010'R\u001d\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010'R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070#\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010'R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070#\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010'R\u0014\u00100\u001a\u000201X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006D"}, d2={"Lcom/autonomousapps/internal/analyzer/JvmAnalyzer;", "Lcom/autonomousapps/internal/analyzer/AbstractDependencyAnalyzer;", "project", "Lorg/gradle/api/Project;", "sourceSet", "Lcom/autonomousapps/internal/analyzer/JvmSourceSet;", "hasAbi", "", "<init>", "(Lorg/gradle/api/Project;Lcom/autonomousapps/internal/analyzer/JvmSourceSet;Z)V", "flavorName", "", "getFlavorName", "()Ljava/lang/String;", "buildType", "getBuildType", "sourceKind", "Lcom/autonomousapps/model/source/SourceKind;", "getSourceKind", "()Lcom/autonomousapps/model/source/SourceKind;", "variantName", "getVariantName", "taskNameSuffix", "getTaskNameSuffix", "compileConfigurationName", "getCompileConfigurationName", "runtimeConfigurationName", "getRuntimeConfigurationName", "kaptConfigurationName", "getKaptConfigurationName", "annotationProcessorConfigurationName", "getAnnotationProcessorConfigurationName", "attributeValueJar", "getAttributeValueJar", "kotlinSourceFiles", "Lorg/gradle/api/provider/Provider;", "", "Ljava/io/File;", "getKotlinSourceFiles", "()Lorg/gradle/api/provider/Provider;", "javaSourceFiles", "getJavaSourceFiles", "groovySourceFiles", "getGroovySourceFiles", "scalaSourceFiles", "getScalaSourceFiles", "isDataBindingEnabled", "isViewBindingEnabled", "outputPaths", "Lcom/autonomousapps/internal/OutputPaths;", "getOutputPaths", "()Lcom/autonomousapps/internal/OutputPaths;", "registerByteCodeSourceExploderTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/autonomousapps/tasks/ClassListExploderTask;", "registerAbiAnalysisTask", "Lcom/autonomousapps/tasks/AbiAnalysisTask;", "abiExclusions", "registerFindDeclaredProcsTask", "Lcom/autonomousapps/tasks/FindDeclaredProcsTask;", "registerFindNativeLibsTask", "Lcom/autonomousapps/tasks/FindNativeLibsTask;", "getGroovySources", "getJavaSources", "getKotlinSources", "getScalaSources", "getSourceDirectories", "Lorg/gradle/api/file/FileTree;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nJvmProjectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/JvmAnalyzer\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,170:1\n246#2:171\n246#2:172\n246#2:173\n246#2:174\n*S KotlinDebug\n*F\n+ 1 JvmProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/JvmAnalyzer\n*L\n56#1:171\n65#1:172\n74#1:173\n88#1:174\n*E\n"})
public abstract class JvmAnalyzer
extends AbstractDependencyAnalyzer {
    @NotNull
    private final JvmSourceSet sourceSet;
    private final boolean hasAbi;
    @Nullable
    private final String flavorName;
    @Nullable
    private final String buildType;
    @NotNull
    private final SourceKind sourceKind;
    @NotNull
    private final String variantName;
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileConfigurationName;
    @NotNull
    private final String runtimeConfigurationName;
    @NotNull
    private final String kaptConfigurationName;
    @NotNull
    private final String annotationProcessorConfigurationName;
    @NotNull
    private final String attributeValueJar;
    @NotNull
    private final Provider<Iterable<File>> kotlinSourceFiles;
    @Nullable
    private final Provider<Iterable<File>> javaSourceFiles;
    @NotNull
    private final Provider<Iterable<File>> groovySourceFiles;
    @NotNull
    private final Provider<Iterable<File>> scalaSourceFiles;
    @NotNull
    private final Provider<Boolean> isDataBindingEnabled;
    @NotNull
    private final Provider<Boolean> isViewBindingEnabled;
    @NotNull
    private final OutputPaths outputPaths;

    public JvmAnalyzer(@NotNull Project project, @NotNull JvmSourceSet sourceSet, boolean hasAbi) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        super(project);
        this.sourceSet = sourceSet;
        this.hasAbi = hasAbi;
        this.sourceKind = this.sourceSet.getSourceKind();
        this.variantName = this.sourceSet.getName();
        this.taskNameSuffix = UtilsKt.capitalizeSafely(this.variantName);
        this.compileConfigurationName = this.sourceSet.getCompileClasspathConfigurationName();
        this.runtimeConfigurationName = this.sourceSet.getRuntimeClasspathConfigurationName();
        this.kaptConfigurationName = "kapt";
        this.annotationProcessorConfigurationName = "annotationProcessor";
        this.attributeValueJar = "jar";
        this.kotlinSourceFiles = this.getKotlinSources();
        this.javaSourceFiles = this.getJavaSources();
        this.groovySourceFiles = this.getGroovySources();
        this.scalaSourceFiles = this.getScalaSources();
        Provider provider = project.provider((Callable)isDataBindingEnabled.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        this.isDataBindingEnabled = provider;
        Provider provider2 = project.provider((Callable)isViewBindingEnabled.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"provider(...)");
        this.isViewBindingEnabled = provider2;
        this.outputPaths = new OutputPaths(project, this.variantName);
    }

    @Override
    @Nullable
    public final String getFlavorName() {
        return this.flavorName;
    }

    @Override
    @Nullable
    public final String getBuildType() {
        return this.buildType;
    }

    @Override
    @NotNull
    public final SourceKind getSourceKind() {
        return this.sourceKind;
    }

    @Override
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Override
    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @Override
    @NotNull
    public final String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    @Override
    @NotNull
    public final String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    @Override
    @NotNull
    public final String getKaptConfigurationName() {
        return this.kaptConfigurationName;
    }

    @Override
    @NotNull
    public final String getAnnotationProcessorConfigurationName() {
        return this.annotationProcessorConfigurationName;
    }

    @Override
    @NotNull
    public final String getAttributeValueJar() {
        return this.attributeValueJar;
    }

    @Override
    @NotNull
    public final Provider<Iterable<File>> getKotlinSourceFiles() {
        return this.kotlinSourceFiles;
    }

    @Override
    @Nullable
    public Provider<Iterable<File>> getJavaSourceFiles() {
        return this.javaSourceFiles;
    }

    @Override
    @NotNull
    public final Provider<Iterable<File>> getGroovySourceFiles() {
        return this.groovySourceFiles;
    }

    @Override
    @NotNull
    public final Provider<Iterable<File>> getScalaSourceFiles() {
        return this.scalaSourceFiles;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isDataBindingEnabled() {
        return this.isDataBindingEnabled;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isViewBindingEnabled() {
        return this.isViewBindingEnabled;
    }

    @Override
    @NotNull
    public OutputPaths getOutputPaths() {
        return this.outputPaths;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<ClassListExploderTask> registerByteCodeSourceExploderTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeByteCodeSource" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> JvmAnalyzer.registerByteCodeSourceExploderTask$lambda$0(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, ClassListExploderTask.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object t) {
                this.function.invoke(t);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final TaskProvider<AbiAnalysisTask> registerAbiAnalysisTask(@NotNull Provider<String> abiExclusions) {
        void name$iv;
        void $this$register$iv;
        Intrinsics.checkNotNullParameter(abiExclusions, (String)"abiExclusions");
        if (!this.hasAbi) {
            return null;
        }
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "abiAnalysis" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> JvmAnalyzer.registerAbiAnalysisTask$lambda$1(this, abiExclusions, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, AbiAnalysisTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindDeclaredProcsTask> registerFindDeclaredProcsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findDeclaredProcs" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> JvmAnalyzer.registerFindDeclaredProcsTask$lambda$4(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindDeclaredProcsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<FindNativeLibsTask> registerFindNativeLibsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findNativeLibs" + this.taskNameSuffix;
        Function1 configuration$iv = arg_0 -> JvmAnalyzer.registerFindNativeLibsTask$lambda$5(this, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindNativeLibsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    private final Provider<Iterable<File>> getGroovySources() {
        Provider provider = this.getProject().provider(new Callable(this){
            final /* synthetic */ JvmAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public final Iterable<File> call() {
                return (Iterable)JvmAnalyzer.access$getSourceDirectories(this.this$0).matching(Language.Companion.filterOf(Language.GROOVY));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final Provider<Iterable<File>> getJavaSources() {
        Provider provider = this.getProject().provider(new Callable(this){
            final /* synthetic */ JvmAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public final Iterable<File> call() {
                return (Iterable)JvmAnalyzer.access$getSourceDirectories(this.this$0).matching(Language.Companion.filterOf(Language.JAVA));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final Provider<Iterable<File>> getKotlinSources() {
        Provider provider = this.getProject().provider(new Callable(this){
            final /* synthetic */ JvmAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public final Iterable<File> call() {
                return (Iterable)JvmAnalyzer.access$getSourceDirectories(this.this$0).matching(Language.Companion.filterOf(Language.KOTLIN));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final Provider<Iterable<File>> getScalaSources() {
        Provider provider = this.getProject().provider(new Callable(this){
            final /* synthetic */ JvmAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public final Iterable<File> call() {
                return (Iterable)JvmAnalyzer.access$getSourceDirectories(this.this$0).matching(Language.Companion.filterOf(Language.SCALA));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final FileTree getSourceDirectories() {
        FileCollection fileCollection = this.sourceSet.getSourceCode().getSourceDirectories();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getSourceDirectories(...)");
        FileCollection allSource = fileCollection;
        Object[] objectArray = new Object[]{allSource};
        FileTree fileTree = this.getProject().files(objectArray).getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getAsFileTree(...)");
        return fileTree;
    }

    private static final Unit registerByteCodeSourceExploderTask$lambda$0(JvmAnalyzer this$0, ClassListExploderTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.getClasses().setFrom((Iterable)this$0.sourceSet.getClassesDirs());
        $this$register.getOutput().set(this$0.getOutputPaths().getExplodingBytecodePath());
        return Unit.INSTANCE;
    }

    private static final Unit registerAbiAnalysisTask$lambda$1(JvmAnalyzer this$0, Provider $abiExclusions, AbiAnalysisTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.getClasses().setFrom((Iterable)this$0.sourceSet.getClassesDirs());
        $this$register.getExclusions().set($abiExclusions);
        $this$register.getOutput().set(this$0.getOutputPaths().getAbiAnalysisPath());
        $this$register.getAbiDump().set(this$0.getOutputPaths().getAbiDumpPath());
        return Unit.INSTANCE;
    }

    private static final Unit registerFindDeclaredProcsTask$lambda$4(JvmAnalyzer this$0, FindDeclaredProcsTask $this$register) {
        Configuration it;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Property<InMemoryCache> property = $this$register.getInMemoryCacheProvider();
        Project project = $this$register.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        property.set(InMemoryCache.Companion.register(project));
        Configuration configuration = this$0.kaptConf();
        if (configuration != null) {
            it = configuration;
            boolean bl = false;
            ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            $this$register.setKaptArtifacts(artifactCollection);
        }
        Configuration configuration2 = this$0.annotationProcessorConf();
        if (configuration2 != null) {
            it = configuration2;
            boolean bl = false;
            ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            $this$register.setAnnotationProcessorArtifacts(artifactCollection);
        }
        $this$register.getOutput().set(this$0.getOutputPaths().getDeclaredProcPath());
        return Unit.INSTANCE;
    }

    private static final Unit registerFindNativeLibsTask$lambda$5(JvmAnalyzer this$0, FindNativeLibsTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$register.setMacNativeLibs(ArtifactViewsKt.artifactsFor((Configuration)object, "dylib"));
        $this$register.getOutput().set(this$0.getOutputPaths().getNativeDependenciesPath());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FileTree access$getSourceDirectories(JvmAnalyzer $this) {
        return $this.getSourceDirectories();
    }
}

