/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.graph;

import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.graph.GraphViewBuilder;
import com.autonomousapps.internal.graph.GraphViewBuilder$walk$;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/internal/graph/GraphViewBuilder;", "", "root", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "fileCoordinates", "", "Lcom/autonomousapps/model/Coordinates;", "localOnly", "", "<init>", "(Lorg/gradle/api/artifacts/result/ResolvedComponentResult;Ljava/util/Set;Z)V", "graph", "Lcom/google/common/graph/Graph;", "getGraph", "()Lcom/google/common/graph/Graph;", "graphBuilder", "Lcom/google/common/graph/ImmutableGraph$Builder;", "visited", "", "componentFilter", "Lkotlin/Function1;", "Lorg/gradle/api/artifacts/result/ResolvedDependencyResult;", "walkFileDeps", "", "rootId", "walk", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGraphViewBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphViewBuilder.kt\ncom/autonomousapps/internal/graph/GraphViewBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,86:1\n1869#2,2:87\n477#3:89\n1321#3,2:90\n*S KotlinDebug\n*F\n+ 1 GraphViewBuilder.kt\ncom/autonomousapps/internal/graph/GraphViewBuilder\n*L\n47#1:87,2\n55#1:89\n74#1:90,2\n*E\n"})
public final class GraphViewBuilder {
    private final boolean localOnly;
    @NotNull
    private final Graph<Coordinates> graph;
    @NotNull
    private final ImmutableGraph.Builder<Coordinates> graphBuilder;
    @NotNull
    private final Set<Coordinates> visited;
    @NotNull
    private final Function1<ResolvedDependencyResult, Boolean> componentFilter;

    public GraphViewBuilder(@NotNull ResolvedComponentResult root, @NotNull Set<? extends Coordinates> fileCoordinates, boolean localOnly) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(fileCoordinates, (String)"fileCoordinates");
        this.localOnly = localOnly;
        this.graphBuilder = DependencyGraphView.Companion.newGraphBuilder$dependency_analysis_gradle_plugin();
        this.visited = new LinkedHashSet();
        this.componentFilter = arg_0 -> GraphViewBuilder.componentFilter$lambda$0(this, arg_0);
        Coordinates rootId = GradleStringsKt.rootCoordinates(root);
        this.walkFileDeps(fileCoordinates, rootId);
        this.walk(root, rootId);
        ImmutableGraph immutableGraph = this.graphBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"build(...)");
        this.graph = (Graph)immutableGraph;
    }

    public /* synthetic */ GraphViewBuilder(ResolvedComponentResult resolvedComponentResult, Set set2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(resolvedComponentResult, set2, bl);
    }

    @NotNull
    public final Graph<Coordinates> getGraph() {
        return this.graph;
    }

    private final void walkFileDeps(Set<? extends Coordinates> fileCoordinates, Coordinates rootId) {
        this.graphBuilder.addNode((Object)rootId);
        Iterable $this$forEach$iv = fileCoordinates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Coordinates id = (Coordinates)element$iv;
            boolean bl = false;
            this.graphBuilder.putEdge((Object)rootId, (Object)id);
        }
    }

    private final void walk(ResolvedComponentResult root, Coordinates rootId) {
        Set set2 = root.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getDependencies(...)");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)set2);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)walk$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence sequence2 = SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)sequence, this.componentFilter), GraphViewBuilder::walk$lambda$2), GraphViewBuilder::walk$lambda$3), arg_0 -> GraphViewBuilder.walk$lambda$4(rootId, arg_0)), GraphViewBuilder::walk$lambda$5);
        Comparator comparator2 = ((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)pair.getSecond().getClass().getSimpleName());
                pair = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)pair.getSecond().getClass().getSimpleName())));
            }
        }).thenComparing(walk.6.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"thenComparing(...)");
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)sequence2, comparator2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            ResolvedDependencyResult dependencyResult = (ResolvedDependencyResult)pair.component1();
            Coordinates depId = (Coordinates)pair.component2();
            this.graphBuilder.putEdge((Object)rootId, (Object)depId);
            if (this.visited.contains(depId)) continue;
            this.visited.add(depId);
            ResolvedComponentResult resolvedComponentResult = dependencyResult.getSelected();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"getSelected(...)");
            this.walk(resolvedComponentResult, depId);
        }
    }

    private static final boolean componentFilter$lambda$0(GraphViewBuilder this$0, ResolvedDependencyResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.localOnly || it.getSelected().getId() instanceof ProjectComponentIdentifier;
    }

    private static final boolean walk$lambda$2(ResolvedDependencyResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isConstraint();
    }

    private static final boolean walk$lambda$3(ResolvedDependencyResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ArtifactViewsKt.isJavaPlatform(it);
    }

    private static final boolean walk$lambda$4(Coordinates $rootId, ResolvedDependencyResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)GradleStringsKt.toCoordinates(it), (Object)$rootId);
    }

    private static final Pair walk$lambda$5(ResolvedDependencyResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Pair((Object)it, (Object)GradleStringsKt.toCoordinates(it));
    }
}

