/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.ManifestParser;
import com.autonomousapps.internal.parse.ExplodedManifest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/internal/parse/AndroidManifestParser;", "", "projectDir", "Ljava/io/File;", "manifests", "", "namespace", "", "<init>", "(Ljava/io/File;Ljava/lang/Iterable;Ljava/lang/String;)V", "parser", "Lcom/autonomousapps/internal/ManifestParser;", "explodedManifests", "", "Lcom/autonomousapps/internal/parse/ExplodedManifest;", "getExplodedManifests", "()Ljava/util/Set;", "compute", "parseManifests", "toExplodedManifests", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "toExplodedManifest", "dependency-analysis-gradle-plugin"})
public final class AndroidManifestParser {
    @NotNull
    private final File projectDir;
    @NotNull
    private final Iterable<File> manifests;
    @NotNull
    private final String namespace;
    @NotNull
    private final ManifestParser parser;
    @NotNull
    private final Set<ExplodedManifest> explodedManifests;

    public AndroidManifestParser(@NotNull File projectDir, @NotNull Iterable<? extends File> manifests, @NotNull String namespace2) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(manifests, (String)"manifests");
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        this.projectDir = projectDir;
        this.manifests = manifests;
        this.namespace = namespace2;
        this.parser = new ManifestParser(this.namespace);
        this.explodedManifests = this.compute();
    }

    @NotNull
    public final Set<ExplodedManifest> getExplodedManifests() {
        return this.explodedManifests;
    }

    private final Set<ExplodedManifest> compute() {
        String string;
        if (!StringsKt.isBlank((CharSequence)this.namespace)) {
            return this.parseManifests();
        }
        List parseResults = new ArrayList();
        List malformedManifests = new ArrayList();
        for (File manifest : this.manifests) {
            if (!manifest.exists()) continue;
            try {
                ((Collection)parseResults).add(TuplesKt.to((Object)manifest, (Object)ManifestParser.parse$default(this.parser, manifest, false, 2, null)));
            }
            catch (ManifestParser.ManifestParseException manifestParseException) {
                ((Collection)malformedManifests).add(manifest);
            }
        }
        Object object = (Pair)CollectionsKt.firstOrNull((List)parseResults);
        if ((object != null && (object = (ManifestParser.ParseResult)object.getSecond()) != null ? ((ManifestParser.ParseResult)object).getPackageName() : (string = null)) == null) {
            string = "";
        }
        String mainNamespace = string;
        ManifestParser malformedParser = new ManifestParser(mainNamespace);
        for (File remainder : malformedManifests) {
            ((Collection)parseResults).add(TuplesKt.to((Object)remainder, (Object)ManifestParser.parse$default(malformedParser, remainder, false, 2, null)));
        }
        return this.toExplodedManifests((Sequence<? extends Pair<? extends File, ManifestParser.ParseResult>>)CollectionsKt.asSequence((Iterable)parseResults));
    }

    private final Set<ExplodedManifest> parseManifests() {
        return this.toExplodedManifests((Sequence<? extends Pair<? extends File, ManifestParser.ParseResult>>)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(this.manifests), AndroidManifestParser::parseManifests$lambda$0), arg_0 -> AndroidManifestParser.parseManifests$lambda$1(this, arg_0)));
    }

    private final Set<ExplodedManifest> toExplodedManifests(Sequence<? extends Pair<? extends File, ManifestParser.ParseResult>> $this$toExplodedManifests) {
        return SequencesKt.toSet((Sequence)SequencesKt.map($this$toExplodedManifests, arg_0 -> AndroidManifestParser.toExplodedManifests$lambda$2(this, arg_0)));
    }

    private final ExplodedManifest toExplodedManifest(Pair<? extends File, ManifestParser.ParseResult> $this$toExplodedManifest) {
        return new ExplodedManifest(FilesKt.toRelativeString((File)((File)$this$toExplodedManifest.getFirst()), (File)this.projectDir), ((ManifestParser.ParseResult)$this$toExplodedManifest.getSecond()).getApplicationName(), ((ManifestParser.ParseResult)$this$toExplodedManifest.getSecond()).getAttrRefs());
    }

    private static final boolean parseManifests$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.exists();
    }

    private static final Pair parseManifests$lambda$1(AndroidManifestParser this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)it, (Object)ManifestParser.parse$default(this$0.parser, it, false, 2, null));
    }

    private static final ExplodedManifest toExplodedManifests$lambda$2(AndroidManifestParser this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.toExplodedManifest((Pair<? extends File, ManifestParser.ParseResult>)it);
    }
}

