/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.utils;

import com.autonomousapps.internal.utils.CoordinatesString;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.IncludedBuildCoordinates;
import com.autonomousapps.model.internal.intermediates.Usage;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/internal/utils/CoordinatesString;", "", "fullBuildGav", "", "localGav", "capabilities", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getFullBuildGav", "()Ljava/lang/String;", "getLocalGav", "getCapabilities", "()Ljava/util/Set;", "fullGav", "toString", "matches", "", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "matchesGav", "matchesCapabilities", "Companion", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCoordinatesString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinatesString.kt\ncom/autonomousapps/internal/utils/CoordinatesString\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class CoordinatesString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fullBuildGav;
    @Nullable
    private final String localGav;
    @Nullable
    private final Set<String> capabilities;
    @NotNull
    public static final String SEPARATOR = "|";
    @NotNull
    public static final String CAPABILITIES_SEPARATOR = ",";

    public CoordinatesString(@NotNull String fullBuildGav, @Nullable String localGav, @Nullable Set<String> capabilities) {
        Intrinsics.checkNotNullParameter((Object)fullBuildGav, (String)"fullBuildGav");
        this.fullBuildGav = fullBuildGav;
        this.localGav = localGav;
        this.capabilities = capabilities;
        if (this.localGav != null && !StringsKt.startsWith$default((String)this.localGav, (String)":", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "localGav must start with ':'. Was '" + this.localGav + "'.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getFullBuildGav() {
        return this.fullBuildGav;
    }

    @Nullable
    public final String getLocalGav() {
        return this.localGav;
    }

    @Nullable
    public final Set<String> getCapabilities() {
        return this.capabilities;
    }

    @NotNull
    public final String fullGav() {
        StringBuilder stringBuilder;
        StringBuilder $this$fullGav_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$fullGav_u24lambda_u241.append(this.fullBuildGav);
        if (this.localGav != null) {
            $this$fullGav_u24lambda_u241.append(SEPARATOR);
            $this$fullGav_u24lambda_u241.append(this.localGav);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u242.append(this.fullBuildGav);
        if (this.localGav != null) {
            $this$toString_u24lambda_u242.append(SEPARATOR);
            $this$toString_u24lambda_u242.append(this.localGav);
        }
        if (this.capabilities != null) {
            $this$toString_u24lambda_u242.append(SEPARATOR);
            $this$toString_u24lambda_u242.append(CollectionsKt.joinToString$default((Iterable)this.capabilities, (CharSequence)CAPABILITIES_SEPARATOR, null, null, (int)0, null, null, (int)62, null));
        }
        return stringBuilder.toString();
    }

    public final boolean matches(@NotNull Coordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        boolean byGav = this.matchesGav(coordinates);
        boolean byCapabilities = this.matchesCapabilities(coordinates);
        return byGav && byCapabilities;
    }

    private final boolean matchesGav(Coordinates coordinates) {
        String requestedId = coordinates.gav();
        String[] stringArray = new String[]{":"};
        List tokens = StringsKt.split$default((CharSequence)this.fullBuildGav, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (tokens.size() == 3 && Intrinsics.areEqual((Object)requestedId, (Object)this.fullBuildGav)) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.fullBuildGav, (Object)requestedId) || Intrinsics.areEqual((Object)this.localGav, (Object)requestedId);
    }

    private final boolean matchesCapabilities(Coordinates coordinates) {
        Set<String> requestedCapabilities = coordinates.getGradleVariantIdentification().getCapabilities();
        if (requestedCapabilities.isEmpty() && this.capabilities == null) {
            return true;
        }
        Set<String> set2 = this.capabilities;
        if (!(set2 != null ? requestedCapabilities.size() == set2.size() : false)) {
            return false;
        }
        return Intrinsics.areEqual(requestedCapabilities, this.capabilities);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\u00020\u0005H\u0002J:\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000b0\r2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000b0\r2\u0006\u0010\u0011\u001a\u00020\u0005J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J(\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00160\u0019J(\u0010\u001a\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00160\u0019J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J*\u0010\u001c\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00160\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/autonomousapps/internal/utils/CoordinatesString$Companion;", "", "<init>", "()V", "SEPARATOR", "", "CAPABILITIES_SEPARATOR", "of", "Lcom/autonomousapps/internal/utils/CoordinatesString;", "string", "toCapabilities", "", "toStringCoordinates", "", "Lcom/autonomousapps/model/internal/intermediates/Usage;", "map", "Lcom/autonomousapps/model/Coordinates;", "buildPath", "toCoordinatesKey", "coordinates", "matchesKey", "", "T", "requestedId", "mapEntry", "", "equalsKey", "key", "startsWithKey", "firstCoordinatesKeySegment", "s", "secondCoordinatesKeySegment", "thirdCoordinatesKeySegment", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nCoordinatesString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinatesString.kt\ncom/autonomousapps/internal/utils/CoordinatesString$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n216#2,2:200\n1#3:202\n*S KotlinDebug\n*F\n+ 1 CoordinatesString.kt\ncom/autonomousapps/internal/utils/CoordinatesString$Companion\n*L\n115#1:200,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoordinatesString of(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String[] stringArray = new String[]{CoordinatesString.SEPARATOR};
            List parts = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (!(parts.size() <= 3)) {
                boolean $i$a$-require-CoordinatesString$Companion$of$22 = false;
                String $i$a$-require-CoordinatesString$Companion$of$22 = "Coordinates string must have a maximum of three parts. Was '" + string + "'.";
                throw new IllegalArgumentException($i$a$-require-CoordinatesString$Companion$of$22.toString());
            }
            String fullBuildGav = (String)parts.get(0);
            String localGav = null;
            Set<String> capabilities = null;
            if (parts.size() == 2) {
                if (StringsKt.startsWith$default((String)((String)parts.get(1)), (String)":", (boolean)false, (int)2, null)) {
                    localGav = (String)parts.get(1);
                } else {
                    capabilities = this.toCapabilities((String)parts.get(1));
                }
            } else if (parts.size() == 3) {
                localGav = (String)parts.get(1);
                capabilities = this.toCapabilities((String)parts.get(2));
            }
            return new CoordinatesString(fullBuildGav, localGav, capabilities);
        }

        private final Set<String> toCapabilities(String $this$toCapabilities) {
            String[] stringArray = new String[]{CoordinatesString.CAPABILITIES_SEPARATOR};
            return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)$this$toCapabilities, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }

        @NotNull
        public final Map<String, Set<Usage>> toStringCoordinates(@NotNull Map<Coordinates, ? extends Set<Usage>> map, @NotNull String buildPath2) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)buildPath2, (String)"buildPath");
            Map result = new LinkedHashMap();
            Map<Coordinates, ? extends Set<Usage>> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Coordinates, ? extends Set<Usage>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Coordinates, ? extends Set<Usage>> element$iv;
                Map.Entry<Coordinates, ? extends Set<Usage>> entry = element$iv = iterator.next();
                boolean bl = false;
                Coordinates coordinates = entry.getKey();
                Set<Usage> usages = entry.getValue();
                ((Set)result.computeIfAbsent(Companion.toCoordinatesKey(coordinates, buildPath2), toStringCoordinates.1.1.INSTANCE)).addAll((Collection)usages);
            }
            return result;
        }

        private final String toCoordinatesKey(Coordinates coordinates, String buildPath2) {
            Collection collection;
            String fullBuildGav = coordinates.gav();
            String localGav = coordinates instanceof IncludedBuildCoordinates && Intrinsics.areEqual((Object)((IncludedBuildCoordinates)coordinates).getResolvedProject().getBuildPath(), (Object)buildPath2) ? ((IncludedBuildCoordinates)coordinates).getResolvedProject().gav() : null;
            Collection collection2 = coordinates.getGradleVariantIdentification().getCapabilities();
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = collection2;
            }
            Set capabilities = (Set)collection;
            CoordinatesString coordinatesString = new CoordinatesString(fullBuildGav, localGav, capabilities);
            return coordinatesString.toString();
        }

        public final <T> boolean matchesKey(@NotNull String requestedId, @NotNull Map.Entry<String, ? extends T> mapEntry) {
            Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
            Intrinsics.checkNotNullParameter(mapEntry, (String)"mapEntry");
            if (this.equalsKey(requestedId, mapEntry)) {
                return true;
            }
            if (this.startsWithKey(requestedId + ":", mapEntry)) {
                return true;
            }
            return this.startsWithKey(requestedId, mapEntry);
        }

        public final <T> boolean equalsKey(@NotNull String requestedId, @NotNull Map.Entry<String, ? extends T> mapEntry) {
            Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
            Intrinsics.checkNotNullParameter(mapEntry, (String)"mapEntry");
            return this.equalsKey(requestedId, mapEntry.getKey());
        }

        public final boolean equalsKey(@NotNull String requestedId, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String firstSegment = this.firstCoordinatesKeySegment(key);
            String[] stringArray = new String[]{":"};
            List tokens = StringsKt.split$default((CharSequence)firstSegment, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (tokens.size() == 3 && Intrinsics.areEqual((Object)requestedId, (Object)firstSegment)) {
                return true;
            }
            return Intrinsics.areEqual((Object)firstSegment, (Object)requestedId) || Intrinsics.areEqual((Object)this.secondCoordinatesKeySegment(key), (Object)requestedId);
        }

        private final <T> boolean startsWithKey(String requestedId, Map.Entry<String, ? extends T> mapEntry) {
            return this.startsWithKey(requestedId, mapEntry.getKey());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean startsWithKey(String requestedId, String key) {
            if (StringsKt.startsWith$default((String)this.firstCoordinatesKeySegment(key), (String)requestedId, (boolean)false, (int)2, null)) return true;
            String string = this.secondCoordinatesKeySegment(key);
            if (string == null) return false;
            if (!StringsKt.startsWith$default((String)string, (String)requestedId, (boolean)false, (int)2, null)) return false;
            return true;
        }

        @NotNull
        public final String firstCoordinatesKeySegment(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return this.of(s).getFullBuildGav();
        }

        @Nullable
        public final String secondCoordinatesKeySegment(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return this.of(s).getLocalGav();
        }

        @Nullable
        public final Set<String> thirdCoordinatesKeySegment(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return this.of(s).getCapabilities();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

