/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0007J\f\u0010#\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR\u0011\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\tR\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\t\u00a8\u0006%"}, d2={"Lcom/autonomousapps/internal/utils/FileUtils;", "", "<init>", "()V", "ONE_KB", "", "ONE_KB_BI", "Ljava/math/BigDecimal;", "getONE_KB_BI", "()Ljava/math/BigDecimal;", "ONE_MB", "ONE_MB_BI", "getONE_MB_BI", "ONE_GB", "ONE_GB_BI", "getONE_GB_BI", "ONE_TB", "ONE_TB_BI", "getONE_TB_BI", "ONE_PB", "ONE_PB_BI", "getONE_PB_BI", "ONE_EB", "ONE_EB_BI", "getONE_EB_BI", "ONE_ZB", "getONE_ZB", "ONE_YB", "getONE_YB", "byteCountToDisplaySize", "", "size", "scale", "Lcom/autonomousapps/internal/utils/FileUtils$Scale;", "getScale", "scaled", "Scale", "dependency-analysis-gradle-plugin"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    public static final long ONE_KB = 1024L;
    @NotNull
    private static final BigDecimal ONE_KB_BI;
    public static final long ONE_MB = 0x100000L;
    @NotNull
    private static final BigDecimal ONE_MB_BI;
    public static final long ONE_GB = 0x40000000L;
    @NotNull
    private static final BigDecimal ONE_GB_BI;
    public static final long ONE_TB = 0x10000000000L;
    @NotNull
    private static final BigDecimal ONE_TB_BI;
    public static final long ONE_PB = 0x4000000000000L;
    @NotNull
    private static final BigDecimal ONE_PB_BI;
    public static final long ONE_EB = 0x1000000000000000L;
    @NotNull
    private static final BigDecimal ONE_EB_BI;
    @NotNull
    private static final BigDecimal ONE_ZB;
    @NotNull
    private static final BigDecimal ONE_YB;

    private FileUtils() {
    }

    @NotNull
    public final BigDecimal getONE_KB_BI() {
        return ONE_KB_BI;
    }

    @NotNull
    public final BigDecimal getONE_MB_BI() {
        return ONE_MB_BI;
    }

    @NotNull
    public final BigDecimal getONE_GB_BI() {
        return ONE_GB_BI;
    }

    @NotNull
    public final BigDecimal getONE_TB_BI() {
        return ONE_TB_BI;
    }

    @NotNull
    public final BigDecimal getONE_PB_BI() {
        return ONE_PB_BI;
    }

    @NotNull
    public final BigDecimal getONE_EB_BI() {
        return ONE_EB_BI;
    }

    @NotNull
    public final BigDecimal getONE_ZB() {
        return ONE_ZB;
    }

    @NotNull
    public final BigDecimal getONE_YB() {
        return ONE_YB;
    }

    @NotNull
    public final String byteCountToDisplaySize(long size, @Nullable Scale scale) {
        BigDecimal bigDecimal = BigDecimal.valueOf(size);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        BigDecimal value = this.scaled(bigDecimal);
        return scale == null ? this.byteCountToDisplaySize(value) : this.byteCountToDisplaySize(value, scale);
    }

    public static /* synthetic */ String byteCountToDisplaySize$default(FileUtils fileUtils, long l, Scale scale, int n, Object object) {
        if ((n & 2) != 0) {
            scale = null;
        }
        return fileUtils.byteCountToDisplaySize(l, scale);
    }

    @NotNull
    public final String byteCountToDisplaySize(@NotNull BigDecimal size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Pair s = size.divide(ONE_EB_BI).compareTo(BigDecimal.ONE) > 0 ? TuplesKt.to((Object)size.divide(ONE_EB_BI), (Object)"EiB") : (size.divide(ONE_PB_BI).compareTo(BigDecimal.ONE) > 0 ? TuplesKt.to((Object)size.divide(ONE_PB_BI), (Object)"PiB") : (size.divide(ONE_TB_BI).compareTo(BigDecimal.ONE) > 0 ? TuplesKt.to((Object)size.divide(ONE_TB_BI), (Object)"TiB") : (size.divide(ONE_GB_BI).compareTo(BigDecimal.ONE) > 0 ? TuplesKt.to((Object)size.divide(ONE_GB_BI), (Object)"GiB") : (size.divide(ONE_MB_BI).compareTo(BigDecimal.ONE) > 0 ? TuplesKt.to((Object)size.divide(ONE_MB_BI), (Object)"MiB") : (size.divide(ONE_KB_BI).compareTo(BigDecimal.ONE) > 0 ? TuplesKt.to((Object)size.divide(ONE_KB_BI), (Object)"KiB") : TuplesKt.to((Object)size, (Object)"bytes"))))));
        Object object = s.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
        return this.scaled((BigDecimal)object) + " " + s.getSecond();
    }

    @NotNull
    public final String byteCountToDisplaySize(@NotNull BigDecimal size, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        Pair s = TuplesKt.to((Object)size.divide(scale.getDivisor()), (Object)scale.unit());
        Object object = s.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
        return this.scaled((BigDecimal)object) + " " + s.getSecond();
    }

    @NotNull
    public final Scale getScale(long size) {
        BigDecimal bigDecimal = BigDecimal.valueOf(size);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.getScale(this.scaled(bigDecimal));
    }

    @NotNull
    public final Scale getScale(@NotNull BigDecimal size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        BigDecimal scaleDivisor = BigDecimal.valueOf(5L);
        return size.divide(ONE_YB).compareTo(scaleDivisor) > 0 ? Scale.YiB : (size.divide(ONE_ZB).compareTo(scaleDivisor) > 0 ? Scale.ZiB : (size.divide(ONE_EB_BI).compareTo(scaleDivisor) > 0 ? Scale.EiB : (size.divide(ONE_PB_BI).compareTo(scaleDivisor) > 0 ? Scale.PiB : (size.divide(ONE_TB_BI).compareTo(scaleDivisor) > 0 ? Scale.TiB : (size.divide(ONE_GB_BI).compareTo(scaleDivisor) > 0 ? Scale.GiB : (size.divide(ONE_MB_BI).compareTo(scaleDivisor) > 0 ? Scale.MiB : (size.divide(ONE_KB_BI).compareTo(scaleDivisor) > 0 ? Scale.KiB : Scale.B)))))));
    }

    private final BigDecimal scaled(BigDecimal $this$scaled) {
        BigDecimal bigDecimal = $this$scaled.setScale(2, RoundingMode.HALF_UP);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"setScale(...)");
        return bigDecimal;
    }

    static {
        BigDecimal bigDecimal = BigDecimal.valueOf(1024L);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        ONE_KB_BI = bigDecimal;
        BigDecimal bigDecimal2 = ONE_KB_BI.multiply(ONE_KB_BI);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"multiply(...)");
        ONE_MB_BI = bigDecimal2;
        BigDecimal bigDecimal3 = ONE_KB_BI.multiply(ONE_MB_BI);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
        ONE_GB_BI = bigDecimal3;
        BigDecimal bigDecimal4 = ONE_KB_BI.multiply(ONE_GB_BI);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"multiply(...)");
        ONE_TB_BI = bigDecimal4;
        BigDecimal bigDecimal5 = ONE_KB_BI.multiply(ONE_TB_BI);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"multiply(...)");
        ONE_PB_BI = bigDecimal5;
        BigDecimal bigDecimal6 = ONE_KB_BI.multiply(ONE_PB_BI);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"multiply(...)");
        ONE_EB_BI = bigDecimal6;
        BigDecimal bigDecimal7 = BigDecimal.valueOf(1024L).multiply(BigDecimal.valueOf(0x1000000000000000L));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"multiply(...)");
        ONE_ZB = bigDecimal7;
        BigDecimal bigDecimal8 = ONE_KB_BI.multiply(ONE_ZB);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal8, (String)"multiply(...)");
        ONE_YB = bigDecimal8;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/internal/utils/FileUtils$Scale;", "", "divisor", "Ljava/math/BigDecimal;", "<init>", "(Ljava/lang/String;ILjava/math/BigDecimal;)V", "getDivisor", "()Ljava/math/BigDecimal;", "B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB", "unit", "", "dependency-analysis-gradle-plugin"})
    public static final class Scale
    extends Enum<Scale> {
        @NotNull
        private final BigDecimal divisor;
        public static final /* enum */ Scale B;
        public static final /* enum */ Scale KiB;
        public static final /* enum */ Scale MiB;
        public static final /* enum */ Scale GiB;
        public static final /* enum */ Scale TiB;
        public static final /* enum */ Scale PiB;
        public static final /* enum */ Scale EiB;
        public static final /* enum */ Scale ZiB;
        public static final /* enum */ Scale YiB;
        private static final /* synthetic */ Scale[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Scale(BigDecimal divisor) {
            this.divisor = divisor;
        }

        @NotNull
        public final BigDecimal getDivisor() {
            return this.divisor;
        }

        @NotNull
        public final String unit() {
            return this.name();
        }

        public static Scale[] values() {
            return (Scale[])$VALUES.clone();
        }

        public static Scale valueOf(String value) {
            return Enum.valueOf(Scale.class, value);
        }

        @NotNull
        public static EnumEntries<Scale> getEntries() {
            return $ENTRIES;
        }

        static {
            BigDecimal bigDecimal = BigDecimal.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ONE");
            B = new Scale(bigDecimal);
            KiB = new Scale(INSTANCE.getONE_KB_BI());
            MiB = new Scale(INSTANCE.getONE_MB_BI());
            GiB = new Scale(INSTANCE.getONE_GB_BI());
            TiB = new Scale(INSTANCE.getONE_TB_BI());
            PiB = new Scale(INSTANCE.getONE_PB_BI());
            EiB = new Scale(INSTANCE.getONE_EB_BI());
            ZiB = new Scale(INSTANCE.getONE_ZB());
            YiB = new Scale(INSTANCE.getONE_YB());
            $VALUES = scaleArray = new Scale[]{Scale.B, Scale.KiB, Scale.MiB, Scale.GiB, Scale.TiB, Scale.PiB, Scale.EiB, Scale.ZiB, Scale.YiB};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

