/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.model.internal;

import com.autonomousapps.DependencyAnalysisPluginKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.model.Coordinates;
import com.squareup.moshi.JsonClass;
import java.io.File;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=false)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/autonomousapps/model/internal/PhysicalArtifact;", "", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "file", "Ljava/io/File;", "<init>", "(Lcom/autonomousapps/model/Coordinates;Ljava/io/File;)V", "getCoordinates", "()Lcom/autonomousapps/model/Coordinates;", "getFile", "()Ljava/io/File;", "mode", "Lcom/autonomousapps/model/internal/PhysicalArtifact$Mode;", "getMode", "()Lcom/autonomousapps/model/internal/PhysicalArtifact$Mode;", "isJar", "", "containsClassFiles", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "Mode", "Companion", "dependency-analysis-gradle-plugin"})
public final class PhysicalArtifact
implements Comparable<PhysicalArtifact> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinates coordinates;
    @NotNull
    private final File file;
    @NotNull
    private final Mode mode;

    public PhysicalArtifact(@NotNull Coordinates coordinates, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.coordinates = coordinates;
        this.file = file;
        if (!(this.isJar() || this.containsClassFiles())) {
            boolean bl = false;
            String string = "'file' must either be a jar or a directory that contains class files. Was '" + this.file + "'";
            throw new IllegalStateException(string.toString());
        }
        this.mode = this.isJar() ? Mode.ZIP : Mode.CLASSES;
    }

    @NotNull
    public final Coordinates getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final boolean isJar() {
        return PhysicalArtifact.Companion.isJar(this.file);
    }

    public final boolean containsClassFiles() {
        return PhysicalArtifact.Companion.containsClassFiles(this.file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull PhysicalArtifact other) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int it = this.coordinates.compareTo(other.coordinates);
        boolean bl = false;
        return it == 0 ? this.file.compareTo(other.file) : var2_2;
    }

    @NotNull
    public final Coordinates component1() {
        return this.coordinates;
    }

    @NotNull
    public final File component2() {
        return this.file;
    }

    @NotNull
    public final PhysicalArtifact copy(@NotNull Coordinates coordinates, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new PhysicalArtifact(coordinates, file);
    }

    public static /* synthetic */ PhysicalArtifact copy$default(PhysicalArtifact physicalArtifact, Coordinates coordinates, File file, int n, Object object) {
        if ((n & 1) != 0) {
            coordinates = physicalArtifact.coordinates;
        }
        if ((n & 2) != 0) {
            file = physicalArtifact.file;
        }
        return physicalArtifact.copy(coordinates, file);
    }

    @NotNull
    public String toString() {
        return "PhysicalArtifact(coordinates=" + this.coordinates + ", file=" + this.file + ")";
    }

    public int hashCode() {
        int result = this.coordinates.hashCode();
        result = result * 31 + this.file.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysicalArtifact)) {
            return false;
        }
        PhysicalArtifact physicalArtifact = (PhysicalArtifact)other;
        if (!Intrinsics.areEqual((Object)this.coordinates, (Object)physicalArtifact.coordinates)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)physicalArtifact.file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/model/internal/PhysicalArtifact$Companion;", "", "<init>", "()V", "of", "Lcom/autonomousapps/model/internal/PhysicalArtifact;", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "file", "Ljava/io/File;", "of$dependency_analysis_gradle_plugin", "isValidArtifact", "", "isJar", "containsClassFiles", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nPhysicalArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicalArtifact.kt\ncom/autonomousapps/model/internal/PhysicalArtifact$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,70:1\n1255#2,2:71\n*S KotlinDebug\n*F\n+ 1 PhysicalArtifact.kt\ncom/autonomousapps/model/internal/PhysicalArtifact$Companion\n*L\n67#1:71,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PhysicalArtifact of$dependency_analysis_gradle_plugin(@NotNull ResolvedArtifactResult artifact, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!this.isValidArtifact(file)) {
                DependencyAnalysisPluginKt.getPROJECT_LOGGER().debug(artifact + " is not valid as a PhysicalArtifact. " + file + " is neither a jar nor a class-files-containing directory");
                return null;
            }
            return new PhysicalArtifact(GradleStringsKt.toCoordinates(artifact), file);
        }

        private final boolean isValidArtifact(File file) {
            return this.isJar(file) || this.containsClassFiles(file);
        }

        private final boolean isJar(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null);
        }

        private final boolean containsClassFiles(File file) {
            boolean bl;
            block1: {
                Sequence $this$any$iv = (Sequence)FilesKt.walkBottomUp((File)file);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    File f = (File)element$iv;
                    boolean bl2 = false;
                    String string = f.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/model/internal/PhysicalArtifact$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "ZIP", "CLASSES", "dependency-analysis-gradle-plugin"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode ZIP = new Mode();
        public static final /* enum */ Mode CLASSES = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.ZIP, Mode.CLASSES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

