/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.subplugin;

import com.autonomousapps.DependencyAnalysisExtension;
import com.autonomousapps.Flags;
import com.autonomousapps.artifacts.ArtifactDescription;
import com.autonomousapps.artifacts.Publisher;
import com.autonomousapps.artifacts.Resolver;
import com.autonomousapps.internal.RootOutputPaths;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.artifacts.DagpArtifacts;
import com.autonomousapps.internal.utils.LoggingKt;
import com.autonomousapps.internal.utils.project.ProjectsKt;
import com.autonomousapps.services.GlobalDslService;
import com.autonomousapps.subplugin.RootPlugin;
import com.autonomousapps.tasks.BuildHealthTask;
import com.autonomousapps.tasks.ComputeAllDependenciesTask;
import com.autonomousapps.tasks.ComputeDuplicateDependenciesTask;
import com.autonomousapps.tasks.GenerateBuildHealthTask;
import com.autonomousapps.tasks.GenerateWorkPlan;
import com.autonomousapps.tasks.PrintDuplicateDependenciesTask;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\f\u0010\u0016\u001a\u00020\u0013*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/subplugin/RootPlugin;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "dagpExtension", "Lcom/autonomousapps/DependencyAnalysisExtension;", "dslService", "Lorg/gradle/api/provider/Provider;", "Lcom/autonomousapps/services/GlobalDslService;", "getDslService$annotations", "()V", "adviceResolver", "Lcom/autonomousapps/artifacts/Resolver;", "Lorg/gradle/api/Named;", "combinedGraphResolver", "resolvedDepsResolver", "apply", "", "checkFlags", "checkGuava", "configureRootProject", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRootPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootPlugin.kt\ncom/autonomousapps/subplugin/RootPlugin\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n246#2:159\n246#2:160\n246#2:161\n246#2:162\n246#2:163\n246#2:164\n1869#3,2:165\n*S KotlinDebug\n*F\n+ 1 RootPlugin.kt\ncom/autonomousapps/subplugin/RootPlugin\n*L\n94#1:159\n99#1:160\n103#1:161\n108#1:162\n121#1:163\n129#1:164\n149#1:165,2\n*E\n"})
public final class RootPlugin {
    @NotNull
    private final Project project;
    @NotNull
    private final DependencyAnalysisExtension dagpExtension;
    @NotNull
    private final Provider<GlobalDslService> dslService;
    @NotNull
    private final Resolver<? extends Named> adviceResolver;
    @NotNull
    private final Resolver<? extends Named> combinedGraphResolver;
    @NotNull
    private final Resolver<? extends Named> resolvedDepsResolver;

    /*
     * WARNING - void declaration
     */
    public RootPlugin(@NotNull Project project) {
        void $this$dslService_u24lambda_u242;
        Provider<GlobalDslService> provider;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!Intrinsics.areEqual((Object)this.project, (Object)this.project.getRootProject())) {
            boolean $i$a$-check-RootPlugin$22 = false;
            String $i$a$-check-RootPlugin$22 = "This plugin must only be applied to the root project. Was " + this.project.getPath() + ".";
            throw new IllegalStateException($i$a$-check-RootPlugin$22.toString());
        }
        this.dagpExtension = DependencyAnalysisExtension.Companion.of(this.project);
        Provider<GlobalDslService> $i$a$-check-RootPlugin$22 = provider = GlobalDslService.Companion.of(this.project);
        RootPlugin rootPlugin = this;
        boolean bl = false;
        Object object = $this$dslService_u24lambda_u242.get();
        GlobalDslService $this$dslService_u24lambda_u242_u24lambda_u241 = (GlobalDslService)object;
        boolean bl2 = false;
        $this$dslService_u24lambda_u242_u24lambda_u241.setRegisteredOnRoot$dependency_analysis_gradle_plugin();
        $this$dslService_u24lambda_u242_u24lambda_u241.withVersionCatalogs$dependency_analysis_gradle_plugin(this.project);
        rootPlugin.dslService = provider;
        this.adviceResolver = Resolver.Companion.interProjectResolver(this.project, (ArtifactDescription)DagpArtifacts.Kind.PROJECT_HEALTH);
        this.combinedGraphResolver = Resolver.Companion.interProjectResolver(this.project, (ArtifactDescription)DagpArtifacts.Kind.COMBINED_GRAPH);
        this.resolvedDepsResolver = Resolver.Companion.interProjectResolver(this.project, (ArtifactDescription)DagpArtifacts.Kind.RESOLVED_DEPS);
    }

    private static /* synthetic */ void getDslService$annotations() {
    }

    public final void apply() {
        Project $this$apply_u24lambda_u243 = this.project;
        boolean bl = false;
        Logger logger = $this$apply_u24lambda_u243.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LoggingKt.log(logger, "Adding root project tasks");
        this.checkFlags($this$apply_u24lambda_u243);
        this.checkGuava();
        this.configureRootProject($this$apply_u24lambda_u243);
    }

    private final void checkFlags(Project $this$checkFlags) {
        Provider provider = $this$checkFlags.getProviders().gradleProperty("dependency.analysis.autoapply");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"gradleProperty(...)");
        Provider autoApply = provider;
        if (autoApply.isPresent()) {
            if (Boolean.parseBoolean((String)autoApply.get())) {
                throw new IllegalStateException("dependency.analysis.autoapply is set to true, but this has no effect. To automatically apply Dependency Analysis Gradle \nPlugin  to every project in your build, apply the `com.autonomousapps.build-health` plugin to your settings script.".toString());
            }
            $this$checkFlags.getLogger().warn("dependency.analysis.autoapply is set to false, but this is now the only behavior, and the flag has no effect. You should\nremove it from your build scripts.");
        }
    }

    private final void checkGuava() {
        ((GlobalDslService)this.dslService.get()).verifyValidGuavaVersion$dependency_analysis_gradle_plugin();
    }

    private final void configureRootProject(Project $this$configureRootProject) {
        String name$iv;
        TaskContainer $this$register$iv;
        String name$iv2;
        TaskContainer $this$register$iv2;
        RootOutputPaths paths = new RootOutputPaths($this$configureRootProject);
        TaskContainer taskContainer = $this$configureRootProject.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        String string = "computeDuplicateDependencies";
        Object configuration$iv = arg_0 -> RootPlugin.configureRootProject$lambda$4(this, paths, arg_0);
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv2.register(name$iv2, ComputeDuplicateDependenciesTask.class, new Action((Function1)configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object t) {
                this.function.invoke(t);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        TaskProvider computeDuplicatesTask = taskProvider;
        TaskContainer taskContainer3 = $this$configureRootProject.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"getTasks(...)");
        $this$register$iv2 = taskContainer3;
        name$iv2 = "printDuplicateDependencies";
        configuration$iv = arg_0 -> RootPlugin.configureRootProject$lambda$5(computeDuplicatesTask, arg_0);
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv2.register(name$iv2, PrintDuplicateDependenciesTask.class, new /* invalid duplicate definition of identical inner class */), (String)"register(...)");
        TaskContainer taskContainer4 = $this$configureRootProject.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer4, (String)"getTasks(...)");
        $this$register$iv2 = taskContainer4;
        name$iv2 = "computeAllDependencies";
        configuration$iv = arg_0 -> RootPlugin.configureRootProject$lambda$6(this, paths, arg_0);
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv2.register(name$iv2, ComputeAllDependenciesTask.class, new /* invalid duplicate definition of identical inner class */), (String)"register(...)");
        TaskContainer taskContainer5 = $this$configureRootProject.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer5, (String)"getTasks(...)");
        name$iv2 = taskContainer5;
        configuration$iv = "generateBuildHealth";
        Function1 configuration$iv2 = arg_0 -> RootPlugin.configureRootProject$lambda$7(this, $this$configureRootProject, paths, arg_0);
        boolean $i$f$register2 = false;
        TaskProvider taskProvider2 = $this$register$iv.register(name$iv, GenerateBuildHealthTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"register(...)");
        TaskProvider generateBuildHealthTask2 = taskProvider2;
        TaskContainer taskContainer6 = $this$configureRootProject.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer6, (String)"getTasks(...)");
        $this$register$iv = taskContainer6;
        name$iv = "buildHealth";
        configuration$iv2 = arg_0 -> RootPlugin.configureRootProject$lambda$8(generateBuildHealthTask2, this, $this$configureRootProject, arg_0);
        $i$f$register2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, BuildHealthTask.class, new /* invalid duplicate definition of identical inner class */), (String)"register(...)");
        TaskContainer taskContainer7 = $this$configureRootProject.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer7, (String)"getTasks(...)");
        $this$register$iv = taskContainer7;
        name$iv = "generateWorkPlan";
        configuration$iv2 = arg_0 -> RootPlugin.configureRootProject$lambda$9($this$configureRootProject, this, paths, arg_0);
        $i$f$register2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, GenerateWorkPlan.class, new /* invalid duplicate definition of identical inner class */), (String)"register(...)");
        Publisher combinedGraphPublisher = Publisher.Companion.interProjectPublisher($this$configureRootProject, (ArtifactDescription)DagpArtifacts.Kind.COMBINED_GRAPH);
        Publisher projectHealthPublisher = Publisher.Companion.interProjectPublisher($this$configureRootProject, (ArtifactDescription)DagpArtifacts.Kind.PROJECT_HEALTH);
        Publisher resolvedDependenciesPublisher = Publisher.Companion.interProjectPublisher($this$configureRootProject, (ArtifactDescription)DagpArtifacts.Kind.RESOLVED_DEPS);
        Set set2 = $this$configureRootProject.getAllprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAllprojects(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project p = (Project)element$iv;
            boolean bl = false;
            DependencyHandler d = $this$configureRootProject.getDependencies();
            boolean bl2 = false;
            d.add(combinedGraphPublisher.getDeclarableName(), (Object)d.project(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)p.getPath()))));
            d.add(projectHealthPublisher.getDeclarableName(), (Object)d.project(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)p.getPath()))));
            d.add(resolvedDependenciesPublisher.getDeclarableName(), (Object)d.project(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)p.getPath()))));
        }
    }

    private static final Unit configureRootProject$lambda$4(RootPlugin this$0, RootOutputPaths $paths, ComputeDuplicateDependenciesTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Object[] objectArray = new Object[]{this$0.resolvedDepsResolver.artifactFilesProvider()};
        $this$register.getResolvedDependenciesReports().setFrom(objectArray);
        $this$register.getOutput().set($paths.getDuplicateDependenciesPath());
        return Unit.INSTANCE;
    }

    private static final Unit configureRootProject$lambda$5(TaskProvider $computeDuplicatesTask, PrintDuplicateDependenciesTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.getDuplicateDependenciesReport().set($computeDuplicatesTask.flatMap((Transformer)configureRootProject.1.1.INSTANCE));
        return Unit.INSTANCE;
    }

    private static final Unit configureRootProject$lambda$6(RootPlugin this$0, RootOutputPaths $paths, ComputeAllDependenciesTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Object[] objectArray = new Object[]{this$0.resolvedDepsResolver.artifactFilesProvider()};
        $this$register.getResolvedDependenciesReports().setFrom(objectArray);
        $this$register.getOutput().set($paths.getAllLibsVersionsTomlPath());
        return Unit.INSTANCE;
    }

    private static final Unit configureRootProject$lambda$7(RootPlugin this$0, Project $this_configureRootProject, RootOutputPaths $paths, GenerateBuildHealthTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Object[] objectArray = new Object[]{this$0.adviceResolver.getInternal().map((Transformer)configureRootProject.generateBuildHealthTask.1.1.INSTANCE)};
        $this$register.getProjectHealthReports().setFrom(objectArray);
        $this$register.getReportingConfig().set((Object)this$0.dagpExtension.getReportingHandler$dependency_analysis_gradle_plugin().config$dependency_analysis_gradle_plugin());
        $this$register.getProjectCount().set((Object)$this_configureRootProject.getAllprojects().size());
        Property<DslKind> property = $this$register.getDslKind();
        File file = $this_configureRootProject.getBuildFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildFile(...)");
        property.set((Object)DslKind.Companion.from(file));
        $this$register.getDependencyMap().set((Provider)this$0.dagpExtension.getDependenciesHandler$dependency_analysis_gradle_plugin().getMap());
        $this$register.getUseTypesafeProjectAccessors().set((Provider)this$0.dagpExtension.getUseTypesafeProjectAccessors$dependency_analysis_gradle_plugin());
        $this$register.getOutput().set($paths.getBuildHealthPath());
        $this$register.getConsoleOutput().set($paths.getConsoleReportPath());
        $this$register.getOutputFail().set($paths.getShouldFailPath());
        return Unit.INSTANCE;
    }

    private static final Unit configureRootProject$lambda$8(TaskProvider $generateBuildHealthTask, RootPlugin this$0, Project $this_configureRootProject, BuildHealthTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.getShouldFail().set($generateBuildHealthTask.flatMap((Transformer)configureRootProject.3.1.INSTANCE));
        $this$register.getBuildHealth().set($generateBuildHealthTask.flatMap((Transformer)configureRootProject.3.2.INSTANCE));
        $this$register.getConsoleReport().set($generateBuildHealthTask.flatMap((Transformer)configureRootProject.3.3.INSTANCE));
        $this$register.getPrintBuildHealth().set(this$0.dagpExtension.getReportingHandler$dependency_analysis_gradle_plugin().getPrintBuildHealth$dependency_analysis_gradle_plugin().orElse((Object)Flags.INSTANCE.printBuildHealth$dependency_analysis_gradle_plugin($this_configureRootProject)));
        $this$register.getPostscript().set((Provider)this$0.dagpExtension.getReportingHandler$dependency_analysis_gradle_plugin().getPostscript$dependency_analysis_gradle_plugin());
        return Unit.INSTANCE;
    }

    private static final Unit configureRootProject$lambda$9(Project $this_configureRootProject, RootPlugin this$0, RootOutputPaths $paths, GenerateWorkPlan $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        Property<String> property = $this$register.getBuildPath();
        String string = this$0.combinedGraphResolver.getInternal().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        property.set(ProjectsKt.buildPath($this_configureRootProject, string));
        Object[] objectArray = new Object[]{this$0.combinedGraphResolver.getInternal().map((Transformer)configureRootProject.4.1.INSTANCE)};
        $this$register.getCombinedProjectGraphs().setFrom(objectArray);
        $this$register.getOutputDirectory().set($paths.getWorkPlanDir());
        return Unit.INSTANCE;
    }
}

