/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.ClassFilesParser;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.intermediates.consumer.ExplodingBytecode;
import com.autonomousapps.tasks.AndroidClassesTask;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/tasks/ClassListExploderTask;", "Lcom/autonomousapps/tasks/AndroidClassesTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "<init>", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/file/ProjectLayout;)V", "classes", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "ClassListExploderParameters", "ClassListExploderWorkAction", "dependency-analysis-gradle-plugin"})
public abstract class ClassListExploderTask
extends AndroidClassesTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final ProjectLayout layout;

    @Inject
    public ClassListExploderTask(@NotNull WorkerExecutor workerExecutor, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.workerExecutor = workerExecutor;
        this.layout = layout;
        this.setDescription("Produces a report of all classes referenced by a given set of class files");
    }

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(ClassListExploderWorkAction.class, new Action(this){
            final /* synthetic */ ClassListExploderTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ClassListExploderParameters $this$submit) {
                ConfigurableFileCollection configurableFileCollection = $this$submit.getClassFiles();
                FileTree fileTree = this.this$0.getClasses().getAsFileTree();
                Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getAsFileTree(...)");
                configurableFileCollection.setFrom((Iterable)CollectionsKt.filterToClassFiles((FileCollection)fileTree).getFiles());
                Object[] objectArray = new Object[]{this.this$0.androidClassFiles()};
                $this$submit.getClassFiles().from(objectArray);
                $this$submit.getBuildDir().set((Provider)ClassListExploderTask.access$getLayout$p(this.this$0).getBuildDirectory());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
        });
    }

    public static final /* synthetic */ ProjectLayout access$getLayout$p(ClassListExploderTask $this) {
        return $this.layout;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ClassListExploderTask$ClassListExploderParameters;", "Lorg/gradle/workers/WorkParameters;", "classFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "buildDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDir", "()Lorg/gradle/api/file/DirectoryProperty;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "dependency-analysis-gradle-plugin"})
    public static interface ClassListExploderParameters
    extends WorkParameters {
        @NotNull
        public ConfigurableFileCollection getClassFiles();

        @NotNull
        public DirectoryProperty getBuildDir();

        @NotNull
        public RegularFileProperty getOutput();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/autonomousapps/tasks/ClassListExploderTask$ClassListExploderWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ClassListExploderTask$ClassListExploderParameters;", "<init>", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nClassListExploderTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassListExploderTask.kt\ncom/autonomousapps/tasks/ClassListExploderTask$ClassListExploderWorkAction\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,68:1\n154#2,13:69\n50#2,3:82\n34#2,4:85\n167#2,2:89\n*S KotlinDebug\n*F\n+ 1 ClassListExploderTask.kt\ncom/autonomousapps/tasks/ClassListExploderTask$ClassListExploderWorkAction\n*L\n64#1:69,13\n64#1:82,3\n64#1:85,4\n64#1:89,2\n*E\n"})
    public static abstract class ClassListExploderWorkAction
    implements WorkAction<ClassListExploderParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            void $this$bufferWriteJsonSet_u24default$iv;
            File output = UtilsKt.getAndDelete(((ClassListExploderParameters)this.getParameters()).getOutput());
            Set set2 = ((ClassListExploderParameters)this.getParameters()).getClassFiles().getAsFileTree().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
            File file = ((Directory)((ClassListExploderParameters)this.getParameters()).getBuildDir().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            Set<ExplodingBytecode> usedClasses = new ClassFilesParser(set2, file).analyze$dependency_analysis_gradle_plugin();
            File file2 = output;
            Set<ExplodingBytecode> set$iv = usedClasses;
            boolean compress$iv = false;
            String indent$iv = "";
            boolean $i$f$bufferWriteJsonSet = false;
            BufferedSink buffer$iv = Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null));
            Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)buffer$iv);
            Throwable throwable = null;
            try {
                void $this$withNulls$iv$iv$iv;
                JsonWriter writer$iv = (JsonWriter)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{ExplodingBytecode.class};
                ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
                typeArray = typeArray2;
                boolean withNulls$iv$iv$iv = withNulls$iv$iv;
                boolean $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, set$iv);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

