/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.internal.utils.VersionCatalogKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.ModuleCoordinates;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/autonomousapps/tasks/ComputeResolvedDependenciesTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "externalDependencies", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getExternalDependencies", "()Lorg/gradle/api/provider/ListProperty;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "outputToml", "getOutputToml", "action", "", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nComputeResolvedDependenciesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeResolvedDependenciesTask.kt\ncom/autonomousapps/tasks/ComputeResolvedDependenciesTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public abstract class ComputeResolvedDependenciesTask
extends DefaultTask {
    public ComputeResolvedDependenciesTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Computes resolved external dependencies for all variants.");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getExternalDependencies();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputToml();

    @TaskAction
    public final void action() {
        File output = UtilsKt.getAndDelete(this.getOutput());
        File outputToml = UtilsKt.getAndDelete(this.getOutputToml());
        Object object = this.getExternalDependencies().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Set dependencies = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), ComputeResolvedDependenciesTask::action$lambda$0), ComputeResolvedDependenciesTask::action$lambda$2));
        FilesKt.writeText$default((File)output, (String)CollectionsKt.joinToString$default((Iterable)dependencies, (CharSequence)"\n", null, null, (int)0, null, ComputeResolvedDependenciesTask::action$lambda$3, (int)30, null), null, (int)2, null);
        FilesKt.writeText$default((File)outputToml, (String)VersionCatalogKt.toVersionCatalog(dependencies), null, (int)2, null);
    }

    private static final Iterable action$lambda$0(RegularFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilsKt.readLines(it);
    }

    private static final ModuleCoordinates action$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Coordinates external = Coordinates.Companion.of(it);
        if (!(external instanceof ModuleCoordinates)) {
            boolean bl = false;
            String string = "ModuleCoordinates expected. Was " + it + ".";
            throw new IllegalStateException(string.toString());
        }
        return (ModuleCoordinates)external;
    }

    private static final CharSequence action$lambda$3(ModuleCoordinates it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.gav();
    }
}

