/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.Behavior;
import com.autonomousapps.extension.Exclusion;
import com.autonomousapps.extension.ExclusionKt;
import com.autonomousapps.extension.Ignore;
import com.autonomousapps.internal.DependencyScope;
import com.autonomousapps.internal.advice.SeverityHandler;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.DuplicateClass;
import com.autonomousapps.model.ModuleAdvice;
import com.autonomousapps.model.PluginAdvice;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.model.Warning;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 .2\u00020\u0001:\u0003,-.B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010*\u001a\u00020+H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000eR\u0014\u0010(\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\t\u00a8\u0006/"}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "<init>", "(Lorg/gradle/workers/WorkerExecutor;)V", "projectAdvice", "Lorg/gradle/api/file/RegularFileProperty;", "getProjectAdvice", "()Lorg/gradle/api/file/RegularFileProperty;", "dataBindingEnabled", "Lorg/gradle/api/provider/Property;", "", "getDataBindingEnabled", "()Lorg/gradle/api/provider/Property;", "viewBindingEnabled", "getViewBindingEnabled", "anyBehavior", "Lorg/gradle/api/provider/ListProperty;", "Lcom/autonomousapps/extension/Behavior;", "getAnyBehavior", "()Lorg/gradle/api/provider/ListProperty;", "unusedDependenciesBehavior", "getUnusedDependenciesBehavior", "usedTransitiveDependenciesBehavior", "getUsedTransitiveDependenciesBehavior", "incorrectConfigurationBehavior", "getIncorrectConfigurationBehavior", "unusedProcsBehavior", "getUnusedProcsBehavior", "compileOnlyBehavior", "getCompileOnlyBehavior", "runtimeOnlyBehavior", "getRuntimeOnlyBehavior", "duplicateClassWarningsBehavior", "getDuplicateClassWarningsBehavior", "redundantPluginsBehavior", "getRedundantPluginsBehavior", "moduleStructureBehavior", "getModuleStructureBehavior", "output", "getOutput", "action", "", "FilterAdviceParameters", "FilterAdviceAction", "Companion", "dependency-analysis-gradle-plugin"})
public abstract class FilterAdviceTask
extends DefaultTask {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private static final List<String> databindingDependencies;
    @NotNull
    private static final List<String> viewBindingDependencies;

    @Inject
    public FilterAdviceTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setDescription("Filter merged advice based on user preferences");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @Input
    @NotNull
    public abstract Property<Boolean> getDataBindingEnabled();

    @Input
    @NotNull
    public abstract Property<Boolean> getViewBindingEnabled();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getAnyBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getUnusedDependenciesBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getUsedTransitiveDependenciesBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getIncorrectConfigurationBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getUnusedProcsBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getCompileOnlyBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getRuntimeOnlyBehavior();

    @Input
    @NotNull
    public abstract ListProperty<Behavior> getDuplicateClassWarningsBehavior();

    @Input
    @NotNull
    public abstract Property<Behavior> getRedundantPluginsBehavior();

    @Input
    @NotNull
    public abstract Property<Behavior> getModuleStructureBehavior();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(FilterAdviceAction.class, new Action(this){
            final /* synthetic */ FilterAdviceTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(FilterAdviceParameters $this$submit) {
                $this$submit.getProjectAdvice().set((Provider)this.this$0.getProjectAdvice());
                $this$submit.getDataBindingEnabled().set((Provider)this.this$0.getDataBindingEnabled());
                $this$submit.getViewBindingEnabled().set((Provider)this.this$0.getViewBindingEnabled());
                $this$submit.getAnyBehavior().set((Provider)this.this$0.getAnyBehavior());
                $this$submit.getUnusedDependenciesBehavior().set((Provider)this.this$0.getUnusedDependenciesBehavior());
                $this$submit.getUsedTransitiveDependenciesBehavior().set((Provider)this.this$0.getUsedTransitiveDependenciesBehavior());
                $this$submit.getIncorrectConfigurationBehavior().set((Provider)this.this$0.getIncorrectConfigurationBehavior());
                $this$submit.getUnusedProcsBehavior().set((Provider)this.this$0.getUnusedProcsBehavior());
                $this$submit.getCompileOnlyBehavior().set((Provider)this.this$0.getCompileOnlyBehavior());
                $this$submit.getRuntimeOnlyBehavior().set((Provider)this.this$0.getRuntimeOnlyBehavior());
                $this$submit.getDuplicateClassWarningsBehavior().set((Provider)this.this$0.getDuplicateClassWarningsBehavior());
                $this$submit.getRedundantPluginsBehavior().set((Provider)this.this$0.getRedundantPluginsBehavior());
                $this$submit.getModuleStructureBehavior().set((Provider)this.this$0.getModuleStructureBehavior());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
        });
    }

    static {
        Object[] objectArray = new String[]{"androidx.databinding:databinding-adapters", "androidx.databinding:databinding-runtime", "androidx.databinding:databinding-common", "androidx.databinding:databinding-compiler", "androidx.databinding:databinding-ktx"};
        databindingDependencies = CollectionsKt.listOf((Object[])objectArray);
        viewBindingDependencies = CollectionsKt.listOf((Object)"androidx.databinding:viewbinding");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask$Companion;", "", "<init>", "()V", "databindingDependencies", "", "", "getDatabindingDependencies", "()Ljava/util/List;", "viewBindingDependencies", "getViewBindingDependencies", "dependency-analysis-gradle-plugin"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDatabindingDependencies() {
            return databindingDependencies;
        }

        @NotNull
        public final List<String> getViewBindingDependencies() {
            return viewBindingDependencies;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016JF\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020!0\u001a*\b\u0012\u0004\u0012\u00020!0\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceParameters;", "<init>", "()V", "dataBindingEnabled", "", "viewBindingEnabled", "anyBehavior", "Lkotlin/Pair;", "Lcom/autonomousapps/extension/Behavior;", "", "unusedDependenciesBehavior", "usedTransitiveDependenciesBehavior", "incorrectConfigurationBehavior", "unusedProcsBehavior", "compileOnlyBehavior", "runtimeOnlyBehavior", "duplicateClassWarningsBehavior", "redundantPluginsBehavior", "moduleStructureBehavior", "partition", "behaviors", "execute", "", "filterOf", "Lkotlin/sequences/Sequence;", "Lcom/autonomousapps/model/Advice;", "behaviorSpec", "predicate", "Lkotlin/Function1;", "filterDataBinding", "filterViewBinding", "Lcom/autonomousapps/model/DuplicateClass;", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nFilterAdviceTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterAdviceTask.kt\ncom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n3301#2,10:302\n1761#2,3:342\n1761#2,3:345\n774#2:348\n865#2:349\n866#2:351\n1563#2:352\n1634#2,3:353\n2851#2,7:356\n774#2:363\n865#2,2:364\n1563#2:366\n1634#2,3:367\n2851#2,7:370\n142#3,13:312\n41#4,2:325\n34#4,4:327\n177#4,3:331\n41#4,2:334\n34#4,4:336\n180#4,2:340\n1#5:350\n*S KotlinDebug\n*F\n+ 1 FilterAdviceTask.kt\ncom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceAction\n*L\n131#1:302,10\n157#1:342,3\n160#1:345,3\n219#1:348\n219#1:349\n219#1:351\n227#1:352\n227#1:353,3\n231#1:356,7\n268#1:363\n268#1:364,2\n273#1:366\n273#1:367,3\n276#1:370,7\n142#1:312,13\n142#1:325,2\n142#1:327,4\n201#1:331,3\n201#1:334,2\n201#1:336,4\n201#1:340,2\n*E\n"})
    public static abstract class FilterAdviceAction
    implements WorkAction<FilterAdviceParameters> {
        private final boolean dataBindingEnabled;
        private final boolean viewBindingEnabled;
        @NotNull
        private final Pair<Behavior, List<Behavior>> anyBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> unusedDependenciesBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> usedTransitiveDependenciesBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> incorrectConfigurationBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> unusedProcsBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> compileOnlyBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> runtimeOnlyBehavior;
        @NotNull
        private final Pair<Behavior, List<Behavior>> duplicateClassWarningsBehavior;
        @NotNull
        private final Behavior redundantPluginsBehavior;
        @NotNull
        private final Behavior moduleStructureBehavior;

        public FilterAdviceAction() {
            Object object = ((FilterAdviceParameters)this.getParameters()).getDataBindingEnabled().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.dataBindingEnabled = (Boolean)object;
            Object object2 = ((FilterAdviceParameters)this.getParameters()).getViewBindingEnabled().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            this.viewBindingEnabled = (Boolean)object2;
            Object object3 = ((FilterAdviceParameters)this.getParameters()).getAnyBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            this.anyBehavior = this.partition((List)object3);
            Object object4 = ((FilterAdviceParameters)this.getParameters()).getUnusedDependenciesBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            this.unusedDependenciesBehavior = this.partition((List)object4);
            Object object5 = ((FilterAdviceParameters)this.getParameters()).getUsedTransitiveDependenciesBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
            this.usedTransitiveDependenciesBehavior = this.partition((List)object5);
            Object object6 = ((FilterAdviceParameters)this.getParameters()).getIncorrectConfigurationBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            this.incorrectConfigurationBehavior = this.partition((List)object6);
            Object object7 = ((FilterAdviceParameters)this.getParameters()).getUnusedProcsBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
            this.unusedProcsBehavior = this.partition((List)object7);
            Object object8 = ((FilterAdviceParameters)this.getParameters()).getCompileOnlyBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
            this.compileOnlyBehavior = this.partition((List)object8);
            Object object9 = ((FilterAdviceParameters)this.getParameters()).getRuntimeOnlyBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
            this.runtimeOnlyBehavior = this.partition((List)object9);
            Object object10 = ((FilterAdviceParameters)this.getParameters()).getDuplicateClassWarningsBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"get(...)");
            this.duplicateClassWarningsBehavior = this.partition((List)object10);
            Object object11 = ((FilterAdviceParameters)this.getParameters()).getRedundantPluginsBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"get(...)");
            this.redundantPluginsBehavior = (Behavior)object11;
            Object object12 = ((FilterAdviceParameters)this.getParameters()).getModuleStructureBehavior().get();
            Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"get(...)");
            this.moduleStructureBehavior = (Behavior)object12;
        }

        private final Pair<Behavior, List<Behavior>> partition(List<? extends Behavior> behaviors) {
            Iterable $this$partition$iv = behaviors;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Behavior it = (Behavior)element$iv;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getSourceSetName(), (Object)"__all") ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair p = new Pair(first$iv, second$iv);
            Behavior global = (Behavior)CollectionsKt.first((List)((List)p.getFirst()));
            List rest = (List)p.getSecond();
            return TuplesKt.to((Object)global, (Object)rest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            void $this$bufferWriteJson_u24default$iv;
            Behavior $this$withNulls$iv$iv$iv$iv$iv;
            Pair<Behavior, List<Behavior>> reader$iv$iv$iv;
            File output = UtilsKt.getAndDelete(((FilterAdviceParameters)this.getParameters()).getOutput());
            RegularFileProperty $this$fromJson$iv = ((FilterAdviceParameters)this.getParameters()).getProjectAdvice();
            boolean $i$f$fromJson = false;
            Object object = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson222 = false;
            Pair<Behavior, List<Behavior>> pair = (Pair<Behavior, List<Behavior>>)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Pair<Behavior, List<Behavior>> pair2 = null;
            try {
                reader$iv$iv$iv = (BufferedSource)pair;
                boolean bl = false;
                boolean withNulls$iv$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter jsonAdapter2 = jsonAdapter;
                boolean withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                boolean $i$f$withNulls = false;
                Object object2 = $this$withNulls$iv$iv$iv$iv$iv.fromJson((BufferedSource)reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object2);
                reader$iv$iv$iv = object2;
            }
            catch (Throwable bl) {
                pair2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)pair, (Throwable)pair2);
            }
            ProjectAdvice projectAdvice = (ProjectAdvice)reader$iv$iv$iv;
            Set dependencyAdvice = SequencesKt.toSortedSet(this.filterViewBinding(this.filterDataBinding(this.filterOf(this.filterOf(this.filterOf(this.filterOf(this.filterOf(this.filterOf(this.filterOf((Sequence<Advice>)CollectionsKt.asSequence((Iterable)projectAdvice.getDependencyAdvice()), this.anyBehavior, (Function1<? super Advice, Boolean>)((Function1)FilterAdviceAction::execute$lambda$1)), this.unusedDependenciesBehavior, (Function1<? super Advice, Boolean>)((Function1)FilterAdviceAction::execute$lambda$2)), this.usedTransitiveDependenciesBehavior, (Function1<? super Advice, Boolean>)((Function1)FilterAdviceAction::execute$lambda$3)), this.incorrectConfigurationBehavior, (Function1<? super Advice, Boolean>)((Function1)FilterAdviceAction::execute$lambda$4)), this.compileOnlyBehavior, (Function1<? super Advice, Boolean>)((Function1)FilterAdviceAction::execute$lambda$5)), this.runtimeOnlyBehavior, (Function1<? super Advice, Boolean>)((Function1)FilterAdviceAction::execute$lambda$6)), this.unusedProcsBehavior, (Function1<? super Advice, Boolean>)((Function1)FilterAdviceAction::execute$lambda$7)))));
            Set pluginAdvice = SequencesKt.toSortedSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)projectAdvice.getPluginAdvice()), arg_0 -> FilterAdviceAction.execute$lambda$9(this, arg_0)), arg_0 -> FilterAdviceAction.execute$lambda$11(this, arg_0)));
            Set moduleAdvice = SequencesKt.toSortedSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)projectAdvice.getModuleAdvice()), arg_0 -> FilterAdviceAction.execute$lambda$12(this, arg_0)), arg_0 -> FilterAdviceAction.execute$lambda$13(this, arg_0)));
            SortedSet duplicateClassWarnings = SequencesKt.toSortedSet(this.filterOf((Sequence<DuplicateClass>)CollectionsKt.asSequence((Iterable)projectAdvice.getWarning().getDuplicateClasses()), this.duplicateClassWarningsBehavior));
            Pair<Behavior, List<Behavior>> $i$f$fromJson222 = this.anyBehavior;
            pair = this.unusedDependenciesBehavior;
            pair2 = this.usedTransitiveDependenciesBehavior;
            reader$iv$iv$iv = this.incorrectConfigurationBehavior;
            Pair<Behavior, List<Behavior>> bl = this.unusedProcsBehavior;
            Object withNulls$iv$iv$iv$iv = this.compileOnlyBehavior;
            Pair<Behavior, List<Behavior>> $i$f$getJsonAdapter = this.duplicateClassWarningsBehavior;
            $this$withNulls$iv$iv$iv$iv$iv = this.redundantPluginsBehavior;
            Behavior withNulls$iv$iv$iv$iv$iv = this.moduleStructureBehavior;
            SeverityHandler severityHandler = new SeverityHandler((Pair<? extends Behavior, ? extends List<? extends Behavior>>)$i$f$fromJson222, (Pair<? extends Behavior, ? extends List<? extends Behavior>>)pair, (Pair<? extends Behavior, ? extends List<? extends Behavior>>)pair2, (Pair<? extends Behavior, ? extends List<? extends Behavior>>)reader$iv$iv$iv, (Pair<? extends Behavior, ? extends List<? extends Behavior>>)withNulls$iv$iv$iv$iv, (Pair<? extends Behavior, ? extends List<? extends Behavior>>)bl, (Pair<? extends Behavior, ? extends List<? extends Behavior>>)$i$f$getJsonAdapter, $this$withNulls$iv$iv$iv$iv$iv, withNulls$iv$iv$iv$iv$iv);
            boolean shouldFailDeps = severityHandler.shouldFailDeps(dependencyAdvice);
            boolean shouldFailPlugins = severityHandler.shouldFailPlugins(pluginAdvice);
            boolean shouldFailModuleStructure = severityHandler.shouldFailModuleStructure(moduleAdvice);
            boolean shouldFailDuplicateClasses = severityHandler.shouldFailDuplicateClasses(duplicateClassWarnings);
            ProjectAdvice filteredAdvice = ProjectAdvice.copy$default(projectAdvice, null, dependencyAdvice, pluginAdvice, moduleAdvice, new Warning(duplicateClassWarnings), shouldFailDeps || shouldFailPlugins || shouldFailModuleStructure || shouldFailDuplicateClasses, 1, null);
            withNulls$iv$iv$iv$iv = output;
            ProjectAdvice obj$iv = filteredAdvice;
            String indent$iv = "";
            boolean $i$f$bufferWriteJson = false;
            Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
            Throwable throwable = null;
            try {
                void $this$withNulls$iv$iv$iv;
                JsonWriter writer$iv = (JsonWriter)closeable;
                boolean bl2 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter2 = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter jsonAdapter3 = jsonAdapter;
                boolean withNulls$iv$iv$iv = withNulls$iv$iv;
                boolean $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)obj$iv);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final Sequence<Advice> filterOf(Sequence<Advice> $this$filterOf, Pair<? extends Behavior, ? extends List<? extends Behavior>> behaviorSpec, Function1<? super Advice, Boolean> predicate) {
            Behavior globalBehavior = (Behavior)behaviorSpec.getFirst();
            List sourceSetsBehavior = (List)behaviorSpec.getSecond();
            Function1 byGlobal = arg_0 -> FilterAdviceAction.filterOf$lambda$14(globalBehavior, arg_0);
            Function1 bySourceSets = arg_0 -> FilterAdviceAction.filterOf$lambda$20(sourceSetsBehavior, arg_0);
            return SequencesKt.filterNot($this$filterOf, arg_0 -> FilterAdviceAction.filterOf$lambda$21(predicate, byGlobal, bySourceSets, arg_0));
        }

        private final Sequence<Advice> filterDataBinding(Sequence<Advice> $this$filterDataBinding) {
            return this.dataBindingEnabled ? SequencesKt.filterNot($this$filterDataBinding, FilterAdviceAction::filterDataBinding$lambda$22) : $this$filterDataBinding;
        }

        private final Sequence<Advice> filterViewBinding(Sequence<Advice> $this$filterViewBinding) {
            return this.viewBindingEnabled ? SequencesKt.filterNot($this$filterViewBinding, FilterAdviceAction::filterViewBinding$lambda$23) : $this$filterViewBinding;
        }

        private final Sequence<DuplicateClass> filterOf(Sequence<DuplicateClass> $this$filterOf, Pair<? extends Behavior, ? extends List<? extends Behavior>> behaviorSpec) {
            Behavior globalBehavior = (Behavior)behaviorSpec.getFirst();
            List sourceSetsBehavior = (List)behaviorSpec.getSecond();
            Function1 byGlobal = arg_0 -> FilterAdviceAction.filterOf$lambda$24(globalBehavior, arg_0);
            Function1 bySourceSets = arg_0 -> FilterAdviceAction.filterOf$lambda$28(sourceSetsBehavior, arg_0);
            return SequencesKt.filterNot($this$filterOf, arg_0 -> FilterAdviceAction.filterOf$lambda$29(byGlobal, bySourceSets, arg_0));
        }

        private static final boolean execute$lambda$1(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        private static final boolean execute$lambda$2(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isRemove();
        }

        private static final boolean execute$lambda$3(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isAdd();
        }

        private static final boolean execute$lambda$4(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isChange();
        }

        private static final boolean execute$lambda$5(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isCompileOnly();
        }

        private static final boolean execute$lambda$6(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isRuntimeOnly();
        }

        private static final boolean execute$lambda$7(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isProcessor();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean execute$lambda$9(FilterAdviceAction this$0, PluginAdvice pa) {
            Exclusion it;
            Intrinsics.checkNotNullParameter((Object)pa, (String)"pa");
            if (this$0.anyBehavior.getFirst() instanceof Ignore) return true;
            Iterable $this$any$iv = ((Behavior)this$0.anyBehavior.getFirst()).getFilter();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (Exclusion)element$iv;
                boolean bl = false;
            } while (!it.matches(pa.getRedundantPlugin()));
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean execute$lambda$11(FilterAdviceAction this$0, PluginAdvice pa) {
            Exclusion it;
            Intrinsics.checkNotNullParameter((Object)pa, (String)"pa");
            if (this$0.redundantPluginsBehavior instanceof Ignore) return true;
            Iterable $this$any$iv = this$0.redundantPluginsBehavior.getFilter();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (Exclusion)element$iv;
                boolean bl = false;
            } while (!it.matches(pa.getRedundantPlugin()));
            return true;
        }

        private static final boolean execute$lambda$12(FilterAdviceAction this$0, ModuleAdvice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.anyBehavior.getFirst() instanceof Ignore || it.shouldIgnore$dependency_analysis_gradle_plugin((Behavior)this$0.anyBehavior.getFirst());
        }

        private static final boolean execute$lambda$13(FilterAdviceAction this$0, ModuleAdvice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.moduleStructureBehavior instanceof Ignore || it.shouldIgnore$dependency_analysis_gradle_plugin(this$0.moduleStructureBehavior);
        }

        private static final boolean filterOf$lambda$14(Behavior $globalBehavior, Advice a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return $globalBehavior instanceof Ignore || ExclusionKt.anyMatches((Collection<? extends Exclusion>)$globalBehavior.getFilter(), a.getCoordinates().getIdentifier()) || ExclusionKt.anyMatches((Collection<? extends Exclusion>)$globalBehavior.getFilter(), a.getCoordinates().gav());
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean filterOf$lambda$20(List $sourceSetsBehavior, Advice a) {
            Object v2;
            void $this$reduceOrNull$iv;
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Iterable $this$filter$iv = $sourceSetsBehavior;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable<Object> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String to;
                String string;
                String from;
                String string2;
                Behavior b = (Behavior)element$iv$iv;
                boolean bl = false;
                if (a.getFromConfiguration() != null) {
                    String it;
                    boolean bl2 = false;
                    string2 = DependencyScope.Companion.sourceSetName(it);
                } else {
                    string2 = from = null;
                }
                if (a.getToConfiguration() != null) {
                    String it;
                    boolean bl3 = false;
                    string = DependencyScope.Companion.sourceSetName(it);
                } else {
                    string = to = null;
                }
                if (!(Intrinsics.areEqual((Object)b.getSourceSetName(), (Object)from) || Intrinsics.areEqual((Object)b.getSourceSetName(), (Object)to))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List behaviors = (List)destination$iv$iv;
            Iterable $this$map$iv = behaviors;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Behavior bl = (Behavior)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it instanceof Ignore || ExclusionKt.anyMatches((Collection<? extends Exclusion>)it.getFilter(), a.getCoordinates().getIdentifier()) || ExclusionKt.anyMatches((Collection<? extends Exclusion>)it.getFilter(), a.getCoordinates().gav()));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    $i$f$mapTo = (Boolean)iterator$iv.next();
                    boolean acc = (Boolean)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc || b != false;
                }
                v2 = accumulator$iv;
            }
            Boolean bl = v2;
            return bl != null ? bl : false;
        }

        private static final boolean filterOf$lambda$21(Function1 $predicate, Function1 $byGlobal, Function1 $bySourceSets, Advice advice) {
            Intrinsics.checkNotNullParameter((Object)advice, (String)"advice");
            return (Boolean)$predicate.invoke((Object)advice) != false && ((Boolean)$byGlobal.invoke((Object)advice) != false || (Boolean)$bySourceSets.invoke((Object)advice) != false);
        }

        private static final boolean filterDataBinding$lambda$22(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.getDatabindingDependencies().contains(it.getCoordinates().getIdentifier());
        }

        private static final boolean filterViewBinding$lambda$23(Advice it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.getViewBindingDependencies().contains(it.getCoordinates().getIdentifier());
        }

        private static final boolean filterOf$lambda$24(Behavior $globalBehavior, DuplicateClass d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return $globalBehavior instanceof Ignore || d.containsMatchIn$dependency_analysis_gradle_plugin($globalBehavior);
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean filterOf$lambda$28(List $sourceSetsBehavior, DuplicateClass d) {
            Object v0;
            void $this$reduceOrNull$iv;
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            Iterable $this$filter$iv = $sourceSetsBehavior;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Behavior b = (Behavior)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)b.getSourceSetName(), (Object)DependencyScope.Companion.sourceSetName(d.getClasspathName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List behaviors = (List)destination$iv$iv;
            Iterable $this$map$iv = behaviors;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Behavior bl = (Behavior)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it instanceof Ignore || d.containsMatchIn$dependency_analysis_gradle_plugin((Behavior)it));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    $i$f$mapTo = (Boolean)iterator$iv.next();
                    boolean acc = (Boolean)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc || b != false;
                }
                v0 = accumulator$iv;
            }
            Boolean bl = v0;
            return bl != null ? bl : false;
        }

        private static final boolean filterOf$lambda$29(Function1 $byGlobal, Function1 $bySourceSets, DuplicateClass duplicateClass) {
            Intrinsics.checkNotNullParameter((Object)duplicateClass, (String)"duplicateClass");
            return (Boolean)$byGlobal.invoke((Object)duplicateClass) != false || (Boolean)$bySourceSets.invoke((Object)duplicateClass) != false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\nR\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\nR\u0012\u0010$\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006&\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/FilterAdviceTask$FilterAdviceParameters;", "Lorg/gradle/workers/WorkParameters;", "projectAdvice", "Lorg/gradle/api/file/RegularFileProperty;", "getProjectAdvice", "()Lorg/gradle/api/file/RegularFileProperty;", "dataBindingEnabled", "Lorg/gradle/api/provider/Property;", "", "getDataBindingEnabled", "()Lorg/gradle/api/provider/Property;", "viewBindingEnabled", "getViewBindingEnabled", "anyBehavior", "Lorg/gradle/api/provider/ListProperty;", "Lcom/autonomousapps/extension/Behavior;", "getAnyBehavior", "()Lorg/gradle/api/provider/ListProperty;", "unusedDependenciesBehavior", "getUnusedDependenciesBehavior", "usedTransitiveDependenciesBehavior", "getUsedTransitiveDependenciesBehavior", "incorrectConfigurationBehavior", "getIncorrectConfigurationBehavior", "unusedProcsBehavior", "getUnusedProcsBehavior", "compileOnlyBehavior", "getCompileOnlyBehavior", "runtimeOnlyBehavior", "getRuntimeOnlyBehavior", "duplicateClassWarningsBehavior", "getDuplicateClassWarningsBehavior", "redundantPluginsBehavior", "getRedundantPluginsBehavior", "moduleStructureBehavior", "getModuleStructureBehavior", "output", "getOutput", "dependency-analysis-gradle-plugin"})
    public static interface FilterAdviceParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getProjectAdvice();

        @NotNull
        public Property<Boolean> getDataBindingEnabled();

        @NotNull
        public Property<Boolean> getViewBindingEnabled();

        @NotNull
        public ListProperty<Behavior> getAnyBehavior();

        @NotNull
        public ListProperty<Behavior> getUnusedDependenciesBehavior();

        @NotNull
        public ListProperty<Behavior> getUsedTransitiveDependenciesBehavior();

        @NotNull
        public ListProperty<Behavior> getIncorrectConfigurationBehavior();

        @NotNull
        public ListProperty<Behavior> getUnusedProcsBehavior();

        @NotNull
        public ListProperty<Behavior> getCompileOnlyBehavior();

        @NotNull
        public ListProperty<Behavior> getRuntimeOnlyBehavior();

        @NotNull
        public ListProperty<Behavior> getDuplicateClassWarningsBehavior();

        @NotNull
        public Property<Behavior> getRedundantPluginsBehavior();

        @NotNull
        public Property<Behavior> getModuleStructureBehavior();

        @NotNull
        public RegularFileProperty getOutput();
    }
}

