/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.internal.intermediates.AndroidLinterDependency;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/tasks/FindAndroidLinters;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "lintJars", "Lorg/gradle/api/artifacts/ArtifactCollection;", "setLintJars", "", "getLintArtifactFiles", "Lorg/gradle/api/file/FileCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "findLintRegistry", "", "jar", "Ljava/io/File;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFindAndroidLinters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindAndroidLinters.kt\ncom/autonomousapps/tasks/FindAndroidLinters\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n154#2,13:91\n50#2,3:104\n34#2,4:107\n167#2,2:111\n1#3:113\n*S KotlinDebug\n*F\n+ 1 FindAndroidLinters.kt\ncom/autonomousapps/tasks/FindAndroidLinters\n*L\n65#1:91,13\n65#1:104,3\n65#1:107,4\n65#1:111,2\n*E\n"})
public abstract class FindAndroidLinters
extends DefaultTask {
    private ArtifactCollection lintJars;

    public FindAndroidLinters() {
        this.setDescription("Produces a report of dependencies that supply Android linters");
    }

    public final void setLintJars(@NotNull ArtifactCollection lintJars) {
        Intrinsics.checkNotNullParameter((Object)lintJars, (String)"lintJars");
        this.lintJars = lintJars;
    }

    @Classpath
    @NotNull
    public final FileCollection getLintArtifactFiles() {
        ArtifactCollection artifactCollection = this.lintJars;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lintJars");
            artifactCollection = null;
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getArtifactFiles(...)");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJsonSet_u24default$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        ArtifactCollection artifactCollection = this.lintJars;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lintJars");
            artifactCollection = null;
        }
        Set linters = SequencesKt.toSortedSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)artifactCollection)), FindAndroidLinters::action$lambda$0), arg_0 -> FindAndroidLinters.action$lambda$1(this, arg_0)));
        File file = outputFile;
        Set set$iv = linters;
        boolean compress$iv = false;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        BufferedSink buffer$iv = Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null));
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)buffer$iv);
        Throwable throwable = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            Type[] typeArray = new Type[]{AndroidLinterDependency.class};
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
            Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
            typeArray = typeArray2;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)set$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findLintRegistry(File jar) {
        String serviceEntry;
        String string;
        block18: {
            block16: {
                List list;
                String manifestEntry;
                String string2;
                Iterator iterator;
                Object object;
                ZipFile zip = new ZipFile(jar);
                ZipEntry zipEntry = zip.getEntry("META-INF/MANIFEST.MF");
                if (zipEntry != null) {
                    Object v2;
                    Object object2;
                    block15: {
                        ZipEntry $this$findLintRegistry_u24lambda_u243 = zipEntry;
                        boolean bl = false;
                        InputStream inputStream = zip.getInputStream($this$findLintRegistry_u24lambda_u243);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        object2 = inputStream;
                        object = Charsets.UTF_8;
                        iterator = new InputStreamReader((InputStream)object2, (Charset)object);
                        int n = 8192;
                        object2 = iterator instanceof BufferedReader ? (BufferedReader)((Object)iterator) : new BufferedReader((Reader)((Object)iterator), n);
                        object = null;
                        try {
                            BufferedReader p0 = (BufferedReader)object2;
                            boolean bl2 = false;
                            iterator = TextStreamsKt.readLines((Reader)p0);
                        }
                        catch (Throwable bl2) {
                            object = bl2;
                            throw bl2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                        }
                        object = (Iterable)((Object)iterator);
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Object bl2 = iterator.next();
                            String it = (String)bl2;
                            boolean bl3 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)"Lint-Registry", (boolean)false, (int)2, null)) continue;
                            v2 = bl2;
                            break block15;
                        }
                        v2 = null;
                    }
                    String string3 = v2;
                    string2 = string3 != null && (object2 = StringsKt.substringAfter$default((String)string3, (String)":", null, (int)2, null)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString() : null;
                } else {
                    string2 = null;
                }
                String string4 = manifestEntry = string2;
                if (string4 != null) {
                    return string4;
                }
                ZipEntry zipEntry2 = zip.getEntry("META-INF/services/com.android.tools.lint.client.api.IssueRegistry");
                if (zipEntry2 == null) break block16;
                ZipEntry $this$findLintRegistry_u24lambda_u245 = zipEntry2;
                boolean bl = false;
                InputStream inputStream = zip.getInputStream($this$findLintRegistry_u24lambda_u245);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                object = inputStream;
                iterator = Charsets.UTF_8;
                Reader bl2 = new InputStreamReader((InputStream)object, (Charset)((Object)iterator));
                int it = 8192;
                object = bl2 instanceof BufferedReader ? (BufferedReader)bl2 : new BufferedReader(bl2, it);
                iterator = null;
                try {
                    BufferedReader p0 = (BufferedReader)object;
                    boolean bl4 = false;
                    list = TextStreamsKt.readLines((Reader)p0);
                }
                catch (Throwable throwable) {
                    try {
                        iterator = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)((Object)iterator));
                        throw throwable2;
                    }
                }
                CloseableKt.closeFinally((Closeable)object, iterator);
                string = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)list)))).toString();
                break block18;
            }
            string = null;
        }
        String string5 = serviceEntry = string;
        if (string5 != null) {
            return string5;
        }
        throw new GradleException("No linter issue registry for " + jar.getPath());
    }

    private static final boolean action$lambda$0(ResolvedArtifactResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile().exists();
    }

    private static final AndroidLinterDependency action$lambda$1(FindAndroidLinters this$0, ResolvedArtifactResult it) {
        AndroidLinterDependency androidLinterDependency;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            Coordinates coordinates = GradleStringsKt.toCoordinates(it);
            File file = it.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            androidLinterDependency = new AndroidLinterDependency(coordinates, this$0.findLintRegistry(file));
        }
        catch (GradleException gradleException) {
            androidLinterDependency = null;
        }
        return androidLinterDependency;
    }
}

