/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.intermediates.ServiceLoaderDependency;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/tasks/FindServiceLoadersTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "compileClasspath", "Lorg/gradle/api/artifacts/ArtifactCollection;", "setCompileClasspath", "", "artifacts", "getCompileClasspath", "Lorg/gradle/api/file/FileCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "findServiceLoaders", "", "Lcom/autonomousapps/model/internal/intermediates/ServiceLoaderDependency;", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFindServiceLoadersTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindServiceLoadersTask.kt\ncom/autonomousapps/tasks/FindServiceLoadersTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n774#2:99\n865#2,2:100\n1460#2,5:107\n1563#2:135\n1634#2,3:136\n865#2,2:140\n116#3,5:102\n76#3:139\n154#4,13:112\n50#4,3:125\n34#4,4:128\n167#4,2:132\n1#5:134\n*S KotlinDebug\n*F\n+ 1 FindServiceLoadersTask.kt\ncom/autonomousapps/tasks/FindServiceLoadersTask\n*L\n55#1:99\n55#1:100,2\n56#1:107,5\n75#1:135\n75#1:136,3\n77#1:140,2\n56#1:102,5\n77#1:139\n58#1:112,13\n58#1:125,3\n58#1:128,4\n58#1:132,2\n*E\n"})
public abstract class FindServiceLoadersTask
extends DefaultTask {
    private ArtifactCollection compileClasspath;

    public FindServiceLoadersTask() {
        this.setDescription("Produces a report of all dependencies that include Java ServiceLoaders");
    }

    public final void setCompileClasspath(@NotNull ArtifactCollection artifacts) {
        Intrinsics.checkNotNullParameter((Object)artifacts, (String)"artifacts");
        this.compileClasspath = artifacts;
    }

    @Classpath
    @NotNull
    public final FileCollection getCompileClasspath() {
        ArtifactCollection artifactCollection = this.compileClasspath;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
            artifactCollection = null;
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getArtifactFiles(...)");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJsonSet_u24default$iv;
        void $this$flatMapTo$iv$iv$iv;
        void $this$filterTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        ArtifactCollection artifactCollection = this.compileClasspath;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
            artifactCollection = null;
        }
        Iterable $this$filter$iv = CollectionsKt.filterNonGradle(artifactCollection);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl = false;
            String string = it.getFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object $this$flatMapToSet$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapToSet = false;
        Iterable $this$flatMapToMutableSet$iv$iv = $this$flatMapToSet$iv;
        boolean $i$f$flatMapToMutableSet = false;
        Iterable $i$f$filterTo22 = $this$flatMapToMutableSet$iv$iv;
        Collection destination$iv$iv$iv = new HashSet(CollectionsKt.collectionSizeOrDefault($this$flatMapToMutableSet$iv$iv, 10));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv$iv : $this$flatMapTo$iv$iv$iv) {
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv$iv = this.findServiceLoaders(it);
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv$iv, (Iterable)list$iv$iv$iv);
        }
        Set serviceLoaders = (Set)destination$iv$iv$iv;
        $this$flatMapToSet$iv = outputFile;
        Set set$iv = serviceLoaders;
        boolean compress$iv = false;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        BufferedSink buffer$iv = Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null));
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)buffer$iv);
        Object object = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            Type[] typeArray = new Type[]{ServiceLoaderDependency.class};
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
            Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
            typeArray = typeArray2;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)set$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)closeable, object);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
    }

    private final Set<ServiceLoaderDependency> findServiceLoaders(ResolvedArtifactResult artifact) {
        ZipFile zip = new ZipFile(artifact.getFile());
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        return SequencesKt.toSortedSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)kotlin.collections.CollectionsKt.iterator(enumeration)), FindServiceLoadersTask::findServiceLoaders$lambda$2), FindServiceLoadersTask::findServiceLoaders$lambda$3), FindServiceLoadersTask::findServiceLoaders$lambda$4), arg_0 -> FindServiceLoadersTask.findServiceLoaders$lambda$8(zip, artifact, this, arg_0)));
    }

    private static final boolean findServiceLoaders$lambda$2(ZipEntry it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"META-INF/services/", (boolean)false, (int)2, null);
    }

    private static final boolean findServiceLoaders$lambda$3(ZipEntry it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"META-INF/services/javax.annotation.processing.Processor", (boolean)false, (int)2, null);
    }

    private static final boolean findServiceLoaders$lambda$4(ZipEntry it) {
        return it.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final ServiceLoaderDependency findServiceLoaders$lambda$8(ZipFile $zip, ResolvedArtifactResult $artifact, FindServiceLoadersTask this$0, ZipEntry serviceFile) {
        ServiceLoaderDependency serviceLoaderDependency;
        void $this$filterTo$iv$iv;
        void $this$filterToSet$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object p0;
        InputStream inputStream = $zip.getInputStream(serviceFile);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Object object = inputStream;
        Object object2 = Charsets.UTF_8;
        Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
        int n = 8192;
        object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        object2 = null;
        try {
            p0 = (BufferedReader)object;
            boolean bl = false;
            p0 = TextStreamsKt.readLines((Reader)((Reader)p0));
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        object = (Iterable)p0;
        boolean $i$f$map = false;
        p0 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterToSet = false;
        $this$mapTo$iv$iv = $this$filterToSet$iv;
        destination$iv$iv = new HashSet();
        int $i$f$filterTo = 0;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set providerClasses = (Set)destination$iv$iv;
        if (!((Collection)providerClasses).isEmpty()) {
            String string = serviceFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            serviceLoaderDependency = ServiceLoaderDependency.Companion.newInstance(StringsKt.removePrefix((String)string, (CharSequence)"META-INF/services/"), providerClasses, $artifact);
        } else {
            String string;
            InputStream inputStream2 = $zip.getInputStream(serviceFile);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
            Closeable closeable = inputStream2;
            object3 = Charsets.UTF_8;
            destination$iv$iv = new InputStreamReader((InputStream)closeable, (Charset)object3);
            $i$f$filterTo = 8192;
            closeable = destination$iv$iv instanceof BufferedReader ? (BufferedReader)destination$iv$iv : new BufferedReader((Reader)destination$iv$iv, $i$f$filterTo);
            object3 = null;
            try {
                BufferedReader p02 = (BufferedReader)closeable;
                boolean bl = false;
                string = TextStreamsKt.readText((Reader)p02);
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
            }
            String contents = string;
            this$0.getLogger().debug($artifact.getFile().getName() + " has a services file at path " + serviceFile.getName() + ", but there are no services! File contents:\n<<" + contents + ">>");
            serviceLoaderDependency = null;
        }
        return serviceLoaderDependency;
    }
}

