/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.extension.ReportingHandler;
import com.autonomousapps.extension.ReportingHandlerKt;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.advice.ProjectHealthConsoleReportBuilder;
import com.autonomousapps.internal.utils.Colors;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.BuildHealth;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010#\u001a\u00020$H\u0007J\u0016\u0010%\u001a\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u0014\u0010\u001b\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001e\u00a8\u0006)"}, d2={"Lcom/autonomousapps/tasks/GenerateBuildHealthTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "projectHealthReports", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getProjectHealthReports", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "reportingConfig", "Lorg/gradle/api/provider/Property;", "Lcom/autonomousapps/extension/ReportingHandler$Config;", "getReportingConfig", "()Lorg/gradle/api/provider/Property;", "projectCount", "", "getProjectCount", "dslKind", "Lcom/autonomousapps/internal/advice/DslKind;", "getDslKind", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "useTypesafeProjectAccessors", "", "getUseTypesafeProjectAccessors", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "consoleOutput", "getConsoleOutput", "outputFail", "getOutputFail", "action", "", "isFunctionallyEmpty", "advice", "", "Lcom/autonomousapps/model/ProjectAdvice;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateBuildHealthTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateBuildHealthTask.kt\ncom/autonomousapps/tasks/GenerateBuildHealthTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,179:1\n1563#2:180\n1634#2,2:181\n1636#2:191\n669#2,11:204\n1869#2,2:215\n808#2,11:217\n1869#2,2:228\n153#3,2:183\n41#4,2:185\n34#4,4:187\n177#4,3:193\n41#4,2:196\n34#4,4:198\n180#4,2:202\n608#5:192\n*S KotlinDebug\n*F\n+ 1 GenerateBuildHealthTask.kt\ncom/autonomousapps/tasks/GenerateBuildHealthTask\n*L\n79#1:180\n79#1:181,2\n79#1:191\n172#1:204,11\n116#1:215,2\n126#1:217,11\n126#1:228,2\n79#1:183,2\n79#1:185,2\n79#1:187,4\n150#1:193,3\n150#1:196,2\n150#1:198,4\n150#1:202,2\n92#1:192\n*E\n"})
public abstract class GenerateBuildHealthTask
extends DefaultTask {
    public GenerateBuildHealthTask() {
        this.setDescription("Generates json report for build health");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getProjectHealthReports();

    @Nested
    @NotNull
    public abstract Property<ReportingHandler.Config> getReportingConfig();

    @Input
    @NotNull
    public abstract Property<Integer> getProjectCount();

    @Input
    @NotNull
    public abstract Property<DslKind> getDslKind();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @Input
    @NotNull
    public abstract Property<Boolean> getUseTypesafeProjectAccessors();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getConsoleOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFail();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJson_u24default$iv;
        void $this$sortedBy$iv;
        Throwable throwable;
        Serializable serializable;
        void $this$mapTo$iv$iv;
        File output = UtilsKt.getAndDelete(this.getOutput());
        File consoleOutput = UtilsKt.getAndDelete(this.getConsoleOutput());
        File outputFail = UtilsKt.getAndDelete(this.getOutputFail());
        Ref.BooleanRef didWrite = new Ref.BooleanRef();
        Ref.BooleanRef shouldFail = new Ref.BooleanRef();
        Ref.IntRef unusedDependencies = new Ref.IntRef();
        Ref.IntRef undeclaredDependencies = new Ref.IntRef();
        Ref.IntRef misDeclaredDependencies = new Ref.IntRef();
        Ref.IntRef compileOnlyDependencies = new Ref.IntRef();
        Ref.IntRef runtimeOnlyDependencies = new Ref.IntRef();
        Ref.IntRef processorDependencies = new Ref.IntRef();
        BuildHealth.AndroidScoreMetrics.Builder androidMetricsBuilder = new BuildHealth.AndroidScoreMetrics.Builder();
        Set set2 = this.getProjectHealthReports().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
        Iterable $this$map$iv = set2;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object reader$iv;
            void it;
            serializable = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            void $this$fromJson$iv = it;
            boolean $i$f$fromJson = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead((File)$this$fromJson$iv);
            throwable = null;
            try {
                void $this$withNulls$iv$iv$iv;
                reader$iv = (BufferedSource)closeable;
                boolean bl2 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(ProjectAdvice.class), (String)"adapter(...)");
                boolean withNulls$iv$iv$iv = withNulls$iv$iv;
                boolean $i$f$withNulls = false;
                Object object = $this$withNulls$iv$iv$iv.fromJson(reader$iv);
                Intrinsics.checkNotNull((Object)object);
                reader$iv = object;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            collection.add((ProjectAdvice)reader$iv);
        }
        List advice = (List)destination$iv$iv;
        if (this.isFunctionallyEmpty(advice)) {
            this.getLogger().warn("No project health reports found. Is 'com.autonomousapps.dependency-analysis' not applied to any subprojects in this build?\nSee https://github.com/autonomousapps/dependency-analysis-gradle-plugin/wiki/Adding-to-your-project");
        }
        Sequence $i$f$map22 = CollectionsKt.asSequence((Iterable)advice);
        boolean $i$f$sortedBy22 = false;
        Set projectAdvice = SequencesKt.toSortedSet((Sequence)SequencesKt.onEach((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProjectAdvice it = (ProjectAdvice)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getProjectPath());
                it = (ProjectAdvice)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getProjectPath())));
            }
        }), arg_0 -> GenerateBuildHealthTask.action$lambda$4(didWrite, consoleOutput, shouldFail, this, unusedDependencies, undeclaredDependencies, misDeclaredDependencies, compileOnlyDependencies, runtimeOnlyDependencies, processorDependencies, androidMetricsBuilder, arg_0)));
        BuildHealth buildHealth = new BuildHealth(projectAdvice, shouldFail.element, projectAdvice.size(), unusedDependencies.element, undeclaredDependencies.element, misDeclaredDependencies.element, compileOnlyDependencies.element, runtimeOnlyDependencies.element, processorDependencies.element, androidMetricsBuilder.build());
        File $i$f$sortedBy22 = output;
        BuildHealth obj$iv = buildHealth;
        String indent$iv = "";
        boolean $i$f$bufferWriteJson = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
        serializable = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(BuildHealth.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
            throwable = jsonAdapter;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)obj$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            serializable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
        }
        FilesKt.writeText$default((File)outputFail, (String)String.valueOf(shouldFail.element), null, (int)2, null);
        if (!didWrite.element) {
            FilesKt.writeText$default((File)consoleOutput, (String)"", null, (int)2, null);
        } else {
            Object object = this.getReportingConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ReportingHandler.Config reportingConfig = (ReportingHandler.Config)object;
            String ps = ReportingHandlerKt.getEffectivePostscript(reportingConfig, shouldFail.element);
            if (((CharSequence)ps).length() > 0) {
                FilesKt.appendText$default((File)consoleOutput, (String)("\n\n" + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(ps, "\u001b[1m")), null, (int)2, null);
            }
        }
    }

    private final boolean isFunctionallyEmpty(Collection<ProjectAdvice> advice) {
        if (advice.isEmpty()) {
            return true;
        }
        if (advice.size() == 1) {
            Object v0;
            block5: {
                Iterable $this$singleOrNull$iv = advice;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ProjectAdvice it = (ProjectAdvice)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getProjectPath(), (Object)":")) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if (v0 != null) {
                Integer n = (Integer)this.getProjectCount().get();
                int n2 = 1;
                return n == null || n != n2;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit action$lambda$4(Ref.BooleanRef $didWrite, File $consoleOutput, Ref.BooleanRef $shouldFail, GenerateBuildHealthTask this$0, Ref.IntRef $unusedDependencies, Ref.IntRef $undeclaredDependencies, Ref.IntRef $misDeclaredDependencies, Ref.IntRef $compileOnlyDependencies, Ref.IntRef $runtimeOnlyDependencies, Ref.IntRef $processorDependencies, BuildHealth.AndroidScoreMetrics.Builder $androidMetricsBuilder, ProjectAdvice projectAdvice) {
        Intrinsics.checkNotNullParameter((Object)projectAdvice, (String)"projectAdvice");
        if (projectAdvice.isNotEmpty()) {
            void $this$filterIsInstanceTo$iv$iv;
            if ($didWrite.element) {
                FilesKt.appendText$default((File)$consoleOutput, (String)"\n\n", null, (int)2, null);
            }
            $shouldFail.element = $shouldFail.element || projectAdvice.getShouldFail();
            Object object = this$0.getDslKind().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            DslKind dslKind = (DslKind)((Object)object);
            Object object2 = this$0.getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Function1<String, String> function1 = DependenciesHandler.Companion.toLambda((Map)object2);
            Object object3 = this$0.getUseTypesafeProjectAccessors().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            String report = new ProjectHealthConsoleReportBuilder(projectAdvice, "", dslKind, function1, (Boolean)object3).getText();
            String projectPath = Intrinsics.areEqual((Object)projectAdvice.getProjectPath(), (Object)":") ? "root project" : projectAdvice.getProjectPath();
            FilesKt.appendText$default((File)$consoleOutput, (String)("Advice for " + projectPath + "\n" + report), null, (int)2, null);
            $didWrite.element = true;
            Iterable $this$forEach$iv = projectAdvice.getDependencyAdvice();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n;
                Advice it = (Advice)element$iv;
                boolean bl = false;
                if (it.isRemove()) {
                    n = $unusedDependencies.element;
                    $unusedDependencies.element = n + 1;
                    continue;
                }
                if (it.isAdd()) {
                    n = $undeclaredDependencies.element;
                    $undeclaredDependencies.element = n + 1;
                    continue;
                }
                if (it.isChange()) {
                    n = $misDeclaredDependencies.element;
                    $misDeclaredDependencies.element = n + 1;
                    continue;
                }
                if (it.isCompileOnly()) {
                    n = $compileOnlyDependencies.element;
                    $compileOnlyDependencies.element = n + 1;
                    continue;
                }
                if (it.isRuntimeOnly()) {
                    n = $runtimeOnlyDependencies.element;
                    $runtimeOnlyDependencies.element = n + 1;
                    continue;
                }
                if (!it.isProcessor()) continue;
                n = $processorDependencies.element;
                $processorDependencies.element = n + 1;
            }
            Iterable $this$filterIsInstance$iv = projectAdvice.getModuleAdvice();
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n;
                AndroidScore it = (AndroidScore)element$iv;
                boolean bl = false;
                if (it.shouldBeJvm()) {
                    n = $androidMetricsBuilder.getShouldBeJvmCount();
                    $androidMetricsBuilder.setShouldBeJvmCount(n + 1);
                    continue;
                }
                if (!it.couldBeJvm()) continue;
                n = $androidMetricsBuilder.getCouldBeJvmCount();
                $androidMetricsBuilder.setCouldBeJvmCount(n + 1);
            }
        }
        return Unit.INSTANCE;
    }
}

