/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.graph.GraphViewBuilder;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.graph.GraphsKt;
import com.autonomousapps.internal.utils.GraphAdapter;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.google.common.graph.Graph;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectGraphTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "buildPath", "Lorg/gradle/api/provider/Property;", "", "getBuildPath", "()Lorg/gradle/api/provider/Property;", "compileClasspath", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "getCompileClasspath", "runtimeClasspath", "getRuntimeClasspath", "output", "Lorg/gradle/api/file/DirectoryProperty;", "getOutput", "()Lorg/gradle/api/file/DirectoryProperty;", "action", "", "Companion", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateProjectGraphTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateProjectGraphTask.kt\ncom/autonomousapps/tasks/GenerateProjectGraphTask\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,81:1\n177#2,3:82\n41#2,2:85\n34#2,4:87\n180#2,2:91\n*S KotlinDebug\n*F\n+ 1 GenerateProjectGraphTask.kt\ncom/autonomousapps/tasks/GenerateProjectGraphTask\n*L\n74#1:82,3\n74#1:85,2\n74#1:87,4\n74#1:91,2\n*E\n"})
public abstract class GenerateProjectGraphTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PROJECT_COMBINED_CLASSPATH_JSON = "project-combined-classpath.json";
    @NotNull
    public static final String PROJECT_COMPILE_CLASSPATH_GV = "project-compile-classpath.gv";
    @NotNull
    public static final String PROJECT_RUNTIME_CLASSPATH_GV = "project-runtime-classpath.gv";
    @NotNull
    public static final String PROJECT_COMBINED_CLASSPATH_GV = "project-combined-classpath.gv";

    public GenerateProjectGraphTask() {
        this.setDescription("Generates several graph views of this project's local dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @Input
    @NotNull
    public abstract Property<ResolvedComponentResult> getCompileClasspath();

    @Input
    @NotNull
    public abstract Property<ResolvedComponentResult> getRuntimeClasspath();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJson_u24default$iv;
        Provider provider = this.getOutput().file(PROJECT_COMPILE_CLASSPATH_GV);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        File compileOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider);
        Provider provider2 = this.getOutput().file(PROJECT_RUNTIME_CLASSPATH_GV);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"file(...)");
        File runtimeOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider2);
        Provider provider3 = this.getOutput().file(PROJECT_COMBINED_CLASSPATH_GV);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"file(...)");
        File combinedOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider3);
        Provider provider4 = this.getOutput().file(PROJECT_COMBINED_CLASSPATH_JSON);
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"file(...)");
        File combinedJsonOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider4);
        Provider provider5 = this.getOutput().file("project-compile-classpath-topological.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"file(...)");
        File compileTopOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider5);
        Provider provider6 = this.getOutput().file("project-runtime-classpath-topological.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider6, (String)"file(...)");
        File runtimeTopOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider6);
        Object object = this.getCompileClasspath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Graph<Coordinates> compileGraph = new GraphViewBuilder((ResolvedComponentResult)object, SetsKt.emptySet(), true).getGraph();
        Object object2 = this.getRuntimeClasspath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Graph<Coordinates> runtimeGraph = new GraphViewBuilder((ResolvedComponentResult)object2, SetsKt.emptySet(), true).getGraph();
        Object object3 = this.getBuildPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        GraphWriter graphWriter = new GraphWriter((String)object3);
        Object object4 = this.getBuildPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        String buildPath2 = (String)object4;
        FilesKt.writeText$default((File)compileOutput, (String)graphWriter.toDot(compileGraph), null, (int)2, null);
        FilesKt.writeText$default((File)runtimeOutput, (String)graphWriter.toDot(runtimeGraph), null, (int)2, null);
        Graph<Coordinates> combinedGraph = GraphsKt.plus(GraphsKt.stripVariants(compileGraph, buildPath2), GraphsKt.stripVariants(runtimeGraph, buildPath2));
        FilesKt.writeText$default((File)combinedOutput, (String)graphWriter.toDot(combinedGraph), null, (int)2, null);
        File file = combinedJsonOutput;
        GraphAdapter.GraphContainer obj$iv = new GraphAdapter.GraphContainer(combinedGraph);
        String indent$iv = "";
        boolean $i$f$bufferWriteJson = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(GraphAdapter.GraphContainer.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
            JsonAdapter jsonAdapter2 = jsonAdapter;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)obj$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FilesKt.writeText$default((File)compileTopOutput, (String)graphWriter.topological(compileGraph), null, (int)2, null);
        FilesKt.writeText$default((File)runtimeTopOutput, (String)graphWriter.topological(runtimeGraph), null, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectGraphTask$Companion;", "", "<init>", "()V", "PROJECT_COMBINED_CLASSPATH_JSON", "", "PROJECT_COMPILE_CLASSPATH_GV", "PROJECT_RUNTIME_CLASSPATH_GV", "PROJECT_COMBINED_CLASSPATH_GV", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

