/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="Always prints output")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/autonomousapps/tasks/ProjectGraphTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "rootDir", "Lorg/gradle/api/file/DirectoryProperty;", "getRootDir", "()Lorg/gradle/api/file/DirectoryProperty;", "graphsDir", "getGraphsDir", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class ProjectGraphTask
extends DefaultTask {
    public ProjectGraphTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Generates several graph views of this project's local dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Internal
    @NotNull
    public abstract DirectoryProperty getRootDir();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getGraphsDir();

    @TaskAction
    public final void action() {
        StringBuilder stringBuilder;
        File file = ((RegularFile)this.getGraphsDir().file("project-compile-classpath.gv").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        File compileOutput = file;
        File file2 = ((RegularFile)this.getGraphsDir().file("project-runtime-classpath.gv").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        File runtimeOutput = file2;
        File file3 = ((RegularFile)this.getGraphsDir().file("project-combined-classpath.gv").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
        File combinedOutput = file3;
        StringBuilder $this$action_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object object = this.getProjectPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String svgName = StringsKt.replace$default((String)StringsKt.removePrefix((String)((String)object), (CharSequence)":"), (char)':', (char)'-', (boolean)false, (int)4, null) + ".svg";
        File file4 = ((Directory)this.getRootDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getAsFile(...)");
        File rootPath = file4;
        File compilePath = FilesKt.relativeTo((File)compileOutput, (File)rootPath);
        File runtimePath = FilesKt.relativeTo((File)runtimeOutput, (File)rootPath);
        File combinedPath = FilesKt.relativeTo((File)combinedOutput, (File)rootPath);
        $this$action_u24lambda_u240.append("Graphs generated to:").append('\n');
        $this$action_u24lambda_u240.append(" - " + compilePath).append('\n');
        $this$action_u24lambda_u240.append(" - " + runtimePath).append('\n');
        $this$action_u24lambda_u240.append(" - " + combinedPath).append('\n');
        $this$action_u24lambda_u240.append('\n');
        $this$action_u24lambda_u240.append("To generate an SVG with graphviz, you could run the following. (You must have graphviz installed.)").append('\n');
        $this$action_u24lambda_u240.append('\n');
        $this$action_u24lambda_u240.append("    dot -Tsvg " + runtimePath + " -o " + svgName).append('\n');
        String msg = stringBuilder.toString();
        this.getLogger().quiet(msg);
    }
}

