/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.exception.BuildScriptParseException;
import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.advice.AdvicePrinter;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.parse.BuildScriptDependenciesRewriter;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="No outputs")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0007J0\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/autonomousapps/tasks/RewriteTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "buildScript", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildScript", "()Lorg/gradle/api/file/RegularFileProperty;", "projectAdvice", "getProjectAdvice", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "useTypesafeProjectAccessors", "Lorg/gradle/api/provider/Property;", "", "getUseTypesafeProjectAccessors", "()Lorg/gradle/api/provider/Property;", "upgrade", "getUpgrade", "action", "", "createReversedDependencyMap", "Lkotlin/Function1;", "map", "", "filtered", "", "Lcom/autonomousapps/model/Advice;", "isUpgrade", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRewriteTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RewriteTask.kt\ncom/autonomousapps/tasks/RewriteTask\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 4 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n142#2,13:120\n41#3,2:133\n34#3,4:135\n76#4:139\n865#5,2:140\n*S KotlinDebug\n*F\n+ 1 RewriteTask.kt\ncom/autonomousapps/tasks/RewriteTask\n*L\n65#1:120,13\n65#1:133,2\n65#1:135,4\n118#1:139\n118#1:140,2\n*E\n"})
public abstract class RewriteTask
extends DefaultTask {
    public RewriteTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Rewrite build script for this project to match dependency advice");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildScript();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @Input
    @NotNull
    public abstract Property<Boolean> getUseTypesafeProjectAccessors();

    @Optional
    @Input
    @Option(option="upgrade", description="Use --upgrade if you only want to add or upgrade (implementation -> api) dependencies")
    @NotNull
    public abstract Property<Boolean> getUpgrade();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        Object object;
        File file = ((RegularFile)this.getBuildScript().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        File buildScript = file;
        Object object2 = this.getUpgrade().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        boolean isUpgrade = (Boolean)object2;
        if (isUpgrade) {
            this.getLogger().quiet("Fixing dependencies for " + buildScript.getPath() + ". Upgrades only.");
        } else {
            this.getLogger().quiet("Fixing dependencies for " + buildScript.getPath() + ".");
        }
        DslKind dslKind = DslKind.Companion.from(buildScript);
        RegularFileProperty $this$fromJson$iv = this.getProjectAdvice();
        boolean $i$f$fromJson = false;
        Object object3 = $this$fromJson$iv.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        RegularFile $this$fromJson$iv$iv = (RegularFile)object3;
        boolean $i$f$fromJson2 = false;
        File file2 = $this$fromJson$iv$iv.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        File $this$fromJson$iv$iv$iv = file2;
        boolean $i$f$fromJson3 = false;
        Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
        Throwable throwable = null;
        try {
            void $this$withNulls$iv$iv$iv$iv$iv;
            BufferedSource reader$iv$iv$iv = (BufferedSource)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
            JsonAdapter jsonAdapter2 = jsonAdapter;
            boolean withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
            boolean $i$f$withNulls = false;
            Object object4 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object4);
            object = object4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ProjectAdvice projectAdvice = (ProjectAdvice)object;
        Object object5 = this.getDependencyMap().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        Map map = (Map)object5;
        Set<Advice> set2 = this.filtered(projectAdvice.getDependencyAdvice(), isUpgrade);
        Function1<String, String> function1 = DependenciesHandler.Companion.toLambda(map);
        Object object6 = this.getUseTypesafeProjectAccessors().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        AdvicePrinter advicePrinter = new AdvicePrinter(dslKind, function1, (Boolean)object6, false, 8, null);
        Object object7 = this.getUseTypesafeProjectAccessors().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
        BuildScriptDependenciesRewriter rewriter = BuildScriptDependenciesRewriter.Companion.of(buildScript, set2, advicePrinter, this.createReversedDependencyMap(map, (Boolean)object7));
        try {
            String newText = rewriter.rewritten();
            FilesKt.writeText$default((File)buildScript, (String)newText, null, (int)2, null);
        }
        catch (BuildScriptParseException e) {
            this.getLogger().warn("Can't fix dependencies for '" + projectAdvice.getProjectPath() + "': " + e.getLocalizedMessage());
        }
    }

    private final Function1<String, String> createReversedDependencyMap(Map<String, String> map, boolean useTypesafeProjectAccessors) {
        Map<String, String> reversedMap = CollectionsKt.reversed(map);
        return arg_0 -> RewriteTask.createReversedDependencyMap$lambda$1(reversedMap, useTypesafeProjectAccessors, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Advice> filtered(Set<Advice> $this$filtered, boolean isUpgrade) {
        Set set2;
        if (!isUpgrade) {
            set2 = $this$filtered;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filterToSet$iv = $this$filtered;
            boolean $i$f$filterToSet = false;
            Iterable iterable = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Advice it = (Advice)element$iv$iv;
                boolean bl = false;
                if (!it.isUpgrade()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set2 = (Set)destination$iv$iv;
        }
        return set2;
    }

    private static final CharSequence createReversedDependencyMap$lambda$1$lambda$0(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        Object e = matchResult.getGroupValues().get(1);
        String string = ((String)matchResult.getGroupValues().get(2)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return e + "-" + string;
    }

    private static final String createReversedDependencyMap$lambda$1(Map $reversedMap, boolean $useTypesafeProjectAccessors, String identifier2) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        Object object = (String)$reversedMap.get(identifier2);
        if (object == null) {
            if ($useTypesafeProjectAccessors && StringsKt.startsWith$default((String)identifier2, (String)"projects.", (boolean)false, (int)2, null)) {
                CharSequence charSequence = StringsKt.removePrefix((String)identifier2, (CharSequence)"projects.");
                Regex regex = new Regex("([a-z])([A-Z])");
                Function1 function1 = RewriteTask::createReversedDependencyMap$lambda$1$lambda$0;
                String projectPath = StringsKt.replace$default((String)regex.replace(charSequence, function1), (String)".", (String)":", (boolean)false, (int)4, null);
                object = ":" + projectPath;
            } else {
                object = identifier2;
            }
        }
        return object;
    }
}

