/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AsmKt;
import com.autonomousapps.internal.ClassRef;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.Type;
import com.autonomousapps.internal.utils.RegexKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0002J\u001c\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J&\u0010\u001f\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010 \u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010!\u001a\u00020\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J\u0012\u0010\"\u001a\u00020\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010#\u001a\u00020\u0014H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/autonomousapps/internal/AnnotationAnalyzer;", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "annotationClass", "", "visible", "", "logger", "Lorg/gradle/api/logging/Logger;", "classes", "", "Lcom/autonomousapps/internal/ClassRef;", "level", "", "arrayName", "<init>", "(Ljava/lang/String;ZLorg/gradle/api/logging/Logger;Ljava/util/Set;ILjava/lang/String;)V", "arraySize", "isTypeAlias", "arrayElements", "addClass", "", "className", "enclosingAnnotation", "log", "msgProvider", "Lkotlin/Function0;", "indent", "visit", "name", "value", "", "visitEnum", "descriptor", "visitAnnotation", "visitArray", "visitEnd", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nasm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/AnnotationAnalyzer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,733:1\n1321#2,2:734\n*S KotlinDebug\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/AnnotationAnalyzer\n*L\n544#1:734,2\n*E\n"})
final class AnnotationAnalyzer
extends AnnotationVisitor {
    @NotNull
    private final String annotationClass;
    private final boolean visible;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<ClassRef> classes;
    private final int level;
    @Nullable
    private final String arrayName;
    private int arraySize;
    private boolean isTypeAlias;
    @NotNull
    private final Set<ClassRef> arrayElements;

    public AnnotationAnalyzer(@NotNull String annotationClass, boolean visible, @NotNull Logger logger, @NotNull Set<ClassRef> classes, int level, @Nullable String arrayName) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        super(589824);
        this.annotationClass = annotationClass;
        this.visible = visible;
        this.logger = logger;
        this.classes = classes;
        this.level = level;
        this.arrayName = arrayName;
        this.arrayElements = new LinkedHashSet();
    }

    public /* synthetic */ AnnotationAnalyzer(String string, boolean bl, Logger logger, Set set, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            string2 = null;
        }
        this(string, bl, logger, set, n, string2);
    }

    private final void addClass(String className, String enclosingAnnotation) {
        AsmKt.access$addClass(this.classes, className, ClassRef.Kind.ANNOTATION, enclosingAnnotation);
        if (Intrinsics.areEqual((Object)this.arrayName, (Object)"d2")) {
            AsmKt.addClass$default(this.arrayElements, className, ClassRef.Kind.NOT_ANNOTATION, null, 4, null);
        }
    }

    static /* synthetic */ void addClass$default(AnnotationAnalyzer annotationAnalyzer, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        annotationAnalyzer.addClass(string, string2);
    }

    private final void log(Function0<String> msgProvider) {
        if (!AsmKt.access$getLogDebug$p()) {
            this.logger.quiet((String)msgProvider.invoke());
        }
    }

    private final String indent() {
        return StringsKt.repeat((CharSequence)"  ", (int)this.level);
    }

    public void visit(@Nullable String name, @Nullable Object value) {
        String valueString = AsmKt.access$stringValueOfArrayElement(value);
        this.log((Function0<String>)((Function0)() -> AnnotationAnalyzer.visit$lambda$0(this, name, value, valueString)));
        if (this.arrayName != null) {
            int n = this.arraySize;
            this.arraySize = n + 1;
            if (Intrinsics.areEqual((Object)valueString, (Object)"alias")) {
                this.isTypeAlias = true;
            }
        }
        if (value instanceof String) {
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)RegexKt.getMETHOD_DESCRIPTOR_REGEX(), (CharSequence)((CharSequence)value), (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult result = (MatchResult)element$iv;
                boolean bl = false;
                if (this.visible) {
                    this.addClass(result.getValue(), AsmKt.access$getFqcnFromSpec(this.annotationClass));
                    continue;
                }
                AnnotationAnalyzer.addClass$default(this, result.getValue(), null, 2, null);
            }
        } else if (value instanceof Type) {
            if (this.visible) {
                this.addClass(((Type)value).getDescriptor(), AsmKt.access$getFqcnFromSpec(this.annotationClass));
            } else {
                AnnotationAnalyzer.addClass$default(this, ((Type)value).getDescriptor(), null, 2, null);
            }
        }
    }

    public void visitEnum(@Nullable String name, @Nullable String descriptor, @Nullable String value) {
        this.log((Function0<String>)((Function0)() -> AnnotationAnalyzer.visitEnum$lambda$2(this, name, descriptor, value)));
        AnnotationAnalyzer.addClass$default(this, descriptor, null, 2, null);
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@Nullable String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> AnnotationAnalyzer.visitAnnotation$lambda$3(this, name, descriptor)));
        AnnotationAnalyzer.addClass$default(this, descriptor, null, 2, null);
        return new AnnotationAnalyzer(descriptor, this.visible, this.logger, this.classes, this.level + 1, null, 32, null);
    }

    @NotNull
    public AnnotationVisitor visitArray(@Nullable String name) {
        this.log((Function0<String>)((Function0)() -> AnnotationAnalyzer.visitArray$lambda$4(this, name)));
        return new AnnotationAnalyzer(this.annotationClass, this.visible, this.logger, this.classes, this.level + 1, name);
    }

    public void visitEnd() {
        if (this.isTypeAlias()) {
            this.classes.addAll((Collection<ClassRef>)this.arrayElements);
        }
    }

    private final boolean isTypeAlias() {
        return this.arraySize == 3 && this.isTypeAlias;
    }

    private static final String visit$lambda$0(AnnotationAnalyzer this$0, String $name, Object $value, String $valueString) {
        Class<?> clazz;
        return this$0.indent() + "- AnnotationAnalyzer#visit: name=" + $name + ", value=(" + ((clazz = $value) != null && (clazz = clazz.getClass()) != null ? clazz.getSimpleName() : null) + ", " + $valueString + ")";
    }

    private static final String visitEnum$lambda$2(AnnotationAnalyzer this$0, String $name, String $descriptor, String $value) {
        return this$0.indent() + "- AnnotationAnalyzer#visitEnum: name=" + $name + ", descriptor=" + $descriptor + ", value=" + $value;
    }

    private static final String visitAnnotation$lambda$3(AnnotationAnalyzer this$0, String $name, String $descriptor) {
        return this$0.indent() + "- AnnotationAnalyzer#visitAnnotation: name=" + $name + ", descriptor=" + $descriptor;
    }

    private static final String visitArray$lambda$4(AnnotationAnalyzer this$0, String $name) {
        return this$0.indent() + "- AnnotationAnalyzer#visitArray: name=" + $name;
    }
}

