/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.internal.CodeSource;
import com.autonomousapps.model.internal.intermediates.consumer.LdcConstant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0007\"\u0004\b\u0013\u0010\u0005R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/autonomousapps/tasks/CodeSourceBuilder;", "", "className", "", "<init>", "(Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "relativePath", "getRelativePath", "setRelativePath", "kind", "Lcom/autonomousapps/model/internal/CodeSource$Kind;", "getKind", "()Lcom/autonomousapps/model/internal/CodeSource$Kind;", "setKind", "(Lcom/autonomousapps/model/internal/CodeSource$Kind;)V", "superClass", "getSuperClass", "setSuperClass", "interfaces", "Ljava/util/TreeSet;", "getInterfaces", "()Ljava/util/TreeSet;", "nonAnnotationClasses", "getNonAnnotationClasses", "nonAnnotationClassesWithinVisibleAnnotation", "", "getNonAnnotationClassesWithinVisibleAnnotation", "()Ljava/util/Map;", "annotationClasses", "getAnnotationClasses", "exposedClasses", "getExposedClasses", "imports", "getImports", "inferredConstants", "Lcom/autonomousapps/model/internal/intermediates/consumer/LdcConstant;", "getInferredConstants", "concat", "other", "build", "Lcom/autonomousapps/model/internal/CodeSource;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSynthesizeProjectViewTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynthesizeProjectViewTask.kt\ncom/autonomousapps/tasks/CodeSourceBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
final class CodeSourceBuilder {
    @NotNull
    private final String className;
    @Nullable
    private String relativePath;
    @NotNull
    private CodeSource.Kind kind;
    @Nullable
    private String superClass;
    @NotNull
    private final TreeSet<String> interfaces;
    @NotNull
    private final TreeSet<String> nonAnnotationClasses;
    @NotNull
    private final Map<String, String> nonAnnotationClassesWithinVisibleAnnotation;
    @NotNull
    private final TreeSet<String> annotationClasses;
    @NotNull
    private final TreeSet<String> exposedClasses;
    @NotNull
    private final TreeSet<String> imports;
    @NotNull
    private final TreeSet<LdcConstant> inferredConstants;

    public CodeSourceBuilder(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.className = className;
        this.kind = CodeSource.Kind.UNKNOWN;
        this.interfaces = SetsKt.sortedSetOf((Object[])new String[0]);
        this.nonAnnotationClasses = SetsKt.sortedSetOf((Object[])new String[0]);
        this.nonAnnotationClassesWithinVisibleAnnotation = new LinkedHashMap();
        this.annotationClasses = SetsKt.sortedSetOf((Object[])new String[0]);
        this.exposedClasses = SetsKt.sortedSetOf((Object[])new String[0]);
        this.imports = SetsKt.sortedSetOf((Object[])new String[0]);
        this.inferredConstants = SetsKt.sortedSetOf((Object[])new LdcConstant[0]);
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @Nullable
    public final String getRelativePath() {
        return this.relativePath;
    }

    public final void setRelativePath(@Nullable String string) {
        this.relativePath = string;
    }

    @NotNull
    public final CodeSource.Kind getKind() {
        return this.kind;
    }

    public final void setKind(@NotNull CodeSource.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"<set-?>");
        this.kind = kind;
    }

    @Nullable
    public final String getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(@Nullable String string) {
        this.superClass = string;
    }

    @NotNull
    public final TreeSet<String> getInterfaces() {
        return this.interfaces;
    }

    @NotNull
    public final TreeSet<String> getNonAnnotationClasses() {
        return this.nonAnnotationClasses;
    }

    @NotNull
    public final Map<String, String> getNonAnnotationClassesWithinVisibleAnnotation() {
        return this.nonAnnotationClassesWithinVisibleAnnotation;
    }

    @NotNull
    public final TreeSet<String> getAnnotationClasses() {
        return this.annotationClasses;
    }

    @NotNull
    public final TreeSet<String> getExposedClasses() {
        return this.exposedClasses;
    }

    @NotNull
    public final TreeSet<String> getImports() {
        return this.imports;
    }

    @NotNull
    public final TreeSet<LdcConstant> getInferredConstants() {
        return this.inferredConstants;
    }

    @NotNull
    public final CodeSourceBuilder concat(@NotNull CodeSourceBuilder other) {
        String it;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = other.relativePath;
        if (string != null) {
            it = string;
            boolean bl = false;
            this.relativePath = it;
        }
        String string2 = other.superClass;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.superClass = it;
        }
        this.interfaces.addAll((Collection<String>)other.interfaces);
        this.nonAnnotationClasses.addAll((Collection<String>)other.nonAnnotationClasses);
        this.nonAnnotationClassesWithinVisibleAnnotation.putAll(other.nonAnnotationClassesWithinVisibleAnnotation);
        this.annotationClasses.addAll((Collection<String>)other.annotationClasses);
        this.exposedClasses.addAll((Collection<String>)other.exposedClasses);
        this.imports.addAll((Collection<String>)other.imports);
        this.kind = other.kind;
        return this;
    }

    @NotNull
    public final CodeSource build() {
        String string = this.relativePath;
        if (string == null) {
            boolean bl = false;
            String string2 = "'relativePath' was null for " + this.className;
            throw new IllegalStateException(string2.toString());
        }
        String relativePath = string;
        String string3 = this.superClass;
        Set<String> set = CollectionsKt.efficient((Set)this.interfaces);
        CodeSource.Kind kind = this.kind;
        String string4 = this.className;
        Set<String> set2 = CollectionsKt.efficient((Set)this.nonAnnotationClasses);
        Map<String, String> map = CollectionsKt.efficient(this.nonAnnotationClassesWithinVisibleAnnotation);
        Set<String> set3 = CollectionsKt.efficient((Set)this.annotationClasses);
        Set<String> set4 = CollectionsKt.efficient((Set)this.exposedClasses);
        Set<String> set5 = CollectionsKt.efficient((Set)this.imports);
        Set<LdcConstant> set6 = CollectionsKt.efficient((Set)this.inferredConstants);
        return new CodeSource(relativePath, kind, string4, string3, set, set2, map, set3, set4, set5, set6);
    }
}

