/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.reason.DependencyAdviceExplainer;
import com.autonomousapps.internal.reason.ModuleAdviceExplainer;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.CoordinatesString;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.FlatCoordinates;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.IncludedBuildCoordinates;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.model.ProjectCoordinates;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.autonomousapps.model.internal.intermediates.BundleTrace;
import com.autonomousapps.model.internal.intermediates.Usage;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UntrackedTask(because="Always prints output")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u00002\u00020\u0001:\u000656789:B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00100\u001a\u000201H\u0007J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR*\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R*\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0014\u0010'\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0014\u0010)\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006;"}, d2={"Lcom/autonomousapps/tasks/ReasonTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "<init>", "(Lorg/gradle/workers/WorkerExecutor;)V", "rootProjectName", "Lorg/gradle/api/provider/Property;", "", "getRootProjectName", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "buildPath", "getBuildPath", "value", "id", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "capability", "getCapability", "setCapability", "module", "getModule", "setModule", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getDependencyUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "annotationProcessorUsageReport", "getAnnotationProcessorUsageReport", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "finalAdviceReport", "getFinalAdviceReport", "bundleTracesReport", "getBundleTracesReport", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "action", "", "options", "Lcom/autonomousapps/tasks/ReasonTask$Options;", "help", "Options", "ExplainDependencyAdviceParams", "ExplainDependencyAdviceAction", "ExplainModuleAdviceParams", "ExplainModuleAdviceAction", "Explainer", "dependency-analysis-gradle-plugin"})
public abstract class ReasonTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @Nullable
    private String id;
    @Nullable
    private String capability;
    @Nullable
    private String module;

    @Inject
    public ReasonTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis");
        this.setDescription("Explain how a dependency is used");
    }

    @Input
    @NotNull
    public abstract Property<String> getRootProjectName();

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @Optional
    @Input
    @Nullable
    public final String getId() {
        return this.id;
    }

    @Option(option="id", description="The dependency you'd like to reason about (com.foo:bar:1.0 or :other:module)")
    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @Optional
    @Input
    @Nullable
    public final String getCapability() {
        return this.capability;
    }

    @Option(option="capability", description="The capability you're interested in. Defaults to main capability. A typical option is 'test-fixtures'")
    public final void setCapability(@Nullable String string) {
        this.capability = string;
    }

    @Optional
    @Input
    @Nullable
    public final String getModule() {
        return this.module;
    }

    @Option(option="module", description="The module-structure-related advice you'd like more insight into ('android')")
    public final void setModule(@Nullable String string) {
        this.module = string;
    }

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getDependencyUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAnnotationProcessorUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getUnfilteredAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getFinalAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBundleTracesReport();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getDependencyGraphViews();

    @TaskAction
    public final void action() {
        block1: {
            Options options = this.options();
            String string = options.getId();
            if (string != null) {
                String dependency = string;
                boolean bl = false;
                this.workerExecutor.noIsolation().submit(ExplainDependencyAdviceAction.class, arg_0 -> ReasonTask.action$lambda$2$lambda$1(arg_0 -> ReasonTask.action$lambda$2$lambda$0(dependency, options, this, arg_0), arg_0));
            }
            String string2 = options.getModule();
            if (string2 == null) break block1;
            String moduleStructure = string2;
            boolean bl = false;
            this.workerExecutor.noIsolation().submit(ExplainModuleAdviceAction.class, arg_0 -> ReasonTask.action$lambda$5$lambda$4(arg_0 -> ReasonTask.action$lambda$5$lambda$3(moduleStructure, this, arg_0), arg_0));
        }
    }

    private final Options options() {
        String id = this.id;
        String module = this.module;
        String capability = this.capability;
        if (id == null && module == null) {
            throw new InvalidUserDataException(this.help());
        }
        if (capability != null && id == null) {
            throw new InvalidUserDataException(this.help());
        }
        return new Options(id, capability, module);
    }

    private final String help() {
        String path = (String)this.getProjectPath().get();
        boolean bl = false;
        return StringsKt.trimIndent((String)("\n      You must call 'reason' with either the `--id` or `--module` option, or both.\n      You may also specify a `--capability`, but this only influences the results of an `--id` query.\n      \n      Usage for --id:\n        ./gradlew " + path + ":reason --id com.foo:bar:1.0\n        ./gradlew " + path + ":reason --id com.foo:bar\n        ./gradlew " + path + ":reason --id :other:module\n        ./gradlew " + path + ":reason --id <dependency identifier> --capability test-fixtures\n        \n      For external dependencies, the version is optional.\n      Capability is optional. If unspecified, defaults to main capability.\n      \n      Usage for --module:\n        ./gradlew " + path + ":reason --module android\n    "));
    }

    private static final Unit action$lambda$2$lambda$0(String $dependency, Options $options, ReasonTask this$0, ExplainDependencyAdviceParams it) {
        it.getId().set((Object)$dependency);
        Property<String> property = it.getCapability();
        String string = $options.getCapability();
        if (string == null) {
            string = "";
        }
        property.set((Object)string);
        it.getRootProjectName().set((Provider)this$0.getRootProjectName());
        it.getProjectPath().set((Provider)this$0.getProjectPath());
        it.getBuildPath().set((Provider)this$0.getBuildPath());
        it.getDependencyMap().set((Provider)this$0.getDependencyMap());
        it.getDependencyUsageReport().set((Provider)this$0.getDependencyUsageReport());
        it.getAnnotationProcessorUsageReport().set((Provider)this$0.getAnnotationProcessorUsageReport());
        it.getUnfilteredAdviceReport().set((Provider)this$0.getUnfilteredAdviceReport());
        it.getFinalAdviceReport().set((Provider)this$0.getFinalAdviceReport());
        it.getBundleTracesReport().set((Provider)this$0.getBundleTracesReport());
        it.getDependencyGraphViews().set((Provider)this$0.getDependencyGraphViews());
        return Unit.INSTANCE;
    }

    private static final void action$lambda$2$lambda$1(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit action$lambda$5$lambda$3(String $moduleStructure, ReasonTask this$0, ExplainModuleAdviceParams it) {
        it.getModule().set((Object)$moduleStructure);
        it.getProjectPath().set((Provider)this$0.getProjectPath());
        it.getUnfilteredAdviceReport().set((Provider)this$0.getUnfilteredAdviceReport());
        it.getFinalAdviceReport().set((Provider)this$0.getFinalAdviceReport());
        return Unit.INSTANCE;
    }

    private static final void action$lambda$5$lambda$4(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010'\u001a\u00020\u0010H\u0002J\u0018\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0019H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0015H\u0002J\b\u0010-\u001a\u00020#H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "capability", "", "kotlin.jvm.PlatformType", "rootProjectName", "projectPath", "dependencyGraph", "", "Lcom/autonomousapps/model/internal/DependencyGraphView;", "unfilteredProjectAdvice", "Lcom/autonomousapps/model/ProjectAdvice;", "finalProjectAdvice", "dependencyMap", "Lkotlin/Function1;", "dependencyUsages", "", "Lcom/autonomousapps/model/internal/intermediates/Usage;", "annotationProcessorUsages", "targetCoord", "Lcom/autonomousapps/model/Coordinates;", "requestedCoord", "finalAdvice", "Lcom/autonomousapps/model/Advice;", "unfilteredAdvice", "usages", "execute", "", "getRequestedCoordinates", "normalize", "", "getUsageFor", "coordinates", "findAdviceIn", "projectAdvice", "matchesByIdentifier", "advice", "request", "bundleTraces", "Lcom/autonomousapps/model/internal/intermediates/BundleTrace;", "wasFiltered", "Companion", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 5 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n*L\n1#1,462:1\n21#2:463\n1563#3:464\n1634#3,2:465\n1636#3:481\n1208#3,2:482\n1236#3,4:484\n865#3,2:583\n865#3,2:611\n1761#3,3:613\n147#4,8:467\n142#4,13:488\n142#4,13:507\n101#4,17:526\n101#4,17:552\n63#4,17:585\n41#5,2:475\n34#5,4:477\n41#5,2:501\n34#5,4:503\n41#5,2:520\n34#5,4:522\n97#5:543\n60#5,4:544\n34#5,4:548\n97#5:569\n60#5,4:570\n34#5,4:574\n50#5,3:603\n34#5,4:606\n1104#6,3:578\n1#7:581\n1#7:602\n76#8:582\n76#8:610\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n*L\n214#1:463\n220#1:464\n220#1:465,2\n220#1:481\n221#1:482,2\n221#1:484,4\n360#1:583,2\n376#1:611,2\n382#1:613,3\n220#1:467,8\n222#1:488,13\n223#1:507,13\n226#1:526,17\n227#1:552,17\n376#1:585,17\n220#1:475,2\n220#1:477,4\n222#1:501,2\n222#1:503,4\n223#1:520,2\n223#1:522,4\n226#1:543\n226#1:544,4\n226#1:548,4\n227#1:569\n227#1:570,4\n227#1:574,4\n376#1:603,3\n376#1:606,4\n305#1:578,3\n376#1:602\n360#1:582\n376#1:610\n*E\n"})
    public static abstract class ExplainDependencyAdviceAction
    implements WorkAction<ExplainDependencyAdviceParams> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Logger logger;
        private final String capability;
        private final String rootProjectName;
        private final String projectPath;
        @NotNull
        private final Map<String, DependencyGraphView> dependencyGraph;
        @NotNull
        private final ProjectAdvice unfilteredProjectAdvice;
        @NotNull
        private final ProjectAdvice finalProjectAdvice;
        @NotNull
        private final Function1<String, String> dependencyMap;
        @NotNull
        private final Map<String, Set<Usage>> dependencyUsages;
        @NotNull
        private final Map<String, Set<Usage>> annotationProcessorUsages;
        @NotNull
        private final Coordinates targetCoord;
        @NotNull
        private final Coordinates requestedCoord;
        @NotNull
        private final Set<Advice> finalAdvice;
        @NotNull
        private final Set<Advice> unfilteredAdvice;
        @NotNull
        private final Set<Usage> usages;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainDependencyAdviceAction() {
            Type[] $this$withNulls$iv$iv$iv$iv$iv$iv;
            Type[] $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$withNulls;
            boolean withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl5;
            Object reader$iv$iv$iv;
            RegularFileProperty $this$fromJson$iv;
            Object element$iv$iv2;
            void $this$associateByTo$iv$iv;
            RegularFileProperty $this$associateBy$iv;
            Object object;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
            this.capability = (String)((ExplainDependencyAdviceParams)this.getParameters()).getCapability().get();
            this.rootProjectName = (String)((ExplainDependencyAdviceParams)this.getParameters()).getRootProjectName().get();
            this.projectPath = (String)((ExplainDependencyAdviceParams)this.getParameters()).getProjectPath().get();
            Object object2 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyGraphViews().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Iterable $i$f$getLogger22 = (Iterable)object2;
            ExplainDependencyAdviceAction explainDependencyAdviceAction = this;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                Object object3;
                File $this$fromJson$iv$iv;
                void it;
                RegularFile regularFile = (RegularFile)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                void $this$fromJson$iv2 = it;
                boolean $i$f$fromJson = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv2.getAsFile(), (String)"getAsFile(...)");
                boolean $i$f$fromJson2 = false;
                Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv);
                Throwable throwable = null;
                try {
                    void $this$withNulls$iv$iv$iv$iv;
                    BufferedSource reader$iv$iv = (BufferedSource)closeable;
                    boolean bl3 = false;
                    boolean withNulls$iv$iv$iv = false;
                    boolean $i$f$getJsonAdapter2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(DependencyGraphView.class), (String)"adapter(...)");
                    boolean withNulls$iv$iv$iv$iv2 = withNulls$iv$iv$iv;
                    boolean $i$f$withNulls2 = false;
                    Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object.add((DependencyGraphView)object3);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                void it;
                DependencyGraphView bl2 = (DependencyGraphView)element$iv$iv2;
                object = destination$iv$iv2;
                boolean bl4 = false;
                object.put(it.getName() + "," + it.getConfigurationName(), element$iv$iv2);
            }
            explainDependencyAdviceAction.dependencyGraph = destination$iv$iv2;
            $this$associateBy$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            explainDependencyAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object4;
            boolean $i$f$fromJson3 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson4 = false;
            item$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            element$iv$iv2 = null;
            try {
                reader$iv$iv$iv = (BufferedSource)item$iv$iv2;
                bl5 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter $i$f$fromJson2 = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object5);
                reader$iv$iv$iv = object5;
            }
            catch (Throwable bl5) {
                element$iv$iv2 = bl5;
                throw bl5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)item$iv$iv2, element$iv$iv2);
            }
            explainDependencyAdviceAction.unfilteredProjectAdvice = (ProjectAdvice)reader$iv$iv$iv;
            $this$fromJson$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainDependencyAdviceAction = this;
            $i$f$fromJson = false;
            Object object6 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            $this$fromJson$iv$iv = (RegularFile)object6;
            $i$f$fromJson3 = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson4 = false;
            item$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            element$iv$iv2 = null;
            try {
                reader$iv$iv$iv = (BufferedSource)item$iv$iv2;
                bl5 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                Type[] typeArray = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"adapter(...)");
                $this$withNulls$iv$iv$iv$iv$iv = typeArray;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object7 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object7);
                reader$iv$iv$iv = object7;
            }
            catch (Throwable throwable) {
                element$iv$iv2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)item$iv$iv2, element$iv$iv2);
            }
            explainDependencyAdviceAction.finalProjectAdvice = (ProjectAdvice)reader$iv$iv$iv;
            Object object8 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
            this.dependencyMap = DependenciesHandler.Companion.toLambda((Map)object8);
            RegularFileProperty $this$fromJsonMapSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyUsageReport();
            boolean $i$f$fromJsonMapSet = false;
            Object object9 = $this$fromJsonMapSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
            RegularFile $this$fromJsonMapSet$iv$iv = (RegularFile)object9;
            boolean $i$f$fromJsonMapSet2 = false;
            File file3 = $this$fromJsonMapSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
            File $this$fromJsonMapSet$iv$iv$iv = file3;
            boolean $i$f$fromJsonMapSet3 = false;
            BufferedSource $this$fromJsonMapSet$iv$iv$iv$iv = UtilsKt.access$bufferRead($this$fromJsonMapSet$iv$iv$iv);
            boolean $i$f$fromJsonMapSet4 = false;
            boolean withNulls$iv$iv$iv$iv$iv2 = false;
            boolean $i$f$getJsonMapSetAdapter = false;
            Type[] withNulls$iv$iv$iv$iv3 = new Type[]{Usage.class};
            ParameterizedType setType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])withNulls$iv$iv$iv$iv3);
            $this$withNulls$iv$iv$iv$iv$iv = new Type[]{String.class, setType$iv$iv$iv$iv$iv};
            Object mapType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$this$withNulls$iv$iv$iv$iv$iv);
            Type[] typeArray = MoshiUtils.getMOSHI().adapter((Type)mapType$iv$iv$iv$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"adapter(...)");
            $this$withNulls$iv$iv$iv$iv$iv = typeArray;
            boolean withNulls$iv$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv$iv2;
            $i$f$withNulls = false;
            Object object10 = $this$withNulls$iv$iv$iv$iv$iv$iv.fromJson($this$fromJsonMapSet$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object10);
            this.dependencyUsages = (Map)object10;
            $this$fromJsonMapSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getAnnotationProcessorUsageReport();
            $i$f$fromJsonMapSet = false;
            Object object11 = $this$fromJsonMapSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"get(...)");
            $this$fromJsonMapSet$iv$iv = (RegularFile)object11;
            $i$f$fromJsonMapSet2 = false;
            File file4 = $this$fromJsonMapSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getAsFile(...)");
            $this$fromJsonMapSet$iv$iv$iv = file4;
            $i$f$fromJsonMapSet3 = false;
            $this$fromJsonMapSet$iv$iv$iv$iv = UtilsKt.access$bufferRead($this$fromJsonMapSet$iv$iv$iv);
            $i$f$fromJsonMapSet4 = false;
            withNulls$iv$iv$iv$iv$iv2 = false;
            $i$f$getJsonMapSetAdapter = false;
            mapType$iv$iv$iv$iv$iv = new Type[]{Usage.class};
            setType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])mapType$iv$iv$iv$iv$iv);
            $this$withNulls$iv$iv$iv$iv$iv$iv = new Type[]{String.class, setType$iv$iv$iv$iv$iv};
            mapType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$this$withNulls$iv$iv$iv$iv$iv$iv);
            Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)mapType$iv$iv$iv$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
            $this$withNulls$iv$iv$iv$iv$iv$iv = typeArray2;
            withNulls$iv$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv$iv2;
            $i$f$withNulls = false;
            Object object12 = $this$withNulls$iv$iv$iv$iv$iv$iv.fromJson($this$fromJsonMapSet$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object12);
            this.annotationProcessorUsages = (Map)object12;
            this.targetCoord = this.getRequestedCoordinates(true);
            this.requestedCoord = this.getRequestedCoordinates(false);
            this.finalAdvice = this.findAdviceIn(this.finalProjectAdvice);
            this.unfilteredAdvice = this.findAdviceIn(this.unfilteredProjectAdvice);
            this.usages = this.getUsageFor(this.targetCoord);
        }

        public void execute() {
            String string = this.projectPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectPath");
            ProjectCoordinates project = new ProjectCoordinates(string, new GradleVariantIdentification(SetsKt.setOf((Object)"ROOT"), MapsKt.emptyMap()), (String)((ExplainDependencyAdviceParams)this.getParameters()).getBuildPath().get());
            String string2 = this.capability;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capability");
            String reason = new DependencyAdviceExplainer(project, this.requestedCoord, this.targetCoord, string2, this.usages, this.finalAdvice, this.dependencyGraph, this.bundleTraces(), this.wasFiltered(), this.dependencyMap).computeReason();
            this.logger.quiet(reason);
        }

        private final Coordinates getRequestedCoordinates(boolean normalize) {
            Coordinates coordinates;
            String includedBuildId;
            String capabilitySuffix;
            String string;
            String requestedId = (String)((ExplainDependencyAdviceParams)this.getParameters()).getId().get();
            String requestedCapability = this.capability;
            Intrinsics.checkNotNull((Object)requestedId);
            boolean requestedViaProjectPath = StringsKt.startsWith$default((String)requestedId, (String)":", (boolean)false, (int)2, null);
            String string2 = Companion.findFilteredDependencyKey$dependency_analysis_gradle_plugin(this.dependencyUsages.entrySet(), requestedId);
            if (string2 == null && (string2 = Companion.findFilteredDependencyKey$dependency_analysis_gradle_plugin(this.annotationProcessorUsages.entrySet(), requestedId)) == null && (string2 = ExplainDependencyAdviceAction.getRequestedCoordinates$findInGraph(this, requestedId)) == null) {
                throw new InvalidUserDataException("There is no dependency with coordinates '" + requestedId + "' in this project.");
            }
            String gavKey = string2;
            if (requestedViaProjectPath && !normalize) {
                string = CoordinatesString.Companion.secondCoordinatesKeySegment(gavKey);
                if (string == null) {
                    string = gavKey;
                }
            } else {
                string = CoordinatesString.Companion.firstCoordinatesKeySegment(gavKey);
            }
            String gav = string;
            Intrinsics.checkNotNull((Object)requestedCapability);
            String string3 = capabilitySuffix = ((CharSequence)requestedCapability).length() == 0 ? "" : (Intrinsics.areEqual((Object)requestedCapability, (Object)"testFixtures") ? "-test-fixtures" : "-" + requestedCapability);
            Set<String> set = CoordinatesString.Companion.of(gavKey).getCapabilities();
            if (set == null || (set = (String)kotlin.collections.CollectionsKt.singleOrNull((Iterable)set)) == null) {
                set = "";
            }
            Set<String> baseCapability = set;
            String syntheticCapability = (String)((Object)baseCapability) + capabilitySuffix;
            CharSequence $this$count$iv = requestedId;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl = false;
                if (!(it == ':')) continue;
                ++count$iv;
            }
            String string4 = includedBuildId = count$iv == 1 ? this.rootProjectName + requestedId : this.rootProjectName + com.autonomousapps.internal.utils.strings.StringsKt.replaceExceptLast$default(requestedId, ":", ".", false, 4, null);
            if (Intrinsics.areEqual((Object)gav, (Object)includedBuildId)) {
                GradleVariantIdentification gradleVariantIdentification = new GradleVariantIdentification(SetsKt.setOf((Object)syntheticCapability), MapsKt.emptyMap());
                coordinates = new IncludedBuildCoordinates(includedBuildId, new ProjectCoordinates(requestedId, gradleVariantIdentification, ":"), gradleVariantIdentification);
            } else {
                Collection collection;
                Set capabilities = ((CharSequence)syntheticCapability).length() > 0 ? SetsKt.setOf((Object)syntheticCapability) : SetsKt.emptySet();
                Coordinates coord = Coordinates.Companion.of(gav);
                Coordinates.Companion companion = Coordinates.Companion;
                Coordinates coordinates2 = coord;
                Collection collection2 = capabilities;
                if (collection2.isEmpty()) {
                    Coordinates coordinates3 = coordinates2;
                    Coordinates.Companion companion2 = companion;
                    boolean bl = false;
                    Set set2 = SetsKt.setOf((Object)coord.getIdentifier());
                    companion = companion2;
                    coordinates2 = coordinates3;
                    collection = set2;
                } else {
                    collection = collection2;
                }
                Map map = MapsKt.emptyMap();
                Set set3 = (Set)collection;
                coordinates = companion.copy(coordinates2, new GradleVariantIdentification(set3, map));
            }
            return coordinates;
        }

        private final Set<Usage> getUsageFor(Coordinates coordinates) {
            Set<Usage> set;
            Set set2;
            Object v0;
            Set<Usage> set3;
            block4: {
                set3 = (Set<Usage>)this.dependencyUsages.entrySet();
                for (Object object : set3) {
                    Map.Entry entry = (Map.Entry)object;
                    boolean bl = false;
                    if (!CoordinatesString.Companion.of((String)entry.getKey()).matches(coordinates)) continue;
                    v0 = object;
                    break block4;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry != null && (set2 = (Set)entry.getValue()) != null && (set3 = CollectionsKt.softSortedSet(set2, Usage.Companion.getBY_VARIANT())) != null) {
                set = set3;
            } else {
                Set set4;
                Object v2;
                block5: {
                    Iterable iterable = this.annotationProcessorUsages.entrySet();
                    for (Object t : iterable) {
                        Map.Entry entry2 = (Map.Entry)t;
                        boolean bl = false;
                        if (!CoordinatesString.Companion.of((String)entry2.getKey()).matches(coordinates)) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                Map.Entry entry3 = v2;
                set = entry3 != null && (set4 = (Set)entry3.getValue()) != null ? CollectionsKt.softSortedSet(set4, Usage.Companion.getBY_VARIANT()) : SetsKt.emptySet();
            }
            return set;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Advice> findAdviceIn(ProjectAdvice projectAdvice) {
            void $this$filterTo$iv$iv;
            Iterable $this$filterToSet$iv = projectAdvice.getDependencyAdvice();
            boolean $i$f$filterToSet = false;
            Iterable iterable = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Advice advice = (Advice)element$iv$iv;
                boolean bl = false;
                String adviceGav = advice.getCoordinates().gav();
                boolean byGav = Intrinsics.areEqual((Object)adviceGav, (Object)this.targetCoord.gav()) || Intrinsics.areEqual((Object)adviceGav, (Object)this.requestedCoord.gav());
                if (!(byGav || this.matchesByIdentifier(advice, this.targetCoord) || this.matchesByIdentifier(advice, this.requestedCoord))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Set)destination$iv$iv;
        }

        private final boolean matchesByIdentifier(Advice advice, Coordinates request) {
            if (!(request instanceof FlatCoordinates)) {
                return false;
            }
            return Intrinsics.areEqual((Object)advice.getCoordinates().getIdentifier(), (Object)((FlatCoordinates)request).getIdentifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Set<BundleTrace> bundleTraces() {
            void $this$filterTo$iv$iv;
            Set set;
            void $this$fromJsonSet$iv$iv;
            RegularFileProperty $this$fromJsonSet_u24default$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getBundleTracesReport();
            boolean compressed$iv = false;
            boolean $i$f$fromJsonSet22 = false;
            Object object = $this$fromJsonSet_u24default$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            RegularFile regularFile = (RegularFile)object;
            boolean compressed$iv$iv = compressed$iv;
            boolean $i$f$fromJsonSet = false;
            File file = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            BufferedSource source$iv$iv = UtilsKt.access$bufferRead(file);
            Closeable closeable = (Closeable)source$iv$iv;
            Throwable throwable = null;
            try {
                void $this$withNulls$iv$iv$iv$iv;
                BufferedSource it$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{BundleTrace.class};
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
                typeArray = typeArray2;
                boolean withNulls$iv$iv$iv$iv = withNulls$iv$iv$iv;
                boolean $i$f$withNulls = false;
                Object object2 = $this$withNulls$iv$iv$iv$iv.fromJson(it$iv$iv);
                Intrinsics.checkNotNull((Object)object2);
                set = (Set)object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Iterable $this$filterToSet$iv = set;
            boolean $i$f$filterToSet = false;
            Iterable $i$f$fromJsonSet22 = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BundleTrace it = (BundleTrace)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTop().gav(), (Object)this.targetCoord.gav()) || Intrinsics.areEqual((Object)it.getBottom().gav(), (Object)this.targetCoord.gav()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Set)destination$iv$iv;
        }

        private final boolean wasFiltered() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.unfilteredAdvice;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Advice unfiltered = (Advice)element$iv;
                        boolean bl2 = false;
                        if (!(!this.finalAdvice.contains(unfiltered))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final Iterable getRequestedCoordinates$findInGraph$lambda$2(DependencyGraphView it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getNodes();
        }

        private static final String getRequestedCoordinates$findInGraph(ExplainDependencyAdviceAction this$0, String requestedId) {
            Object v0;
            block1: {
                Sequence sequence = SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this$0.dependencyGraph.values()), ExplainDependencyAdviceAction::getRequestedCoordinates$findInGraph$lambda$2);
                for (Object e : sequence) {
                    Coordinates coordinates = (Coordinates)e;
                    boolean bl = false;
                    String gav = coordinates.gav();
                    if (!(Intrinsics.areEqual((Object)gav, (Object)requestedId) || StringsKt.startsWith$default((String)gav, (String)(requestedId + ":"), (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)gav), (Object)requestedId) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)coordinates.getIdentifier()), (Object)requestedId))) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            Coordinates coordinates = v0;
            return coordinates != null ? coordinates.gav() : null;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion;", "", "<init>", "()V", "findFilteredDependencyKey", "", "dependencies", "", "", "requestedId", "findFilteredDependencyKey$dependency_analysis_gradle_plugin", "dependency-analysis-gradle-plugin"})
        @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,462:1\n1563#2:463\n1634#2,3:464\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n*L\n407#1:463\n407#1:464,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String findFilteredDependencyKey$dependency_analysis_gradle_plugin(@NotNull Set<? extends Map.Entry<String, ? extends Object>> dependencies, @NotNull String requestedId) {
                String string;
                Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
                LinkedHashSet<String> filteredKeys = new LinkedHashSet<String>();
                for (Map.Entry<String, ? extends Object> entry : dependencies) {
                    if (CoordinatesString.Companion.equalsKey(requestedId, entry)) {
                        return entry.getKey();
                    }
                    if (!CoordinatesString.Companion.matchesKey(requestedId, entry)) continue;
                    filteredKeys.add(CoordinatesString.Companion.of(entry.getKey()).fullGav());
                }
                if (filteredKeys.isEmpty()) {
                    string = null;
                } else if (filteredKeys.size() == 1) {
                    string = (String)filteredKeys.iterator().next();
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = filteredKeys;
                    String string2 = requestedId;
                    boolean bl = false;
                    void var6_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string3 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string4 = CoordinatesString.Companion.secondCoordinatesKeySegment((String)it);
                        if (string4 == null) {
                            string4 = it;
                        }
                        collection.add(string4);
                    }
                    String string5 = "Coordinates '" + string2 + "' matches more than 1 dependency " + (List)destination$iv$iv;
                    throw new InvalidUserDataException(string5);
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0012\u0010\u0019\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0012\u0010\u001b\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0012\u0010\u001d\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "id", "Lorg/gradle/api/provider/Property;", "", "getId", "()Lorg/gradle/api/provider/Property;", "capability", "getCapability", "rootProjectName", "getRootProjectName", "projectPath", "getProjectPath", "buildPath", "getBuildPath", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getDependencyUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "annotationProcessorUsageReport", "getAnnotationProcessorUsageReport", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "finalAdviceReport", "getFinalAdviceReport", "bundleTracesReport", "getBundleTracesReport", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "dependency-analysis-gradle-plugin"})
    public static interface ExplainDependencyAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getId();

        @NotNull
        public Property<String> getCapability();

        @NotNull
        public Property<String> getRootProjectName();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public Property<String> getBuildPath();

        @NotNull
        public MapProperty<String, String> getDependencyMap();

        @NotNull
        public RegularFileProperty getDependencyUsageReport();

        @NotNull
        public RegularFileProperty getAnnotationProcessorUsageReport();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();

        @NotNull
        public RegularFileProperty getBundleTracesReport();

        @NotNull
        public ListProperty<RegularFile> getDependencyGraphViews();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "projectPath", "", "kotlin.jvm.PlatformType", "module", "unfilteredAndroidScore", "Lcom/autonomousapps/model/AndroidScore;", "finalAndroidScore", "execute", "", "validateModuleOption", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,462:1\n21#2:463\n142#3,13:464\n142#3,13:494\n41#4,2:477\n34#4,4:479\n41#4,2:507\n34#4,4:509\n808#5,11:483\n808#5,11:513\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n*L\n423#1:463\n428#1:464,13\n433#1:494,13\n428#1:477,2\n428#1:479,4\n433#1:507,2\n433#1:509,4\n430#1:483,11\n435#1:513,11\n*E\n"})
    public static abstract class ExplainModuleAdviceAction
    implements WorkAction<ExplainModuleAdviceParams> {
        @NotNull
        private final Logger logger;
        private final String projectPath;
        private final String module;
        @Nullable
        private final AndroidScore unfilteredAndroidScore;
        @Nullable
        private final AndroidScore finalAndroidScore;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainModuleAdviceAction() {
            Object object;
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            RegularFileProperty $this$filterIsInstance$iv;
            JsonAdapter $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$withNulls;
            boolean withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl2;
            Object reader$iv$iv$iv;
            Iterable $this$fromJson$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
            this.projectPath = (String)((ExplainModuleAdviceParams)this.getParameters()).getProjectPath().get();
            this.module = (String)((ExplainModuleAdviceParams)this.getParameters()).getModule().get();
            RegularFileProperty $i$f$getLogger22 = ((ExplainModuleAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            ExplainModuleAdviceAction explainModuleAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object2 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable throwable = null;
            try {
                reader$iv$iv$iv = (BufferedSource)closeable;
                bl2 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter jsonAdapter2 = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                reader$iv$iv$iv = object3;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)reader$iv$iv$iv).getModuleAdvice();
            boolean $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.unfilteredAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = ((ExplainModuleAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainModuleAdviceAction = this;
            $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            $this$fromJson$iv$iv = (RegularFile)object4;
            $i$f$fromJson = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson = false;
            element$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            throwable = null;
            try {
                reader$iv$iv$iv = (BufferedSource)element$iv$iv2;
                bl2 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object5);
                object = object5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(element$iv$iv2, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)object).getModuleAdvice();
            $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.finalAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        }

        public void execute() {
            this.validateModuleOption();
            String string = this.projectPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectPath");
            String reason = new ModuleAdviceExplainer(new ProjectCoordinates(string, GradleVariantIdentification.Companion.getEMPTY(), null, 4, null), this.unfilteredAndroidScore, this.finalAndroidScore).computeReason();
            this.logger.quiet(reason);
        }

        private final void validateModuleOption() {
            if (!Intrinsics.areEqual((Object)this.module, (Object)"android")) {
                throw new InvalidUserDataException("'" + this.module + "' unexpected. The only valid option for '--module' at this time is 'android'.");
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "module", "Lorg/gradle/api/provider/Property;", "", "getModule", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "unfilteredAdviceReport", "Lorg/gradle/api/file/RegularFileProperty;", "getUnfilteredAdviceReport", "()Lorg/gradle/api/file/RegularFileProperty;", "finalAdviceReport", "getFinalAdviceReport", "dependency-analysis-gradle-plugin"})
    public static interface ExplainModuleAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getModule();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Explainer;", "", "computeReason", "", "dependency-analysis-gradle-plugin"})
    public static interface Explainer {
        @NotNull
        public String computeReason();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Options;", "", "id", "", "capability", "module", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getCapability", "getModule", "dependency-analysis-gradle-plugin"})
    private static final class Options {
        @Nullable
        private final String id;
        @Nullable
        private final String capability;
        @Nullable
        private final String module;

        public Options(@Nullable String id, @Nullable String capability, @Nullable String module) {
            this.id = id;
            this.capability = capability;
            this.module = module;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getCapability() {
            return this.capability;
        }

        @Nullable
        public final String getModule() {
            return this.module;
        }
    }
}

