/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.Manifest;
import com.autonomousapps.internal.utils.XmlKt;
import com.autonomousapps.internal.utils.document.DocumentKt;
import com.autonomousapps.model.internal.AndroidResSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012*\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0014\u0010\u0015\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/internal/ManifestParser;", "", "namespace", "", "<init>", "(Ljava/lang/String;)V", "parse", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "manifest", "Ljava/io/File;", "allComponents", "", "application", "Lorg/w3c/dom/Element;", "document", "Lorg/w3c/dom/Document;", "packageName", "componentNames", "", "component", "Lcom/autonomousapps/internal/Manifest$Component;", "withPackageName", "ParseResult", "ManifestParseException", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nManifestParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestParser.kt\ncom/autonomousapps/internal/ManifestParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 document.kt\ncom/autonomousapps/internal/utils/document/DocumentKt\n*L\n1#1,122:1\n1617#2,9:123\n1869#2:132\n1870#2:134\n1626#2:135\n1#3:133\n71#4,5:136\n*S KotlinDebug\n*F\n+ 1 ManifestParser.kt\ncom/autonomousapps/internal/ManifestParser\n*L\n54#1:123,9\n54#1:132\n54#1:134\n54#1:135\n54#1:133\n101#1:136,5\n*E\n"})
public final class ManifestParser {
    @NotNull
    private final String namespace;

    public ManifestParser(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ParseResult parse(@NotNull File manifest, boolean allComponents) throws ManifestParseException {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Set<String> set;
        Set<String> activities;
        Set<String> set2;
        Set<String> providers;
        Set<String> set3;
        Set<String> services;
        Set<String> set4;
        Object applicationName;
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Document document = XmlKt.buildDocument(manifest);
        String packageName = this.packageName(manifest, document);
        Element application = this.application(document);
        Object object = application;
        if (object == null || (object = object.getAttribute("android:name")) == null) {
            object = applicationName = "";
        }
        if ((set4 = application) == null || (set4 = this.componentNames((Element)((Object)set4), Manifest.Component.SERVICE, packageName)) == null) {
            set4 = services = SetsKt.emptySet();
        }
        if ((set3 = application) == null || (set3 = this.componentNames((Element)((Object)set3), Manifest.Component.PROVIDER, packageName)) == null) {
            set3 = providers = SetsKt.emptySet();
        }
        if ((set2 = application) == null || (set2 = this.componentNames((Element)((Object)set2), Manifest.Component.ACTIVITY, packageName)) == null) {
            set2 = activities = SetsKt.emptySet();
        }
        if ((set = application) == null || (set = this.componentNames((Element)((Object)set), Manifest.Component.RECEIVER, packageName)) == null) {
            set = SetsKt.emptySet();
        }
        Set<String> receivers = set;
        Map componentsMapping = new LinkedHashMap();
        if (!((Collection)services).isEmpty()) {
            componentsMapping.put(Manifest.Component.SERVICE.getMapKey(), services);
        }
        if (!((Collection)providers).isEmpty()) {
            componentsMapping.put(Manifest.Component.PROVIDER.getMapKey(), providers);
        }
        if (allComponents) {
            if (!((Collection)activities).isEmpty()) {
                componentsMapping.put(Manifest.Component.ACTIVITY.getMapKey(), activities);
            }
            if (!((Collection)receivers).isEmpty()) {
                componentsMapping.put(Manifest.Component.RECEIVER.getMapKey(), receivers);
            }
        }
        Iterable iterable = DocumentKt.attrs(document);
        AndroidResSource.AttrRef.Companion companion = AndroidResSource.AttrRef.Companion;
        boolean $i$f$mapNotNull = false;
        void var16_15 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AndroidResSource.AttrRef it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair p0 = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (companion.from((Pair<String, String>)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set attrRefs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new ParseResult(packageName, (String)applicationName, attrRefs, componentsMapping);
    }

    public static /* synthetic */ ParseResult parse$default(ManifestParser manifestParser, File file, boolean bl, int n, Object object) throws ManifestParseException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return manifestParser.parse(file, bl);
    }

    private final Element application(Document document) {
        Element element;
        NodeList elements = document.getElementsByTagName("application");
        if (elements.getLength() > 0) {
            Node node = elements.item(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element = (Element)node;
        } else {
            element = null;
        }
        return element;
    }

    private final String packageName(File manifest, Document document) {
        CharSequence charSequence;
        CharSequence charSequence2 = this.namespace;
        if (charSequence2.length() == 0) {
            Object $this$packageName_u24lambda_u242_u24lambda_u240;
            boolean bl = false;
            Object object = this;
            try {
                $this$packageName_u24lambda_u242_u24lambda_u240 = object;
                boolean bl2 = false;
                $this$packageName_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)document.getElementsByTagName("manifest").item(0).getAttributes().getNamedItem("package").getNodeValue());
            }
            catch (Throwable bl2) {
                $this$packageName_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$packageName_u24lambda_u242_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable t = throwable;
                boolean bl3 = false;
                throw t instanceof NullPointerException ? (Throwable)new ManifestParseException(manifest.getPath() + " has no 'package' attribute. You should use 'android.namespace' to set the package name and remove the 'package' attribute from the main manifest, since that attribute is set for removal with AGP 8.0.", t) : t;
            }
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
            charSequence = (String)object2;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> componentNames(Element $this$componentNames, Manifest.Component component, String packageName) {
        void $this$mapToSet$iv;
        NodeList nodeList = $this$componentNames.getElementsByTagName(component.getTagName());
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        NodeList nodeList2 = nodeList;
        boolean $i$f$mapToSet = false;
        HashSet<String> destination$iv = new HashSet<String>($this$mapToSet$iv.getLength());
        int n = $this$mapToSet$iv.getLength();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            void it;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapToSet$iv.item(i$iv), (String)"item(...)");
            HashSet<String> hashSet = destination$iv;
            boolean bl = false;
            String string = it.getAttributes().getNamedItem(component.getAttrName()).getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeValue(...)");
            hashSet.add(this.withPackageName(string, packageName));
        }
        return destination$iv;
    }

    private final String withPackageName(String $this$withPackageName, String packageName) {
        return StringsKt.startsWith$default((String)$this$withPackageName, (String)".", (boolean)false, (int)2, null) ? packageName + $this$withPackageName : $this$withPackageName;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/autonomousapps/internal/ManifestParser$ManifestParseException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "msg", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "dependency-analysis-gradle-plugin"})
    public static final class ManifestParseException
    extends RuntimeException {
        public ManifestParseException(@NotNull String msg, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(msg, cause);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "", "packageName", "", "applicationName", "attrRefs", "", "Lcom/autonomousapps/model/internal/AndroidResSource$AttrRef;", "components", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Map;)V", "getPackageName", "()Ljava/lang/String;", "getApplicationName", "getAttrRefs", "()Ljava/util/Set;", "getComponents", "()Ljava/util/Map;", "dependency-analysis-gradle-plugin"})
    public static final class ParseResult {
        @NotNull
        private final String packageName;
        @NotNull
        private final String applicationName;
        @NotNull
        private final Set<AndroidResSource.AttrRef> attrRefs;
        @NotNull
        private final Map<String, Set<String>> components;

        public ParseResult(@NotNull String packageName, @NotNull String applicationName, @NotNull Set<AndroidResSource.AttrRef> attrRefs, @NotNull Map<String, ? extends Set<String>> components) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
            Intrinsics.checkNotNullParameter(attrRefs, (String)"attrRefs");
            Intrinsics.checkNotNullParameter(components, (String)"components");
            this.packageName = packageName;
            this.applicationName = applicationName;
            this.attrRefs = attrRefs;
            this.components = components;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final String getApplicationName() {
            return this.applicationName;
        }

        @NotNull
        public final Set<AndroidResSource.AttrRef> getAttrRefs() {
            return this.attrRefs;
        }

        @NotNull
        public final Map<String, Set<String>> getComponents() {
            return this.components;
        }
    }
}

