/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AnnotationAnalyzer;
import com.autonomousapps.internal.AsmKt;
import com.autonomousapps.internal.ClassRef;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.Handle;
import com.autonomousapps.internal.asm.Label;
import com.autonomousapps.internal.asm.MethodVisitor;
import com.autonomousapps.internal.asm.TypePath;
import com.autonomousapps.internal.utils.RegexKt;
import com.autonomousapps.model.internal.intermediates.consumer.LdcConstant;
import com.autonomousapps.model.internal.intermediates.consumer.MemberAccess;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0016J(\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0016J0\u0010 \u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016JC\u0010#\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\b\u0010$\u001a\u0004\u0018\u00010%2\u0016\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010(0'\"\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010)JB\u0010*\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\b\u0010+\u001a\u0004\u0018\u00010\t2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u00020\u001aH\u0016J]\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001a2\b\u00103\u001a\u0004\u0018\u0001042\u0010\u0010,\u001a\f\u0012\u0006\b\u0001\u0012\u00020-\u0018\u00010'2\u0010\u0010.\u001a\f\u0012\u0006\b\u0001\u0012\u00020-\u0018\u00010'2\b\u0010/\u001a\u0004\u0018\u0001052\u0006\u0010\u001f\u001a\u00020\t2\u0006\u00106\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\t2\u0006\u00106\u001a\u00020\"H\u0016J*\u00109\u001a\u0002012\u0006\u00102\u001a\u00020\u001a2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u001f\u001a\u00020\t2\u0006\u00106\u001a\u00020\"H\u0016J \u0010:\u001a\u0002012\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u00106\u001a\u00020\"H\u0016J*\u0010<\u001a\u0002012\u0006\u00102\u001a\u00020\u001a2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u001f\u001a\u00020\t2\u0006\u00106\u001a\u00020\"H\u0016J0\u0010=\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-2\b\u0010>\u001a\u0004\u0018\u00010-2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0016J*\u0010?\u001a\u0002012\u0006\u00102\u001a\u00020\u001a2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u001f\u001a\u00020\t2\u0006\u00106\u001a\u00020\"H\u0016J\u0012\u0010@\u001a\u00020\u00112\b\u0010A\u001a\u0004\u0018\u00010(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/autonomousapps/internal/MethodAnalyzer;", "Lcom/autonomousapps/internal/asm/MethodVisitor;", "logger", "Lorg/gradle/api/logging/Logger;", "classes", "", "Lcom/autonomousapps/internal/ClassRef;", "binaryClasses", "", "", "Ljava/util/SortedSet;", "Lcom/autonomousapps/model/internal/intermediates/consumer/MemberAccess;", "constants", "Lcom/autonomousapps/model/internal/intermediates/consumer/LdcConstant;", "<init>", "(Lorg/gradle/api/logging/Logger;Ljava/util/Set;Ljava/util/Map;Ljava/util/Set;)V", "addClass", "", "className", "kind", "Lcom/autonomousapps/internal/ClassRef$Kind;", "log", "msgProvider", "Lkotlin/Function0;", "visitTypeInsn", "opcode", "", "type", "visitFieldInsn", "owner", "name", "descriptor", "visitMethodInsn", "isInterface", "", "visitInvokeDynamicInsn", "bootstrapMethodHandle", "Lcom/autonomousapps/internal/asm/Handle;", "bootstrapMethodArguments", "", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/autonomousapps/internal/asm/Handle;[Ljava/lang/Object;)V", "visitLocalVariable", "signature", "start", "Lcom/autonomousapps/internal/asm/Label;", "end", "index", "visitLocalVariableAnnotation", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "typeRef", "typePath", "Lcom/autonomousapps/internal/asm/TypePath;", "", "visible", "(ILcom/autonomousapps/internal/asm/TypePath;[Lcom/autonomousapps/internal/asm/Label;[Lcom/autonomousapps/internal/asm/Label;[ILjava/lang/String;Z)Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "visitAnnotation", "visitInsnAnnotation", "visitParameterAnnotation", "parameter", "visitTypeAnnotation", "visitTryCatchBlock", "handler", "visitTryCatchAnnotation", "visitLdcInsn", "value", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nasm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/MethodAnalyzer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,733:1\n1321#2,2:734\n1869#3,2:736\n1#4:738\n*S KotlinDebug\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/MethodAnalyzer\n*L\n392#1:734,2\n426#1:736,2\n*E\n"})
final class MethodAnalyzer
extends MethodVisitor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<ClassRef> classes;
    @NotNull
    private final Map<String, SortedSet<MemberAccess>> binaryClasses;
    @NotNull
    private final Set<LdcConstant> constants;

    public MethodAnalyzer(@NotNull Logger logger, @NotNull Set<ClassRef> classes, @NotNull Map<String, SortedSet<MemberAccess>> binaryClasses, @NotNull Set<LdcConstant> constants) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter(binaryClasses, (String)"binaryClasses");
        Intrinsics.checkNotNullParameter(constants, (String)"constants");
        super(589824);
        this.logger = logger;
        this.classes = classes;
        this.binaryClasses = binaryClasses;
        this.constants = constants;
    }

    private final void addClass(String className, ClassRef.Kind kind) {
        AsmKt.addClass$default(this.classes, className, kind, null, 4, null);
    }

    private final void log(Function0<String> msgProvider) {
        if (!AsmKt.access$getLogDebug$p()) {
            this.logger.quiet((String)msgProvider.invoke());
        }
    }

    public void visitTypeInsn(int opcode, @Nullable String type) {
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitTypeInsn$lambda$0(type)));
        String string = type;
        this.addClass((String)((string != null ? StringsKt.startsWith$default((String)string, (String)"[", (boolean)false, (int)2, null) : false) ? type : "L" + type + ";"), ClassRef.Kind.NOT_ANNOTATION);
    }

    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitFieldInsn$lambda$1(owner, name, descriptor)));
        MemberAccess.Field field = new MemberAccess.Field(owner, name, descriptor);
        Object[] objectArray = new MemberAccess[]{field};
        this.binaryClasses.merge(owner, SetsKt.sortedSetOf((Object[])objectArray), (arg_0, arg_1) -> MethodAnalyzer.visitFieldInsn$lambda$4(MethodAnalyzer::visitFieldInsn$lambda$3, arg_0, arg_1));
        this.addClass("L" + owner + ";", ClassRef.Kind.NOT_ANNOTATION);
        this.addClass(descriptor, ClassRef.Kind.NOT_ANNOTATION);
    }

    public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitMethodInsn$lambda$5(owner, name, descriptor)));
        this.addClass((String)(StringsKt.startsWith$default((String)owner, (String)"[", (boolean)false, (int)2, null) ? owner : "L" + owner + ";"), ClassRef.Kind.NOT_ANNOTATION);
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)RegexKt.getMETHOD_DESCRIPTOR_REGEX(), (CharSequence)descriptor, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult result = (MatchResult)element$iv;
            boolean bl = false;
            this.addClass(result.getValue(), ClassRef.Kind.NOT_ANNOTATION);
        }
        MemberAccess.Method method = new MemberAccess.Method(owner, name, descriptor);
        Object[] objectArray = new MemberAccess[]{method};
        this.binaryClasses.merge(owner, SetsKt.sortedSetOf((Object[])objectArray), (arg_0, arg_1) -> MethodAnalyzer.visitMethodInsn$lambda$9(MethodAnalyzer::visitMethodInsn$lambda$8, arg_0, arg_1));
    }

    public void visitInvokeDynamicInsn(@Nullable String name, @Nullable String descriptor, @Nullable Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        Intrinsics.checkNotNullParameter((Object)bootstrapMethodArguments, (String)"bootstrapMethodArguments");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitInvokeDynamicInsn$lambda$10(name, descriptor)));
        this.addClass(descriptor, ClassRef.Kind.NOT_ANNOTATION);
    }

    public void visitLocalVariable(@Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable Label start, @Nullable Label end, int index) {
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitLocalVariable$lambda$11(name, descriptor)));
        Object object = signature;
        if (object != null && (object = RegexKt.genericTypes((String)object)) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.addClass(it, ClassRef.Kind.NOT_ANNOTATION);
            }
        }
        this.addClass(descriptor, ClassRef.Kind.NOT_ANNOTATION);
    }

    @NotNull
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable Label[] start, @Nullable Label[] end, @Nullable int[] index, @NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitLocalVariableAnnotation$lambda$13(descriptor)));
        this.addClass(descriptor, ClassRef.Kind.NOT_ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitAnnotation$lambda$14(descriptor)));
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    @NotNull
    public AnnotationVisitor visitInsnAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitInsnAnnotation$lambda$15(descriptor)));
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    @NotNull
    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitParameterAnnotation$lambda$16(descriptor)));
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitTypeAnnotation$lambda$17(descriptor)));
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    public void visitTryCatchBlock(@Nullable Label start, @Nullable Label end, @Nullable Label handler, @Nullable String type) {
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitTryCatchBlock$lambda$18(type)));
        this.addClass("L" + type + ";", ClassRef.Kind.NOT_ANNOTATION);
    }

    @NotNull
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String descriptor, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitTryCatchAnnotation$lambda$19(descriptor)));
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return new AnnotationAnalyzer(descriptor, visible, this.logger, this.classes, 0, null, 48, null);
    }

    public void visitLdcInsn(@Nullable Object value) {
        this.log((Function0<String>)((Function0)() -> MethodAnalyzer.visitLdcInsn$lambda$21(value)));
        this.constants.add(LdcConstant.Companion.of(value));
    }

    private static final String visitTypeInsn$lambda$0(String $type) {
        return "- MethodAnalyzer#visitTypeInsn: " + $type;
    }

    private static final String visitFieldInsn$lambda$1(String $owner, String $name, String $descriptor) {
        return "- MethodAnalyzer#visitFieldInsn: " + $owner + "." + $name + " " + $descriptor;
    }

    private static final SortedSet visitFieldInsn$lambda$3(SortedSet acc, SortedSet inc) {
        SortedSet sortedSet;
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        Intrinsics.checkNotNullParameter((Object)inc, (String)"inc");
        SortedSet $this$visitFieldInsn_u24lambda_u243_u24lambda_u242 = sortedSet = acc;
        boolean bl = false;
        $this$visitFieldInsn_u24lambda_u243_u24lambda_u242.addAll(inc);
        return sortedSet;
    }

    private static final SortedSet visitFieldInsn$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (SortedSet)$tmp0.invoke(p0, p1);
    }

    private static final String visitMethodInsn$lambda$5(String $owner, String $name, String $descriptor) {
        return "- MethodAnalyzer#visitMethodInsn: " + $owner + "." + $name + " " + $descriptor;
    }

    private static final SortedSet visitMethodInsn$lambda$8(SortedSet acc, SortedSet inc) {
        SortedSet sortedSet;
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        Intrinsics.checkNotNullParameter((Object)inc, (String)"inc");
        SortedSet $this$visitMethodInsn_u24lambda_u248_u24lambda_u247 = sortedSet = acc;
        boolean bl = false;
        $this$visitMethodInsn_u24lambda_u248_u24lambda_u247.addAll(inc);
        return sortedSet;
    }

    private static final SortedSet visitMethodInsn$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        return (SortedSet)$tmp0.invoke(p0, p1);
    }

    private static final String visitInvokeDynamicInsn$lambda$10(String $name, String $descriptor) {
        return "- MethodAnalyzer#visitInvokeDynamicInsn: " + $name + " " + $descriptor;
    }

    private static final String visitLocalVariable$lambda$11(String $name, String $descriptor) {
        return "- MethodAnalyzer#visitLocalVariable: " + $name + " " + $descriptor;
    }

    private static final String visitLocalVariableAnnotation$lambda$13(String $descriptor) {
        return "- MethodAnalyzer#visitLocalVariableAnnotation: " + $descriptor;
    }

    private static final String visitAnnotation$lambda$14(String $descriptor) {
        return "- MethodAnalyzer#visitAnnotation: " + $descriptor;
    }

    private static final String visitInsnAnnotation$lambda$15(String $descriptor) {
        return "- MethodAnalyzer#visitInsnAnnotation: " + $descriptor;
    }

    private static final String visitParameterAnnotation$lambda$16(String $descriptor) {
        return "- MethodAnalyzer#visitParameterAnnotation: " + $descriptor;
    }

    private static final String visitTypeAnnotation$lambda$17(String $descriptor) {
        return "- MethodAnalyzer#visitTypeAnnotation: " + $descriptor;
    }

    private static final String visitTryCatchBlock$lambda$18(String $type) {
        return "- MethodAnalyzer#visitTryCatchBlock: " + $type;
    }

    private static final String visitTryCatchAnnotation$lambda$19(String $descriptor) {
        return "- MethodAnalyzer#visitTryCatchAnnotation: " + $descriptor;
    }

    private static final String visitLdcInsn$lambda$21(Object $value) {
        String string;
        Class<?> clazz = $value;
        Class<?> clazz2 = $value;
        if (clazz2 != null && (clazz2 = clazz2.getClass()) != null && (clazz2 = clazz2.getCanonicalName()) != null) {
            Class<?> it = clazz2;
            Class<?> clazz3 = clazz;
            boolean bl = false;
            string = " (type=" + (String)((Object)it) + ")";
            clazz = clazz3;
        } else {
            string = null;
        }
        return "- MethodAnalyzer#visitLdcInsn: " + clazz + string;
    }
}

