/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.android.build.api.variant.SourceDirectories;
import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.OutputPaths;
import com.autonomousapps.internal.analyzer.AbstractDependencyAnalyzer;
import com.autonomousapps.internal.analyzer.AndroidSources;
import com.autonomousapps.internal.analyzer.AndroidVariant;
import com.autonomousapps.internal.android.AndroidGradlePlugin;
import com.autonomousapps.internal.android.AndroidGradlePluginFactory;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.source.SourceKind;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.AndroidClassesTask;
import com.autonomousapps.tasks.AndroidCodeSourceExploderTask;
import com.autonomousapps.tasks.AssetSourceExploderTask;
import com.autonomousapps.tasks.ClassListExploderTask;
import com.autonomousapps.tasks.CodeSourceExploderTask;
import com.autonomousapps.tasks.FindAndroidAssetProviders;
import com.autonomousapps.tasks.FindAndroidLinters;
import com.autonomousapps.tasks.FindAndroidResTask;
import com.autonomousapps.tasks.FindDeclaredProcsTask;
import com.autonomousapps.tasks.FindNativeLibsTask;
import com.autonomousapps.tasks.ManifestComponentsExtractionTask;
import com.autonomousapps.tasks.XmlSourceExploderTask;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u00102\u001a\u00020\tH\u0002J\f\u00107\u001a\b\u0012\u0004\u0012\u00020908J\u000e\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020;08J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=08J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?08J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A08J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C08J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E08J\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G08J\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I08J\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K08J\b\u0010L\u001a\u00020\tH\u0002J\b\u0010M\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0011\u0010%\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016R\u0011\u0010'\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0016R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0016R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u0002000*\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010,R\u0017\u00101\u001a\b\u0012\u0004\u0012\u0002000*\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010,R\u0011\u00103\u001a\u000204\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006N"}, d2={"Lcom/autonomousapps/internal/analyzer/AndroidAnalyzer;", "Lcom/autonomousapps/internal/analyzer/AbstractDependencyAnalyzer;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/autonomousapps/internal/analyzer/AndroidVariant;", "androidSources", "Lcom/autonomousapps/internal/analyzer/AndroidSources;", "agpVersion", "", "<init>", "(Lorg/gradle/api/Project;Lcom/autonomousapps/internal/analyzer/AndroidVariant;Lcom/autonomousapps/internal/analyzer/AndroidSources;Ljava/lang/String;)V", "getVariant", "()Lcom/autonomousapps/internal/analyzer/AndroidVariant;", "getAndroidSources", "()Lcom/autonomousapps/internal/analyzer/AndroidSources;", "agp", "Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "getAgp", "()Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "flavorName", "getFlavorName", "()Ljava/lang/String;", "variantName", "getVariantName", "buildType", "getBuildType", "sourceKind", "Lcom/autonomousapps/model/source/SourceKind;", "getSourceKind", "()Lcom/autonomousapps/model/source/SourceKind;", "taskNameSuffix", "getTaskNameSuffix", "compileConfigurationName", "getCompileConfigurationName", "runtimeConfigurationName", "getRuntimeConfigurationName", "kaptConfigurationName", "getKaptConfigurationName", "annotationProcessorConfigurationName", "getAnnotationProcessorConfigurationName", "testInstrumentationRunner", "Lorg/gradle/api/provider/Provider;", "getTestInstrumentationRunner", "()Lorg/gradle/api/provider/Provider;", "attributeValueJar", "getAttributeValueJar", "isDataBindingEnabled", "", "isViewBindingEnabled", "suffix", "outputPaths", "Lcom/autonomousapps/internal/OutputPaths;", "getOutputPaths", "()Lcom/autonomousapps/internal/OutputPaths;", "registerByteCodeSourceExploderTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/autonomousapps/tasks/ClassListExploderTask;", "registerCodeSourceExploderTask", "Lcom/autonomousapps/tasks/CodeSourceExploderTask;", "registerManifestComponentsExtractionTask", "Lcom/autonomousapps/tasks/ManifestComponentsExtractionTask;", "registerFindAndroidResTask", "Lcom/autonomousapps/tasks/FindAndroidResTask;", "registerExplodeXmlSourceTask", "Lcom/autonomousapps/tasks/XmlSourceExploderTask;", "registerExplodeAssetSourceTask", "Lcom/autonomousapps/tasks/AssetSourceExploderTask;", "registerFindNativeLibsTask", "Lcom/autonomousapps/tasks/FindNativeLibsTask;", "registerFindAndroidLintersTask", "Lcom/autonomousapps/tasks/FindAndroidLinters;", "registerFindAndroidAssetProvidersTask", "Lcom/autonomousapps/tasks/FindAndroidAssetProviders;", "registerFindDeclaredProcsTask", "Lcom/autonomousapps/tasks/FindDeclaredProcsTask;", "kaptConfName", "computeTaskNameSuffix", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAndroidProjectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/AndroidAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
public abstract class AndroidAnalyzer
extends AbstractDependencyAnalyzer {
    @NotNull
    private final AndroidVariant variant;
    @NotNull
    private final AndroidSources androidSources;
    @NotNull
    private final AndroidGradlePlugin agp;
    @NotNull
    private final String flavorName;
    @NotNull
    private final String variantName;
    @NotNull
    private final String buildType;
    @NotNull
    private final SourceKind sourceKind;
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileConfigurationName;
    @NotNull
    private final String runtimeConfigurationName;
    @NotNull
    private final String kaptConfigurationName;
    @NotNull
    private final String annotationProcessorConfigurationName;
    @NotNull
    private final Provider<String> testInstrumentationRunner;
    @NotNull
    private final String attributeValueJar;
    @NotNull
    private final Provider<Boolean> isDataBindingEnabled;
    @NotNull
    private final Provider<Boolean> isViewBindingEnabled;
    @NotNull
    private final OutputPaths outputPaths;

    public AndroidAnalyzer(@NotNull Project project, @NotNull AndroidVariant variant, @NotNull AndroidSources androidSources, @NotNull String agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)androidSources, (String)"androidSources");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        super(project);
        this.variant = variant;
        this.androidSources = androidSources;
        this.agp = new AndroidGradlePluginFactory(project, agpVersion).newAdapter();
        this.flavorName = this.variant.getFlavorName();
        this.variantName = this.variant.getVariantName();
        this.buildType = this.variant.getBuildType();
        this.sourceKind = this.androidSources.getSourceKind();
        this.taskNameSuffix = this.computeTaskNameSuffix();
        this.compileConfigurationName = this.androidSources.getCompileClasspathConfigurationName();
        this.runtimeConfigurationName = this.androidSources.getRuntimeClasspathConfigurationName();
        this.kaptConfigurationName = this.kaptConfName();
        this.annotationProcessorConfigurationName = this.variantName + "AnnotationProcessorClasspath";
        this.testInstrumentationRunner = this.variant.getTestInstrumentationRunner();
        this.attributeValueJar = "android-classes";
        this.isDataBindingEnabled = this.agp.isDataBindingEnabled();
        this.isViewBindingEnabled = this.agp.isViewBindingEnabled();
        this.outputPaths = new OutputPaths(project, this.variantName + this.suffix());
    }

    @NotNull
    protected final AndroidVariant getVariant() {
        return this.variant;
    }

    @NotNull
    protected final AndroidSources getAndroidSources() {
        return this.androidSources;
    }

    @NotNull
    protected final AndroidGradlePlugin getAgp() {
        return this.agp;
    }

    @Override
    @NotNull
    public final String getFlavorName() {
        return this.flavorName;
    }

    @Override
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Override
    @NotNull
    public final String getBuildType() {
        return this.buildType;
    }

    @Override
    @NotNull
    public final SourceKind getSourceKind() {
        return this.sourceKind;
    }

    @Override
    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @Override
    @NotNull
    public final String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    @Override
    @NotNull
    public final String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    @Override
    @NotNull
    public final String getKaptConfigurationName() {
        return this.kaptConfigurationName;
    }

    @Override
    @NotNull
    public final String getAnnotationProcessorConfigurationName() {
        return this.annotationProcessorConfigurationName;
    }

    @Override
    @NotNull
    public final Provider<String> getTestInstrumentationRunner() {
        return this.testInstrumentationRunner;
    }

    @Override
    @NotNull
    public final String getAttributeValueJar() {
        return this.attributeValueJar;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isDataBindingEnabled() {
        return this.isDataBindingEnabled;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isViewBindingEnabled() {
        return this.isViewBindingEnabled;
    }

    private final String suffix() {
        String string;
        switch (this.sourceKind.getKind()) {
            case "MAIN": {
                string = "Main";
                break;
            }
            case "TEST": {
                string = "Test";
                break;
            }
            case "ANDROID_TEST_FIXTURES": {
                string = "TestFixtures";
                break;
            }
            case "ANDROID_TEST": {
                string = "AndroidTest";
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown kind. Was '" + this.sourceKind.getKind() + "'").toString());
            }
        }
        return string;
    }

    @Override
    @NotNull
    public final OutputPaths getOutputPaths() {
        return this.outputPaths;
    }

    @Override
    @NotNull
    public final TaskProvider<ClassListExploderTask> registerByteCodeSourceExploderTask() {
        TaskProvider taskProvider;
        TaskProvider provider = taskProvider = this.getProject().getTasks().register("explodeByteCodeSource" + this.taskNameSuffix, ClassListExploderTask.class, arg_0 -> AndroidAnalyzer.registerByteCodeSourceExploderTask$lambda$1(arg_0 -> AndroidAnalyzer.registerByteCodeSourceExploderTask$lambda$0(this, arg_0), arg_0));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)provider);
        this.androidSources.wireWithClassFiles((TaskProvider<? extends AndroidClassesTask>)provider);
        TaskProvider taskProvider2 = taskProvider;
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"also(...)");
        return taskProvider2;
    }

    @Override
    @NotNull
    public final TaskProvider<? extends CodeSourceExploderTask> registerCodeSourceExploderTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("explodeCodeSource" + this.taskNameSuffix, AndroidCodeSourceExploderTask.class, arg_0 -> AndroidAnalyzer.registerCodeSourceExploderTask$lambda$6(arg_0 -> AndroidAnalyzer.registerCodeSourceExploderTask$lambda$5(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<ManifestComponentsExtractionTask> registerManifestComponentsExtractionTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("extractPackageNameFromManifest" + this.taskNameSuffix, ManifestComponentsExtractionTask.class, arg_0 -> AndroidAnalyzer.registerManifestComponentsExtractionTask$lambda$8(arg_0 -> AndroidAnalyzer.registerManifestComponentsExtractionTask$lambda$7(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<FindAndroidResTask> registerFindAndroidResTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("findAndroidResImports" + this.taskNameSuffix, FindAndroidResTask.class, arg_0 -> AndroidAnalyzer.registerFindAndroidResTask$lambda$10(arg_0 -> AndroidAnalyzer.registerFindAndroidResTask$lambda$9(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<XmlSourceExploderTask> registerExplodeXmlSourceTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("explodeXmlSource" + this.taskNameSuffix, XmlSourceExploderTask.class, arg_0 -> AndroidAnalyzer.registerExplodeXmlSourceTask$lambda$13(arg_0 -> AndroidAnalyzer.registerExplodeXmlSourceTask$lambda$12(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<AssetSourceExploderTask> registerExplodeAssetSourceTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("explodeAssetSource" + this.taskNameSuffix, AssetSourceExploderTask.class, arg_0 -> AndroidAnalyzer.registerExplodeAssetSourceTask$lambda$15(arg_0 -> AndroidAnalyzer.registerExplodeAssetSourceTask$lambda$14(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<FindNativeLibsTask> registerFindNativeLibsTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("findNativeLibs" + this.taskNameSuffix, FindNativeLibsTask.class, arg_0 -> AndroidAnalyzer.registerFindNativeLibsTask$lambda$17(arg_0 -> AndroidAnalyzer.registerFindNativeLibsTask$lambda$16(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<FindAndroidLinters> registerFindAndroidLintersTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("findAndroidLinters" + this.taskNameSuffix, FindAndroidLinters.class, arg_0 -> AndroidAnalyzer.registerFindAndroidLintersTask$lambda$19(arg_0 -> AndroidAnalyzer.registerFindAndroidLintersTask$lambda$18(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<FindAndroidAssetProviders> registerFindAndroidAssetProvidersTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("findAndroidAssetProviders" + this.taskNameSuffix, FindAndroidAssetProviders.class, arg_0 -> AndroidAnalyzer.registerFindAndroidAssetProvidersTask$lambda$21(arg_0 -> AndroidAnalyzer.registerFindAndroidAssetProvidersTask$lambda$20(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<FindDeclaredProcsTask> registerFindDeclaredProcsTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("findDeclaredProcs" + this.taskNameSuffix, FindDeclaredProcsTask.class, arg_0 -> AndroidAnalyzer.registerFindDeclaredProcsTask$lambda$25(arg_0 -> AndroidAnalyzer.registerFindDeclaredProcsTask$lambda$24(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    private final String kaptConfName() {
        Object object;
        switch (this.sourceKind.getKind()) {
            case "MAIN": {
                object = "kapt" + UtilsKt.capitalizeSafely(this.variantName);
                break;
            }
            case "TEST": {
                object = "kaptTest";
                break;
            }
            case "ANDROID_TEST_FIXTURES": {
                object = "kaptTestFixtures";
                break;
            }
            case "ANDROID_TEST": {
                object = "kaptAndroidTest";
                break;
            }
            case "CUSTOM_JVM": {
                throw new IllegalStateException("Custom JVM source sets are not supported in Android context".toString());
            }
            default: {
                throw new IllegalStateException(("Unknown kind: '" + this.sourceKind.getKind() + "'").toString());
            }
        }
        return object;
    }

    private final String computeTaskNameSuffix() {
        return Intrinsics.areEqual((Object)this.sourceKind.getKind(), (Object)"MAIN") ? UtilsKt.capitalizeSafely(this.variantName) : UtilsKt.capitalizeSafely(this.variantName) + this.suffix();
    }

    private static final Unit registerByteCodeSourceExploderTask$lambda$0(AndroidAnalyzer this$0, ClassListExploderTask it) {
        it.getClasses().setFrom((Iterable)this$0.getProject().files(new Object[0]));
        it.getOutput().set(this$0.outputPaths.getExplodingBytecodePath());
        return Unit.INSTANCE;
    }

    private static final void registerByteCodeSourceExploderTask$lambda$1(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerCodeSourceExploderTask$lambda$5(AndroidAnalyzer this$0, AndroidCodeSourceExploderTask it) {
        SourceDirectories.Flat flat;
        SourceDirectories.Flat flat2 = this$0.androidSources.getSources().getJava();
        if (flat2 != null && (flat2 = flat2.getAll()) != null) {
            SourceDirectories.Flat j = flat2;
            boolean bl = false;
            it.getJavaSource().set((Provider)j);
        }
        if ((flat = this$0.androidSources.getSources().getKotlin()) != null && (flat = flat.getAll()) != null) {
            SourceDirectories.Flat k = flat;
            boolean bl = false;
            it.getKotlinSource().set((Provider)k);
        }
        it.getOutput().set(this$0.outputPaths.getExplodedSourcePath());
        return Unit.INSTANCE;
    }

    private static final void registerCodeSourceExploderTask$lambda$6(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerManifestComponentsExtractionTask$lambda$7(AndroidAnalyzer this$0, ManifestComponentsExtractionTask it) {
        Configuration configuration = this$0.getProject().getConfigurations().getByName(this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        it.setArtifacts(ArtifactViewsKt.artifactsFor(configuration, "android-manifest"));
        it.getNamespace().set(this$0.agp.namespace());
        it.getOutput().set(this$0.outputPaths.getManifestPackagesPath());
        return Unit.INSTANCE;
    }

    private static final void registerManifestComponentsExtractionTask$lambda$8(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerFindAndroidResTask$lambda$9(AndroidAnalyzer this$0, FindAndroidResTask it) {
        Configuration configuration = this$0.getProject().getConfigurations().getByName(this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        it.setAndroidSymbols(ArtifactViewsKt.artifactsFor(configuration, "android-symbol-with-package-name"));
        Configuration configuration2 = this$0.getProject().getConfigurations().getByName(this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"getByName(...)");
        it.setAndroidPublicRes(ArtifactViewsKt.artifactsFor(configuration2, "android-public-res"));
        it.getOutput().set(this$0.outputPaths.getAndroidResPath());
        return Unit.INSTANCE;
    }

    private static final void registerFindAndroidResTask$lambda$10(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerExplodeXmlSourceTask$lambda$12(AndroidAnalyzer this$0, XmlSourceExploderTask it) {
        Provider<List<Collection<Directory>>> provider = this$0.androidSources.getAndroidRes();
        if (provider != null) {
            Provider<List<Collection<Directory>>> r = provider;
            boolean bl = false;
            it.getAndroidLocalRes().set(r);
        }
        it.getManifests().set(this$0.androidSources.getManifestFiles());
        Object[] objectArray = new Object[]{this$0.androidSources.getMergedManifest()};
        it.getMergedManifestFiles().setFrom(objectArray);
        it.getNamespace().set(this$0.agp.namespace());
        it.getOutput().set(this$0.outputPaths.getAndroidResToResUsagePath());
        it.getOutputRuntime().set(this$0.outputPaths.getAndroidResToResUsageRuntimePath());
        return Unit.INSTANCE;
    }

    private static final void registerExplodeXmlSourceTask$lambda$13(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerExplodeAssetSourceTask$lambda$14(AndroidAnalyzer this$0, AssetSourceExploderTask it) {
        Object[] objectArray = new Object[]{this$0.androidSources.getAndroidAssets()};
        it.getAndroidLocalAssets().setFrom(objectArray);
        it.getOutput().set(this$0.outputPaths.getAndroidAssetSourcePath());
        return Unit.INSTANCE;
    }

    private static final void registerExplodeAssetSourceTask$lambda$15(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerFindNativeLibsTask$lambda$16(AndroidAnalyzer this$0, FindNativeLibsTask it) {
        Configuration configuration = this$0.getProject().getConfigurations().getByName(this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        it.setAndroidJni(ArtifactViewsKt.artifactsFor(configuration, "android-jni"));
        it.getOutput().set(this$0.outputPaths.getNativeDependenciesPath());
        return Unit.INSTANCE;
    }

    private static final void registerFindNativeLibsTask$lambda$17(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerFindAndroidLintersTask$lambda$18(AndroidAnalyzer this$0, FindAndroidLinters it) {
        Configuration configuration = this$0.getProject().getConfigurations().getByName(this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        it.setLintJars(ArtifactViewsKt.artifactsFor(configuration, "android-lint"));
        it.getOutput().set(this$0.outputPaths.getAndroidLintersPath());
        return Unit.INSTANCE;
    }

    private static final void registerFindAndroidLintersTask$lambda$19(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerFindAndroidAssetProvidersTask$lambda$20(AndroidAnalyzer this$0, FindAndroidAssetProviders it) {
        Configuration configuration = this$0.getProject().getConfigurations().getByName(this$0.runtimeConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        it.setAssets(ArtifactViewsKt.artifactsFor(configuration, "android-assets"));
        it.getOutput().set(this$0.outputPaths.getAndroidAssetsPath());
        return Unit.INSTANCE;
    }

    private static final void registerFindAndroidAssetProvidersTask$lambda$21(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerFindDeclaredProcsTask$lambda$24(AndroidAnalyzer this$0, FindDeclaredProcsTask it) {
        Configuration configuration;
        it.getInMemoryCacheProvider().set(InMemoryCache.Companion.register(this$0.getProject()));
        Configuration configuration2 = this$0.kaptConf();
        if (configuration2 != null) {
            configuration = configuration2;
            boolean bl = false;
            ArtifactCollection artifactCollection = configuration.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            it.setKaptArtifacts(artifactCollection);
        }
        Configuration configuration3 = this$0.annotationProcessorConf();
        if (configuration3 != null) {
            configuration = configuration3;
            boolean bl = false;
            ArtifactCollection artifactCollection = configuration.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            it.setAnnotationProcessorArtifacts(artifactCollection);
        }
        it.getOutput().set(this$0.outputPaths.getDeclaredProcPath());
        return Unit.INSTANCE;
    }

    private static final void registerFindDeclaredProcsTask$lambda$25(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }
}

