/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.OutputPaths;
import com.autonomousapps.internal.analyzer.AbstractDependencyAnalyzer;
import com.autonomousapps.internal.analyzer.JvmSourceSet;
import com.autonomousapps.internal.analyzer.Language;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.source.SourceKind;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.AbiAnalysisTask;
import com.autonomousapps.tasks.ClassListExploderTask;
import com.autonomousapps.tasks.CodeSourceExploderTask;
import com.autonomousapps.tasks.FindDeclaredProcsTask;
import com.autonomousapps.tasks.FindNativeLibsTask;
import com.autonomousapps.tasks.JvmCodeSourceExploderTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u000e\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0+J\u001c\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010+2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0#J\f\u00102\u001a\b\u0012\u0004\u0012\u0002030+J\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002050+H\u0016J\u0014\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000208070#H\u0002J\u0014\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000208070#H\u0002J\u0014\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000208070#H\u0002J\u0014\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000208070#H\u0002J\b\u0010<\u001a\u00020=H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0014\u0010\u001c\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0014\u0010\u001e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR\u0014\u0010 \u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006>"}, d2={"Lcom/autonomousapps/internal/analyzer/JvmAnalyzer;", "Lcom/autonomousapps/internal/analyzer/AbstractDependencyAnalyzer;", "project", "Lorg/gradle/api/Project;", "sourceSet", "Lcom/autonomousapps/internal/analyzer/JvmSourceSet;", "hasAbi", "", "<init>", "(Lorg/gradle/api/Project;Lcom/autonomousapps/internal/analyzer/JvmSourceSet;Z)V", "flavorName", "", "getFlavorName", "()Ljava/lang/String;", "buildType", "getBuildType", "sourceKind", "Lcom/autonomousapps/model/source/SourceKind;", "getSourceKind", "()Lcom/autonomousapps/model/source/SourceKind;", "variantName", "getVariantName", "taskNameSuffix", "getTaskNameSuffix", "compileConfigurationName", "getCompileConfigurationName", "runtimeConfigurationName", "getRuntimeConfigurationName", "kaptConfigurationName", "getKaptConfigurationName", "annotationProcessorConfigurationName", "getAnnotationProcessorConfigurationName", "attributeValueJar", "getAttributeValueJar", "isDataBindingEnabled", "Lorg/gradle/api/provider/Provider;", "()Lorg/gradle/api/provider/Provider;", "isViewBindingEnabled", "outputPaths", "Lcom/autonomousapps/internal/OutputPaths;", "getOutputPaths", "()Lcom/autonomousapps/internal/OutputPaths;", "registerByteCodeSourceExploderTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/autonomousapps/tasks/ClassListExploderTask;", "registerCodeSourceExploderTask", "Lcom/autonomousapps/tasks/CodeSourceExploderTask;", "registerAbiAnalysisTask", "Lcom/autonomousapps/tasks/AbiAnalysisTask;", "abiExclusions", "registerFindDeclaredProcsTask", "Lcom/autonomousapps/tasks/FindDeclaredProcsTask;", "registerFindNativeLibsTask", "Lcom/autonomousapps/tasks/FindNativeLibsTask;", "getGroovySources", "", "Ljava/io/File;", "getJavaSources", "getKotlinSources", "getScalaSources", "getSourceDirectories", "Lorg/gradle/api/file/FileTree;", "dependency-analysis-gradle-plugin"})
public abstract class JvmAnalyzer
extends AbstractDependencyAnalyzer {
    @NotNull
    private final JvmSourceSet sourceSet;
    private final boolean hasAbi;
    @Nullable
    private final String flavorName;
    @Nullable
    private final String buildType;
    @NotNull
    private final SourceKind sourceKind;
    @NotNull
    private final String variantName;
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileConfigurationName;
    @NotNull
    private final String runtimeConfigurationName;
    @NotNull
    private final String kaptConfigurationName;
    @NotNull
    private final String annotationProcessorConfigurationName;
    @NotNull
    private final String attributeValueJar;
    @NotNull
    private final Provider<Boolean> isDataBindingEnabled;
    @NotNull
    private final Provider<Boolean> isViewBindingEnabled;
    @NotNull
    private final OutputPaths outputPaths;

    public JvmAnalyzer(@NotNull Project project, @NotNull JvmSourceSet sourceSet, boolean hasAbi) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        super(project);
        this.sourceSet = sourceSet;
        this.hasAbi = hasAbi;
        this.sourceKind = this.sourceSet.getSourceKind();
        this.variantName = this.sourceSet.getName();
        this.taskNameSuffix = UtilsKt.capitalizeSafely(this.variantName);
        this.compileConfigurationName = this.sourceSet.getCompileClasspathConfigurationName();
        this.runtimeConfigurationName = this.sourceSet.getRuntimeClasspathConfigurationName();
        this.kaptConfigurationName = "kapt";
        this.annotationProcessorConfigurationName = "annotationProcessor";
        this.attributeValueJar = "jar";
        Provider provider = project.provider(JvmAnalyzer::isDataBindingEnabled$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        this.isDataBindingEnabled = provider;
        Provider provider2 = project.provider(JvmAnalyzer::isViewBindingEnabled$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"provider(...)");
        this.isViewBindingEnabled = provider2;
        this.outputPaths = new OutputPaths(project, this.variantName);
    }

    @Override
    @Nullable
    public final String getFlavorName() {
        return this.flavorName;
    }

    @Override
    @Nullable
    public final String getBuildType() {
        return this.buildType;
    }

    @Override
    @NotNull
    public final SourceKind getSourceKind() {
        return this.sourceKind;
    }

    @Override
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Override
    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @Override
    @NotNull
    public final String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    @Override
    @NotNull
    public final String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    @Override
    @NotNull
    public final String getKaptConfigurationName() {
        return this.kaptConfigurationName;
    }

    @Override
    @NotNull
    public final String getAnnotationProcessorConfigurationName() {
        return this.annotationProcessorConfigurationName;
    }

    @Override
    @NotNull
    public final String getAttributeValueJar() {
        return this.attributeValueJar;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isDataBindingEnabled() {
        return this.isDataBindingEnabled;
    }

    @Override
    @NotNull
    public final Provider<Boolean> isViewBindingEnabled() {
        return this.isViewBindingEnabled;
    }

    @Override
    @NotNull
    public OutputPaths getOutputPaths() {
        return this.outputPaths;
    }

    @Override
    @NotNull
    public final TaskProvider<ClassListExploderTask> registerByteCodeSourceExploderTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("explodeByteCodeSource" + this.taskNameSuffix, ClassListExploderTask.class, arg_0 -> JvmAnalyzer.registerByteCodeSourceExploderTask$lambda$3(arg_0 -> JvmAnalyzer.registerByteCodeSourceExploderTask$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public final TaskProvider<? extends CodeSourceExploderTask> registerCodeSourceExploderTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("explodeCodeSource" + this.taskNameSuffix, JvmCodeSourceExploderTask.class, arg_0 -> JvmAnalyzer.registerCodeSourceExploderTask$lambda$5(arg_0 -> JvmAnalyzer.registerCodeSourceExploderTask$lambda$4(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @Nullable
    public final TaskProvider<AbiAnalysisTask> registerAbiAnalysisTask(@NotNull Provider<String> abiExclusions) {
        Intrinsics.checkNotNullParameter(abiExclusions, (String)"abiExclusions");
        if (!this.hasAbi) {
            return null;
        }
        return this.getProject().getTasks().register("abiAnalysis" + this.taskNameSuffix, AbiAnalysisTask.class, arg_0 -> JvmAnalyzer.registerAbiAnalysisTask$lambda$7(arg_0 -> JvmAnalyzer.registerAbiAnalysisTask$lambda$6(this, abiExclusions, arg_0), arg_0));
    }

    @Override
    @NotNull
    public final TaskProvider<FindDeclaredProcsTask> registerFindDeclaredProcsTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("findDeclaredProcs" + this.taskNameSuffix, FindDeclaredProcsTask.class, arg_0 -> JvmAnalyzer.registerFindDeclaredProcsTask$lambda$11(arg_0 -> JvmAnalyzer.registerFindDeclaredProcsTask$lambda$10(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @Override
    @NotNull
    public TaskProvider<FindNativeLibsTask> registerFindNativeLibsTask() {
        TaskProvider taskProvider = this.getProject().getTasks().register("findNativeLibs" + this.taskNameSuffix, FindNativeLibsTask.class, arg_0 -> JvmAnalyzer.registerFindNativeLibsTask$lambda$13(arg_0 -> JvmAnalyzer.registerFindNativeLibsTask$lambda$12(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    private final Provider<Iterable<File>> getGroovySources() {
        Provider provider = this.getProject().provider(() -> JvmAnalyzer.getGroovySources$lambda$14(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final Provider<Iterable<File>> getJavaSources() {
        Provider provider = this.getProject().provider(() -> JvmAnalyzer.getJavaSources$lambda$15(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final Provider<Iterable<File>> getKotlinSources() {
        Provider provider = this.getProject().provider(() -> JvmAnalyzer.getKotlinSources$lambda$16(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final Provider<Iterable<File>> getScalaSources() {
        Provider provider = this.getProject().provider(() -> JvmAnalyzer.getScalaSources$lambda$17(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final FileTree getSourceDirectories() {
        FileCollection allSource = this.sourceSet.getSourceCode().getSourceDirectories();
        Object[] objectArray = new Object[]{allSource};
        FileTree fileTree = this.getProject().files(objectArray).getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getAsFileTree(...)");
        return fileTree;
    }

    private static final Boolean isDataBindingEnabled$lambda$0() {
        return false;
    }

    private static final Boolean isViewBindingEnabled$lambda$1() {
        return false;
    }

    private static final Unit registerByteCodeSourceExploderTask$lambda$2(JvmAnalyzer this$0, ClassListExploderTask it) {
        it.getClasses().setFrom((Iterable)this$0.sourceSet.getClassesDirs());
        it.getOutput().set(this$0.getOutputPaths().getExplodingBytecodePath());
        return Unit.INSTANCE;
    }

    private static final void registerByteCodeSourceExploderTask$lambda$3(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerCodeSourceExploderTask$lambda$4(JvmAnalyzer this$0, JvmCodeSourceExploderTask it) {
        Object[] objectArray = new Object[]{this$0.getGroovySources()};
        it.getGroovySource().setFrom(objectArray);
        objectArray = new Object[]{this$0.getJavaSources()};
        it.getJavaSource().setFrom(objectArray);
        objectArray = new Object[]{this$0.getKotlinSources()};
        it.getKotlinSource().setFrom(objectArray);
        objectArray = new Object[]{this$0.getScalaSources()};
        it.getScalaSource().setFrom(objectArray);
        it.getOutput().set(this$0.getOutputPaths().getExplodedSourcePath());
        return Unit.INSTANCE;
    }

    private static final void registerCodeSourceExploderTask$lambda$5(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerAbiAnalysisTask$lambda$6(JvmAnalyzer this$0, Provider $abiExclusions, AbiAnalysisTask it) {
        it.getClasses().setFrom((Iterable)this$0.sourceSet.getClassesDirs());
        it.getExclusions().set($abiExclusions);
        it.getOutput().set(this$0.getOutputPaths().getAbiAnalysisPath());
        it.getAbiDump().set(this$0.getOutputPaths().getAbiDumpPath());
        return Unit.INSTANCE;
    }

    private static final void registerAbiAnalysisTask$lambda$7(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerFindDeclaredProcsTask$lambda$10(JvmAnalyzer this$0, FindDeclaredProcsTask it) {
        Configuration configuration;
        it.getInMemoryCacheProvider().set(InMemoryCache.Companion.register(this$0.getProject()));
        Configuration configuration2 = this$0.kaptConf();
        if (configuration2 != null) {
            configuration = configuration2;
            boolean bl = false;
            ArtifactCollection artifactCollection = configuration.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            it.setKaptArtifacts(artifactCollection);
        }
        Configuration configuration3 = this$0.annotationProcessorConf();
        if (configuration3 != null) {
            configuration = configuration3;
            boolean bl = false;
            ArtifactCollection artifactCollection = configuration.getIncoming().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
            it.setAnnotationProcessorArtifacts(artifactCollection);
        }
        it.getOutput().set(this$0.getOutputPaths().getDeclaredProcPath());
        return Unit.INSTANCE;
    }

    private static final void registerFindDeclaredProcsTask$lambda$11(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit registerFindNativeLibsTask$lambda$12(JvmAnalyzer this$0, FindNativeLibsTask it) {
        Configuration configuration = this$0.getProject().getConfigurations().getByName(this$0.compileConfigurationName);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        it.setMacNativeLibs(ArtifactViewsKt.artifactsFor(configuration, "dylib"));
        it.getOutput().set(this$0.getOutputPaths().getNativeDependenciesPath());
        return Unit.INSTANCE;
    }

    private static final void registerFindNativeLibsTask$lambda$13(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Iterable getGroovySources$lambda$14(JvmAnalyzer this$0) {
        return (Iterable)this$0.getSourceDirectories().matching(Language.Companion.filterOf(Language.GROOVY));
    }

    private static final Iterable getJavaSources$lambda$15(JvmAnalyzer this$0) {
        return (Iterable)this$0.getSourceDirectories().matching(Language.Companion.filterOf(Language.JAVA));
    }

    private static final Iterable getKotlinSources$lambda$16(JvmAnalyzer this$0) {
        return (Iterable)this$0.getSourceDirectories().matching(Language.Companion.filterOf(Language.KOTLIN));
    }

    private static final Iterable getScalaSources$lambda$17(JvmAnalyzer this$0) {
        return (Iterable)this$0.getSourceDirectories().matching(Language.Companion.filterOf(Language.SCALA));
    }
}

