/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.cash.grammar.kotlindsl.model.DependencyDeclaration;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.ModuleCoordinates;
import com.autonomousapps.model.ProjectCoordinates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0014\u0010\u0011\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0012\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0014\u0010\u0014\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/internal/parse/AdviceFinder;", "", "advice", "", "Lcom/autonomousapps/model/Advice;", "reversedDependencyMap", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "findAdvice", "dependencyDeclaration", "Lcom/autonomousapps/internal/cash/grammar/kotlindsl/model/DependencyDeclaration;", "normalizeTypeSafeProjectAccessor", "identifier", "matchesIdentifier", "", "matchesConfiguration", "matchesType", "rawIdentifier", "matchesCapabilities", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAdviceFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdviceFinder.kt\ncom/autonomousapps/internal/parse/AdviceFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1563#2:109\n1634#2,3:110\n1761#2,3:113\n1761#2,3:116\n1761#2,3:119\n*S KotlinDebug\n*F\n+ 1 AdviceFinder.kt\ncom/autonomousapps/internal/parse/AdviceFinder\n*L\n53#1:109\n53#1:110,3\n96#1:113,3\n100#1:116,3\n104#1:119,3\n*E\n"})
public final class AdviceFinder {
    @NotNull
    private final Set<Advice> advice;
    @NotNull
    private final Function1<String, String> reversedDependencyMap;

    public AdviceFinder(@NotNull Set<Advice> advice, @NotNull Function1<? super String, String> reversedDependencyMap) {
        Intrinsics.checkNotNullParameter(advice, (String)"advice");
        Intrinsics.checkNotNullParameter(reversedDependencyMap, (String)"reversedDependencyMap");
        this.advice = advice;
        this.reversedDependencyMap = reversedDependencyMap;
    }

    @Nullable
    public final Advice findAdvice(@NotNull DependencyDeclaration dependencyDeclaration) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)dependencyDeclaration, (String)"dependencyDeclaration");
            String originalIdentifier = StringsKt.removeSurrounding((String)dependencyDeclaration.getIdentifier().getPath(), (CharSequence)"\"");
            String rawIdentifier = (String)this.reversedDependencyMap.invoke((Object)originalIdentifier);
            String normalizedIdentifier = this.normalizeTypeSafeProjectAccessor(originalIdentifier);
            Iterable iterable = this.advice;
            for (Object t : iterable) {
                Advice it = (Advice)t;
                boolean bl = false;
                if (!((this.matchesIdentifier(it, rawIdentifier) || this.matchesIdentifier(it, normalizedIdentifier)) && this.matchesConfiguration(it, dependencyDeclaration) && this.matchesType(it, dependencyDeclaration, originalIdentifier) && this.matchesCapabilities(it, dependencyDeclaration))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final String normalizeTypeSafeProjectAccessor(String identifier) {
        void $this$mapTo$iv$iv;
        if (!StringsKt.startsWith$default((String)identifier, (String)"projects.", (boolean)false, (int)2, null)) {
            return identifier;
        }
        String projectPath = StringsKt.removePrefix((String)identifier, (CharSequence)"projects.");
        String withColons = StringsKt.replace$default((String)projectPath, (String)".", (String)":", (boolean)false, (int)4, null);
        String[] stringArray = new String[]{":"};
        List segments = StringsKt.split$default((CharSequence)withColons, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$map$iv = segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void segment;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)segment;
            Regex regex = new Regex("([a-z])([A-Z])");
            Function1 function1 = AdviceFinder::normalizeTypeSafeProjectAccessor$lambda$2$lambda$1;
            collection.add(regex.replace(charSequence, function1));
        }
        List normalizedSegments = (List)destination$iv$iv;
        return ":" + CollectionsKt.joinToString$default((Iterable)normalizedSegments, (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean matchesIdentifier(Advice $this$matchesIdentifier, String identifier) {
        return Intrinsics.areEqual((Object)$this$matchesIdentifier.getCoordinates().gav(), (Object)identifier) || Intrinsics.areEqual((Object)$this$matchesIdentifier.getCoordinates().getIdentifier(), (Object)identifier);
    }

    private final boolean matchesConfiguration(Advice $this$matchesConfiguration, DependencyDeclaration dependencyDeclaration) {
        return Intrinsics.areEqual((Object)$this$matchesConfiguration.getFromConfiguration(), (Object)dependencyDeclaration.getConfiguration());
    }

    private final boolean matchesType(Advice $this$matchesType, DependencyDeclaration dependencyDeclaration, String rawIdentifier) {
        boolean bl;
        if (StringsKt.startsWith$default((String)rawIdentifier, (String)"projects.", (boolean)false, (int)2, null) && $this$matchesType.getCoordinates() instanceof ProjectCoordinates) {
            return true;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[dependencyDeclaration.getType().ordinal()]) {
            case 1: {
                bl = $this$matchesType.getCoordinates() instanceof ModuleCoordinates;
                break;
            }
            case 2: {
                bl = $this$matchesType.getCoordinates() instanceof ProjectCoordinates;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            case 5: {
                bl = false;
                break;
            }
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean matchesCapabilities(Advice $this$matchesCapabilities, DependencyDeclaration dependencyDeclaration) {
        boolean bl;
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[dependencyDeclaration.getCapability().ordinal()]) {
            case 1: {
                bl = $this$matchesCapabilities.getCoordinates().getGradleVariantIdentification().getCapabilities().isEmpty();
                break;
            }
            case 2: {
                Iterable $this$any$iv = $this$matchesCapabilities.getCoordinates().getGradleVariantIdentification().getCapabilities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)"-enforced-platform", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 3: {
                Iterable $this$any$iv = $this$matchesCapabilities.getCoordinates().getGradleVariantIdentification().getCapabilities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)"-platform", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 4: {
                Iterable $this$any$iv = $this$matchesCapabilities.getCoordinates().getGradleVariantIdentification().getCapabilities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)"-test-fixtures", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final CharSequence normalizeTypeSafeProjectAccessor$lambda$2$lambda$1(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        Object e = matchResult.getGroupValues().get(1);
        String string = ((String)matchResult.getGroupValues().get(2)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return e + "-" + string;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DependencyDeclaration.Type.values().length];
            try {
                nArray[DependencyDeclaration.Type.MODULE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Type.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Type.GRADLE_DISTRIBUTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Type.FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Type.FILES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Type.FILE_TREE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DependencyDeclaration.Capability.values().length];
            try {
                nArray[DependencyDeclaration.Capability.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Capability.ENFORCED_PLATFORM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Capability.PLATFORM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyDeclaration.Capability.TEST_FIXTURES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

