/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.parse.ExplodedLayout;
import com.autonomousapps.internal.utils.RegexKt;
import com.autonomousapps.internal.utils.XmlKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/internal/parse/AndroidLayoutParser;", "", "projectDir", "Ljava/io/File;", "layouts", "", "<init>", "(Ljava/io/File;Ljava/lang/Iterable;)V", "explodedLayouts", "", "Lcom/autonomousapps/internal/parse/ExplodedLayout;", "getExplodedLayouts", "()Ljava/util/Set;", "parseLayouts", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nexplodeAndroidResSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidLayoutParser\n+ 2 document.kt\ncom/autonomousapps/internal/utils/document/DocumentKt\n+ 3 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n63#2,5:197\n84#3:202\n865#4,2:203\n*S KotlinDebug\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidLayoutParser\n*L\n32#1:197,5\n33#1:202\n33#1:203,2\n*E\n"})
public final class AndroidLayoutParser {
    @NotNull
    private final File projectDir;
    @NotNull
    private final Iterable<File> layouts;
    @NotNull
    private final Set<ExplodedLayout> explodedLayouts;

    public AndroidLayoutParser(@NotNull File projectDir, @NotNull Iterable<? extends File> layouts) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(layouts, (String)"layouts");
        this.projectDir = projectDir;
        this.layouts = layouts;
        this.explodedLayouts = this.parseLayouts();
    }

    @NotNull
    public final Set<ExplodedLayout> getExplodedLayouts() {
        return this.explodedLayouts;
    }

    private final Set<ExplodedLayout> parseLayouts() {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence(this.layouts), AndroidLayoutParser::parseLayouts$lambda$2), arg_0 -> AndroidLayoutParser.parseLayouts$lambda$3(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair parseLayouts$lambda$2(File layoutFile) {
        void $this$filterTo$iv$iv;
        void $this$filterToOrderedSet$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)layoutFile, (String)"layoutFile");
        NodeList nodeList = XmlKt.buildDocument(layoutFile).getElementsByTagName("*");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        NodeList nodeList2 = nodeList;
        File file = layoutFile;
        boolean $i$f$map = false;
        ArrayList<String> destination$iv = new ArrayList<String>($this$map$iv.getLength());
        int n = $this$map$iv.getLength();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            void it;
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv.item(i$iv), (String)"item(...)");
            ArrayList<String> arrayList = destination$iv;
            boolean bl = false;
            arrayList.add(it.getNodeName());
        }
        $this$map$iv = destination$iv;
        boolean $i$f$filterToOrderedSet = false;
        destination$iv = $this$filterToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Regex regex = RegexKt.getJAVA_FQCN_REGEX_DOTTY();
            Intrinsics.checkNotNull((Object)it);
            if (!regex.matches((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return TuplesKt.to((Object)file, (Object)((Set)destination$iv$iv));
    }

    private static final ExplodedLayout parseLayouts$lambda$3(AndroidLayoutParser this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        File file = (File)pair.component1();
        Set classes = (Set)pair.component2();
        return new ExplodedLayout(FilesKt.toRelativeString((File)file, (File)this$0.projectDir), classes);
    }
}

