/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.utils;

import com.autonomousapps.internal.utils.GraphAdapter;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.autonomousapps.model.source.SourceKind;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonClass;
import com.squareup.moshi.ToJson;
import java.util.Comparator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\u000bH\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0082\u0004\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/internal/utils/GraphAdapter;", "", "<init>", "()V", "graphViewToJson", "Lcom/autonomousapps/internal/utils/GraphAdapter$GraphViewJson;", "graphView", "Lcom/autonomousapps/model/internal/DependencyGraphView;", "jsonToGraphView", "json", "graphToJson", "Lcom/autonomousapps/internal/utils/GraphAdapter$GraphJson;", "graph", "Lcom/google/common/graph/Graph;", "Lcom/autonomousapps/model/Coordinates;", "jsonToGraph", "to", "Lcom/autonomousapps/internal/utils/GraphAdapter$EdgeJson;", "target", "GraphContainer", "GraphViewJson", "GraphJson", "EdgeJson", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nmoshi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 moshi.kt\ncom/autonomousapps/internal/utils/GraphAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1869#2,2:278\n1869#2,2:280\n1869#2,2:282\n1869#2,2:284\n*S KotlinDebug\n*F\n+ 1 moshi.kt\ncom/autonomousapps/internal/utils/GraphAdapter\n*L\n236#1:278,2\n237#1:280,2\n244#1:282,2\n245#1:284,2\n*E\n"})
public final class GraphAdapter {
    @ToJson
    @NotNull
    public final GraphViewJson graphViewToJson(@NotNull DependencyGraphView graphView) {
        Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
        SourceKind sourceKind = graphView.getSourceKind();
        String string = graphView.getConfigurationName();
        Set set = graphView.getGraph$dependency_analysis_gradle_plugin().nodes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"nodes(...)");
        Set set2 = CollectionsKt.toSortedSet((Iterable)set);
        Set set3 = graphView.getGraph$dependency_analysis_gradle_plugin().edges();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"edges(...)");
        return new GraphViewJson(sourceKind, string, new GraphJson(set2, SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set3), arg_0 -> GraphAdapter.graphViewToJson$lambda$0(this, arg_0)))));
    }

    @FromJson
    @NotNull
    public final DependencyGraphView jsonToGraphView(@NotNull GraphViewJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return new DependencyGraphView(json.getSourceKind(), json.getConfigurationName(), this.jsonToGraph(json));
    }

    @ToJson
    @NotNull
    public final GraphJson graphToJson(@NotNull Graph<Coordinates> graph) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Set set = graph.nodes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"nodes(...)");
        Set set2 = CollectionsKt.toSortedSet((Iterable)set);
        Set set3 = graph.edges();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"edges(...)");
        return new GraphJson(set2, SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set3), arg_0 -> GraphAdapter.graphToJson$lambda$1(this, arg_0))));
    }

    @FromJson
    @NotNull
    public final Graph<Coordinates> jsonToGraph(@NotNull GraphJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        ImmutableGraph.Builder<Coordinates> graphBuilder = DependencyGraphView.Companion.newGraphBuilder$dependency_analysis_gradle_plugin();
        Iterable $this$forEach$iv = json.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Coordinates it = (Coordinates)element$iv;
            boolean bl = false;
            graphBuilder.addNode((Object)it);
        }
        $this$forEach$iv = json.getEdges();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EdgeJson edgeJson = (EdgeJson)element$iv;
            boolean bl = false;
            Coordinates source = edgeJson.component1();
            Coordinates target = edgeJson.component2();
            graphBuilder.putEdge((Object)source, (Object)target);
        }
        ImmutableGraph immutableGraph = graphBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"build(...)");
        return (Graph)immutableGraph;
    }

    private final Graph<Coordinates> jsonToGraph(GraphViewJson json) {
        ImmutableGraph.Builder<Coordinates> graphBuilder = DependencyGraphView.Companion.newGraphBuilder$dependency_analysis_gradle_plugin();
        Iterable $this$forEach$iv = json.getGraphJson().getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Coordinates it = (Coordinates)element$iv;
            boolean bl = false;
            graphBuilder.addNode((Object)it);
        }
        $this$forEach$iv = json.getGraphJson().getEdges();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EdgeJson edgeJson = (EdgeJson)element$iv;
            boolean bl = false;
            Coordinates source = edgeJson.component1();
            Coordinates target = edgeJson.component2();
            graphBuilder.putEdge((Object)source, (Object)target);
        }
        ImmutableGraph immutableGraph = graphBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"build(...)");
        return (Graph)immutableGraph;
    }

    private final EdgeJson to(Coordinates $this$to, Coordinates target) {
        return new EdgeJson($this$to, target);
    }

    private static final EdgeJson graphViewToJson$lambda$0(GraphAdapter this$0, EndpointPair pair) {
        Object object = pair.nodeU();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeU(...)");
        Coordinates coordinates = (Coordinates)object;
        Object object2 = pair.nodeV();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nodeV(...)");
        return this$0.to(coordinates, (Coordinates)object2);
    }

    private static final EdgeJson graphToJson$lambda$1(GraphAdapter this$0, EndpointPair pair) {
        Object object = pair.nodeU();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeU(...)");
        Coordinates coordinates = (Coordinates)object;
        Object object2 = pair.nodeV();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nodeV(...)");
        return this$0.to(coordinates, (Coordinates)object2);
    }

    @JsonClass(generateAdapter=false)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/internal/utils/GraphAdapter$EdgeJson;", "", "source", "Lcom/autonomousapps/model/Coordinates;", "target", "<init>", "(Lcom/autonomousapps/model/Coordinates;Lcom/autonomousapps/model/Coordinates;)V", "getSource", "()Lcom/autonomousapps/model/Coordinates;", "getTarget", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "dependency-analysis-gradle-plugin"})
    public static final class EdgeJson
    implements Comparable<EdgeJson> {
        @NotNull
        private final Coordinates source;
        @NotNull
        private final Coordinates target;

        public EdgeJson(@NotNull Coordinates source, @NotNull Coordinates target) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.source = source;
            this.target = target;
        }

        @NotNull
        public final Coordinates getSource() {
            return this.source;
        }

        @NotNull
        public final Coordinates getTarget() {
            return this.target;
        }

        @Override
        public int compareTo(@NotNull EdgeJson other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return ((Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    EdgeJson p0 = (EdgeJson)a;
                    boolean bl = false;
                    Comparable comparable = p0.getSource();
                    p0 = (EdgeJson)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)p0.getSource());
                }
            }).thenComparing(arg_0 -> EdgeJson.compareTo$lambda$0((Function1)compareTo.2.INSTANCE, arg_0)).compare(this, other);
        }

        @NotNull
        public final Coordinates component1() {
            return this.source;
        }

        @NotNull
        public final Coordinates component2() {
            return this.target;
        }

        @NotNull
        public final EdgeJson copy(@NotNull Coordinates source, @NotNull Coordinates target) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new EdgeJson(source, target);
        }

        public static /* synthetic */ EdgeJson copy$default(EdgeJson edgeJson, Coordinates coordinates, Coordinates coordinates2, int n, Object object) {
            if ((n & 1) != 0) {
                coordinates = edgeJson.source;
            }
            if ((n & 2) != 0) {
                coordinates2 = edgeJson.target;
            }
            return edgeJson.copy(coordinates, coordinates2);
        }

        @NotNull
        public String toString() {
            return "EdgeJson(source=" + this.source + ", target=" + this.target + ")";
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = result * 31 + this.target.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EdgeJson)) {
                return false;
            }
            EdgeJson edgeJson = (EdgeJson)other;
            if (!Intrinsics.areEqual((Object)this.source, (Object)edgeJson.source)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)edgeJson.target);
        }

        private static final Coordinates compareTo$lambda$0(Function1 $tmp0, Object p0) {
            return (Coordinates)$tmp0.invoke(p0);
        }
    }

    @JsonClass(generateAdapter=false)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/autonomousapps/internal/utils/GraphAdapter$GraphContainer;", "", "graph", "Lcom/google/common/graph/Graph;", "Lcom/autonomousapps/model/Coordinates;", "<init>", "(Lcom/google/common/graph/Graph;)V", "getGraph", "()Lcom/google/common/graph/Graph;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dependency-analysis-gradle-plugin"})
    public static final class GraphContainer {
        @NotNull
        private final Graph<Coordinates> graph;

        public GraphContainer(@NotNull Graph<Coordinates> graph) {
            Intrinsics.checkNotNullParameter(graph, (String)"graph");
            this.graph = graph;
        }

        @NotNull
        public final Graph<Coordinates> getGraph() {
            return this.graph;
        }

        @NotNull
        public final Graph<Coordinates> component1() {
            return this.graph;
        }

        @NotNull
        public final GraphContainer copy(@NotNull Graph<Coordinates> graph) {
            Intrinsics.checkNotNullParameter(graph, (String)"graph");
            return new GraphContainer(graph);
        }

        public static /* synthetic */ GraphContainer copy$default(GraphContainer graphContainer, Graph graph, int n, Object object) {
            if ((n & 1) != 0) {
                graph = graphContainer.graph;
            }
            return graphContainer.copy(graph);
        }

        @NotNull
        public String toString() {
            return "GraphContainer(graph=" + this.graph + ")";
        }

        public int hashCode() {
            return this.graph.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GraphContainer)) {
                return false;
            }
            GraphContainer graphContainer = (GraphContainer)other;
            return Intrinsics.areEqual(this.graph, graphContainer.graph);
        }
    }

    @JsonClass(generateAdapter=false)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/internal/utils/GraphAdapter$GraphJson;", "", "nodes", "", "Lcom/autonomousapps/model/Coordinates;", "edges", "Lcom/autonomousapps/internal/utils/GraphAdapter$EdgeJson;", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "getNodes", "()Ljava/util/Set;", "getEdges", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dependency-analysis-gradle-plugin"})
    public static final class GraphJson {
        @NotNull
        private final Set<Coordinates> nodes;
        @NotNull
        private final Set<EdgeJson> edges;

        public GraphJson(@NotNull Set<? extends Coordinates> nodes, @NotNull Set<EdgeJson> edges) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            this.nodes = nodes;
            this.edges = edges;
        }

        @NotNull
        public final Set<Coordinates> getNodes() {
            return this.nodes;
        }

        @NotNull
        public final Set<EdgeJson> getEdges() {
            return this.edges;
        }

        @NotNull
        public final Set<Coordinates> component1() {
            return this.nodes;
        }

        @NotNull
        public final Set<EdgeJson> component2() {
            return this.edges;
        }

        @NotNull
        public final GraphJson copy(@NotNull Set<? extends Coordinates> nodes, @NotNull Set<EdgeJson> edges) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            return new GraphJson(nodes, edges);
        }

        public static /* synthetic */ GraphJson copy$default(GraphJson graphJson, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set = graphJson.nodes;
            }
            if ((n & 2) != 0) {
                set2 = graphJson.edges;
            }
            return graphJson.copy(set, set2);
        }

        @NotNull
        public String toString() {
            return "GraphJson(nodes=" + this.nodes + ", edges=" + this.edges + ")";
        }

        public int hashCode() {
            int result = ((Object)this.nodes).hashCode();
            result = result * 31 + ((Object)this.edges).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GraphJson)) {
                return false;
            }
            GraphJson graphJson = (GraphJson)other;
            if (!Intrinsics.areEqual(this.nodes, graphJson.nodes)) {
                return false;
            }
            return Intrinsics.areEqual(this.edges, graphJson.edges);
        }
    }

    @JsonClass(generateAdapter=false)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/internal/utils/GraphAdapter$GraphViewJson;", "", "sourceKind", "Lcom/autonomousapps/model/source/SourceKind;", "configurationName", "", "graphJson", "Lcom/autonomousapps/internal/utils/GraphAdapter$GraphJson;", "<init>", "(Lcom/autonomousapps/model/source/SourceKind;Ljava/lang/String;Lcom/autonomousapps/internal/utils/GraphAdapter$GraphJson;)V", "getSourceKind", "()Lcom/autonomousapps/model/source/SourceKind;", "getConfigurationName", "()Ljava/lang/String;", "getGraphJson", "()Lcom/autonomousapps/internal/utils/GraphAdapter$GraphJson;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "dependency-analysis-gradle-plugin"})
    public static final class GraphViewJson {
        @NotNull
        private final SourceKind sourceKind;
        @NotNull
        private final String configurationName;
        @NotNull
        private final GraphJson graphJson;

        public GraphViewJson(@NotNull SourceKind sourceKind, @NotNull String configurationName, @NotNull GraphJson graphJson) {
            Intrinsics.checkNotNullParameter((Object)sourceKind, (String)"sourceKind");
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            Intrinsics.checkNotNullParameter((Object)graphJson, (String)"graphJson");
            this.sourceKind = sourceKind;
            this.configurationName = configurationName;
            this.graphJson = graphJson;
        }

        @NotNull
        public final SourceKind getSourceKind() {
            return this.sourceKind;
        }

        @NotNull
        public final String getConfigurationName() {
            return this.configurationName;
        }

        @NotNull
        public final GraphJson getGraphJson() {
            return this.graphJson;
        }

        @NotNull
        public final SourceKind component1() {
            return this.sourceKind;
        }

        @NotNull
        public final String component2() {
            return this.configurationName;
        }

        @NotNull
        public final GraphJson component3() {
            return this.graphJson;
        }

        @NotNull
        public final GraphViewJson copy(@NotNull SourceKind sourceKind, @NotNull String configurationName, @NotNull GraphJson graphJson) {
            Intrinsics.checkNotNullParameter((Object)sourceKind, (String)"sourceKind");
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            Intrinsics.checkNotNullParameter((Object)graphJson, (String)"graphJson");
            return new GraphViewJson(sourceKind, configurationName, graphJson);
        }

        public static /* synthetic */ GraphViewJson copy$default(GraphViewJson graphViewJson, SourceKind sourceKind, String string, GraphJson graphJson, int n, Object object) {
            if ((n & 1) != 0) {
                sourceKind = graphViewJson.sourceKind;
            }
            if ((n & 2) != 0) {
                string = graphViewJson.configurationName;
            }
            if ((n & 4) != 0) {
                graphJson = graphViewJson.graphJson;
            }
            return graphViewJson.copy(sourceKind, string, graphJson);
        }

        @NotNull
        public String toString() {
            return "GraphViewJson(sourceKind=" + this.sourceKind + ", configurationName=" + this.configurationName + ", graphJson=" + this.graphJson + ")";
        }

        public int hashCode() {
            int result = this.sourceKind.hashCode();
            result = result * 31 + this.configurationName.hashCode();
            result = result * 31 + this.graphJson.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GraphViewJson)) {
                return false;
            }
            GraphViewJson graphViewJson = (GraphViewJson)other;
            if (!Intrinsics.areEqual((Object)this.sourceKind, (Object)graphViewJson.sourceKind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configurationName, (Object)graphViewJson.configurationName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.graphJson, (Object)graphViewJson.graphJson);
        }
    }
}

