/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.intermediates.NativeLibDependency;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/tasks/FindNativeLibsTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "androidJni", "Lorg/gradle/api/artifacts/ArtifactCollection;", "setAndroidJni", "", "getAndroidJniFiles", "Lorg/gradle/api/file/FileCollection;", "dylibs", "setMacNativeLibs", "getMacNativeLibs", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "findAndroidNativeDependencies", "", "Lcom/autonomousapps/model/internal/intermediates/NativeLibDependency;", "findMacNativeDependencies", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFindNativeLibsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindNativeLibsTask.kt\ncom/autonomousapps/tasks/FindNativeLibsTask\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 3 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n154#2,13:110\n50#2,3:123\n34#2,4:126\n167#2,2:130\n136#3:132\n136#3:138\n1625#4:133\n1869#4:134\n1870#4:136\n1626#4:137\n1625#4:139\n1869#4:140\n1870#4:142\n1626#4:143\n1#5:135\n1#5:141\n*S KotlinDebug\n*F\n+ 1 FindNativeLibsTask.kt\ncom/autonomousapps/tasks/FindNativeLibsTask\n*L\n62#1:110,13\n62#1:123,3\n62#1:126,4\n62#1:130,2\n68#1:132\n87#1:138\n68#1:133\n68#1:134\n68#1:136\n68#1:137\n87#1:139\n87#1:140\n87#1:142\n87#1:143\n68#1:135\n87#1:141\n*E\n"})
public abstract class FindNativeLibsTask
extends DefaultTask {
    private ArtifactCollection androidJni;
    private ArtifactCollection dylibs;

    public FindNativeLibsTask() {
        this.setDescription("Produces a report of all dependencies that supply native libs");
    }

    public final void setAndroidJni(@NotNull ArtifactCollection androidJni) {
        Intrinsics.checkNotNullParameter((Object)androidJni, (String)"androidJni");
        this.androidJni = androidJni;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @Nullable
    public final FileCollection getAndroidJniFiles() {
        if (this.androidJni == null) {
            return null;
        }
        ArtifactCollection artifactCollection = this.androidJni;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidJni");
            artifactCollection = null;
        }
        return artifactCollection.getArtifactFiles();
    }

    public final void setMacNativeLibs(@NotNull ArtifactCollection dylibs) {
        Intrinsics.checkNotNullParameter((Object)dylibs, (String)"dylibs");
        this.dylibs = dylibs;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @Nullable
    public final FileCollection getMacNativeLibs() {
        if (this.dylibs == null) {
            return null;
        }
        ArtifactCollection artifactCollection = this.dylibs;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dylibs");
            artifactCollection = null;
        }
        return artifactCollection.getArtifactFiles();
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJsonSet_u24default$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        Set<NativeLibDependency> nativeLibDependencies = this.findAndroidNativeDependencies();
        Set<NativeLibDependency> macNativeLibs = this.findMacNativeDependencies();
        Set result = SetsKt.plus(nativeLibDependencies, (Iterable)macNativeLibs);
        File file = outputFile;
        Set set$iv = result;
        boolean compress$iv = false;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        BufferedSink buffer$iv = Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null));
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)buffer$iv);
        Throwable throwable = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            Type[] typeArray = new Type[]{NativeLibDependency.class};
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
            Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
            typeArray = typeArray2;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)set$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<NativeLibDependency> findAndroidNativeDependencies() {
        void $this$mapNotNullTo$iv$iv;
        if (this.androidJni == null) {
            return SetsKt.emptySet();
        }
        ArtifactCollection artifactCollection = this.androidJni;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidJni");
            artifactCollection = null;
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NativeLibDependency it$iv$iv;
            NativeLibDependency nativeLibDependency;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult jniDep = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            File file = jniDep.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            SortedSet soFiles = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkBottomUp((File)file)), FindNativeLibsTask::findAndroidNativeDependencies$lambda$2$lambda$0), FindNativeLibsTask::findAndroidNativeDependencies$lambda$2$lambda$1));
            try {
                Intrinsics.checkNotNull((Object)jniDep);
                nativeLibDependency = NativeLibDependency.Companion.newInstance(GradleStringsKt.toCoordinates(jniDep), soFiles);
            }
            catch (GradleException gradleException) {
                nativeLibDependency = null;
            }
            if (nativeLibDependency == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<NativeLibDependency> findMacNativeDependencies() {
        void $this$mapNotNullTo$iv$iv;
        if (this.dylibs == null) {
            return SetsKt.emptySet();
        }
        ArtifactCollection artifactCollection = this.dylibs;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dylibs");
            artifactCollection = null;
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NativeLibDependency nativeLibDependency;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult maybeMacArtifact = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            File file = maybeMacArtifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            SortedSet dylibs = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkBottomUp((File)file)), FindNativeLibsTask::findMacNativeDependencies$lambda$6$lambda$3), FindNativeLibsTask::findMacNativeDependencies$lambda$6$lambda$4), FindNativeLibsTask::findMacNativeDependencies$lambda$6$lambda$5));
            if (!((Collection)dylibs).isEmpty()) {
                NativeLibDependency nativeLibDependency2;
                try {
                    Intrinsics.checkNotNull((Object)maybeMacArtifact);
                    nativeLibDependency2 = NativeLibDependency.Companion.newInstance(GradleStringsKt.toCoordinates(maybeMacArtifact), dylibs);
                }
                catch (GradleException gradleException) {
                    nativeLibDependency2 = null;
                }
                nativeLibDependency = nativeLibDependency2;
            } else {
                nativeLibDependency = null;
            }
            if (nativeLibDependency == null) continue;
            NativeLibDependency it$iv$iv = nativeLibDependency;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Set)destination$iv$iv;
    }

    private static final boolean findAndroidNativeDependencies$lambda$2$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final String findAndroidNativeDependencies$lambda$2$lambda$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final boolean findMacNativeDependencies$lambda$6$lambda$3(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final String findMacNativeDependencies$lambda$6$lambda$4(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final boolean findMacNativeDependencies$lambda$6$lambda$5(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.endsWith$default((String)it, (String)".dylib", (boolean)false, (int)2, null);
    }
}

