/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.extension.ReportingHandler;
import com.autonomousapps.extension.ReportingHandlerKt;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.advice.ProjectHealthConsoleReportBuilder;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import java.io.Closeable;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\t\u00a8\u0006 "}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "<init>", "(Lorg/gradle/workers/WorkerExecutor;)V", "projectAdvice", "Lorg/gradle/api/file/RegularFileProperty;", "getProjectAdvice", "()Lorg/gradle/api/file/RegularFileProperty;", "reportingConfig", "Lorg/gradle/api/provider/Property;", "Lcom/autonomousapps/extension/ReportingHandler$Config;", "getReportingConfig", "()Lorg/gradle/api/provider/Property;", "dslKind", "Lcom/autonomousapps/internal/advice/DslKind;", "getDslKind", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "useTypesafeProjectAccessors", "", "getUseTypesafeProjectAccessors", "output", "getOutput", "action", "", "ProjectHealthParameters", "ProjectHealthAction", "dependency-analysis-gradle-plugin"})
public abstract class GenerateProjectHealthReportTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;

    @Inject
    public GenerateProjectHealthReportTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setDescription("Generates console report for project health");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @Nested
    @NotNull
    public abstract Property<ReportingHandler.Config> getReportingConfig();

    @Input
    @NotNull
    public abstract Property<DslKind> getDslKind();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @Input
    @NotNull
    public abstract Property<Boolean> getUseTypesafeProjectAccessors();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(ProjectHealthAction.class, arg_0 -> GenerateProjectHealthReportTask.action$lambda$1(arg_0 -> GenerateProjectHealthReportTask.action$lambda$0(this, arg_0), arg_0));
    }

    private static final Unit action$lambda$0(GenerateProjectHealthReportTask this$0, ProjectHealthParameters it) {
        it.getAdvice().set((Provider)this$0.getProjectAdvice());
        it.getReportingConfig().set((Provider)this$0.getReportingConfig());
        it.getDslKind().set((Provider)this$0.getDslKind());
        it.getDependencyMap().set((Provider)this$0.getDependencyMap());
        it.getUseTypesafeProjectAccessors().set((Provider)this$0.getUseTypesafeProjectAccessors());
        it.getOutput().set((Provider)this$0.getOutput());
        return Unit.INSTANCE;
    }

    private static final void action$lambda$1(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthParameters;", "<init>", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nGenerateProjectHealthReportTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateProjectHealthReportTask.kt\ncom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthAction\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,92:1\n142#2,13:93\n41#3,2:106\n34#3,4:108\n*S KotlinDebug\n*F\n+ 1 GenerateProjectHealthReportTask.kt\ncom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthAction\n*L\n79#1:93,13\n79#1:106,2\n79#1:108,4\n*E\n"})
    public static abstract class ProjectHealthAction
    implements WorkAction<ProjectHealthParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            Object object;
            File output = UtilsKt.getAndDelete(((ProjectHealthParameters)this.getParameters()).getOutput());
            RegularFileProperty $this$fromJson$iv = ((ProjectHealthParameters)this.getParameters()).getAdvice();
            boolean $i$f$fromJson = false;
            Object object2 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable throwable = null;
            try {
                void $this$withNulls$iv$iv$iv$iv$iv;
                BufferedSource reader$iv$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter jsonAdapter2 = jsonAdapter;
                boolean withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                boolean $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                object = object3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ProjectAdvice projectAdvice = (ProjectAdvice)object;
            Object object4 = ((ProjectHealthParameters)this.getParameters()).getReportingConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            String string = ReportingHandlerKt.getEffectivePostscript((ReportingHandler.Config)object4, projectAdvice.getShouldFail());
            Object object5 = ((ProjectHealthParameters)this.getParameters()).getDslKind().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
            DslKind dslKind = (DslKind)((Object)object5);
            Object object6 = ((ProjectHealthParameters)this.getParameters()).getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            Function1<String, String> function1 = DependenciesHandler.Companion.toLambda((Map)object6);
            Object object7 = ((ProjectHealthParameters)this.getParameters()).getUseTypesafeProjectAccessors().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
            String consoleText = new ProjectHealthConsoleReportBuilder(projectAdvice, string, dslKind, function1, (Boolean)object7).getText();
            FilesKt.writeText$default((File)output, (String)consoleText, null, (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u0012\u0010\u0016\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthParameters;", "Lorg/gradle/workers/WorkParameters;", "advice", "Lorg/gradle/api/file/RegularFileProperty;", "getAdvice", "()Lorg/gradle/api/file/RegularFileProperty;", "reportingConfig", "Lorg/gradle/api/provider/Property;", "Lcom/autonomousapps/extension/ReportingHandler$Config;", "getReportingConfig", "()Lorg/gradle/api/provider/Property;", "dslKind", "Lcom/autonomousapps/internal/advice/DslKind;", "getDslKind", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "useTypesafeProjectAccessors", "", "getUseTypesafeProjectAccessors", "output", "getOutput", "dependency-analysis-gradle-plugin"})
    public static interface ProjectHealthParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getAdvice();

        @NotNull
        public Property<ReportingHandler.Config> getReportingConfig();

        @NotNull
        public Property<DslKind> getDslKind();

        @NotNull
        public MapProperty<String, String> getDependencyMap();

        @NotNull
        public Property<Boolean> getUseTypesafeProjectAccessors();

        @NotNull
        public RegularFileProperty getOutput();
    }
}

