/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.graph.GraphsKt;
import com.autonomousapps.internal.utils.GraphAdapter;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.ProjectCoordinates;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/tasks/GenerateWorkPlan;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "buildPath", "Lorg/gradle/api/provider/Property;", "", "getBuildPath", "()Lorg/gradle/api/provider/Property;", "combinedProjectGraphs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCombinedProjectGraphs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "action", "", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateWorkPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateWorkPlan.kt\ncom/autonomousapps/tasks/GenerateWorkPlan\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,79:1\n1563#2:80\n1634#2,2:81\n1636#2:91\n2783#2,7:92\n827#2:99\n855#2,2:100\n1869#2,2:102\n153#3,2:83\n41#4,2:85\n34#4,4:87\n177#4,3:104\n41#4,2:107\n34#4,4:109\n180#4,2:113\n*S KotlinDebug\n*F\n+ 1 GenerateWorkPlan.kt\ncom/autonomousapps/tasks/GenerateWorkPlan\n*L\n48#1:80\n48#1:81,2\n48#1:91\n49#1:92,7\n64#1:99\n64#1:100,2\n65#1:102,2\n48#1:83,2\n48#1:85,2\n48#1:87,4\n71#1:104,3\n71#1:107,2\n71#1:109,4\n71#1:113,2\n*E\n"})
public abstract class GenerateWorkPlan
extends DefaultTask {
    public GenerateWorkPlan() {
        this.setDescription("Generates work plan for fixing dependency issues with minimal conflict");
    }

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getCombinedProjectGraphs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        String string;
        void $this$bufferWriteJson_u24default$iv;
        void $this$forEach$iv;
        Iterator $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Graph acc;
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Provider provider = this.getOutputDirectory().file("combined-graph.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        File combinedGraphOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider);
        Provider provider2 = this.getOutputDirectory().file("combined-graph.gz");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"file(...)");
        File combinedGraphDotOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider2);
        Provider provider3 = this.getOutputDirectory().file("work-plan.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"file(...)");
        File workPlanJsonOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider3);
        Provider provider4 = this.getOutputDirectory().file("work-plan.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"file(...)");
        File workPlanTextOut = UtilsKt.getAndDelete((Provider<RegularFile>)provider4);
        Set set = this.getCombinedProjectGraphs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        Iterable iterable = set;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object reader$iv;
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            void $this$fromJson$iv = it;
            boolean $i$f$fromJson = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead((File)$this$fromJson$iv);
            Throwable throwable = null;
            try {
                void $this$withNulls$iv$iv$iv;
                reader$iv = (BufferedSource)closeable;
                boolean bl2 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(GraphAdapter.GraphContainer.class), (String)"adapter(...)");
                boolean withNulls$iv$iv$iv = withNulls$iv$iv;
                boolean $i$f$withNulls = false;
                Object object = $this$withNulls$iv$iv$iv.fromJson(reader$iv);
                Intrinsics.checkNotNull((Object)object);
                reader$iv = object;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            collection.add(((GraphAdapter.GraphContainer)reader$iv).getGraph());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void graph;
            Graph $i$f$mapTo2 = (Graph)iterator$iv.next();
            acc = (Graph)accumulator$iv;
            boolean bl = false;
            accumulator$iv = GraphsKt.plus(acc, graph);
        }
        Graph combinedGraph = (Graph)accumulator$iv;
        Object object = this.getBuildPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        GraphWriter graphWriter = new GraphWriter((String)object);
        ProjectCoordinates rootProject = new ProjectCoordinates(":", GradleVariantIdentification.Companion.getEMPTY(), (String)this.getBuildPath().get());
        ImmutableGraph.Builder graphBuilder = GraphsKt.newGraphBuilder();
        accumulator$iv = Graphs.INSTANCE.roots(combinedGraph);
        boolean $i$f$filterNot = false;
        acc = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator bl = $this$filterNotTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            Coordinates it = (Coordinates)element$iv$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it.getIdentifier(), (Object)":")) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Coordinates root = (Coordinates)element$iv;
            boolean bl4 = false;
            graphBuilder.putEdge((Object)new ProjectCoordinates(":", GradleVariantIdentification.Companion.getEMPTY(), null, 4, null), (Object)root);
        }
        ImmutableGraph immutableGraph = graphBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"build(...)");
        Graph finalGraph = GraphsKt.plus((Graph)immutableGraph, combinedGraph);
        FilesKt.writeText$default((File)combinedGraphDotOut, (String)graphWriter.toDot(finalGraph), null, (int)2, null);
        File $i$f$forEach22 = combinedGraphOut;
        GraphAdapter.GraphContainer obj$iv = new GraphAdapter.GraphContainer(finalGraph);
        String indent$iv = "";
        boolean $i$f$bufferWriteJson = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl5 = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(GraphAdapter.GraphContainer.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
            JsonAdapter bl2 = jsonAdapter;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)obj$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String it = string = graphWriter.workPlan(finalGraph);
        boolean bl6 = false;
        this.getLogger().quiet("[INCUBATING] Work plan:\n" + it);
    }
}

