/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.parse.SourceListener;
import com.autonomousapps.model.internal.CodeSource;
import com.autonomousapps.model.internal.intermediates.consumer.ExplodingSourceCode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/tasks/SourceExploder;", "", "projectDir", "Ljava/io/File;", "groovySourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "javaSourceFiles", "kotlinSourceFiles", "scalaSourceFiles", "<init>", "(Ljava/io/File;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/ConfigurableFileCollection;)V", "explode", "", "Lcom/autonomousapps/model/internal/intermediates/consumer/ExplodingSourceCode;", "relativize", "", "file", "canonicalClassName", "relativePath", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCodeSourceExploderTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeSourceExploderTask.kt\ncom/autonomousapps/tasks/SourceExploder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1634#2,3:233\n1634#2,3:236\n1634#2,3:239\n1634#2,3:242\n*S KotlinDebug\n*F\n+ 1 CodeSourceExploderTask.kt\ncom/autonomousapps/tasks/SourceExploder\n*L\n180#1:233,3\n189#1:236,3\n198#1:239,3\n207#1:242,3\n*E\n"})
final class SourceExploder {
    @NotNull
    private final File projectDir;
    @NotNull
    private final ConfigurableFileCollection groovySourceFiles;
    @NotNull
    private final ConfigurableFileCollection javaSourceFiles;
    @NotNull
    private final ConfigurableFileCollection kotlinSourceFiles;
    @NotNull
    private final ConfigurableFileCollection scalaSourceFiles;

    public SourceExploder(@NotNull File projectDir, @NotNull ConfigurableFileCollection groovySourceFiles, @NotNull ConfigurableFileCollection javaSourceFiles, @NotNull ConfigurableFileCollection kotlinSourceFiles, @NotNull ConfigurableFileCollection scalaSourceFiles) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)groovySourceFiles, (String)"groovySourceFiles");
        Intrinsics.checkNotNullParameter((Object)javaSourceFiles, (String)"javaSourceFiles");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceFiles, (String)"kotlinSourceFiles");
        Intrinsics.checkNotNullParameter((Object)scalaSourceFiles, (String)"scalaSourceFiles");
        this.projectDir = projectDir;
        this.groovySourceFiles = groovySourceFiles;
        this.javaSourceFiles = javaSourceFiles;
        this.kotlinSourceFiles = kotlinSourceFiles;
        this.scalaSourceFiles = scalaSourceFiles;
    }

    @NotNull
    public final Set<ExplodingSourceCode> explode() {
        String rel;
        File f;
        Collection collection;
        Iterable $this$mapTo$iv;
        TreeSet destination = SetsKt.sortedSetOf((Object[])new ExplodingSourceCode[0]);
        Iterable iterable = (Iterable)this.javaSourceFiles;
        Collection destination$iv = destination;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            File file = (File)item$iv;
            collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)f);
            rel = this.relativize(f);
            collection.add(new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.JAVA, SourceListener.Companion.parseSourceFileForImports(f)));
        }
        $this$mapTo$iv = (Iterable)this.kotlinSourceFiles;
        destination$iv = destination;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            f = (File)item$iv;
            collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)f);
            rel = this.relativize(f);
            collection.add(new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.KOTLIN, SourceListener.Companion.parseSourceFileForImports(f)));
        }
        $this$mapTo$iv = (Iterable)this.groovySourceFiles;
        destination$iv = destination;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            f = (File)item$iv;
            collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)f);
            rel = this.relativize(f);
            collection.add(new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.GROOVY, SourceListener.Companion.parseSourceFileForImports(f)));
        }
        $this$mapTo$iv = (Iterable)this.scalaSourceFiles;
        destination$iv = destination;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            f = (File)item$iv;
            collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)f);
            rel = this.relativize(f);
            collection.add(new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.SCALA, SourceListener.Companion.parseSourceFileForImports(f)));
        }
        return destination;
    }

    private final String relativize(File file) {
        return FilesKt.toRelativeString((File)file, (File)this.projectDir);
    }

    private final String canonicalClassName(String relativePath) {
        Path path = Paths.get(relativePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return StringsKt.substringBeforeLast$default((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)path, (int)3), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), (char)'.', null, (int)2, null);
    }
}

