/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.extension;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Named;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.api.provider.SetProperty;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\u000e\u0010\t\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0014\u0010\t\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\t\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0003J\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0017J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0014\u0010\u001a\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\u001a\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0017J\u0010\u0010\u001b\u001a\u00020\u00122\b\b\u0001\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000fJ\u0012\u0010\u0013\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0012\u0010\u0019\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/autonomousapps/extension/BundleHandler;", "Lorg/gradle/api/Named;", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "<init>", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;)V", "getName", "primary", "Lorg/gradle/api/provider/Property;", "getPrimary", "()Lorg/gradle/api/provider/Property;", "includes", "Lorg/gradle/api/provider/SetProperty;", "Lkotlin/text/Regex;", "getIncludes", "()Lorg/gradle/api/provider/SetProperty;", "", "identifier", "module", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/artifacts/MinimalExternalModuleDependency;", "Lorg/gradle/api/provider/ProviderConvertible;", "includeGroup", "group", "includeDependency", "include", "regex", "dependency-analysis-gradle-plugin"})
public abstract class BundleHandler
implements Named {
    @NotNull
    private final String name;
    @NotNull
    private final Property<String> primary;
    @NotNull
    private final SetProperty<Regex> includes;

    @Inject
    public BundleHandler(@NotNull String name, @NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.name = name;
        Property property = objects.property(String.class).convention((Object)"");
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"convention(...)");
        this.primary = property;
        SetProperty setProperty = objects.setProperty(Regex.class).convention((Iterable)SetsKt.emptySet());
        Intrinsics.checkNotNullExpressionValue((Object)setProperty, (String)"convention(...)");
        this.includes = setProperty;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Property<String> getPrimary() {
        return this.primary;
    }

    @NotNull
    public final SetProperty<Regex> getIncludes() {
        return this.includes;
    }

    public final void primary(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.primary.set((Object)identifier);
        this.primary.disallowChanges();
        this.includeDependency(identifier);
    }

    public final void primary(@NotNull Provider<MinimalExternalModuleDependency> module) {
        Intrinsics.checkNotNullParameter(module, (String)"module");
        this.primary(this.identifier(module));
    }

    public final void primary(@NotNull ProviderConvertible<MinimalExternalModuleDependency> module) {
        Intrinsics.checkNotNullParameter(module, (String)"module");
        Provider provider = module.asProvider();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"asProvider(...)");
        this.primary((Provider<MinimalExternalModuleDependency>)provider);
    }

    public final void includeGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.include("^" + group + ":.*");
    }

    public final void includeGroup(@NotNull Provider<MinimalExternalModuleDependency> module) {
        Intrinsics.checkNotNullParameter(module, (String)"module");
        this.includeGroup(this.group(module));
    }

    public final void includeGroup(@NotNull ProviderConvertible<MinimalExternalModuleDependency> module) {
        Intrinsics.checkNotNullParameter(module, (String)"module");
        Provider provider = module.asProvider();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"asProvider(...)");
        this.includeGroup((Provider<MinimalExternalModuleDependency>)provider);
    }

    public final void includeDependency(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.include("^" + identifier + "$");
        if (!StringsKt.endsWith$default((String)identifier, (String)"-jvm", (boolean)false, (int)2, null)) {
            this.include("^" + identifier + "-jvm$");
        }
        if (!StringsKt.endsWith$default((String)identifier, (String)"-android", (boolean)false, (int)2, null)) {
            this.include("^" + identifier + "-android$");
        }
    }

    public final void includeDependency(@NotNull Provider<MinimalExternalModuleDependency> module) {
        Intrinsics.checkNotNullParameter(module, (String)"module");
        this.includeDependency(this.identifier(module));
    }

    public final void includeDependency(@NotNull ProviderConvertible<MinimalExternalModuleDependency> module) {
        Intrinsics.checkNotNullParameter(module, (String)"module");
        Provider provider = module.asProvider();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"asProvider(...)");
        this.includeDependency((Provider<MinimalExternalModuleDependency>)provider);
    }

    public final void include(@Language(value="RegExp") @NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.include(new Regex(regex));
    }

    public final void include(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.includes.add((Object)regex);
    }

    private final String identifier(Provider<MinimalExternalModuleDependency> $this$identifier) {
        Object object = $this$identifier.map(arg_0 -> BundleHandler.identifier$lambda$1(BundleHandler::identifier$lambda$0, arg_0)).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (String)object;
    }

    private final String group(Provider<MinimalExternalModuleDependency> $this$group) {
        Object object = $this$group.map(arg_0 -> BundleHandler.group$lambda$3(BundleHandler::group$lambda$2, arg_0)).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (String)object;
    }

    private static final String identifier$lambda$0(MinimalExternalModuleDependency it) {
        return it.getGroup() + ":" + it.getName();
    }

    private static final String identifier$lambda$1(Function1 $tmp0, Object in) {
        return (String)$tmp0.invoke(in);
    }

    private static final String group$lambda$2(MinimalExternalModuleDependency it) {
        String string = it.getGroup();
        if (string == null) {
            throw new IllegalStateException(("No group for " + it).toString());
        }
        return string;
    }

    private static final String group$lambda$3(Function1 $tmp0, Object in) {
        return (String)$tmp0.invoke(in);
    }
}

