/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.subplugin;

import com.autonomousapps.DependencyAnalysisExtension;
import com.autonomousapps.Flags;
import com.autonomousapps.artifacts.ArtifactDescription;
import com.autonomousapps.artifacts.Publisher;
import com.autonomousapps.artifacts.Resolver;
import com.autonomousapps.internal.RootOutputPaths;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.artifacts.DagpArtifacts;
import com.autonomousapps.internal.utils.LoggingKt;
import com.autonomousapps.internal.utils.project.ProjectsKt;
import com.autonomousapps.services.GlobalDslService;
import com.autonomousapps.subplugin.RootPlugin;
import com.autonomousapps.tasks.BuildHealthTask;
import com.autonomousapps.tasks.ComputeAllDependenciesTask;
import com.autonomousapps.tasks.ComputeDuplicateDependenciesTask;
import com.autonomousapps.tasks.GenerateBuildHealthTask;
import com.autonomousapps.tasks.GenerateWorkPlan;
import com.autonomousapps.tasks.PrintDuplicateDependenciesTask;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\f\u0010\u0016\u001a\u00020\u0013*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/subplugin/RootPlugin;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "dagpExtension", "Lcom/autonomousapps/DependencyAnalysisExtension;", "dslService", "Lorg/gradle/api/provider/Provider;", "Lcom/autonomousapps/services/GlobalDslService;", "getDslService$annotations", "()V", "adviceResolver", "Lcom/autonomousapps/artifacts/Resolver;", "Lorg/gradle/api/Named;", "combinedGraphResolver", "resolvedDepsResolver", "apply", "", "checkFlags", "checkGuava", "configureRootProject", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRootPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootPlugin.kt\ncom/autonomousapps/subplugin/RootPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1869#2,2:158\n*S KotlinDebug\n*F\n+ 1 RootPlugin.kt\ncom/autonomousapps/subplugin/RootPlugin\n*L\n148#1:158,2\n*E\n"})
public final class RootPlugin {
    @NotNull
    private final Project project;
    @NotNull
    private final DependencyAnalysisExtension dagpExtension;
    @NotNull
    private final Provider<GlobalDslService> dslService;
    @NotNull
    private final Resolver<? extends Named> adviceResolver;
    @NotNull
    private final Resolver<? extends Named> combinedGraphResolver;
    @NotNull
    private final Resolver<? extends Named> resolvedDepsResolver;

    /*
     * WARNING - void declaration
     */
    public RootPlugin(@NotNull Project project) {
        void $this$dslService_u24lambda_u242;
        Provider<GlobalDslService> provider;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!Intrinsics.areEqual((Object)this.project, (Object)this.project.getRootProject())) {
            boolean $i$a$-check-RootPlugin$22 = false;
            String $i$a$-check-RootPlugin$22 = "This plugin must only be applied to the root project. Was " + this.project.getPath() + ".";
            throw new IllegalStateException($i$a$-check-RootPlugin$22.toString());
        }
        this.dagpExtension = DependencyAnalysisExtension.Companion.of(this.project);
        Provider<GlobalDslService> $i$a$-check-RootPlugin$22 = provider = GlobalDslService.Companion.of(this.project);
        RootPlugin rootPlugin = this;
        boolean bl = false;
        Object object = $this$dslService_u24lambda_u242.get();
        GlobalDslService $this$dslService_u24lambda_u242_u24lambda_u241 = (GlobalDslService)object;
        boolean bl2 = false;
        $this$dslService_u24lambda_u242_u24lambda_u241.setRegisteredOnRoot$dependency_analysis_gradle_plugin();
        $this$dslService_u24lambda_u242_u24lambda_u241.withVersionCatalogs$dependency_analysis_gradle_plugin(this.project);
        rootPlugin.dslService = provider;
        this.adviceResolver = Resolver.Companion.interProjectResolver(this.project, (ArtifactDescription)DagpArtifacts.Kind.PROJECT_HEALTH);
        this.combinedGraphResolver = Resolver.Companion.interProjectResolver(this.project, (ArtifactDescription)DagpArtifacts.Kind.COMBINED_GRAPH);
        this.resolvedDepsResolver = Resolver.Companion.interProjectResolver(this.project, (ArtifactDescription)DagpArtifacts.Kind.RESOLVED_DEPS);
    }

    private static /* synthetic */ void getDslService$annotations() {
    }

    public final void apply() {
        Project $this$apply_u24lambda_u243 = this.project;
        boolean bl = false;
        Logger logger = $this$apply_u24lambda_u243.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LoggingKt.log(logger, "Adding root project tasks");
        this.checkFlags($this$apply_u24lambda_u243);
        this.checkGuava();
        this.configureRootProject($this$apply_u24lambda_u243);
    }

    private final void checkFlags(Project $this$checkFlags) {
        Provider autoApply = $this$checkFlags.getProviders().gradleProperty("dependency.analysis.autoapply");
        if (autoApply.isPresent()) {
            if (Boolean.parseBoolean((String)autoApply.get())) {
                throw new IllegalStateException("dependency.analysis.autoapply is set to true, but this has no effect. To automatically apply Dependency Analysis Gradle \nPlugin  to every project in your build, apply the `com.autonomousapps.build-health` plugin to your settings script.".toString());
            }
            $this$checkFlags.getLogger().warn("dependency.analysis.autoapply is set to false, but this is now the only behavior, and the flag has no effect. You should\nremove it from your build scripts.");
        }
    }

    private final void checkGuava() {
        ((GlobalDslService)this.dslService.get()).verifyValidGuavaVersion$dependency_analysis_gradle_plugin();
    }

    private final void configureRootProject(Project $this$configureRootProject) {
        RootOutputPaths paths = new RootOutputPaths($this$configureRootProject);
        TaskProvider computeDuplicatesTask = $this$configureRootProject.getTasks().register("computeDuplicateDependencies", ComputeDuplicateDependenciesTask.class, arg_0 -> RootPlugin.configureRootProject$lambda$5(arg_0 -> RootPlugin.configureRootProject$lambda$4(this, paths, arg_0), arg_0));
        $this$configureRootProject.getTasks().register("printDuplicateDependencies", PrintDuplicateDependenciesTask.class, arg_0 -> RootPlugin.configureRootProject$lambda$9(arg_0 -> RootPlugin.configureRootProject$lambda$8(computeDuplicatesTask, arg_0), arg_0));
        $this$configureRootProject.getTasks().register("computeAllDependencies", ComputeAllDependenciesTask.class, arg_0 -> RootPlugin.configureRootProject$lambda$11(arg_0 -> RootPlugin.configureRootProject$lambda$10(this, paths, arg_0), arg_0));
        TaskProvider generateBuildHealthTask2 = $this$configureRootProject.getTasks().register("generateBuildHealth", GenerateBuildHealthTask.class, arg_0 -> RootPlugin.configureRootProject$lambda$14(arg_0 -> RootPlugin.configureRootProject$lambda$13(this, $this$configureRootProject, paths, arg_0), arg_0));
        $this$configureRootProject.getTasks().register("buildHealth", BuildHealthTask.class, arg_0 -> RootPlugin.configureRootProject$lambda$22(arg_0 -> RootPlugin.configureRootProject$lambda$21(generateBuildHealthTask2, this, $this$configureRootProject, arg_0), arg_0));
        $this$configureRootProject.getTasks().register("generateWorkPlan", GenerateWorkPlan.class, arg_0 -> RootPlugin.configureRootProject$lambda$25(arg_0 -> RootPlugin.configureRootProject$lambda$24($this$configureRootProject, this, paths, arg_0), arg_0));
        Publisher combinedGraphPublisher = Publisher.Companion.interProjectPublisher($this$configureRootProject, (ArtifactDescription)DagpArtifacts.Kind.COMBINED_GRAPH);
        Publisher projectHealthPublisher = Publisher.Companion.interProjectPublisher($this$configureRootProject, (ArtifactDescription)DagpArtifacts.Kind.PROJECT_HEALTH);
        Publisher resolvedDependenciesPublisher = Publisher.Companion.interProjectPublisher($this$configureRootProject, (ArtifactDescription)DagpArtifacts.Kind.RESOLVED_DEPS);
        Set set = $this$configureRootProject.getAllprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllprojects(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project p = (Project)element$iv;
            boolean bl = false;
            DependencyHandler d = $this$configureRootProject.getDependencies();
            boolean bl2 = false;
            d.add(combinedGraphPublisher.getDeclarableName(), (Object)d.project(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)p.getPath()))));
            d.add(projectHealthPublisher.getDeclarableName(), (Object)d.project(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)p.getPath()))));
            d.add(resolvedDependenciesPublisher.getDeclarableName(), (Object)d.project(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)p.getPath()))));
        }
    }

    private static final Unit configureRootProject$lambda$4(RootPlugin this$0, RootOutputPaths $paths, ComputeDuplicateDependenciesTask it) {
        Object[] objectArray = new Object[]{this$0.resolvedDepsResolver.artifactFilesProvider()};
        it.getResolvedDependenciesReports().setFrom(objectArray);
        it.getOutput().set($paths.getDuplicateDependenciesPath());
        return Unit.INSTANCE;
    }

    private static final void configureRootProject$lambda$5(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Provider configureRootProject$lambda$8$lambda$6(ComputeDuplicateDependenciesTask it) {
        return (Provider)it.getOutput();
    }

    private static final Provider configureRootProject$lambda$8$lambda$7(Function1 $tmp0, Object in) {
        return (Provider)$tmp0.invoke(in);
    }

    private static final Unit configureRootProject$lambda$8(TaskProvider $computeDuplicatesTask, PrintDuplicateDependenciesTask it) {
        it.getDuplicateDependenciesReport().set($computeDuplicatesTask.flatMap(arg_0 -> RootPlugin.configureRootProject$lambda$8$lambda$7(RootPlugin::configureRootProject$lambda$8$lambda$6, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void configureRootProject$lambda$9(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit configureRootProject$lambda$10(RootPlugin this$0, RootOutputPaths $paths, ComputeAllDependenciesTask it) {
        Object[] objectArray = new Object[]{this$0.resolvedDepsResolver.artifactFilesProvider()};
        it.getResolvedDependenciesReports().setFrom(objectArray);
        it.getOutput().set($paths.getAllLibsVersionsTomlPath());
        return Unit.INSTANCE;
    }

    private static final void configureRootProject$lambda$11(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final FileCollection configureRootProject$lambda$13$lambda$12(Function1 $tmp0, Object in) {
        return (FileCollection)$tmp0.invoke(in);
    }

    private static final Unit configureRootProject$lambda$13(RootPlugin this$0, Project $this_configureRootProject, RootOutputPaths $paths, GenerateBuildHealthTask it) {
        Object[] objectArray = new Object[]{this$0.adviceResolver.getInternal().map(arg_0 -> RootPlugin.configureRootProject$lambda$13$lambda$12(configureRootProject.generateBuildHealthTask.1.1.INSTANCE, arg_0))};
        it.getProjectHealthReports().setFrom(objectArray);
        it.getReportingConfig().set((Object)this$0.dagpExtension.getReportingHandler$dependency_analysis_gradle_plugin().config$dependency_analysis_gradle_plugin());
        it.getProjectCount().set((Object)$this_configureRootProject.getAllprojects().size());
        Property<DslKind> property = it.getDslKind();
        File file = $this_configureRootProject.getBuildFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildFile(...)");
        property.set((Object)DslKind.Companion.from(file));
        it.getDependencyMap().set((Provider)this$0.dagpExtension.getDependenciesHandler$dependency_analysis_gradle_plugin().getMap());
        it.getUseTypesafeProjectAccessors().set((Provider)this$0.dagpExtension.getUseTypesafeProjectAccessors$dependency_analysis_gradle_plugin());
        it.getOutput().set($paths.getBuildHealthPath());
        it.getConsoleOutput().set($paths.getConsoleReportPath());
        it.getOutputFail().set($paths.getShouldFailPath());
        return Unit.INSTANCE;
    }

    private static final void configureRootProject$lambda$14(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Provider configureRootProject$lambda$21$lambda$15(GenerateBuildHealthTask it) {
        return (Provider)it.getOutputFail();
    }

    private static final Provider configureRootProject$lambda$21$lambda$16(Function1 $tmp0, Object in) {
        return (Provider)$tmp0.invoke(in);
    }

    private static final Provider configureRootProject$lambda$21$lambda$17(GenerateBuildHealthTask it) {
        return (Provider)it.getOutput();
    }

    private static final Provider configureRootProject$lambda$21$lambda$18(Function1 $tmp0, Object in) {
        return (Provider)$tmp0.invoke(in);
    }

    private static final Provider configureRootProject$lambda$21$lambda$19(GenerateBuildHealthTask it) {
        return (Provider)it.getConsoleOutput();
    }

    private static final Provider configureRootProject$lambda$21$lambda$20(Function1 $tmp0, Object in) {
        return (Provider)$tmp0.invoke(in);
    }

    private static final Unit configureRootProject$lambda$21(TaskProvider $generateBuildHealthTask, RootPlugin this$0, Project $this_configureRootProject, BuildHealthTask it) {
        it.getShouldFail().set($generateBuildHealthTask.flatMap(arg_0 -> RootPlugin.configureRootProject$lambda$21$lambda$16(RootPlugin::configureRootProject$lambda$21$lambda$15, arg_0)));
        it.getBuildHealth().set($generateBuildHealthTask.flatMap(arg_0 -> RootPlugin.configureRootProject$lambda$21$lambda$18(RootPlugin::configureRootProject$lambda$21$lambda$17, arg_0)));
        it.getConsoleReport().set($generateBuildHealthTask.flatMap(arg_0 -> RootPlugin.configureRootProject$lambda$21$lambda$20(RootPlugin::configureRootProject$lambda$21$lambda$19, arg_0)));
        it.getPrintBuildHealth().set(this$0.dagpExtension.getReportingHandler$dependency_analysis_gradle_plugin().getPrintBuildHealth$dependency_analysis_gradle_plugin().orElse((Object)Flags.INSTANCE.printBuildHealth$dependency_analysis_gradle_plugin($this_configureRootProject)));
        it.getPostscript().set((Provider)this$0.dagpExtension.getReportingHandler$dependency_analysis_gradle_plugin().getPostscript$dependency_analysis_gradle_plugin());
        return Unit.INSTANCE;
    }

    private static final void configureRootProject$lambda$22(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final FileCollection configureRootProject$lambda$24$lambda$23(Function1 $tmp0, Object in) {
        return (FileCollection)$tmp0.invoke(in);
    }

    private static final Unit configureRootProject$lambda$24(Project $this_configureRootProject, RootPlugin this$0, RootOutputPaths $paths, GenerateWorkPlan it) {
        Property<String> property = it.getBuildPath();
        String string = this$0.combinedGraphResolver.getInternal().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        property.set(ProjectsKt.buildPath($this_configureRootProject, string));
        Object[] objectArray = new Object[]{this$0.combinedGraphResolver.getInternal().map(arg_0 -> RootPlugin.configureRootProject$lambda$24$lambda$23(configureRootProject.4.1.INSTANCE, arg_0))};
        it.getCombinedProjectGraphs().setFrom(objectArray);
        it.getOutputDirectory().set($paths.getWorkPlanDir());
        return Unit.INSTANCE;
    }

    private static final void configureRootProject$lambda$25(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }
}

