/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencySizeTree;
import com.autonomousapps.graph.DominanceTree;
import com.autonomousapps.graph.DominanceTreeDataWriter;
import com.autonomousapps.graph.DominanceTreeWriter;
import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.utils.FileUtils;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.IncludedBuildCoordinates;
import com.autonomousapps.model.ProjectCoordinates;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.autonomousapps.model.internal.PhysicalArtifact;
import com.google.common.graph.Graph;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "buildPath", "Lorg/gradle/api/provider/Property;", "", "getBuildPath", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "physicalArtifacts", "Lorg/gradle/api/file/RegularFileProperty;", "getPhysicalArtifacts", "()Lorg/gradle/api/file/RegularFileProperty;", "graphView", "getGraphView", "outputTxt", "getOutputTxt", "outputDot", "getOutputDot", "outputJson", "getOutputJson", "action", "", "BySize", "Companion", "dependency-analysis-gradle-plugin"})
public abstract class ComputeDominatorTreeTask
extends DefaultTask {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public ComputeDominatorTreeTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Computes a dominator view of the dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPhysicalArtifacts();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getGraphView();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputTxt();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJson();

    @TaskAction
    public final void action() {
        Companion.compute(this.getBuildPath(), this.getProjectPath(), this.getOutputTxt(), this.getOutputDot(), this.getOutputJson(), this.getPhysicalArtifacts(), this.getGraphView());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0018\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0018j\b\u0012\u0004\u0012\u00020\u0002`\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0018j\b\u0012\u0004\u0012\u00020\u0002`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize;", "Lcom/autonomousapps/graph/DominanceTreeWriter$NodeWriter;", "Lcom/autonomousapps/model/Coordinates;", "files", "", "Ljava/io/File;", "tree", "Lcom/autonomousapps/graph/DominanceTree;", "root", "<init>", "(Ljava/util/Map;Lcom/autonomousapps/graph/DominanceTree;Lcom/autonomousapps/model/Coordinates;)V", "sizes", "", "", "reachableNodes", "", "getTreeSize", "node", "(Lcom/autonomousapps/model/Coordinates;)Ljava/lang/Long;", "getSize", "treeSizeOf", "scale", "Lcom/autonomousapps/internal/utils/FileUtils$Scale;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "toString", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nComputeDominatorTreeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1617#2,9:186\n1869#2:195\n1870#2:197\n1626#2:198\n1617#2,9:200\n1869#2:209\n1870#2:211\n1626#2:212\n1617#2,9:214\n1869#2:223\n1870#2:225\n1626#2:226\n1#3:196\n1#3:199\n1#3:210\n1#3:213\n1#3:224\n1#3:227\n*S KotlinDebug\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize\n*L\n93#1:186,9\n93#1:195\n93#1:197\n93#1:198\n88#1:200,9\n88#1:209\n88#1:211\n88#1:212\n111#1:214,9\n111#1:223\n111#1:225\n111#1:226\n93#1:196\n88#1:210\n111#1:224\n*E\n"})
    private static final class BySize
    implements DominanceTreeWriter.NodeWriter<Coordinates> {
        @NotNull
        private final Map<Coordinates, File> files;
        @NotNull
        private final DominanceTree<Coordinates> tree;
        @NotNull
        private final Map<Coordinates, Long> sizes;
        @NotNull
        private final Map<Coordinates, Set<Coordinates>> reachableNodes;
        @NotNull
        private final FileUtils.Scale scale;
        @NotNull
        private final Comparator<Coordinates> comparator;

        /*
         * WARNING - void declaration
         */
        public BySize(@NotNull Map<Coordinates, ? extends File> files, @NotNull DominanceTree<Coordinates> tree, @NotNull Coordinates root) {
            void it;
            long l;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.files = files;
            this.tree = tree;
            this.sizes = new LinkedHashMap();
            this.reachableNodes = new LinkedHashMap();
            Iterable iterable = this.reachableNodes(root);
            BySize bySize = this;
            boolean $i$f$mapNotNull22 = false;
            void var6_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it2 = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
            long $i$f$mapNotNull22 = 0L;
            for (Object e : iterable) {
                void it3;
                $this$forEach$iv$iv$iv = (File)e;
                l = $i$f$mapNotNull22;
                boolean bl = false;
                long l2 = it3.length();
                $i$f$mapNotNull22 = l + l2;
            }
            $i$f$mapNotNull22 = l = $i$f$mapNotNull22;
            boolean bl = false;
            bySize.scale = FileUtils.INSTANCE.getScale((long)it);
            this.comparator = (arg_0, arg_1) -> BySize.comparator$lambda$9(this, arg_0, arg_1);
        }

        @NotNull
        public Long getTreeSize(@NotNull Coordinates node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Long l = this.sizes.computeIfAbsent(node, arg_0 -> BySize.getTreeSize$lambda$1(arg_0 -> BySize.getTreeSize$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"computeIfAbsent(...)");
            return l;
        }

        @Nullable
        public Long getSize(@NotNull Coordinates node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            File file = this.files.get(node);
            return file != null ? Long.valueOf(file.length()) : null;
        }

        private final Set<Coordinates> reachableNodes(Coordinates node) {
            Set set = this.reachableNodes.computeIfAbsent(node, arg_0 -> BySize.reachableNodes$lambda$3(arg_0 -> BySize.reachableNodes$lambda$2(this, node, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
            return set;
        }

        /*
         * WARNING - void declaration
         */
        private final long treeSizeOf(Coordinates node) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.reachableNodes(node);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            long l = 0L;
            for (Object t : iterable2) {
                void it;
                $this$forEach$iv$iv$iv = (File)t;
                long l2 = l;
                boolean bl = false;
                long l3 = it.length();
                l = l2 + l3;
            }
            return l;
        }

        @NotNull
        public Comparator<Coordinates> comparator() {
            return this.comparator;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String toString(@NotNull Coordinates node) {
            File totalSize2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            StringBuilder builder = new StringBuilder();
            boolean printedTotalSize = false;
            Set<Coordinates> subs = this.reachableNodes(node);
            if (!((Collection)SetsKt.minus(subs, (Object)node)).isEmpty()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = subs;
                boolean $i$f$mapNotNull = false;
                void var10_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    File it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Coordinates it = (Coordinates)element$iv$iv;
                    boolean bl2 = false;
                    if (this.files.get(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv;
                long l = 0L;
                for (Object $i$f$mapNotNullTo2 : iterable) {
                    void it;
                    $this$forEach$iv$iv$iv = (File)$i$f$mapNotNullTo2;
                    long l2 = l;
                    boolean bl = false;
                    long l3 = it.length();
                    l = l2 + l3;
                }
                long totalSize2 = l;
                printedTotalSize = true;
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(totalSize2, this.scale)).append(' ');
            }
            if ((totalSize2 = this.files.get(node)) != null) {
                long it = totalSize2.length();
                boolean bl = false;
                if (printedTotalSize) {
                    builder.append('(');
                }
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(it, this.scale));
                if (printedTotalSize) {
                    builder.append(')');
                }
                builder.append(' ');
            }
            Coordinates preferredCoordinatesNotation = node instanceof IncludedBuildCoordinates ? (Coordinates)((IncludedBuildCoordinates)node).getResolvedProject() : node;
            builder.append(preferredCoordinatesNotation.gav());
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private static final Long getTreeSize$lambda$0(BySize this$0, Coordinates it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.treeSizeOf(it);
        }

        private static final Long getTreeSize$lambda$1(Function1 $tmp0, Object p0) {
            return (Long)$tmp0.invoke(p0);
        }

        private static final Set reachableNodes$lambda$2(BySize this$0, Coordinates $node, Coordinates it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Graphs.INSTANCE.reachableNodes(this$0.tree.getDominanceGraph(), (Object)$node, false);
        }

        private static final Set reachableNodes$lambda$3(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final int comparator$lambda$9(BySize this$0, Coordinates left, Coordinates right) {
            Intrinsics.checkNotNull((Object)right);
            long l = this$0.getTreeSize(right);
            Intrinsics.checkNotNull((Object)left);
            return Intrinsics.compare((long)l, (long)this$0.getTreeSize(left));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion;", "", "<init>", "()V", "compute", "", "buildPath", "Lorg/gradle/api/provider/Property;", "", "projectPath", "outputTxt", "Lorg/gradle/api/file/RegularFileProperty;", "outputDot", "outputJson", "physicalArtifacts", "graphView", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nComputeDominatorTreeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n63#2,17:186\n142#2,13:217\n1#3:203\n50#4,3:204\n34#4,4:207\n41#4,2:230\n34#4,4:232\n183#4,10:236\n1193#5,2:211\n1267#5,4:213\n*S KotlinDebug\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion\n*L\n152#1:186,17\n156#1:217,13\n152#1:203\n152#1:204,3\n152#1:207,4\n156#1:230,2\n156#1:232,4\n179#1:236,10\n152#1:211,2\n152#1:213,4\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void compute(@NotNull Property<String> buildPath, @NotNull Property<String> projectPath, @NotNull RegularFileProperty outputTxt, @NotNull RegularFileProperty outputDot, @NotNull RegularFileProperty outputJson, @NotNull RegularFileProperty physicalArtifacts, @NotNull RegularFileProperty graphView) {
            void $this$bufferWriteParameterizedJson_u24default$iv;
            Object reader$iv$iv$iv;
            Object element$iv$iv2;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            JsonAdapter $this$withNulls$iv$iv$iv$iv;
            Type[] typeArray;
            Object it$iv$iv;
            void $this$fromJsonSet$iv$iv;
            Intrinsics.checkNotNullParameter(buildPath, (String)"buildPath");
            Intrinsics.checkNotNullParameter(projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)outputTxt, (String)"outputTxt");
            Intrinsics.checkNotNullParameter((Object)outputDot, (String)"outputDot");
            Intrinsics.checkNotNullParameter((Object)outputJson, (String)"outputJson");
            Intrinsics.checkNotNullParameter((Object)physicalArtifacts, (String)"physicalArtifacts");
            Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
            File outputTxt2 = UtilsKt.getAndDelete(outputTxt);
            File outputDot2 = UtilsKt.getAndDelete(outputDot);
            File outputJson2 = UtilsKt.getAndDelete(outputJson);
            Object $this$fromJsonSet_u24default$iv = physicalArtifacts;
            boolean compressed$iv = false;
            boolean $i$f$fromJsonSet = false;
            Object object = $this$fromJsonSet_u24default$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            RegularFile regularFile = (RegularFile)object;
            boolean compressed$iv$iv = compressed$iv;
            boolean $i$f$fromJsonSet2 = false;
            File file = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            BufferedSource source$iv$iv = UtilsKt.access$bufferRead(file);
            Closeable closeable = (Closeable)source$iv$iv;
            Object object2 = null;
            try {
                it$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                typeArray = new Type[]{PhysicalArtifact.class};
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
                typeArray = typeArray2;
                boolean withNulls$iv$iv$iv$iv = withNulls$iv$iv$iv;
                boolean $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv.fromJson((BufferedSource)it$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                it$iv$iv = (Set)object3;
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            $this$fromJsonSet_u24default$iv = (Iterable)it$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            $this$fromJsonSet$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
                object2 = destination$iv$iv;
                it$iv$iv = (PhysicalArtifact)element$iv$iv2;
                boolean bl = false;
                Coordinates coord = ((PhysicalArtifact)it$iv$iv).component1();
                File file2 = ((PhysicalArtifact)it$iv$iv).component2();
                it$iv$iv = TuplesKt.to((Object)coord, (Object)file2);
                object2.put(it$iv$iv.getFirst(), it$iv$iv.getSecond());
            }
            Map artifactMap = destination$iv$iv;
            RegularFileProperty $this$fromJson$iv = graphView;
            boolean $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object4;
            boolean $i$f$fromJson2 = false;
            File file3 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
            File $this$fromJson$iv$iv$iv = file3;
            boolean $i$f$fromJson3 = false;
            element$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            object2 = null;
            try {
                void $this$withNulls$iv$iv$iv$iv$iv;
                reader$iv$iv$iv = (BufferedSource)element$iv$iv2;
                boolean bl = false;
                boolean withNulls$iv$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(DependencyGraphView.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                $this$withNulls$iv$iv$iv$iv = jsonAdapter;
                boolean withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                boolean $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object5);
                reader$iv$iv$iv = object5;
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally(element$iv$iv2, (Throwable)object2);
            }
            DependencyGraphView graphView2 = (DependencyGraphView)reader$iv$iv$iv;
            Object object6 = projectPath.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            ProjectCoordinates project = new ProjectCoordinates((String)object6, new GradleVariantIdentification(SetsKt.setOf((Object)"ROOT"), MapsKt.emptyMap()), ":");
            DominanceTree tree = new DominanceTree(graphView2.getGraph(), (Object)project);
            BySize nodeWriter = new BySize(artifactMap, (DominanceTree<Coordinates>)tree, project);
            DominanceTreeWriter dominanceTreeWriter = new DominanceTreeWriter((Object)project, tree, (DominanceTreeWriter.NodeWriter)nodeWriter);
            DominanceTreeDataWriter dataWriter = new DominanceTreeDataWriter((Object)project, tree, (DominanceTreeWriter.NodeWriter)nodeWriter);
            Object object7 = buildPath.get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
            GraphWriter graphWriter = new GraphWriter((String)object7);
            FilesKt.writeText$default((File)outputTxt2, (String)dominanceTreeWriter.getString(), null, (int)2, null);
            FilesKt.writeText$default((File)outputDot2, (String)graphWriter.toDot((Graph<Coordinates>)tree.getDominanceGraph()), null, (int)2, null);
            element$iv$iv2 = outputJson2;
            object2 = dataWriter.getSizeTree().map(Companion::compute$lambda$1);
            String indent$iv = "";
            boolean $i$f$bufferWriteParameterizedJson = false;
            Closeable closeable2 = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteParameterizedJson_u24default$iv, (boolean)false, (int)1, null)));
            Throwable throwable = null;
            try {
                void parameterizedData$iv;
                JsonWriter writer$iv = (JsonWriter)closeable2;
                boolean bl = false;
                Type[] typeArray3 = new Type[]{String.class};
                MoshiUtils.getMOSHI().adapter((Type)Types.newParameterizedType((Type)((Type)((Object)DependencySizeTree.class)), (Type[])typeArray3)).indent(indent$iv).toJson(writer$iv, (Object)parameterizedData$iv);
                typeArray = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
        }

        private static final String compute$lambda$1(Coordinates it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getIdentifier();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

