/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.binary.BinaryCompatibilityChecker;
import com.autonomousapps.internal.graph.supers.SuperNode;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.internal.AndroidAssetCapability;
import com.autonomousapps.model.internal.AndroidLinterCapability;
import com.autonomousapps.model.internal.AndroidManifestCapability;
import com.autonomousapps.model.internal.AndroidResCapability;
import com.autonomousapps.model.internal.AndroidResSource;
import com.autonomousapps.model.internal.AnnotationProcessorCapability;
import com.autonomousapps.model.internal.BinaryClassCapability;
import com.autonomousapps.model.internal.Capability;
import com.autonomousapps.model.internal.ConstantCapability;
import com.autonomousapps.model.internal.Dependency;
import com.autonomousapps.model.internal.ExcludedIdentifier;
import com.autonomousapps.model.internal.InferredCapability;
import com.autonomousapps.model.internal.InlineMemberCapability;
import com.autonomousapps.model.internal.KtFile;
import com.autonomousapps.model.internal.NativeLibCapability;
import com.autonomousapps.model.internal.ProjectVariant;
import com.autonomousapps.model.internal.SecurityProviderCapability;
import com.autonomousapps.model.internal.ServiceLoaderCapability;
import com.autonomousapps.model.internal.TypealiasCapability;
import com.autonomousapps.model.internal.declaration.Bucket;
import com.autonomousapps.model.internal.intermediates.DependencyTraceReport;
import com.autonomousapps.model.internal.intermediates.Reason;
import com.autonomousapps.model.internal.intermediates.consumer.LdcConstant;
import com.autonomousapps.model.internal.intermediates.producer.Constant;
import com.autonomousapps.tasks.AnnotationProcessorDetector;
import com.autonomousapps.tasks.ComputeUsagesTask;
import com.autonomousapps.tasks.ResByResAnalysisResult;
import com.autonomousapps.visitor.GraphViewVisitor;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010 \u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010!\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\"\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010#\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010 \u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010'\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010(\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010)\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010+\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010,\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010.\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u00102\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u0002032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u00104\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u0002052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/autonomousapps/tasks/GraphVisitor;", "Lcom/autonomousapps/visitor/GraphViewVisitor;", "project", "Lcom/autonomousapps/model/internal/ProjectVariant;", "kapt", "", "checkSuperClasses", "checkBinaryCompat", "<init>", "(Lcom/autonomousapps/model/internal/ProjectVariant;ZZZ)V", "report", "Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport;", "getReport", "()Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport;", "reportBuilder", "Lcom/autonomousapps/model/internal/intermediates/DependencyTraceReport$Builder;", "visit", "", "excludedIdentifier", "Lcom/autonomousapps/model/internal/ExcludedIdentifier;", "dependency", "Lcom/autonomousapps/model/internal/Dependency;", "context", "Lcom/autonomousapps/visitor/GraphViewVisitor$Context;", "noRealCapabilities", "isRuntimeAndroid", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "capability", "Lcom/autonomousapps/model/internal/AndroidManifestCapability;", "isAbi", "Lcom/autonomousapps/model/internal/BinaryClassCapability;", "isImplementation", "isForMissingSuperclass", "usesAnnotation", "checkBinaryCompatibility", "binaryClassCapability", "typealiasCapability", "Lcom/autonomousapps/model/internal/TypealiasCapability;", "isImported", "containsAndroidTestInstrumentationRunner", "usesConstantByBytecode", "Lcom/autonomousapps/model/internal/ConstantCapability;", "usesConstantByImport", "usesAssets", "Lcom/autonomousapps/model/internal/AndroidAssetCapability;", "usesResBySource", "Lcom/autonomousapps/model/internal/AndroidResCapability;", "usesResByRes", "Lcom/autonomousapps/tasks/ResByResAnalysisResult;", "usesInlineMember", "Lcom/autonomousapps/model/internal/InlineMemberCapability;", "usesAnnotationProcessor", "Lcom/autonomousapps/model/internal/AnnotationProcessorCapability;", "Companion", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nComputeUsagesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeUsagesTask.kt\ncom/autonomousapps/tasks/GraphVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n*L\n1#1,863:1\n1869#2:864\n1870#2:869\n669#2,11:870\n1460#2,2:886\n1563#2:888\n1634#2,3:889\n1462#2,3:892\n865#2:897\n669#2,11:898\n866#2:909\n1761#2,3:910\n1563#2:913\n1634#2,3:914\n1634#2,3:918\n1617#2,9:921\n1869#2:930\n1870#2:932\n1626#2:933\n1563#2:934\n1634#2,3:935\n1563#2:938\n1634#2,3:939\n24#3:865\n63#3,3:866\n116#4,5:881\n84#4:896\n112#4:917\n1#5:895\n1#5:931\n21#6:942\n*S KotlinDebug\n*F\n+ 1 ComputeUsagesTask.kt\ncom/autonomousapps/tasks/GraphVisitor\n*L\n187#1:864\n187#1:869\n366#1:870,11\n507#1:886,2\n508#1:888\n508#1:889,3\n507#1:892,3\n446#1:897\n449#1:898,11\n446#1:909\n578#1:910,3\n629#1:913\n629#1:914,3\n638#1:918,3\n645#1:921,9\n645#1:930\n645#1:932\n645#1:933\n650#1:934\n650#1:935,3\n774#1:938\n774#1:939,3\n212#1:865\n212#1:866,3\n507#1:881,5\n446#1:896\n638#1:917\n645#1:931\n145#1:942\n*E\n"})
final class GraphVisitor
implements GraphViewVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean kapt;
    private final boolean checkSuperClasses;
    private final boolean checkBinaryCompat;
    @NotNull
    private final DependencyTraceReport.Builder reportBuilder;
    @NotNull
    private static final Logger logger;

    public GraphVisitor(@NotNull ProjectVariant project, boolean kapt, boolean checkSuperClasses, boolean checkBinaryCompat) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.kapt = kapt;
        this.checkSuperClasses = checkSuperClasses;
        this.checkBinaryCompat = checkBinaryCompat;
        this.reportBuilder = new DependencyTraceReport.Builder(project.getBuildType(), project.getFlavor(), project.getSourceKind());
    }

    @NotNull
    public final DependencyTraceReport getReport() {
        return this.reportBuilder.build();
    }

    @Override
    public void visit(@NotNull ExcludedIdentifier excludedIdentifier) {
        Intrinsics.checkNotNullParameter((Object)excludedIdentifier, (String)"excludedIdentifier");
        Coordinates coordinates = Coordinates.Companion.of(excludedIdentifier.getIdentifier());
        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.NONE);
        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.Excluded.INSTANCE);
    }

    @Override
    public void visit(@NotNull Dependency dependency, @NotNull GraphViewVisitor.Context context) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Coordinates dependencyCoordinates = dependency.getCoordinates();
        boolean isAccessedByReflection = false;
        boolean isAnnotationProcessor = false;
        boolean isAnnotationProcessorCandidate = false;
        boolean isApiCandidate = false;
        boolean isImplCandidate = false;
        boolean isImplByImportCandidate = false;
        boolean isUnusedCandidate = false;
        boolean isLintJar = false;
        boolean isCompileOnlyCandidate = false;
        boolean isAnnotationCandidate = false;
        boolean isRuntimeAndroid = false;
        boolean usesTestInstrumentationRunner = false;
        boolean usesResBySource = false;
        boolean usesResByResCompileTime = false;
        boolean usesResByResRuntime = false;
        boolean usesAssets = false;
        boolean usesConstant = false;
        boolean usesInlineMember = false;
        boolean hasServiceLoader = false;
        boolean hasSecurityProvider = false;
        boolean hasNativeLib = false;
        Iterable $this$forEach$iv = dependency.getCapabilities().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set<String> providers;
            Capability capability = (Capability)element$iv;
            boolean bl = false;
            Capability capability2 = capability;
            if (capability2 instanceof AndroidLinterCapability) {
                isLintJar = ((AndroidLinterCapability)capability).isLintJar();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.LintJar.Companion.of(((AndroidLinterCapability)capability).getLintRegistry()));
                continue;
            }
            if (capability2 instanceof AndroidManifestCapability) {
                isRuntimeAndroid = this.isRuntimeAndroid(dependencyCoordinates, (AndroidManifestCapability)capability);
                continue;
            }
            if (capability2 instanceof AndroidAssetCapability) {
                usesAssets = this.usesAssets(dependencyCoordinates, (AndroidAssetCapability)capability, context);
                continue;
            }
            if (capability2 instanceof AndroidResCapability) {
                usesResBySource = this.usesResBySource(dependencyCoordinates, (AndroidResCapability)capability, context);
                ResByResAnalysisResult result = this.usesResByRes(dependencyCoordinates, (AndroidResCapability)capability, context);
                usesResByResCompileTime = result.getUsesForCompileTime();
                usesResByResRuntime = result.getUsesForRuntime();
                continue;
            }
            if (capability2 instanceof AnnotationProcessorCapability) {
                isAnnotationProcessor = true;
                isAnnotationProcessorCandidate = this.usesAnnotationProcessor(dependencyCoordinates, (AnnotationProcessorCapability)capability, context);
                continue;
            }
            if (capability2 instanceof BinaryClassCapability) {
                if (this.checkBinaryCompat) {
                    boolean $i$f$measureTime = false;
                    TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
                    boolean $i$f$measureTime2 = false;
                    long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
                    boolean bl2 = false;
                    this.checkBinaryCompatibility(dependencyCoordinates, (BinaryClassCapability)capability, context);
                    long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
                    logger.info("Binary compatibility check duration: " + Duration.toString-impl((long)duration));
                }
                if (this.containsAndroidTestInstrumentationRunner(dependencyCoordinates, (BinaryClassCapability)capability, context)) {
                    usesTestInstrumentationRunner = true;
                }
                if (this.isAbi(dependencyCoordinates, (BinaryClassCapability)capability, context)) {
                    isApiCandidate = true;
                    continue;
                }
                if (this.isImplementation(dependencyCoordinates, (BinaryClassCapability)capability, context)) {
                    isImplCandidate = true;
                    continue;
                }
                if (this.isImported(dependencyCoordinates, (BinaryClassCapability)capability, context)) {
                    isImplByImportCandidate = true;
                    continue;
                }
                if (this.isForMissingSuperclass(dependencyCoordinates, (BinaryClassCapability)capability, context)) {
                    isImplCandidate = true;
                    continue;
                }
                if (this.usesAnnotation(dependencyCoordinates, (BinaryClassCapability)capability, context)) {
                    isAnnotationCandidate = true;
                    continue;
                }
                isUnusedCandidate = true;
                continue;
            }
            if (capability2 instanceof ConstantCapability) {
                usesConstant = this.usesConstantByBytecode(dependencyCoordinates, (ConstantCapability)capability, context);
                usesConstant = usesConstant || this.usesConstantByImport(dependencyCoordinates, (ConstantCapability)capability, context);
                continue;
            }
            if (capability2 instanceof InferredCapability) {
                if (((InferredCapability)capability).isAnnotations()) {
                    this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Annotations());
                }
                isCompileOnlyCandidate = ((InferredCapability)capability).isAnnotations();
                if (!(!((Collection)((InferredCapability)capability).getReflectiveAccesses()).isEmpty())) continue;
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Reflection(((InferredCapability)capability).getReflectiveAccesses()));
                isUnusedCandidate = false;
                isAccessedByReflection = true;
                continue;
            }
            if (capability2 instanceof InlineMemberCapability) {
                usesInlineMember = this.usesInlineMember(dependencyCoordinates, (InlineMemberCapability)capability, context);
                continue;
            }
            if (capability2 instanceof TypealiasCapability) {
                if (!this.isImplementation(dependencyCoordinates, (TypealiasCapability)capability, context)) continue;
                isImplCandidate = true;
                isUnusedCandidate = false;
                continue;
            }
            if (capability2 instanceof ServiceLoaderCapability) {
                providers = ((ServiceLoaderCapability)capability).getProviderClasses();
                hasServiceLoader = !((Collection)providers).isEmpty();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ServiceLoader(providers));
                continue;
            }
            if (capability2 instanceof NativeLibCapability) {
                Set<String> fileNames = ((NativeLibCapability)capability).getFileNames();
                hasNativeLib = !((Collection)fileNames).isEmpty();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.NativeLib(fileNames));
                continue;
            }
            if (capability2 instanceof SecurityProviderCapability) {
                providers = ((SecurityProviderCapability)capability).getSecurityProviders();
                hasSecurityProvider = !((Collection)providers).isEmpty();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.SecurityProvider(providers));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (dependency.getCapabilities().isEmpty()) {
            isUnusedCandidate = true;
        }
        if (isAnnotationProcessorCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.ANNOTATION_PROCESSOR);
        } else if (isAnnotationProcessor) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.NONE);
        }
        if (isApiCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.API);
        } else if (isImplCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        } else if (isCompileOnlyCandidate) {
            isUnusedCandidate = false;
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.COMPILE_ONLY);
        } else if (isImplByImportCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        } else if (isAnnotationCandidate) {
            isUnusedCandidate = false;
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.COMPILE_ONLY);
        } else if (isAccessedByReflection) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
        } else if (this.noRealCapabilities(dependency)) {
            isUnusedCandidate = true;
        }
        if (isUnusedCandidate) {
            if (usesResBySource) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesResByResCompileTime) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesResByResRuntime) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (usesConstant) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesInlineMember) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (isLintJar) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (isRuntimeAndroid) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (usesTestInstrumentationRunner) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (usesAssets) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasServiceLoader) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasSecurityProvider) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasNativeLib) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.NONE);
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.Unused.INSTANCE);
            }
        }
    }

    private final boolean noRealCapabilities(Dependency dependency) {
        Object v0;
        block3: {
            if (dependency.getCapabilities().isEmpty()) {
                return true;
            }
            Iterable $this$singleOrNull$iv = dependency.getCapabilities().values();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Capability it = (Capability)element$iv;
                boolean bl = false;
                if (!(it instanceof InferredCapability || it instanceof NativeLibCapability)) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        Capability single = v0;
        InferredCapability inferredCapability = single instanceof InferredCapability ? (InferredCapability)single : null;
        return (inferredCapability != null ? !inferredCapability.isAnnotations() : false) || single instanceof NativeLibCapability;
    }

    private final boolean isRuntimeAndroid(Coordinates coordinates, AndroidManifestCapability capability) {
        Set<String> set;
        Set<String> set2;
        Set<String> set3;
        Set<String> set4;
        Set<String> it;
        Map<AndroidManifestCapability.Component, Set<String>> components = capability.getComponentMap();
        Set<String> set5 = components.get((Object)AndroidManifestCapability.Component.ACTIVITY);
        if (set5 != null) {
            Set<String> set6;
            it = set6 = set5;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.activities(it));
            set4 = set6;
        } else {
            set4 = null;
        }
        Set<String> activities = set4;
        Set<String> set7 = components.get((Object)AndroidManifestCapability.Component.PROVIDER);
        if (set7 != null) {
            Set<String> it2 = it = set7;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.providers(it2));
            set3 = it;
        } else {
            set3 = null;
        }
        Set<String> providers = set3;
        Set<String> set8 = components.get((Object)AndroidManifestCapability.Component.RECEIVER);
        if (set8 != null) {
            Set<String> set9;
            Set<String> it3 = set9 = set8;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.receivers(it3));
            set2 = set9;
        } else {
            set2 = null;
        }
        Set<String> receivers = set2;
        Set<String> set10 = components.get((Object)AndroidManifestCapability.Component.SERVICE);
        if (set10 != null) {
            Set<String> set11;
            Set<String> it4 = set11 = set10;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.services(it4));
            set = set11;
        } else {
            set = null;
        }
        Set<String> services = set;
        return activities != null || providers != null || receivers != null || services != null;
    }

    private final boolean isAbi(Coordinates coordinates, BinaryClassCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet exposedClasses = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getExposedClasses()), arg_0 -> GraphVisitor.isAbi$lambda$7(capability, arg_0)));
        if (!((Collection)exposedClasses).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Abi(exposedClasses));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isImplementation(Coordinates coordinates, BinaryClassCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet implClasses = SequencesKt.toSortedSet((Sequence)SequencesKt.plus((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getImplementationClasses()), arg_0 -> GraphVisitor.isImplementation$lambda$8(capability, arg_0)), (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(context.getProject().getUsedNonAnnotationClassesWithinVisibleAnnotationBySrc()), arg_0 -> GraphVisitor.isImplementation$lambda$9(capability, arg_0)), GraphVisitor::isImplementation$lambda$10)));
        if (!((Collection)implClasses).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Impl(implClasses));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isForMissingSuperclass(Coordinates coordinates, BinaryClassCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        if (!this.checkSuperClasses) {
            return false;
        }
        Graph<SuperNode> superGraph = context.getSuperGraph();
        Set<String> externalSupers = context.getProject().getExternalSupers();
        Set set = superGraph.nodes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"nodes(...)");
        SortedSet requiredExternalClasses = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)set), arg_0 -> GraphVisitor.isForMissingSuperclass$lambda$11(externalSupers, arg_0)), arg_0 -> GraphVisitor.isForMissingSuperclass$lambda$12(superGraph, arg_0)), arg_0 -> GraphVisitor.isForMissingSuperclass$lambda$16(context, arg_0)), arg_0 -> GraphVisitor.isForMissingSuperclass$lambda$17(coordinates, arg_0)), GraphVisitor::isForMissingSuperclass$lambda$18));
        if (!((Collection)requiredExternalClasses).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ImplSuper(requiredExternalClasses));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesAnnotation(Coordinates coordinates, BinaryClassCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet annoClasses = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getUsedAnnotationClassesBySrc()), arg_0 -> GraphVisitor.usesAnnotation$lambda$19(capability, arg_0)));
        if (!((Collection)annoClasses).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Annotation(annoClasses));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkBinaryCompatibility(Coordinates coordinates, BinaryClassCapability binaryClassCapability, GraphViewVisitor.Context context) {
        BinaryCompatibilityChecker.Result result = new BinaryCompatibilityChecker(coordinates, binaryClassCapability, context).getResult();
        if (result == null) {
            return;
        }
        BinaryCompatibilityChecker.Result result2 = result;
        if (!result2.isBinaryCompatible()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.BinaryIncompatible(result2.getRelevantMemberAccesses(), result2.getNonMatchingBinaryClasses()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isImplementation(Coordinates coordinates, TypealiasCapability typealiasCapability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet imports;
        void $this$flatMapTo$iv$iv$iv;
        Iterable $this$flatMapToSet$iv = typealiasCapability.getTypealiases();
        boolean $i$f$flatMapToSet = false;
        Iterable $this$flatMapToMutableSet$iv$iv = $this$flatMapToSet$iv;
        boolean $i$f$flatMapToMutableSet = false;
        Iterable iterable = $this$flatMapToMutableSet$iv$iv;
        Collection destination$iv$iv$iv = new HashSet(CollectionsKt.collectionSizeOrDefault($this$flatMapToMutableSet$iv$iv, 10));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv$iv : $this$flatMapTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            TypealiasCapability.Typealias ta = (TypealiasCapability.Typealias)element$iv$iv$iv;
            boolean bl2 = false;
            Iterable $this$map$iv = ta.getTypealiases();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypealiasCapability.Typealias.Alias alias = (TypealiasCapability.Typealias.Alias)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(ta.getPackageName() + "." + it.getName());
            }
            Iterable list$iv$iv$iv = (List)destination$iv$iv;
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv$iv, (Iterable)list$iv$iv$iv);
        }
        Set fqnTypealiases = (Set)destination$iv$iv$iv;
        SortedSet usedClasses = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getUsedClasses()), arg_0 -> GraphVisitor.isImplementation$lambda$22(fqnTypealiases, arg_0)));
        Set used = SetsKt.plus((Set)usedClasses, (Iterable)(imports = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getImports()), arg_0 -> GraphVisitor.isImplementation$lambda$23(fqnTypealiases, arg_0)))));
        if (!((Collection)used).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Typealias(used));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isImported(Coordinates coordinates, BinaryClassCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet imports = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getImports()), arg_0 -> GraphVisitor.isImported$lambda$24(capability, arg_0)));
        if (!((Collection)imports).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Imported(imports));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean containsAndroidTestInstrumentationRunner(Coordinates coordinates, BinaryClassCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        String string = context.getProject().getTestInstrumentationRunner();
        if (string == null) {
            return false;
        }
        String testInstrumentationRunner = string;
        if (capability.getClasses().contains(testInstrumentationRunner)) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.TestInstrumentationRunner(testInstrumentationRunner));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesConstantByBytecode(Coordinates coordinates, ConstantCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set<LdcConstant> inferredUsages = context.getProject().getInferredConstants();
        SortedSet usedConstants = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence(capability.getConstants()), GraphVisitor::usesConstantByBytecode$lambda$25), arg_0 -> GraphVisitor.usesConstantByBytecode$lambda$27(inferredUsages, arg_0)));
        Set candidateImports = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence(capability.getConstants()), GraphVisitor::usesConstantByBytecode$lambda$28));
        Set usedImports = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getImports()), arg_0 -> GraphVisitor.usesConstantByBytecode$lambda$29(candidateImports, arg_0)));
        if (!((Collection)usedImports).isEmpty() && !((Collection)usedConstants).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ConstantBytecode(usedConstants));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesConstantByImport(Coordinates coordinates, ConstantCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set<KtFile> ktFiles = capability.getKtFiles();
        Set candidateImports = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence(capability.getConstants()), arg_0 -> GraphVisitor.usesConstantByImport$lambda$37(ktFiles, arg_0)), GraphVisitor::usesConstantByImport$lambda$38));
        SortedSet imports = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getImports()), arg_0 -> GraphVisitor.usesConstantByImport$lambda$39(candidateImports, arg_0)));
        if (!((Collection)imports).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ConstantImport(imports));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesAssets(Coordinates coordinates, AndroidAssetCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        boolean usesAssets;
        boolean bl2 = usesAssets = !((Collection)capability.getAssets()).isEmpty() && context.getProject().getUsedNonAnnotationClassesBySrc().contains("android.content.res.AssetManager");
        if (usesAssets) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Asset(capability.getAssets()));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesResBySource(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set<String> projectImports = context.getProject().getImports();
        Object[] objectArray = new String[]{capability.getRImport(), StringsKt.removeSuffix((String)capability.getRImport(), (CharSequence)"R") + "*"};
        SortedSet imports = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)kotlin.collections.CollectionsKt.listOf((Object[])objectArray)), arg_0 -> GraphVisitor.usesResBySource$lambda$40(projectImports, arg_0)));
        if (!((Collection)imports).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ResBySrc(imports));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final ResByResAnalysisResult usesResByRes(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        boolean usesForCompileTime;
        boolean bl2;
        Set compileTimeStyleParentRefs = new LinkedHashSet();
        Set compileTimeAttrRefs = new LinkedHashSet();
        Set runtimeStyleParentRefs = new LinkedHashSet();
        Set runtimeAttrRefs = new LinkedHashSet();
        for (AndroidResCapability.Line line : capability.getLines()) {
            AndroidResSource.AttrRef attrRef;
            Object it;
            Comparable<AndroidResSource.StyleParentRef> comparable;
            AndroidResSource.StyleParentRef styleParentRef;
            Object t2;
            String type = line.component1();
            String id = line.component2();
            for (AndroidResSource candidate : context.getProject().getAndroidResSource()) {
                Object v1;
                block14: {
                    Object v0;
                    block13: {
                        Iterable iterable = candidate.getStyleParentRefs();
                        for (Object t2 : iterable) {
                            styleParentRef = (AndroidResSource.StyleParentRef)t2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)id, (Object)styleParentRef.getStyleParent())) continue;
                            v0 = t2;
                            break block13;
                        }
                        v0 = null;
                    }
                    comparable = v0;
                    if (comparable != null) {
                        it = comparable;
                        boolean bl4 = false;
                        compileTimeStyleParentRefs.add(it);
                    }
                    it = candidate.getAttrRefs();
                    Iterator bl4 = it.iterator();
                    while (bl4.hasNext()) {
                        t2 = bl4.next();
                        attrRef = (AndroidResSource.AttrRef)t2;
                        boolean bl5 = false;
                        if (!(Intrinsics.areEqual((Object)type, (Object)attrRef.getType()) && Intrinsics.areEqual((Object)id, (Object)attrRef.getId()))) continue;
                        v1 = t2;
                        break block14;
                    }
                    v1 = null;
                }
                if ((comparable = (AndroidResSource.AttrRef)v1) == null) continue;
                it = comparable;
                boolean bl6 = false;
                compileTimeAttrRefs.add(it);
            }
            for (AndroidResSource candidate : context.getProject().getAndroidResRuntimeSource()) {
                Object v3;
                block16: {
                    Object v2;
                    block15: {
                        it = candidate.getStyleParentRefs();
                        Iterator bl6 = it.iterator();
                        while (bl6.hasNext()) {
                            t2 = bl6.next();
                            styleParentRef = (AndroidResSource.StyleParentRef)t2;
                            boolean bl7 = false;
                            if (!Intrinsics.areEqual((Object)id, (Object)styleParentRef.getStyleParent())) continue;
                            v2 = t2;
                            break block15;
                        }
                        v2 = null;
                    }
                    comparable = v2;
                    if (comparable != null) {
                        it = comparable;
                        boolean bl8 = false;
                        runtimeStyleParentRefs.add(it);
                    }
                    it = candidate.getAttrRefs();
                    Iterator bl8 = it.iterator();
                    while (bl8.hasNext()) {
                        t2 = bl8.next();
                        attrRef = (AndroidResSource.AttrRef)t2;
                        boolean bl9 = false;
                        if (!(Intrinsics.areEqual((Object)type, (Object)attrRef.getType()) && Intrinsics.areEqual((Object)id, (Object)attrRef.getId()))) continue;
                        v3 = t2;
                        break block16;
                    }
                    v3 = null;
                }
                if ((comparable = (AndroidResSource.AttrRef)v3) == null) continue;
                it = comparable;
                boolean bl10 = false;
                runtimeAttrRefs.add(it);
            }
        }
        Set allCompileTimeRefs = SetsKt.plus((Set)compileTimeStyleParentRefs, (Iterable)compileTimeAttrRefs);
        Set allRuntimeRefs = SetsKt.plus((Set)runtimeStyleParentRefs, (Iterable)runtimeAttrRefs);
        if (!((Collection)allCompileTimeRefs).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.ResByRes.Companion.resRefs(allCompileTimeRefs));
            bl2 = true;
        } else {
            bl2 = usesForCompileTime = false;
        }
        if (!((Collection)allRuntimeRefs).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.ResByResRuntime.Companion.resRefs(allRuntimeRefs));
            bl = true;
        } else {
            bl = false;
        }
        boolean usesForRuntime = bl;
        return new ResByResAnalysisResult(usesForCompileTime, usesForRuntime);
    }

    private final boolean usesInlineMember(Coordinates coordinates, InlineMemberCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set candidateImports = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)capability.getInlineMembers()), GraphVisitor::usesInlineMember$lambda$50));
        SortedSet imports = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)context.getProject().getImports()), arg_0 -> GraphVisitor.usesInlineMember$lambda$51(candidateImports, arg_0)));
        if (!((Collection)imports).isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Inline(imports));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesAnnotationProcessor(Coordinates coordinates, AnnotationProcessorCapability capability, GraphViewVisitor.Context context) {
        return new AnnotationProcessorDetector(coordinates, capability.getSupportedAnnotationTypes(), this.kapt, this.reportBuilder).usesAnnotationProcessor(context);
    }

    private static final boolean isAbi$lambda$7(BinaryClassCapability $capability, String exposedClass) {
        Intrinsics.checkNotNullParameter((Object)exposedClass, (String)"exposedClass");
        return $capability.getClasses().contains(exposedClass);
    }

    private static final boolean isImplementation$lambda$8(BinaryClassCapability $capability, String implClass) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        return $capability.getClasses().contains(implClass);
    }

    private static final boolean isImplementation$lambda$9(BinaryClassCapability $capability, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String nonAnnotationClass = (String)entry.getKey();
        String enclosingAnnotation = (String)entry.getValue();
        return $capability.getClasses().contains(nonAnnotationClass) && !$capability.getClasses().contains(enclosingAnnotation);
    }

    private static final String isImplementation$lambda$10(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getKey();
    }

    private static final boolean isForMissingSuperclass$lambda$11(Set $externalSupers, SuperNode superNode) {
        return $externalSupers.contains(superNode.getClassName());
    }

    private static final Iterable isForMissingSuperclass$lambda$12(Graph $superGraph, SuperNode superNode) {
        ImmutableSet immutableSet = com.google.common.graph.Graphs.reachableNodes((Graph)$superGraph, (Object)superNode);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"reachableNodes(...)");
        return (Iterable)immutableSet;
    }

    /*
     * WARNING - void declaration
     */
    private static final SuperNode isForMissingSuperclass$lambda$16(GraphViewVisitor.Context $context, SuperNode superNode) {
        SuperNode superNode2;
        void $this$filterTo$iv$iv;
        Iterable $this$filterToOrderedSet$iv = superNode.getDeps();
        boolean $i$f$filterToOrderedSet = false;
        Iterable iterable = $this$filterToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v0;
            block5: {
                Coordinates dep = (Coordinates)element$iv$iv;
                boolean bl = false;
                Graph<Coordinates> graph = $context.getGraph().getGraph();
                Iterable $this$singleOrNull$iv = Graphs.INSTANCE.parents(graph, (Object)dep);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Coordinates it = (Coordinates)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)Graphs.INSTANCE.root(graph))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if (!(v0 != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set deps = (Set)destination$iv$iv;
        if (!((Collection)deps).isEmpty()) {
            SuperNode superNode3;
            SuperNode $this$isForMissingSuperclass_u24lambda_u2416_u24lambda_u2415 = superNode3 = new SuperNode(superNode.getClassName());
            boolean bl = false;
            kotlin.collections.CollectionsKt.addAll((Collection)$this$isForMissingSuperclass_u24lambda_u2416_u24lambda_u2415.getDeps(), (Iterable)deps);
            superNode2 = superNode3;
        } else {
            superNode2 = null;
        }
        return superNode2;
    }

    private static final boolean isForMissingSuperclass$lambda$17(Coordinates $coordinates, SuperNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getDeps().contains($coordinates);
    }

    private static final String isForMissingSuperclass$lambda$18(SuperNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getClassName();
    }

    private static final boolean usesAnnotation$lambda$19(BinaryClassCapability $capability, String annoClass) {
        Intrinsics.checkNotNullParameter((Object)annoClass, (String)"annoClass");
        return $capability.getClasses().contains(annoClass);
    }

    private static final boolean isImplementation$lambda$22(Set $fqnTypealiases, String usedClass) {
        Intrinsics.checkNotNullParameter((Object)usedClass, (String)"usedClass");
        return $fqnTypealiases.contains(usedClass);
    }

    private static final boolean isImplementation$lambda$23(Set $fqnTypealiases, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        return $fqnTypealiases.contains(string);
    }

    private static final boolean isImported$lambda$24(BinaryClassCapability $capability, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        return $capability.getClasses().contains(string);
    }

    private static final Iterable usesConstantByBytecode$lambda$25(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Iterable)it.getValue();
    }

    private static final boolean usesConstantByBytecode$lambda$27(Set $inferredUsages, Constant candidate) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
            String descriptor = candidate.getDescriptor();
            String value = candidate.getValue();
            Iterable $this$any$iv = $inferredUsages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LdcConstant usage = (LdcConstant)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)descriptor, (Object)usage.getDescriptor()) && Intrinsics.areEqual((Object)value, (Object)usage.getValue()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String usesConstantByBytecode$lambda$28(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String fqcn = (String)entry.getKey();
        return StringsKt.replace$default((String)fqcn, (char)'$', (char)'.', (boolean)false, (int)4, null);
    }

    private static final boolean usesConstantByBytecode$lambda$29(Set $candidateImports, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        return $candidateImports.contains(string);
    }

    private static final List<String> usesConstantByImport$optionalStarImport(String fqcn) {
        return StringsKt.contains$default((CharSequence)fqcn, (CharSequence)".", (boolean)false, (int)2, null) ? kotlin.collections.CollectionsKt.listOf((Object)(StringsKt.substringBeforeLast$default((String)fqcn, (char)'.', null, (int)2, null) + ".*")) : kotlin.collections.CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> usesConstantByImport$optionalCompanionImport(Set<String> names, String fqcn) {
        List list;
        if (names.contains("Companion")) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = names;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void name;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(fqcn + ".Companion." + (String)name);
            }
            list = (List)destination$iv$iv;
        } else {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable usesConstantByImport$lambda$37(Set $ktFiles, Map.Entry entry) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        String string;
        Object name;
        Iterator<Object> iterator;
        Set names;
        Collection collection;
        String $this$mapTo$iv$iv2;
        String fqcn;
        block8: {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            fqcn = (String)entry.getKey();
            Set fields = (Set)entry.getValue();
            Iterable $this$mapToOrderedSet$iv = fields;
            boolean $i$f$mapToOrderedSet = false;
            Iterable iterable = $this$mapToOrderedSet$iv;
            Iterable destination$iv$iv = new TreeSet();
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator22 = $this$mapTo$iv$iv2.iterator();
            while (iterator22.hasNext()) {
                void it;
                Object item$iv$iv = iterator22.next();
                Constant constant = (Constant)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            names = (Set)destination$iv$iv;
            destination$iv$iv = $ktFiles;
            for (Iterator<Object> iterator22 : destination$iv$iv) {
                KtFile ktFile = (KtFile)((Object)iterator22);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ktFile.getFqcn(), (Object)fqcn)) continue;
                iterator = iterator22;
                break block8;
            }
            iterator = null;
        }
        KtFile $i$f$mapToOrderedSet = (KtFile)((Object)iterator);
        if ($i$f$mapToOrderedSet != null && ($this$mapTo$iv$iv2 = $i$f$mapToOrderedSet.getName()) != null) {
            name = $this$mapTo$iv$iv2;
            boolean bl = false;
            string = StringsKt.removeSuffix((String)fqcn, (CharSequence)((CharSequence)name));
        } else {
            string = null;
        }
        String ktPrefix = string;
        Iterable $this$mapNotNull$iv = names;
        boolean $i$f$mapNotNull = false;
        name = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String name2 = (String)element$iv$iv;
            boolean bl2 = false;
            if (ktPrefix != null) {
                String it;
                boolean bl3 = false;
                string2 = it + name2;
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            String it$iv$iv = string2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List ktImports = (List)destination$iv$iv;
        $this$mapNotNull$iv = names;
        collection = kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.plus((Collection)ktImports, (Iterable)kotlin.collections.CollectionsKt.listOf((Object)(fqcn + ".*"))), (Iterable)GraphVisitor.usesConstantByImport$optionalStarImport(fqcn));
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name3;
            object = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(fqcn + "." + (String)name3);
        }
        return kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)GraphVisitor.usesConstantByImport$optionalCompanionImport(names, fqcn));
    }

    private static final String usesConstantByImport$lambda$38(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        return StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null);
    }

    private static final boolean usesConstantByImport$lambda$39(Set $candidateImports, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        return $candidateImports.contains(string);
    }

    private static final boolean usesResBySource$lambda$40(Set $projectImports, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        return $projectImports.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable usesInlineMember$lambda$50(InlineMemberCapability.InlineMember inlineMember) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)inlineMember, (String)"<destruct>");
        String pn = inlineMember.component1();
        Set<String> names = inlineMember.component2();
        Iterable iterable = names;
        Collection collection = kotlin.collections.CollectionsKt.listOf((Object)(pn + ".*"));
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(pn + "." + (String)name);
        }
        return kotlin.collections.CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final boolean usesInlineMember$lambda$51(Set $candidateImports, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        return $candidateImports.contains(string);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = Logging.getLogger(ComputeUsagesTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        GraphVisitor.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/autonomousapps/tasks/GraphVisitor$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

