/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.ManifestParser;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.AndroidManifestCapability;
import com.autonomousapps.model.internal.intermediates.producer.AndroidManifestDependency;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0007J0\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00170\u0015*\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00170\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/tasks/ManifestComponentsExtractionTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "manifestArtifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "setArtifacts", "", "getManifestFiles", "Lorg/gradle/api/file/FileCollection;", "namespace", "Lorg/gradle/api/provider/Property;", "", "getNamespace", "()Lorg/gradle/api/provider/Property;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "toComponentMap", "", "Lcom/autonomousapps/model/internal/AndroidManifestCapability$Component;", "", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nManifestComponentsExtractionTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestComponentsExtractionTask.kt\ncom/autonomousapps/tasks/ManifestComponentsExtractionTask\n+ 2 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n136#2:72\n1625#3:73\n1869#3:74\n1870#3:76\n1626#3:77\n1#4:75\n154#5,13:78\n50#5,3:91\n34#5,4:94\n167#5,2:98\n126#6:100\n153#6,3:101\n*S KotlinDebug\n*F\n+ 1 ManifestComponentsExtractionTask.kt\ncom/autonomousapps/tasks/ManifestComponentsExtractionTask\n*L\n49#1:72\n49#1:73\n49#1:74\n49#1:76\n49#1:77\n49#1:75\n61#1:78,13\n61#1:91,3\n61#1:94,4\n61#1:98,2\n65#1:100\n65#1:101,3\n*E\n"})
public abstract class ManifestComponentsExtractionTask
extends DefaultTask {
    private ArtifactCollection manifestArtifacts;

    public ManifestComponentsExtractionTask() {
        this.setDescription("Produces a report of packages, from other components, that are included via Android manifests");
    }

    public final void setArtifacts(@NotNull ArtifactCollection manifestArtifacts) {
        Intrinsics.checkNotNullParameter((Object)manifestArtifacts, (String)"manifestArtifacts");
        this.manifestArtifacts = manifestArtifacts;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public final FileCollection getManifestFiles() {
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
            artifactCollection = null;
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getArtifactFiles(...)");
        return fileCollection;
    }

    @Input
    @NotNull
    public abstract Property<String> getNamespace();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJsonSet_u24default$iv;
        void $this$mapNotNullTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        Object object = this.getNamespace().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ManifestParser parser = new ManifestParser((String)object);
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
            artifactCollection = null;
        }
        Object $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv$iv.iterator();
        while (object2.hasNext()) {
            ManifestParser.ParseResult it$iv$iv;
            Object parseResult;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object2.next();
            boolean bl = false;
            ResolvedArtifactResult manifest = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            try {
                File file = manifest.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                parseResult = parser.parse(file, true);
                Map<AndroidManifestCapability.Component, Set<String>> map = this.toComponentMap(((ManifestParser.ParseResult)parseResult).getComponents());
                Intrinsics.checkNotNull((Object)manifest);
                parseResult = AndroidManifestDependency.Companion.newInstance(map, manifest);
            }
            catch (GradleException gradleException) {
                parseResult = null;
            }
            if (parseResult == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set manifests = (Set)destination$iv$iv;
        $this$mapNotNullToOrderedSet$iv = outputFile;
        Set set$iv = manifests;
        boolean compress$iv = false;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        BufferedSink buffer$iv = Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null));
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)buffer$iv);
        object2 = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            Type[] bl2 = new Type[]{AndroidManifestDependency.class};
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])bl2);
            Type[] typeArray = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"adapter(...)");
            bl2 = typeArray;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)set$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            try {
                object2 = throwable;
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)closeable, object2);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<AndroidManifestCapability.Component, Set<String>> toComponentMap(Map<String, ? extends Set<String>> $this$toComponentMap) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends Set<String>> $this$map$iv = $this$toComponentMap;
        boolean $i$f$map = false;
        Map<String, ? extends Set<String>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Set values = (Set)entry.getValue();
            collection.add(TuplesKt.to((Object)((Object)AndroidManifestCapability.Component.Companion.of$dependency_analysis_gradle_plugin(key)), (Object)values));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

