/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.UsageContainer;
import com.autonomousapps.internal.reason.DependencyAdviceExplainer;
import com.autonomousapps.internal.reason.ModuleAdviceExplainer;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.FlatCoordinates;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.model.ProjectCoordinates;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.autonomousapps.model.internal.intermediates.BundleTrace;
import com.autonomousapps.model.internal.intermediates.Usage;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UntrackedTask(because="Always prints output")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u00002\u00020\u0001:\u0006345678B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010.\u001a\u00020/H\u0007J\b\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR*\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\b8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R*\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\b8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R*\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\b8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010 R\u0014\u0010%\u001a\u00020\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010 R\u0014\u0010'\u001a\u00020\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010 R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00069"}, d2={"Lcom/autonomousapps/tasks/ReasonTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "<init>", "(Lorg/gradle/workers/WorkerExecutor;)V", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "buildPath", "getBuildPath", "value", "id", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "capability", "getCapability", "setCapability", "module", "getModule", "setModule", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getDependencyUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "annotationProcessorUsageReport", "getAnnotationProcessorUsageReport", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "finalAdviceReport", "getFinalAdviceReport", "bundleTracesReport", "getBundleTracesReport", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "action", "", "options", "Lcom/autonomousapps/tasks/ReasonTask$Options;", "help", "Options", "ExplainDependencyAdviceParams", "ExplainDependencyAdviceAction", "ExplainModuleAdviceParams", "ExplainModuleAdviceAction", "Explainer", "dependency-analysis-gradle-plugin"})
public abstract class ReasonTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @Nullable
    private String id;
    @Nullable
    private String capability;
    @Nullable
    private String module;

    @Inject
    public ReasonTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis");
        this.setDescription("Explain how a dependency is used");
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @Optional
    @Input
    @Nullable
    public final String getId() {
        return this.id;
    }

    @Option(option="id", description="The dependency you'd like to reason about (com.foo:bar:1.0 or :other:module)")
    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @Optional
    @Input
    @Nullable
    public final String getCapability() {
        return this.capability;
    }

    @Option(option="capability", description="The capability you're interested in. Defaults to main capability. A typical option is 'test-fixtures'")
    public final void setCapability(@Nullable String string) {
        this.capability = string;
    }

    @Optional
    @Input
    @Nullable
    public final String getModule() {
        return this.module;
    }

    @Option(option="module", description="The module-structure-related advice you'd like more insight into ('android')")
    public final void setModule(@Nullable String string) {
        this.module = string;
    }

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getDependencyUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAnnotationProcessorUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getUnfilteredAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getFinalAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBundleTracesReport();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getDependencyGraphViews();

    @TaskAction
    public final void action() {
        block1: {
            Options options = this.options();
            String string = options.getId();
            if (string != null) {
                String dependency = string;
                boolean bl = false;
                this.workerExecutor.noIsolation().submit(ExplainDependencyAdviceAction.class, arg_0 -> ReasonTask.action$lambda$2$lambda$1(arg_0 -> ReasonTask.action$lambda$2$lambda$0(dependency, options, this, arg_0), arg_0));
            }
            String string2 = options.getModule();
            if (string2 == null) break block1;
            String moduleStructure = string2;
            boolean bl = false;
            this.workerExecutor.noIsolation().submit(ExplainModuleAdviceAction.class, arg_0 -> ReasonTask.action$lambda$5$lambda$4(arg_0 -> ReasonTask.action$lambda$5$lambda$3(moduleStructure, this, arg_0), arg_0));
        }
    }

    private final Options options() {
        String id = this.id;
        String module = this.module;
        String capability = this.capability;
        if (id == null && module == null) {
            throw new InvalidUserDataException(this.help());
        }
        if (capability != null && id == null) {
            throw new InvalidUserDataException(this.help());
        }
        return new Options(id, capability, module);
    }

    private final String help() {
        String path = (String)this.getProjectPath().get();
        boolean bl = false;
        return StringsKt.trimIndent((String)("\n      You must call 'reason' with either the `--id` or `--module` option, or both.\n      You may also specify a `--capability`, but this only influences the results of an `--id` query.\n      \n      Usage for --id:\n        ./gradlew " + path + ":reason --id com.foo:bar:1.0\n        ./gradlew " + path + ":reason --id com.foo:bar\n        ./gradlew " + path + ":reason --id :other:module\n        ./gradlew " + path + ":reason --id <dependency identifier> --capability test-fixtures\n        \n      For external dependencies, the version is optional.\n      Capability is optional. If unspecified, defaults to main capability.\n      \n      Usage for --module:\n        ./gradlew " + path + ":reason --module android\n    "));
    }

    private static final Unit action$lambda$2$lambda$0(String $dependency, Options $options, ReasonTask this$0, ExplainDependencyAdviceParams it) {
        it.getId().set((Object)$dependency);
        Property<String> property = it.getCapability();
        String string = $options.getCapability();
        if (string == null) {
            string = "";
        }
        property.set((Object)string);
        it.getProjectPath().set((Provider)this$0.getProjectPath());
        it.getBuildPath().set((Provider)this$0.getBuildPath());
        it.getDependencyMap().set((Provider)this$0.getDependencyMap());
        it.getDependencyUsageReport().set((Provider)this$0.getDependencyUsageReport());
        it.getAnnotationProcessorUsageReport().set((Provider)this$0.getAnnotationProcessorUsageReport());
        it.getUnfilteredAdviceReport().set((Provider)this$0.getUnfilteredAdviceReport());
        it.getFinalAdviceReport().set((Provider)this$0.getFinalAdviceReport());
        it.getBundleTracesReport().set((Provider)this$0.getBundleTracesReport());
        it.getDependencyGraphViews().set((Provider)this$0.getDependencyGraphViews());
        return Unit.INSTANCE;
    }

    private static final void action$lambda$2$lambda$1(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Unit action$lambda$5$lambda$3(String $moduleStructure, ReasonTask this$0, ExplainModuleAdviceParams it) {
        it.getModule().set((Object)$moduleStructure);
        it.getProjectPath().set((Provider)this$0.getProjectPath());
        it.getUnfilteredAdviceReport().set((Provider)this$0.getUnfilteredAdviceReport());
        it.getFinalAdviceReport().set((Provider)this$0.getFinalAdviceReport());
        return Unit.INSTANCE;
    }

    private static final void action$lambda$5$lambda$4(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0015H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0016H\u0002J\b\u0010*\u001a\u00020&H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "capability", "", "kotlin.jvm.PlatformType", "buildPath", "projectPath", "dependencyGraph", "", "Lcom/autonomousapps/model/internal/DependencyGraphView;", "unfilteredProjectAdvice", "Lcom/autonomousapps/model/ProjectAdvice;", "finalProjectAdvice", "dependencyMap", "Lkotlin/Function1;", "dependencyUsages", "Lcom/autonomousapps/model/Coordinates;", "", "Lcom/autonomousapps/model/internal/intermediates/Usage;", "annotationProcessorUsages", "requestedCoord", "finalAdvice", "Lcom/autonomousapps/model/Advice;", "unfilteredAdvice", "usages", "execute", "", "getRequestedCoordinates", "getUsageFor", "request", "findAdviceIn", "projectAdvice", "matchesByIdentifier", "", "advice", "bundleTraces", "Lcom/autonomousapps/model/internal/intermediates/BundleTrace;", "wasFiltered", "Companion", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 5 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 6 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,405:1\n21#2:406\n1563#3:407\n1634#3,2:408\n1636#3:424\n1208#3,2:425\n1236#3,4:427\n865#3,2:508\n865#3,2:536\n1761#3,3:538\n147#4,8:410\n142#4,13:431\n142#4,13:450\n142#4,13:469\n142#4,13:488\n63#4,17:510\n41#5,2:418\n34#5,4:420\n41#5,2:444\n34#5,4:446\n41#5,2:463\n34#5,4:465\n41#5,2:482\n34#5,4:484\n41#5,2:501\n34#5,4:503\n50#5,3:528\n34#5,4:531\n76#6:507\n76#6:535\n1#7:527\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n*L\n204#1:406\n210#1:407\n210#1:408,2\n210#1:424\n211#1:425,2\n211#1:427,4\n292#1:508,2\n308#1:536,2\n314#1:538,3\n210#1:410,8\n212#1:431,13\n213#1:450,13\n216#1:469,13\n217#1:488,13\n308#1:510,17\n210#1:418,2\n210#1:420,4\n212#1:444,2\n212#1:446,4\n213#1:463,2\n213#1:465,4\n216#1:482,2\n216#1:484,4\n217#1:501,2\n217#1:503,4\n308#1:528,3\n308#1:531,4\n292#1:507\n308#1:535\n308#1:527\n*E\n"})
    public static abstract class ExplainDependencyAdviceAction
    implements WorkAction<ExplainDependencyAdviceParams> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Logger logger;
        private final String capability;
        private final String buildPath;
        private final String projectPath;
        @NotNull
        private final Map<String, DependencyGraphView> dependencyGraph;
        @NotNull
        private final ProjectAdvice unfilteredProjectAdvice;
        @NotNull
        private final ProjectAdvice finalProjectAdvice;
        @NotNull
        private final Function1<String, String> dependencyMap;
        @NotNull
        private final Map<Coordinates, Set<Usage>> dependencyUsages;
        @NotNull
        private final Map<Coordinates, Set<Usage>> annotationProcessorUsages;
        @NotNull
        private final Coordinates requestedCoord;
        @NotNull
        private final Set<Advice> finalAdvice;
        @NotNull
        private final Set<Advice> unfilteredAdvice;
        @NotNull
        private final Set<Usage> usages;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainDependencyAdviceAction() {
            Object object;
            JsonAdapter $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$withNulls;
            boolean withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl5;
            Object reader$iv$iv$iv;
            RegularFileProperty $this$fromJson$iv;
            void $this$associateByTo$iv$iv;
            RegularFileProperty $this$associateBy$iv;
            Object object2;
            Object object3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
            this.capability = (String)((ExplainDependencyAdviceParams)this.getParameters()).getCapability().get();
            this.buildPath = (String)((ExplainDependencyAdviceParams)this.getParameters()).getBuildPath().get();
            this.projectPath = (String)((ExplainDependencyAdviceParams)this.getParameters()).getProjectPath().get();
            Object object4 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyGraphViews().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            Iterable $i$f$getLogger22 = (Iterable)object4;
            ExplainDependencyAdviceAction explainDependencyAdviceAction = this;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object5;
                File $this$fromJson$iv$iv;
                void it;
                object3 = (RegularFile)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                void $this$fromJson$iv2 = it;
                boolean $i$f$fromJson = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv2.getAsFile(), (String)"getAsFile(...)");
                boolean $i$f$fromJson2 = false;
                Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv);
                Throwable throwable = null;
                try {
                    void $this$withNulls$iv$iv$iv$iv;
                    BufferedSource reader$iv$iv = (BufferedSource)closeable;
                    boolean bl3 = false;
                    boolean withNulls$iv$iv$iv = false;
                    boolean $i$f$getJsonAdapter2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(DependencyGraphView.class), (String)"adapter(...)");
                    boolean withNulls$iv$iv$iv$iv2 = withNulls$iv$iv$iv;
                    boolean $i$f$withNulls2 = false;
                    Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object2.add((DependencyGraphView)object5);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                DependencyGraphView bl2 = (DependencyGraphView)element$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl4 = false;
                object2.put(it.getName() + "," + it.getConfigurationName(), element$iv$iv);
            }
            explainDependencyAdviceAction.dependencyGraph = destination$iv$iv2;
            $this$associateBy$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            explainDependencyAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object6 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object6;
            boolean $i$f$fromJson3 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson4 = false;
            Object object7 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            object3 = null;
            try {
                reader$iv$iv$iv = (BufferedSource)object7;
                bl5 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter $i$f$fromJson2 = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object8 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object8);
                reader$iv$iv$iv = object8;
            }
            catch (Throwable bl5) {
                object3 = bl5;
                throw bl5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object7, (Throwable)object3);
            }
            explainDependencyAdviceAction.unfilteredProjectAdvice = (ProjectAdvice)reader$iv$iv$iv;
            $this$fromJson$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainDependencyAdviceAction = this;
            $i$f$fromJson = false;
            Object object9 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
            $this$fromJson$iv$iv = (RegularFile)object9;
            $i$f$fromJson3 = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson4 = false;
            object7 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            object3 = null;
            try {
                reader$iv$iv$iv = (BufferedSource)object7;
                bl5 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object10 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object10);
                reader$iv$iv$iv = object10;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object7, (Throwable)object3);
            }
            explainDependencyAdviceAction.finalProjectAdvice = (ProjectAdvice)reader$iv$iv$iv;
            Object object11 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"get(...)");
            this.dependencyMap = DependenciesHandler.Companion.toLambda((Map)object11);
            $this$fromJson$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyUsageReport();
            explainDependencyAdviceAction = this;
            $i$f$fromJson = false;
            Object object12 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"get(...)");
            $this$fromJson$iv$iv = (RegularFile)object12;
            $i$f$fromJson3 = false;
            File file3 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
            $this$fromJson$iv$iv$iv = file3;
            $i$f$fromJson4 = false;
            object7 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            object3 = null;
            try {
                reader$iv$iv$iv = (BufferedSource)object7;
                bl5 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(UsageContainer.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object13 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object13);
                reader$iv$iv$iv = object13;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object7, (Throwable)object3);
            }
            explainDependencyAdviceAction.dependencyUsages = ((UsageContainer)reader$iv$iv$iv).toMap();
            $this$fromJson$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getAnnotationProcessorUsageReport();
            explainDependencyAdviceAction = this;
            $i$f$fromJson = false;
            Object object14 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object14, (String)"get(...)");
            $this$fromJson$iv$iv = (RegularFile)object14;
            $i$f$fromJson3 = false;
            File file4 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getAsFile(...)");
            $this$fromJson$iv$iv$iv = file4;
            $i$f$fromJson4 = false;
            object7 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            object3 = null;
            try {
                reader$iv$iv$iv = (BufferedSource)object7;
                bl5 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(UsageContainer.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object15 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object15);
                object = object15;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object7, (Throwable)object3);
            }
            explainDependencyAdviceAction.annotationProcessorUsages = ((UsageContainer)object).toMap();
            this.requestedCoord = this.getRequestedCoordinates();
            this.finalAdvice = this.findAdviceIn(this.finalProjectAdvice);
            this.unfilteredAdvice = this.findAdviceIn(this.unfilteredProjectAdvice);
            this.usages = this.getUsageFor(this.requestedCoord);
        }

        public void execute() {
            String string = this.projectPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectPath");
            ProjectCoordinates project = new ProjectCoordinates(string, new GradleVariantIdentification(SetsKt.setOf((Object)"ROOT"), MapsKt.emptyMap()), this.buildPath);
            String string2 = this.buildPath;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildPath");
            String string3 = this.capability;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capability");
            String reason = new DependencyAdviceExplainer(project, string2, this.requestedCoord, string3, this.usages, this.finalAdvice, this.dependencyGraph, this.bundleTraces(), this.wasFiltered(), this.dependencyMap).computeReason();
            this.logger.quiet(reason);
        }

        private final Coordinates getRequestedCoordinates() {
            String requestedId = (String)((ExplainDependencyAdviceParams)this.getParameters()).getId().get();
            String requestedCapability = this.capability;
            Set<Map.Entry<Coordinates, Set<Usage>>> set = this.dependencyUsages.entrySet();
            Intrinsics.checkNotNull((Object)requestedId);
            Intrinsics.checkNotNull((Object)requestedCapability);
            String string = this.buildPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildPath");
            Coordinates coordinates = Companion.findDependency$dependency_analysis_gradle_plugin(set, requestedId, requestedCapability, string);
            if (coordinates == null) {
                Set<Map.Entry<Coordinates, Set<Usage>>> set2 = this.annotationProcessorUsages.entrySet();
                String string2 = this.buildPath;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildPath");
                coordinates = Companion.findDependency$dependency_analysis_gradle_plugin(set2, requestedId, requestedCapability, string2);
                if (coordinates == null && (coordinates = ExplainDependencyAdviceAction.getRequestedCoordinates$findInGraph(this, requestedId)) == null) {
                    throw new InvalidUserDataException("There is no dependency with coordinates '" + requestedId + "' in this project.");
                }
            }
            return coordinates;
        }

        private final Set<Usage> getUsageFor(Coordinates request) {
            Set<Usage> set;
            Set set2;
            Object v2;
            Set<Usage> set3;
            block4: {
                set3 = (Set<Usage>)this.dependencyUsages.entrySet();
                for (Object object : set3) {
                    Map.Entry entry = (Map.Entry)object;
                    boolean bl = false;
                    Coordinates coordinates = (Coordinates)entry.getKey();
                    String string = this.buildPath;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildPath");
                    if (!Intrinsics.areEqual((Object)request, (Object)coordinates.normalized$dependency_analysis_gradle_plugin(string))) continue;
                    v2 = object;
                    break block4;
                }
                v2 = null;
            }
            Map.Entry entry = v2;
            if (entry != null && (set2 = (Set)entry.getValue()) != null && (set3 = CollectionsKt.softSortedSet(set2, Usage.Companion.getBY_VARIANT())) != null) {
                set = set3;
            } else {
                Set set4;
                Object v6;
                block5: {
                    Iterable iterable = this.annotationProcessorUsages.entrySet();
                    for (Object t : iterable) {
                        Map.Entry entry2 = (Map.Entry)t;
                        boolean bl = false;
                        Coordinates coordinates = (Coordinates)entry2.getKey();
                        String string = this.buildPath;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildPath");
                        if (!Intrinsics.areEqual((Object)request, (Object)coordinates.normalized$dependency_analysis_gradle_plugin(string))) continue;
                        v6 = t;
                        break block5;
                    }
                    v6 = null;
                }
                Map.Entry entry3 = v6;
                set = entry3 != null && (set4 = (Set)entry3.getValue()) != null ? CollectionsKt.softSortedSet(set4, Usage.Companion.getBY_VARIANT()) : SetsKt.emptySet();
            }
            return set;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Advice> findAdviceIn(ProjectAdvice projectAdvice) {
            void $this$filterTo$iv$iv;
            Iterable $this$filterToSet$iv = projectAdvice.getDependencyAdvice();
            boolean $i$f$filterToSet = false;
            Iterable iterable = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Advice advice = (Advice)element$iv$iv;
                boolean bl = false;
                String adviceGav = advice.getCoordinates().gav();
                boolean byGav = Intrinsics.areEqual((Object)adviceGav, (Object)this.requestedCoord.gav()) || Intrinsics.areEqual((Object)adviceGav, (Object)this.requestedCoord.gav());
                if (!(byGav || this.matchesByIdentifier(advice, this.requestedCoord) || this.matchesByIdentifier(advice, this.requestedCoord))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Set)destination$iv$iv;
        }

        private final boolean matchesByIdentifier(Advice advice, Coordinates request) {
            if (!(request instanceof FlatCoordinates)) {
                return false;
            }
            return Intrinsics.areEqual((Object)advice.getCoordinates().getIdentifier(), (Object)((FlatCoordinates)request).getIdentifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Set<BundleTrace> bundleTraces() {
            void $this$filterTo$iv$iv;
            Set set;
            void $this$fromJsonSet$iv$iv;
            RegularFileProperty $this$fromJsonSet_u24default$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getBundleTracesReport();
            boolean compressed$iv = false;
            boolean $i$f$fromJsonSet22 = false;
            Object object = $this$fromJsonSet_u24default$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            RegularFile regularFile = (RegularFile)object;
            boolean compressed$iv$iv = compressed$iv;
            boolean $i$f$fromJsonSet = false;
            File file = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            BufferedSource source$iv$iv = UtilsKt.access$bufferRead(file);
            Closeable closeable = (Closeable)source$iv$iv;
            Throwable throwable = null;
            try {
                void $this$withNulls$iv$iv$iv$iv;
                BufferedSource it$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{BundleTrace.class};
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
                typeArray = typeArray2;
                boolean withNulls$iv$iv$iv$iv = withNulls$iv$iv$iv;
                boolean $i$f$withNulls = false;
                Object object2 = $this$withNulls$iv$iv$iv$iv.fromJson(it$iv$iv);
                Intrinsics.checkNotNull((Object)object2);
                set = (Set)object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Iterable $this$filterToSet$iv = set;
            boolean $i$f$filterToSet = false;
            Iterable $i$f$fromJsonSet22 = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BundleTrace it = (BundleTrace)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTop().gav(), (Object)this.requestedCoord.gav()) || Intrinsics.areEqual((Object)it.getBottom().gav(), (Object)this.requestedCoord.gav()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Set)destination$iv$iv;
        }

        private final boolean wasFiltered() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.unfilteredAdvice;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Advice unfiltered = (Advice)element$iv;
                        boolean bl2 = false;
                        if (!(!this.finalAdvice.contains(unfiltered))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final Iterable getRequestedCoordinates$findInGraph$lambda$2(DependencyGraphView it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getNodes();
        }

        private static final Coordinates getRequestedCoordinates$findInGraph(ExplainDependencyAdviceAction this$0, String requestedId) {
            Object v0;
            block1: {
                Sequence sequence = SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this$0.dependencyGraph.values()), ExplainDependencyAdviceAction::getRequestedCoordinates$findInGraph$lambda$2);
                for (Object e : sequence) {
                    Coordinates coordinates = (Coordinates)e;
                    boolean bl = false;
                    String gav = coordinates.gav();
                    if (!(Intrinsics.areEqual((Object)gav, (Object)requestedId) || StringsKt.startsWith$default((String)gav, (String)(requestedId + ":"), (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)gav), (Object)requestedId) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)coordinates.getIdentifier()), (Object)requestedId))) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u001e\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00070\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion;", "", "<init>", "()V", "findDependency", "Lcom/autonomousapps/model/Coordinates;", "dependencies", "", "", "Lcom/autonomousapps/model/internal/intermediates/Usage;", "requestedId", "", "requestedCapability", "buildPath", "findDependency$dependency_analysis_gradle_plugin", "dependency-analysis-gradle-plugin"})
        @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,405:1\n1761#2,3:406\n1563#2:409\n1634#2,3:410\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n*L\n333#1:406,3\n350#1:409\n350#1:410,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            @Nullable
            public final Coordinates findDependency$dependency_analysis_gradle_plugin(@NotNull Set<? extends Map.Entry<? extends Coordinates, ? extends Set<Usage>>> dependencies, @NotNull String requestedId, @NotNull String requestedCapability, @NotNull String buildPath) {
                Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
                Intrinsics.checkNotNullParameter((Object)requestedCapability, (String)"requestedCapability");
                Intrinsics.checkNotNullParameter((Object)buildPath, (String)"buildPath");
                filteredKeys = new LinkedHashSet<Coordinates>();
                for (Map.Entry<? extends Coordinates, ? extends Set<Usage>> entry : dependencies) {
                    block12: {
                        coordinates = entry.getKey();
                        normalizedCoordinates = coordinates.normalized$dependency_analysis_gradle_plugin(buildPath);
                        byGav = Intrinsics.areEqual((Object)requestedId, (Object)normalizedCoordinates.gav());
                        if (StringsKt.isBlank((CharSequence)requestedCapability) && coordinates.hasDefaultCapability$dependency_analysis_gradle_plugin()) ** GOTO lbl-1000
                        $this$any$iv = coordinates.getGradleVariantIdentification().getCapabilities();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v0 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                $i$a$-any-ReasonTask$ExplainDependencyAdviceAction$Companion$findDependency$byCapability$1 = false;
                                if (!StringsKt.endsWith$default((String)it, (String)requestedCapability, (boolean)false, (int)2, null)) continue;
                                v0 = true;
                                break block12;
                            }
                            v0 = false;
                        }
                    }
                    if (v0) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = byCapability = false;
                    }
                    if (byGav && byCapability) {
                        return normalizedCoordinates;
                    }
                    if (!Intrinsics.areEqual((Object)requestedId, (Object)normalizedCoordinates.getIdentifier()) && !StringsKt.startsWith$default((String)normalizedCoordinates.gav(), (String)requestedId, (boolean)false, (int)2, null)) continue;
                    filteredKeys.add(normalizedCoordinates);
                }
                if (filteredKeys.isEmpty()) {
                    v2 = null;
                } else if (filteredKeys.size() == 1) {
                    v2 = (Coordinates)filteredKeys.iterator().next();
                } else {
                    var6_6 = filteredKeys;
                    var18_22 = requestedId;
                    $i$f$map = false;
                    coordinates = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        $i$f$any = (Coordinates)item$iv$iv;
                        var19_23 = destination$iv$iv;
                        $i$a$-map-ReasonTask$ExplainDependencyAdviceAction$Companion$findDependency$1 = false;
                        var19_23.add(p0.gav());
                    }
                    var20_24 = "Coordinates '" + var18_22 + "' matches more than 1 dependency: " + (List)destination$iv$iv;
                    throw new InvalidUserDataException(var20_24);
                }
                return v2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u001e\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0012\u0010\u0017\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0012\u0010\u0019\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0012\u0010\u001b\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "id", "Lorg/gradle/api/provider/Property;", "", "getId", "()Lorg/gradle/api/provider/Property;", "capability", "getCapability", "projectPath", "getProjectPath", "buildPath", "getBuildPath", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getDependencyUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "annotationProcessorUsageReport", "getAnnotationProcessorUsageReport", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "finalAdviceReport", "getFinalAdviceReport", "bundleTracesReport", "getBundleTracesReport", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "dependency-analysis-gradle-plugin"})
    public static interface ExplainDependencyAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getId();

        @NotNull
        public Property<String> getCapability();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public Property<String> getBuildPath();

        @NotNull
        public MapProperty<String, String> getDependencyMap();

        @NotNull
        public RegularFileProperty getDependencyUsageReport();

        @NotNull
        public RegularFileProperty getAnnotationProcessorUsageReport();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();

        @NotNull
        public RegularFileProperty getBundleTracesReport();

        @NotNull
        public ListProperty<RegularFile> getDependencyGraphViews();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "projectPath", "", "kotlin.jvm.PlatformType", "module", "unfilteredAndroidScore", "Lcom/autonomousapps/model/AndroidScore;", "finalAndroidScore", "execute", "", "validateModuleOption", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,405:1\n21#2:406\n142#3,13:407\n142#3,13:437\n41#4,2:420\n34#4,4:422\n41#4,2:450\n34#4,4:452\n808#5,11:426\n808#5,11:456\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n*L\n366#1:406\n371#1:407,13\n376#1:437,13\n371#1:420,2\n371#1:422,4\n376#1:450,2\n376#1:452,4\n373#1:426,11\n378#1:456,11\n*E\n"})
    public static abstract class ExplainModuleAdviceAction
    implements WorkAction<ExplainModuleAdviceParams> {
        @NotNull
        private final Logger logger;
        private final String projectPath;
        private final String module;
        @Nullable
        private final AndroidScore unfilteredAndroidScore;
        @Nullable
        private final AndroidScore finalAndroidScore;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainModuleAdviceAction() {
            Object object;
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            RegularFileProperty $this$filterIsInstance$iv;
            JsonAdapter $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$withNulls;
            boolean withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl2;
            Object reader$iv$iv$iv;
            Iterable $this$fromJson$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
            this.projectPath = (String)((ExplainModuleAdviceParams)this.getParameters()).getProjectPath().get();
            this.module = (String)((ExplainModuleAdviceParams)this.getParameters()).getModule().get();
            RegularFileProperty $i$f$getLogger22 = ((ExplainModuleAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            ExplainModuleAdviceAction explainModuleAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object2 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable throwable = null;
            try {
                reader$iv$iv$iv = (BufferedSource)closeable;
                bl2 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                JsonAdapter jsonAdapter2 = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                reader$iv$iv$iv = object3;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)reader$iv$iv$iv).getModuleAdvice();
            boolean $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.unfilteredAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = ((ExplainModuleAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainModuleAdviceAction = this;
            $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            $this$fromJson$iv$iv = (RegularFile)object4;
            $i$f$fromJson = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson = false;
            element$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            throwable = null;
            try {
                reader$iv$iv$iv = (BufferedSource)element$iv$iv2;
                bl2 = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
                $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object5);
                object = object5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(element$iv$iv2, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)object).getModuleAdvice();
            $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.finalAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        }

        public void execute() {
            this.validateModuleOption();
            String string = this.projectPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectPath");
            String reason = new ModuleAdviceExplainer(new ProjectCoordinates(string, GradleVariantIdentification.Companion.getEMPTY(), null, 4, null), this.unfilteredAndroidScore, this.finalAndroidScore).computeReason();
            this.logger.quiet(reason);
        }

        private final void validateModuleOption() {
            if (!Intrinsics.areEqual((Object)this.module, (Object)"android")) {
                throw new InvalidUserDataException("'" + this.module + "' unexpected. The only valid option for '--module' at this time is 'android'.");
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "module", "Lorg/gradle/api/provider/Property;", "", "getModule", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "unfilteredAdviceReport", "Lorg/gradle/api/file/RegularFileProperty;", "getUnfilteredAdviceReport", "()Lorg/gradle/api/file/RegularFileProperty;", "finalAdviceReport", "getFinalAdviceReport", "dependency-analysis-gradle-plugin"})
    public static interface ExplainModuleAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getModule();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Explainer;", "", "computeReason", "", "dependency-analysis-gradle-plugin"})
    public static interface Explainer {
        @NotNull
        public String computeReason();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Options;", "", "id", "", "capability", "module", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getCapability", "getModule", "dependency-analysis-gradle-plugin"})
    private static final class Options {
        @Nullable
        private final String id;
        @Nullable
        private final String capability;
        @Nullable
        private final String module;

        public Options(@Nullable String id, @Nullable String capability, @Nullable String module) {
            this.id = id;
            this.capability = capability;
            this.module = module;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getCapability() {
            return this.capability;
        }

        @Nullable
        public final String getModule() {
            return this.module;
        }
    }
}

