/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0012\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/autonomousapps/internal/ConstantPoolParser;", "", "<init>", "()V", "HEAD", "", "CONSTANT_UTF8", "", "CONSTANT_INTEGER", "CONSTANT_FLOAT", "CONSTANT_LONG", "CONSTANT_DOUBLE", "CONSTANT_CLASS", "CONSTANT_STRING", "CONSTANT_FIELDREF", "CONSTANT_METHODREF", "CONSTANT_INTERFACEMETHODREF", "CONSTANT_NAME_AND_TYPE", "CONSTANT_METHODHANDLE", "CONSTANT_METHOD_TYPE", "CONSTANT_DYNAMIC", "CONSTANT_INVOKE_DYNAMIC", "OXF0", "OXE0", "OX3F", "getConstantPoolClassReferences", "", "", "b", "", "classFilePath", "getConstantPoolClassReferences$dependency_analysis_gradle_plugin", "parseConstantPoolClassReferences", "buf", "Ljava/nio/ByteBuffer;", "decodeString", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nConstantPoolParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantPoolParser.kt\ncom/autonomousapps/internal/ConstantPoolParser\n+ 2 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n132#2:126\n1625#3:127\n1869#3:128\n1870#3:130\n1626#3:131\n1#4:129\n*S KotlinDebug\n*F\n+ 1 ConstantPoolParser.kt\ncom/autonomousapps/internal/ConstantPoolParser\n*L\n96#1:126\n96#1:127\n96#1:128\n96#1:130\n96#1:131\n96#1:129\n*E\n"})
public final class ConstantPoolParser {
    @NotNull
    public static final ConstantPoolParser INSTANCE = new ConstantPoolParser();
    private static final int HEAD = -889275714;
    private static final byte CONSTANT_UTF8 = 1;
    private static final byte CONSTANT_INTEGER = 3;
    private static final byte CONSTANT_FLOAT = 4;
    private static final byte CONSTANT_LONG = 5;
    private static final byte CONSTANT_DOUBLE = 6;
    private static final byte CONSTANT_CLASS = 7;
    private static final byte CONSTANT_STRING = 8;
    private static final byte CONSTANT_FIELDREF = 9;
    private static final byte CONSTANT_METHODREF = 10;
    private static final byte CONSTANT_INTERFACEMETHODREF = 11;
    private static final byte CONSTANT_NAME_AND_TYPE = 12;
    private static final byte CONSTANT_METHODHANDLE = 15;
    private static final byte CONSTANT_METHOD_TYPE = 16;
    private static final byte CONSTANT_DYNAMIC = 17;
    private static final byte CONSTANT_INVOKE_DYNAMIC = 18;
    private static final int OXF0 = 240;
    private static final int OXE0 = 224;
    private static final int OX3F = 63;

    private ConstantPoolParser() {
    }

    @NotNull
    public final Set<String> getConstantPoolClassReferences$dependency_analysis_gradle_plugin(@NotNull byte[] b, @NotNull String classFilePath) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)classFilePath, (String)"classFilePath");
        ByteBuffer byteBuffer = ByteBuffer.wrap(b);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return this.parseConstantPoolClassReferences(byteBuffer, classFilePath);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseConstantPoolClassReferences(ByteBuffer buf, String classFilePath) {
        void $this$mapNotNullTo$iv$iv;
        if (buf.order(ByteOrder.BIG_ENDIAN).getInt() != -889275714) {
            return SetsKt.emptySet();
        }
        buf.getChar();
        buf.getChar();
        HashSet<Integer> classes = new HashSet<Integer>();
        HashMap stringConstants = new HashMap();
        int num = buf.getChar();
        for (int ix = 1; ix < num; ++ix) {
            byte b = buf.get();
            if (b == 1) {
                ((Map)stringConstants).put(ix, this.decodeString(buf));
                continue;
            }
            if (b == 7 || b == 8 || b == 16) {
                classes.add(Integer.valueOf(buf.getChar()));
                continue;
            }
            if (b == 9 || b == 10 || b == 11 || b == 12 || b == 17 || b == 18) {
                buf.getChar();
                buf.getChar();
                continue;
            }
            if (b == 3) {
                buf.getInt();
                continue;
            }
            if (b == 4) {
                buf.getFloat();
                continue;
            }
            if (b == 6) {
                buf.getDouble();
                ++ix;
                continue;
            }
            if (b == 5) {
                buf.getLong();
                ++ix;
                continue;
            }
            if (b == 15) {
                buf.get();
                buf.getChar();
                continue;
            }
            throw new RuntimeException("Unknown constant pool type: byte '" + b + "' at pos '" + ix + "', in class file '" + classFilePath + "'");
        }
        Iterable $this$mapNotNullToSet$iv = classes;
        boolean $i$f$mapNotNullToSet = false;
        Iterable iterable = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ((String)stringConstants.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Set)destination$iv$iv;
    }

    private final String decodeString(ByteBuffer buf) {
        char size = buf.getChar();
        int oldLimit = buf.limit();
        Intrinsics.checkNotNull((Object)buf, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)buf).limit(buf.position() + size);
        StringBuilder sb = new StringBuilder(size + (size >> 1) + 16);
        while (buf.hasRemaining()) {
            StringBuilder stringBuilder;
            byte b = buf.get();
            if (b > 0) {
                stringBuilder = sb.append((char)b);
                continue;
            }
            byte b2 = buf.get();
            if ((byte)(b & 0xFFFFFFF0) != -32) {
                stringBuilder = sb.append((char)((byte)(b & 0x1F) << 6 | b2 & 0x3F));
                continue;
            }
            byte b3 = buf.get();
            stringBuilder = sb.append((char)((byte)(b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F));
        }
        ((Buffer)buf).limit(oldLimit);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

